unit Report_Addresses;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, Base_Report, FlexReport, StdCtrls, Buttons, ExtCtrls, ComCtrls,
  DateUtils, DBClient, Provider, DB, IBCustomDataSet, IBQuery, IBDatabase,
  MainDataStore, Misc_Utilities, Misc_Constants, DBLocal, DBLocalI, StrUtils;

const
    ALL_ADDRESS = 0;
    PSEUDO_ADDRESS = 1;

type
  TAddressesReport = class(TReportTemplate)

    bTitle: TFlexReportBand;
    FlexReportPanel1: TFlexReportPanel;
    rTimeStamp: TFlexReportDateTime;
    bFooter: TFlexReportBand;
    bSummary: TFlexReportBand;
    bTable: TFlexReportLayout;
    bTableHeader: TFlexReportBand;
    bTableDetail: TFlexReportBand;
    rPageNumber: TFlexReportPageNumber;
    FlexReportPanel9: TFlexReportPanel;
    FlexReportPanel10: TFlexReportPanel;
    rAddress: TFlexReportPanel;
    rAddressRead: TFlexReportPanel;
    FlexReportPanel4: TFlexReportPanel;
    FlexReportPanel18: TFlexReportPanel;
    rName: TFlexReportPanel;
    rNameRead: TFlexReportPanel;
    FlexReportPanel21: TFlexReportPanel;
    rPhoneAndFax: TFlexReportPanel;
    FlexReportPanel11: TFlexReportPanel;
    rTotalCount: TFlexReportDecimal;
    MainTransaction: TIBTransaction;
    SourceOf_Address: TIBQuery;
    ProviderOf_Address: TDataSetProvider;
    Address: TClientDataSet;
    rCategory: TFlexReportPanel;
    rCatalogue: TFlexReportPanel;

    procedure Report_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure Paper_BeforePrint(Sender: TObject; Report: TFlexCustomReport);

    procedure bTitle_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure bTable_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure bTableDetail_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure bSummary_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
  private
    { Private 錾 }
  public
    { Public 錾 }
    constructor Prepare( typCatalogue, typCategory : Integer; collation : String);
  end;

var
  AddressesReport: TAddressesReport;

implementation

{$R *.dfm}

{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

constructor TAddressesReport.Prepare( typCatalogue, typCategory : Integer; collation : String);
begin
	inherited Create( Screen.ActiveForm);

	Address.Filter := CatalogueFilter( typCatalogue) + IfThen( typCategory = ALL_ADDRESS, '', ' and strUserAddress=''''');
	Address.IndexFieldNames := collation;
	Address.Open;

	rCatalogue.Lines.Text := aCatalogue[ typCatalogue];
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TAddressesReport.Report_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not Address.IsEmpty);
end;

procedure TAddressesReport.Paper_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not bSummary.Printed);
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TAddressesReport.bTitle_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not bTitle.Printed);

	if Trim( Address.FieldByName( 'strUserAddress').AsString) <> '' then
		rCategory.Lines.Text := 'SĂ̎{'
	else
		rCategory.Lines.Text := '͂̂̂̂';
end;

procedure TAddressesReport.bTable_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not Address.Eof);
end;

procedure TAddressesReport.bTableDetail_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not Address.Eof);
	printif( Report.AvailableHeight > bTableDetail.Height + bFooter.Height);

	with Address do
	begin
		rNameRead.Lines.Text := FieldByName( 'strNameRead').AsString;
		rName.Lines.Text := FieldByName( 'strName').AsString;
		rAddressRead.Lines.Text := FieldByName( 'strAddressRead').AsString;
		rAddress.Lines.Text := Format( '%s %s', [
			ToZipText( FieldByName( 'refZip').AsInteger),
			FieldByName( 'strAddress').AsString
		]);
		rPhoneAndFax.Lines.Clear;
		rPhoneAndFax.Lines.Add( FieldByName( 'strPhoneNumber1').AsString);
		rPhoneAndFax.Lines.Add( FieldByName( 'strFaxNumber1').AsString);
	end;

	Address.Next;
end;

procedure TAddressesReport.bSummary_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( Address.Eof);
	printif( Report.AvailableHeight > bSummary.Height + bFooter.Height);

	rTotalCount.Value := Address.RecordCount;
end;

end.
