unit Report_Billing;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, Base_Report, FlexReport, StdCtrls, Buttons, ExtCtrls, ComCtrls,
  DateUtils, DBClient, Provider, DB, IBCustomDataSet, IBQuery, IBDatabase,
  MainDataStore, Misc_Utilities, Misc_Constants;

type
  TBillingReport = class(TReportTemplate)
    MainTransaction: TIBTransaction;
    Billing: TIBQuery;
    Receipt: TIBQuery;

    bFooter: TFlexReportBand;
    rPageNumber: TFlexReportPageNumber;
    bSummary: TFlexReportBand;
    bTable: TFlexReportLayout;
    bTableCategory: TFlexReportBand;
    bTableDetail: TFlexReportBand;
    bTableFooter: TFlexReportBand;
    bTableHeader: TFlexReportBand;
    FlexReportPanel5: TFlexReportPanel;
    FlexReportPanel4: TFlexReportPanel;
    rScheduleAt: TFlexReportDateTime;
    FlexReportPanel7: TFlexReportPanel;
    bTitle: TFlexReportLayout;
    FlexReportBand1: TFlexReportBand;
    FlexReportPanel1: TFlexReportPanel;
    rTimeStamp: TFlexReportDateTime;
    rBillingCode: TFlexReportInteger;
    FlexReportBand9: TFlexReportBand;
    FlexReportPanel2: TFlexReportPanel;
    rCode: TFlexReportPanel;
    FlexReportLayout1: TFlexReportLayout;
    FlexReportBand2: TFlexReportBand;
    FlexReportPanel3: TFlexReportPanel;
    rNameRead: TFlexReportPanel;
    FlexReportBand3: TFlexReportBand;
    rName: TFlexReportPanel;
    FlexReportPanel6: TFlexReportPanel;
    FlexReportLayout2: TFlexReportLayout;
    FlexReportBand4: TFlexReportBand;
    FlexReportPanel8: TFlexReportPanel;
    rAddressRead: TFlexReportPanel;
    FlexReportBand5: TFlexReportBand;
    FlexReportPanel9: TFlexReportPanel;
    FlexReportPanel10: TFlexReportPanel;
    rAddress: TFlexReportPanel;
    rZip: TFlexReportPanel;
    bCash: TFlexReportBand;
    FlexReportBand7: TFlexReportBand;
    FlexReportPanel13: TFlexReportPanel;
    FlexReportBand8: TFlexReportBand;
    FlexReportPanel15: TFlexReportPanel;
    rPublished: TFlexReportDateTime;
    rScheduleTo: TFlexReportDateTime;
    rScheduleFrom: TFlexReportDateTime;
    FlexReportPanel12: TFlexReportPanel;
    rCash: TFlexReportDecimal;
    FlexReportPanel14: TFlexReportPanel;
    FlexReportPanel16: TFlexReportPanel;
    FlexReportPanel17: TFlexReportPanel;
    rTransferCash: TFlexReportDecimal;
    FlexReportPanel18: TFlexReportPanel;
    FlexReportPanel19: TFlexReportPanel;
    rMenageCash: TFlexReportDecimal;
    Padding: TFlexReportBand;
    rDetail: TFlexReportPanel;
    rExchange: TFlexReportPanel;
    rLocation: TFlexReportPanel;
    rService: TFlexReportPanel;
    FlexReportPanel20: TFlexReportPanel;
    FlexReportPanel11: TFlexReportPanel;
    rTotalCount: TFlexReportDecimal;
    rCenterCall: TFlexReportPanel;
    rCenterName: TFlexReportPanel;
    rCenterLocation: TFlexReportPanel;
    Center: TIBQuery;
    rCareCash: TFlexReportDecimal;
    FlexReportPanel21: TFlexReportPanel;
    FlexReportPanel22: TFlexReportPanel;
    rMigrationCash: TFlexReportDecimal;
    bTotal: TFlexReportBand;
    FlexReportPanel23: TFlexReportPanel;
    rSummary: TFlexReportPanel;
    rMinutes: TFlexReportPanel;

    procedure Report_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure Paper_BeforePrint(Sender: TObject; Report: TFlexCustomReport);

    procedure bTitle_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure bTable_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure bTableCategory_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure bTableDetail_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure bSummary_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
  private
    { Private 錾 }
  public
    { Public 錾 }
    constructor Prepare( keyInstance : Integer);
  end;

var
  BillingReport: TBillingReport;

implementation

{$R *.dfm}

{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

constructor TBillingReport.Prepare( keyInstance : Integer);
begin
	inherited Create( Screen.ActiveForm);

	Billing.ParamByName( 'keyInstance').AsInteger := keyInstance;
	Billing.Open;

	Receipt.ParamByName( 'keyBilling').AsInteger := keyInstance;
	Receipt.Open;

	Center.Open;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TBillingReport.Report_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not Billing.IsEmpty);
end;

procedure TBillingReport.Paper_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not bSummary.Printed);
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TBillingReport.bTitle_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not bTitle.Printed);

	with Billing do
	begin
		rBillingCode.Value := FieldByName( 'keyInstance').AsInteger;

		rPublished.Value := FieldByName( 'datPublished').AsDateTime;
		rScheduleFrom.Value := FieldByName( 'datMonthFirstday').AsDateTime;
		rScheduleTo.Value := FieldByName( 'datMonthLastday').AsDateTime;

		rCode.Lines.Text := FieldByName( 'strCode').AsString;

		rNameRead.Lines.Text := FieldByName( 'strNameRead').AsString;
		rName.Lines.Text := FieldByName( 'strName').AsString;

		rZip.Lines.Text := '' + ToZipText( FieldByName( 'refZip').AsInteger);
		rAddressRead.Lines.Text := FieldByName( 'strAddressRead').AsString;
		rAddress.Lines.Text := FieldByName( 'strAddress').AsString;

		rCareCash.Value := FieldByName( 'intCareCash').AsCurrency;
		rMenageCash.Value := FieldByName( 'intMenageCash').AsCurrency;
		rMigrationCash.Value := FieldByName( 'intMigrationCash').AsCurrency;
		rTransferCash.Value := FieldByName( 'intTransferCash').AsCurrency;

		rCash.Value := FieldByName( 'intCash').AsCurrency;

		if FieldByName( 'intMargin').AsCurrency > 0 then
			rSummary.Lines.Text := Format( ' %0.0n ~ { %0.0n ~ (萔)  %0.0n ~', [
				FieldByName( 'intCash').AsCurrency,
				FieldByName( 'intMargin').AsCurrency,
				FieldByName( 'intCash').AsCurrency + FieldByName( 'intMargin').AsCurrency
			])
		else
			rSummary.Lines.Text := Format( ' %0.0n ~', [ FieldByName( 'intCash').AsCurrency]);
	end;

	rScheduleAt.Value := 0; // see bTableCategory_BeforePrint
end;

procedure TBillingReport.bTable_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not Receipt.Eof);
	printif( Report.AvailableHeight > bTableCategory.Height + bTableHeader.Height + bTableDetail.Height + bFooter.Height);
end;

procedure TBillingReport.bTableCategory_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( rScheduleAt.Value <> Receipt.FieldByName( 'datSchedule').AsDateTime);

	rScheduleAt.Value := Receipt.FieldByName( 'datSchedule').AsDateTime;
end;

procedure TBillingReport.bTableDetail_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not Receipt.Eof);
	printif( rScheduleAt.Value = Receipt.FieldByName( 'datSchedule').AsDateTime);
	printif( Report.AvailableHeight > bTableDetail.Height + bFooter.Height);

	with Receipt do
	begin
		rService.Lines.Text := FieldByName( 'strService').AsString;

		case FieldByName( 'typSchedule').AsInteger of
		CARE_SCHEDULE, MENAGE_SCHEDULE :
			begin
				rMinutes.Lines.Text := RangeToText( FieldByName( 'intMinutesAt').AsInteger, FieldByName( 'intMinutesFor').AsInteger);
				rLocation.Lines.Text := Format( '%s%s', [
					FieldByName( 'strClient').AsString,
					FieldByName( 'strAddressFrom').AsString
				]);
			end;

		MIGRATION_SCHEDULE, TRANSFER_SCHEDULE :
			begin
				rMinutes.Lines.Text := MinutesToText( FieldByName( 'intMinutesAt').AsInteger);
				rLocation.Lines.Text := Format( '%s%s%s', [
					FieldByName( 'strClient').AsString,
					FieldByName( 'strAddressFrom').AsString,
					FieldByName( 'strAddressTo').AsString
				]);
			end;
		end;

		rExchange.Lines.Text := AmountToText(
			FieldByName( 'typExchange').AsInteger,
			FieldByName( 'curAmountPerCount').AsCurrency,
			FieldByName( 'curAmountPerHour').AsCurrency,
			FieldByName( 'intMinutesFor').AsInteger
		);
	end;

	Receipt.Next;
end;

procedure TBillingReport.bSummary_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( Receipt.Eof);
	printif( Report.AvailableHeight > bSummary.Height + bFooter.Height);

	rTotalCount.Value := Receipt.RecordCount;

	with Center do
	begin
		rCenterLocation.Lines.Strings[ 0] := Format( '%s@%s%s', [
			ToZipText( FieldByName( 'refZip').AsInteger),
			FieldByName( 'strZipAddress').AsString,
			FieldByName( 'strAddress').AsString
		]);
		rCenterLocation.Lines.Strings[ 1] := FieldByName( 'strLegalName').AsString;
		rCenterName.Lines.Text := FieldByName( 'strTradeName').AsString;

		if FieldByName( 'strPhoneNumber2').AsString <> '' then
			rCenterCall.Lines.Strings[ 0] := Format( 'dbF%s & %s', [
				FieldByName( 'strPhoneNumber1').AsString,
				FieldByName( 'strPhoneNumber2').AsString
			])
		else
			rCenterCall.Lines.Strings[ 0] := Format( 'dbF%s', [
				FieldByName( 'strPhoneNumber1').AsString
			]);

		if FieldByName( 'strFaxNumber2').AsString <> '' then
			rCenterCall.Lines.Strings[ 1] := Format( 'FAXF%s & %s', [
				FieldByName( 'strFaxNumber1').AsString,
				FieldByName( 'strFaxNumber2').AsString
			])
		else
			rCenterCall.Lines.Strings[ 1] := Format( 'FAXF%s', [
				FieldByName( 'strFaxNumber1').AsString
			]);
	end;
end;

end.
