unit Report_CandidatesName;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, Base_Report, FlexReport, StdCtrls, Buttons, ExtCtrls, ComCtrls,
  DateUtils, DBClient, Provider, DB, IBCustomDataSet, IBQuery, IBDatabase,
  Math, StrUtils, MainDataStore, Misc_Utilities, Misc_Constants, DBLocal, DBLocalI;

type
  TCandidatesNameReport = class(TReportTemplate)

    bTitle: TFlexReportBand;
    rTitle: TFlexReportPanel;
    rTimeStamp: TFlexReportDateTime;
    bFooter: TFlexReportBand;
    bSummary: TFlexReportBand;
    bTable: TFlexReportLayout;
    bTableHeader: TFlexReportBand;
    bTableDetail: TFlexReportBand;
    rPageNumber: TFlexReportPageNumber;
    FlexReportPanel9: TFlexReportPanel;
    FlexReportPanel10: TFlexReportPanel;
    rAddress: TFlexReportPanel;
    rAddressRead: TFlexReportPanel;
    FlexReportPanel4: TFlexReportPanel;
    FlexReportPanel18: TFlexReportPanel;
    rName: TFlexReportPanel;
    rNameRead: TFlexReportPanel;
    FlexReportPanel21: TFlexReportPanel;
    rPhoneAndFax: TFlexReportPanel;
    FlexReportPanel11: TFlexReportPanel;
    rTotalCount: TFlexReportDecimal;
    FlexReportPanel12: TFlexReportPanel;
    rCode: TFlexReportPanel;
    MainTransaction: TIBTransaction;
    SourceOf_Profile: TIBQuery;
    ProviderOf_Profile: TDataSetProvider;
    Profile: TClientDataSet;

    procedure Report_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure Paper_BeforePrint(Sender: TObject; Report: TFlexCustomReport);

    procedure bTitle_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure bTable_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure bTableDetail_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure bSummary_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
  private
    { Private 錾 }
  public
    { Public 錾 }
    constructor Prepare( datAt : TDate; refBranch, refRegion : Integer; strTitle, strContent : String; typCategory : Integer; strReportName : String);
  end;

var
  CandidatesNameReport: TCandidatesNameReport;

implementation

{$R *.dfm}

{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

constructor TCandidatesNameReport.Prepare(
	datAt : TDate;
	refBranch, refRegion : Integer;
	strTitle, strContent : String;
	typCategory : Integer;
	strReportName : String
);
begin
	inherited Create( Screen.ActiveForm);

	SourceOf_Profile.ParamByName( 'datAt').AsDate := datAt;
	SourceOf_Profile.ParamByName( 'keyBranch').AsInteger := refBranch;
	SourceOf_Profile.ParamByName( 'keyRegion').AsInteger := refRegion;
	SourceOf_Profile.ParamByName( 'strTitle').AsString := strTitle;
	SourceOf_Profile.ParamByName( 'strContent').AsString := strContent;
	SourceOf_Profile.ParamByName( 'typCategory').AsInteger := typCategory;
	Profile.Open;

	Caption := strReportName;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TCandidatesNameReport.Report_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not Profile.IsEmpty);
end;

procedure TCandidatesNameReport.Paper_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not bSummary.Printed);
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TCandidatesNameReport.bTitle_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not bTitle.Printed);

	rTitle.Lines.Text := Caption;
end;

procedure TCandidatesNameReport.bTable_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not Profile.Eof);
end;

procedure TCandidatesNameReport.bTableDetail_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not Profile.Eof);
	printif( Report.AvailableHeight > bTableDetail.Height + bFooter.Height);

	rCode.Lines.Text := Profile.FieldByName( 'strCode').AsString;
	rNameRead.Lines.Text := Profile.FieldByName( 'strNameRead').AsString;
	rName.Lines.Text := Profile.FieldByName( 'strName').AsString;
	rAddressRead.Lines.Text := Profile.FieldByName( 'strAddressRead').AsString;
	rAddress.Lines.Text := Format( '%s %s', [
		ToZipText( Profile.FieldByName( 'refZip').AsInteger),
		Profile.FieldByName( 'strAddress').AsString
	]);
	rPhoneAndFax.Lines.Clear;
	rPhoneAndFax.Lines.Add( Profile.FieldByName( 'strPhoneNumber1').AsString);
	rPhoneAndFax.Lines.Add( Profile.FieldByName( 'strFaxNumber1').AsString);

	Profile.Next;
end;

procedure TCandidatesNameReport.bSummary_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( Profile.Eof);
	printif( Report.AvailableHeight > bSummary.Height + bFooter.Height);

	rTotalCount.Value := Profile.RecordCount;
end;

end.
