unit Report_Clients;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, Base_Report, FlexReport, StdCtrls, Buttons, ExtCtrls, ComCtrls,
  DateUtils, DBClient, Provider, DB, IBCustomDataSet, IBQuery, IBDatabase,
  MainDataStore, DBLocal, DBLocalI;

type
  TClientsReport = class(TReportTemplate)

    bTitle: TFlexReportBand;
    FlexReportPanel1: TFlexReportPanel;
    rTimeStamp: TFlexReportDateTime;
    bFooter: TFlexReportBand;
    bSummary: TFlexReportBand;
    bTable: TFlexReportLayout;
    bTableHeader: TFlexReportBand;
    bTableDetail: TFlexReportBand;
    rPageNumber: TFlexReportPageNumber;
    rRange: TFlexReportPanel;
    FlexReportPanel2: TFlexReportPanel;
    rFaxNumber: TFlexReportPanel;
    FlexReportPanel5: TFlexReportPanel;
    FlexReportPanel6: TFlexReportPanel;
    rName: TFlexReportPanel;
    rNameRead: TFlexReportPanel;
    FlexReportPanel9: TFlexReportPanel;
    FlexReportPanel10: TFlexReportPanel;
    rAddress: TFlexReportPanel;
    rAddressRead: TFlexReportPanel;
    FlexReportPanel23: TFlexReportPanel;
    rPhoneNumber: TFlexReportPanel;
    FlexReportPanel11: TFlexReportPanel;
    rTotalCount: TFlexReportDecimal;
    MainTransaction: TIBTransaction;
    Client: TIBClientDataSet;

    procedure Report_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure Paper_BeforePrint(Sender: TObject; Report: TFlexCustomReport);

    procedure bTitle_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure bTable_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure bTableDetail_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure bSummary_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
  private
    { Private 錾 }
  public
    { Public 錾 }
    constructor Daily( datAt : TDate);
    constructor Monthly( datAt : TDate);
  end;

var
  ClientsReport: TClientsReport;

implementation

{$R *.dfm}

{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

constructor TClientsReport.Daily( datAt : TDate);
begin
	inherited Create( Screen.ActiveForm);

	Client.Params.ParamByName( 'datFrom').AsDate := datAt;
	Client.Params.ParamByName( 'datTo').AsDate := datAt;
	Client.IndexFieldNames := 'strNameRead;strName;keyInstance';
	Client.Open;
end;

constructor TClientsReport.Monthly( datAt : TDate);
begin
	inherited Create( Screen.ActiveForm);

	Client.Params.ParamByName( 'datFrom').AsDate := StartOfTheMonth( datAt);
	Client.Params.ParamByName( 'datTo').AsDate := EndOfTheMonth( datAt);
	Client.IndexFieldNames := 'strNameRead;strName;keyInstance';
	Client.Open;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TClientsReport.Report_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not Client.IsEmpty);
end;

procedure TClientsReport.Paper_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not bSummary.Printed);
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TClientsReport.bTitle_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not bTitle.Printed);

	with Client do if Params.ParamByName( 'datFrom').AsDate = Params.ParamByName( 'datTo').AsDate then
		rRange.Lines.Text := FormatDateTime( 'ggee"N"MM""dd""(ddd)', Params.ParamByName( 'datFrom').AsDate)
	else
		rRange.Lines.Text := FormatDateTime( 'ggee"N"MM""', Params.ParamByName( 'datFrom').AsDate);
end;

procedure TClientsReport.bTable_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not Client.Eof);
end;

procedure TClientsReport.bTableDetail_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not Client.Eof);
	printif( Report.AvailableHeight > bTableDetail.Height + bFooter.Height);

	rNameRead.Lines.Text := Client.FieldByName( 'strNameRead').AsString;
	rName.Lines.Text := Client.FieldByName( 'strName').AsString;
	rAddressRead.Lines.Text := Client.FieldByName( 'strAddressRead').AsString;
	rAddress.Lines.Text := Client.FieldByName( 'strAddress').AsString;
	rPhoneNumber.Lines.Text := Client.FieldByName( 'strPhoneNumber1').AsString;
	rFaxNumber.Lines.Text := Client.FieldByName( 'strFaxNumber1').AsString;

	Client.Next;
end;

procedure TClientsReport.bSummary_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( Client.Eof);
	printif( Report.AvailableHeight > bSummary.Height + bFooter.Height);

	rTotalCount.Value := Client.RecordCount;
end;

end.
