unit Report_DailyClientSchedule;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, Base_Report, FlexReport, StdCtrls, Buttons, ExtCtrls, ComCtrls,
  DateUtils, DBClient, Provider, DB, IBCustomDataSet, IBQuery, IBDatabase,
  StrUtils, MainDataStore, Misc_Utilities, Misc_Constants;

type
  TDailyClientScheduleReport = class(TReportTemplate)
    MainTransaction: TIBTransaction;
    Profile: TIBQuery;
    SourceOf_Schedule: TIBQuery;
    ProviderOf_Schedule: TDataSetProvider;
    Schedule: TClientDataSet;
    bFooter: TFlexReportBand;
    rPageNumber: TFlexReportPageNumber;
    bSummary: TFlexReportBand;
    FlexReportPanel11: TFlexReportPanel;
    rTotalCount: TFlexReportDecimal;
    bTable: TFlexReportLayout;
    bTableCategory: TFlexReportBand;
    bTableDetail: TFlexReportBand;
    rScheduleAt: TFlexReportDateTime;
    rMinutes: TFlexReportPanel;
    bTitle: TFlexReportLayout;
    FlexReportBand3: TFlexReportBand;
    rName: TFlexReportPanel;
    FlexReportPanel8: TFlexReportPanel;
    FlexReportBand2: TFlexReportBand;
    FlexReportPanel13: TFlexReportPanel;
    rNameRead: TFlexReportPanel;
    FlexReportBand9: TFlexReportBand;
    FlexReportPanel7: TFlexReportPanel;
    rCode: TFlexReportPanel;
    FlexReportBand1: TFlexReportBand;
    FlexReportPanel1: TFlexReportPanel;
    rTimeStamp: TFlexReportDateTime;
    Padding: TFlexReportBand;
    bTableFooter: TFlexReportBand;
    rAddressRead: TFlexReportPanel;
    FlexReportPanel10: TFlexReportPanel;
    FlexReportPanel12: TFlexReportPanel;
    rAddress: TFlexReportPanel;
    rZip: TFlexReportPanel;
    rServer: TFlexReportPanel;
    Arrow: TImage;
    FlexReportPanel16: TFlexReportPanel;
    rSeparator: TFlexReportPanel;
    rAddressFrom: TFlexReportPanel;
    rPlaceFrom: TFlexReportPanel;
    FlexReportPanel14: TFlexReportPanel;
    rAddressTo: TFlexReportPanel;
    rPlaceTo: TFlexReportPanel;
    rService: TFlexReportPanel;

    procedure Report_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure Paper_BeforePrint(Sender: TObject; Report: TFlexCustomReport);

    procedure bTitle_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure bTable_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure bTableDetail_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure bSummary_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
  private
    { Private 錾 }
  public
    { Public 錾 }
    constructor Prepare( keyClient : Integer; datAt : TDate);
  end;

var
  DailyClientScheduleReport: TDailyClientScheduleReport;

implementation

{$R *.dfm}

{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

constructor TDailyClientScheduleReport.Prepare( keyClient : Integer; datAt : TDate);
begin
	inherited Create( Screen.ActiveForm);

	Profile.ParamByName( 'keyInstance').AsInteger := keyClient;
	Profile.ParamByName( 'datAvailableAt').AsDate := Today;
	Profile.Open;

	SourceOf_Schedule.ParamByName( 'keyClient').AsInteger := keyClient;
	SourceOf_Schedule.ParamByName( 'datFrom').AsDate := datAt;
	SourceOf_Schedule.ParamByName( 'datTo').AsDate := datAt;
	Schedule.Open;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TDailyClientScheduleReport.Report_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not Schedule.IsEmpty);
end;

procedure TDailyClientScheduleReport.Paper_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not bSummary.Printed);
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TDailyClientScheduleReport.bTitle_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not bTitle.Printed);

	with Profile do
	begin
		rCode.Lines.Text := FieldByName( 'strCode').AsString;

		rNameRead.Lines.Text := FieldByName( 'strNameRead').AsString;
		rName.Lines.Text := FieldByName( 'strName').AsString;

		rZip.Lines.Text := '' + ToZipText( FieldByName( 'refZip').AsInteger);
		rAddressRead.Lines.Text := FieldByName( 'strAddressRead').AsString;
		rAddress.Lines.Text := FieldByName( 'strAddress').AsString;
	end;

	rScheduleAt.Value := SourceOf_Schedule.ParamByName( 'datFrom').AsDate;

	Caption := Format( '%s - %s', [ Caption, Trim( rName.Lines.Text)]);
end;

procedure TDailyClientScheduleReport.bTable_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not Schedule.Eof);
	printif( Report.AvailableHeight > bTableDetail.Height + bFooter.Height);
end;

procedure TDailyClientScheduleReport.bTableDetail_BeforePrint(Sender: TObject; Report: TFlexCustomReport);

	function NameOf( strPlace : String) : String;
	begin
		result := MidStr( strPlace, Pos( '@', strPlace) + 1, 999)
	end;
var
	FromHome, ToHome : Boolean;
begin
	printif( not Schedule.Eof);
	printif( Report.AvailableHeight > bTableDetail.Height + bFooter.Height);

	rMinutes.Lines.Clear;

	rPlaceFrom.Lines.Clear;
	rAddressFrom.Lines.Clear;
	rPlaceTo.Lines.Clear;
	rAddressTo.Lines.Clear;
	rService.Lines.Clear;

	rServer.Lines.Clear;

	with Schedule do
	begin
		bTableDetail.Transparent := ( FieldByName( 'typProgress').AsInteger = DEFINED_PROGRESS);

		if FieldByName( 'intMinutesFor').AsInteger > 0 then
		begin
			rMinutes.Lines.Add( MinutesToText( FieldByName( 'intMinutesAt').AsInteger));
			rMinutes.Lines.Add( '');
			rMinutes.Lines.Add( MinutesToText( FieldByName( 'intMinutesAt').AsInteger + FieldByName( 'intMinutesFor').AsInteger));
		end
		else if FieldByName( 'intMinutesAt').AsInteger <= FieldByName( 'intSubjectAt').AsInteger then
		begin
			rMinutes.Lines.Add( MinutesToText( FieldByName( 'intMinutesAt').AsInteger));
			rMinutes.Lines.Add( '');
			rMinutes.Lines.Add( MinutesToText( FieldByName( 'intSubjectAt').AsInteger));
		end
		else
		begin
			rMinutes.Lines.Add( MinutesToText( FieldByName( 'intMinutesAt').AsInteger));
		end;
		// assign minutes label

		FromHome := ( FieldByName( 'typPlaceFrom').AsInteger = PROFILE_ADDRESS)
			and ( FieldByName( 'refResidentFrom').AsInteger = FieldByName( 'refClient').AsInteger);

		ToHome := ( FieldByName( 'typPlaceTo').AsInteger = PROFILE_ADDRESS)
			and ( FieldByName( 'refResidentTo').AsInteger = FieldByName( 'refClient').AsInteger);

		case FieldByName( 'typSchedule').AsInteger of CARE_SCHEDULE, MENAGE_SCHEDULE :
			begin
				rPlaceFrom.Lines.Text := IfThen( FromHome, '', NameOf( FieldByName( 'strPlaceFrom').AsString));
				rAddressFrom.Lines.Text := IfThen( FromHome, '', Copy( FieldByName( 'strAddressFrom').AsString, 7, 999));

				rPlaceTo.Lines.Text := '';
				rAddressTo.Lines.Text := '';
			end;
		else
			begin
				rPlaceFrom.Lines.Text := IfThen( FromHome, '', NameOf( FieldByName( 'strPlaceFrom').AsString));
				rAddressFrom.Lines.Text := IfThen( FromHome, '', Copy( FieldByName( 'strAddressFrom').AsString, 7, 999));

				rPlaceTo.Lines.Text := IfThen( ToHome, '', NameOf( FieldByName( 'strPlaceTo').AsString));
				rAddressTo.Lines.Text := IfThen( ToHome, '', Copy( FieldByName( 'strAddressTo').AsString, 7, 999));

				Report.Draw(
					bTableDetail.Left + 255,
					Report.CurrentBounds.Bottom - Report.CurrentBounds.Top + 2,
					bTableDetail.Left + 267,
					Report.CurrentBounds.Bottom - Report.CurrentBounds.Top + 14,
					Arrow.Picture.Graphic
				);
			end;
		end;
		// assign place and minutes label

		if FieldByName( 'refClient').AsInteger <> FieldByName( 'refServer').AsInteger then
		begin
			rServer.Lines.Add( FieldByName( 'strServerCode').AsString);
			rServer.Lines.Add( FieldByName( 'strServerName').AsString);
		end
		else
			rServer.Lines.Add( '');

		if FieldByName( 'curAmountPerCount').AsCurrency + FieldByName( 'curAmountPerHour').AsCurrency > 0 then
			rServer.Lines.Add( Format( '(%s)', [
					AmountToText(
						FieldByName( 'typExchange').AsInteger,
						FieldByName( 'curAmountPerCount').AsCurrency,
						FieldByName( 'curAmountPerHour').AsCurrency,
						FieldByName( 'intMinutesFor').AsInteger
					)
				])
			);
		// assign server label

		if FieldByName( 'strNotice').AsString <> '' then
			rService.Lines.Text := Format( '%s / %s', [
				FieldByName( 'strService').AsString,
				FieldByName( 'strNotice').AsString
			])
		else
			rService.Lines.Text := FieldByName( 'strService').AsString;
		// assign notice label
	end;

	Schedule.Next;
end;

procedure TDailyClientScheduleReport.bSummary_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( Schedule.Eof);
	printif( Report.AvailableHeight > bSummary.Height + bFooter.Height);

	rTotalCount.Value := Schedule.RecordCount;
end;

end.
