unit Report_MatrixSchedule;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Math,
  Dialogs, Base_Report, FlexReport, StdCtrls, Buttons, ExtCtrls, ComCtrls,
  DateUtils, DBClient, Provider, DB, IBCustomDataSet, IBQuery, IBDatabase,
  StrUtils, DBLocal, DBLocalI, MainDataStore, Misc_Utilities, Misc_Constants;

type
  TServerPacket = record
    instanceKey : Integer;
    code, name, nameRead : String;
    birthday : TDate;
    sex : Integer;
    scheduleIndex : Integer;
    overlapped : Boolean;
  end;

  TMatrixScheduleReport = class(TReportTemplate)
    MainTransaction: TIBTransaction;
    bFooter: TFlexReportBand;
    rPageNumber: TFlexReportPageNumber;
    bSummary: TFlexReportBand;
    FlexReportPanel11: TFlexReportPanel;
    rTotalCount: TFlexReportDecimal;
    bTitle: TFlexReportBand;
    FlexReportPanel1: TFlexReportPanel;
    rScheduleAt: TFlexReportDateTime;
    Servers: TIBQuery;
    Schedule: TIBClientDataSet;
    bDetail: TFlexReportBand;
    rProfile: TFlexReportPanel;
    Transfer: TImage;
    Migration: TImage;
    Escort: TImage;
    rSchedule: TFlexReportPanel;
    Undefined: TImage;

    procedure Report_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure Paper_BeforePrint(Sender: TObject; Report: TFlexCustomReport);

    procedure bTitle_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure bDetail_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure rSchedule_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure bSummary_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
  private
    { Private 錾 }
    FHourFrom : Integer;
    FServers : array of TServerPacket;
    FSchedules : array of TSchedulePacket;
    FCurrServer : Integer;

    sv_keyInstance : Integer;
    sv_strServerCode, sv_strServerName, sv_strServerRead : Integer;
    sv_datServerBirthday, sv_typServerSex : Integer;
    sv_strServerPhone, sv_strServerAddress : Integer;

    sc_keyInstance, sc_typSchedule, sc_typProgress : Integer;
    sc_refSubject, sc_typSubject, sc_intSubjectAt, sc_intSubjectFor : Integer;
    sc_strService, sc_intMinutesFrom, sc_intMinutesTo : Integer;
    sc_typAddressFrom, sc_refAddressFrom, sc_strAddressFrom, sc_refResidentFrom : Integer;
    sc_typAddressTo, sc_refAddressTo, sc_strAddressTo, sc_refResidentTo : Integer;
    sc_refServer, sc_strServerCode, sc_strServerName, sc_strServerRead, sc_datServerBirthday, sc_typServerSex, sc_strServerAddress, sc_strServerPhone : Integer;
    sc_refRecipient, sc_refClient, sc_strClient : Integer;
    sc_strOpponent : Integer;
  public
    { Public 錾 }
    constructor Prepare( datAt : TDate; HourFrom, keyBranch, keyRegion : Integer);
  end;

var
  MatrixScheduleReport: TMatrixScheduleReport;

implementation

{$R *.dfm}

{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

constructor TMatrixScheduleReport.Prepare( datAt : TDate; HourFrom, keyBranch, keyRegion : Integer);
begin
	inherited Create( Screen.ActiveForm);

	rScheduleAt.Value := datAt;
	FHourFrom := HourFrom;

	Servers.ParamByName( 'datAvailableAt').AsDate := datAt;
	Servers.ParamByName( 'optAvailability').AsInteger := 1 shl ( DayOfWeek( datAt) - 1);
	Servers.ParamByName( 'optToday').AsInteger := 1 shl ( DayOfTheMonth( datAt) - 1);
	Servers.ParamByName( 'keyBranch').AsInteger := keyBranch;
	Servers.ParamByName( 'keyRegion').AsInteger := keyRegion;
	Servers.Open;
	Servers.FetchAll;

	sv_keyInstance := Servers.FieldByName( 'keyInstance').Index;
	sv_strServerCode := Servers.FieldByName( 'strServerCode').Index;
	sv_strServerName := Servers.FieldByName( 'strServerName').Index;
	sv_strServerRead := Servers.FieldByName( 'strServerRead').Index;
	sv_datServerBirthday := Servers.FieldByName( 'datServerBirthday').Index;
	sv_typServerSex := Servers.FieldByName( 'typServerSex').Index;
	sv_strServerPhone := Servers.FieldByName( 'strServerPhone').Index;
	sv_strServerAddress := Servers.FieldByName( 'strServerAddress').Index;
	// Servers setup

	Schedule.Params.ParamByName( 'datSchedule').AsDate := datAt;
	Schedule.Params.ParamByName( 'keyBranch').AsInteger := keyBranch;
	Schedule.Params.ParamByName( 'keyRegion').AsInteger := keyRegion;
	Schedule.Open;

	sc_keyInstance := Schedule.FieldByName( 'keyInstance').Index;
	sc_typSchedule := Schedule.FieldByName( 'typSchedule').Index;
	sc_typProgress := Schedule.FieldByName( 'typProgress').Index;
	sc_refSubject := Schedule.FieldByName( 'refSubject').Index;
	sc_typSubject := Schedule.FieldByName( 'typSubject').Index;
	sc_intSubjectAt  := Schedule.FieldByName( 'intSubjectAt').Index;
	sc_intSubjectFor  := Schedule.FieldByName( 'intSubjectFor').Index;
	sc_strService := Schedule.FieldByName( 'strService').Index;
	sc_intMinutesFrom := Schedule.FieldByName( 'intMinutesFrom').Index;
	sc_intMinutesTo  := Schedule.FieldByName( 'intMinutesTo').Index;
	sc_typAddressFrom := Schedule.FieldByName( 'typAddressFrom').Index;
	sc_refAddressFrom := Schedule.FieldByName( 'refAddressFrom').Index;
	sc_strAddressFrom := Schedule.FieldByName( 'strAddressFrom').Index;
	sc_refResidentFrom := Schedule.FieldByName( 'refResidentFrom').Index;
	sc_typAddressTo := Schedule.FieldByName( 'typAddressTo').Index;
	sc_refAddressTo := Schedule.FieldByName( 'refAddressTo').Index;
	sc_strAddressTo := Schedule.FieldByName( 'strAddressTo').Index;
	sc_refResidentTo := Schedule.FieldByName( 'refResidentTo').Index;
	sc_refServer  := Schedule.FieldByName( 'refServer').Index;
	sc_strServerCode := Schedule.FieldByName( 'strServerCode').Index;
	sc_strServerName := Schedule.FieldByName( 'strServerName').Index;
	sc_strServerRead := Schedule.FieldByName( 'strServerRead').Index;
	sc_datServerBirthday := Schedule.FieldByName( 'datServerBirthday').Index;
	sc_typServerSex := Schedule.FieldByName( 'typServerSex').Index;
	sc_strServerPhone := Schedule.FieldByName( 'strServerPhone').Index;
	sc_strServerAddress := Schedule.FieldByName( 'strServerAddress').Index;
	sc_refRecipient := Schedule.FieldByName( 'refRecipient').Index;
	sc_refClient := Schedule.FieldByName( 'refClient').Index;
	sc_strClient := Schedule.FieldByName( 'strClient').Index;
	sc_strOpponent := Schedule.FieldByName( 'strOpponent').Index;
	// Schedule setup
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TMatrixScheduleReport.Report_BeforePrint(Sender: TObject; Report: TFlexCustomReport);

	function PacketFromKey( keyProfile : Integer) : Integer;
	var
		index : Integer;
	begin
		result := -1;
		for index := Low( FServers) to High( FServers) do
		begin
			if FServers[ index].instanceKey = keyProfile then
			begin
				result := index;
				exit;
			end;
		end;
	end;

	procedure SortServer( leftMost, rightMost : Integer);
	var
		leftEdge, rightEdge : Integer;
		criterion, tempServer : TServerPacket;

		function CompareServer( const Server1, Server2 : TServerPacket) : Integer;
		begin
			result := CompareStr( Server1.nameRead, Server2.nameRead);
			if result <> 0 then exit;

			result := CompareStr( Server1.name, Server2.name);
			if result <> 0 then exit;

			result := Server1.instanceKey - Server2.instanceKey;
		end;
	begin
		if leftMost >= rightMost then exit;
		criterion := FServers[ ( leftMost + rightMost) div 2];
		leftEdge := leftMost;
		rightEdge := rightMost;

		while true do
		begin
			while ( leftEdge < rightEdge)
				and ( CompareServer( FServers[ leftEdge], criterion) < 0)
					do Inc( leftEdge);

			while ( rightEdge > leftEdge)
				and ( CompareServer( FServers[ rightEdge], criterion) > 0)
					do Dec( rightEdge);

			if leftEdge = rightEdge then break;

			tempServer := FServers[ leftEdge];
			FServers[ leftEdge] := FServers[ rightEdge];
			FServers[ rightEdge] := tempServer;
		end;

		SortServer( leftMost, leftEdge);
		SortServer( leftEdge + 1, rightMost);
	end;
var
	currServer, nextServer : Integer;
	currSchedule, nextSchedule : Integer;
begin
	printif( not ( Servers.IsEmpty and Schedule.IsEmpty));

	FServers := nil;
	nextServer := 0;
	SetLength( FServers, Max( 1, Servers.RecordCount + Schedule.RecordCount));
	FServers[ 0].scheduleIndex := -1;

	FSchedules := nil;
	nextSchedule := 0;
	SetLength( FSchedules, Schedule.RecordCount);

	Servers.First;
	with Servers do while not EOF do
	begin
		currServer := PacketFromKey( Fields[ sv_keyInstance].AsInteger);
		if currServer < 0 then
		begin
			currServer := nextServer;
			with FServers[ currServer] do
			begin
				instanceKey := Fields[ sv_keyInstance].AsInteger;
				code := Fields[ sv_strServerCode].AsString;
				name := Fields[ sv_strServerName].AsString;
				nameRead := Fields[ sv_strServerRead].AsString;
				birthday := Fields[ sv_datServerBirthday].AsDateTime;
				sex := Fields[ sv_typServerSex].AsInteger;
				scheduleIndex := -1;
			end;
			Inc( nextServer);
		end;
		Next;
	end;

	Schedule.First;
	with Schedule do while not EOF do
	begin
		currServer := PacketFromKey( Fields[ sc_refServer].AsInteger);
		if currServer < 0 then
		begin
			currServer := nextServer;
			with FServers[ currServer] do
			begin
				instanceKey := Fields[ sc_refServer].AsInteger;
				code := Fields[ sc_strServerCode].AsString;
				name := Fields[ sc_strServerName].AsString;
				nameRead := Fields[ sc_strServerRead].AsString;
				birthday := Fields[ sc_datServerBirthday].AsDateTime;
				sex := Fields[ sc_typServerSex].AsInteger;
				scheduleIndex := -1;
				overlapped := false;
			end;
			Inc( nextServer);
		end;

		if FServers[ currServer].scheduleIndex >= 0 then
		begin
			currSchedule := FServers[ currServer].scheduleIndex;
			while true do
			begin
				case Fields[ sc_typSchedule].AsInteger of CARE_SCHEDULE, MENAGE_SCHEDULE :
					if IntersectionOf(
						FSchedules[ currSchedule].minutesFrom, FSchedules[ currSchedule].minutesTo,
						Fields[ sc_intMinutesFrom].AsInteger, Fields[ sc_intMinutesTo].AsInteger
					) > 5 then
					begin
						FServers[ currServer].overlapped := true;
					end;
				else
					if ( FSchedules[ currSchedule].scheduleType = Fields[ sc_typSchedule].AsInteger)
					and ( FSchedules[ currSchedule].minutesFrom = Fields[ sc_intMinutesFrom].AsInteger)
					and ( FSchedules[ currSchedule].minutesTo = Fields[ sc_intMinutesTo].AsInteger)
					then
					begin
						FServers[ currServer].overlapped := true;
					end;
				end;
				if FSchedules[ currSchedule].nextIndex < 0 then break;
				currSchedule := FSchedules[ currSchedule].nextIndex;
			end;
			FSchedules[ currSchedule].nextIndex := nextSchedule;
		end
		else
		begin
			FServers[ currServer].scheduleIndex := nextSchedule;
		end;

		with FSchedules[ nextSchedule] do
		begin
			instanceKey := Fields[ sc_keyInstance].AsInteger;
			scheduleType := Fields[ sc_typSchedule].AsInteger;
			progress := Fields[ sc_typProgress].AsInteger;
			minutesFrom := Fields[ sc_intMinutesFrom].AsInteger;
			minutesTo := Fields[ sc_intMinutesTo].AsInteger;
			subjectAt := Fields[ sc_intSubjectAt].AsInteger;
			opponent := Fields[ sc_strOpponent].AsString;
			serverReady := true;
			subjectKey := Fields[ sc_refSubject].AsInteger;
			case scheduleType of
			MIGRATION_SCHEDULE :
				if minutesFrom < subjectAt + Fields[ sc_intSubjectFor].AsInteger div 2 then
					presence := BEFORE_PRESENCE
				else
					presence := AFTER_PRESENCE;

			TRANSFER_SCHEDULE :
				if ( subjectKey > 0) and ( Fields[ sc_typSubject].AsInteger <> TRANSFER_SCHEDULE) then
				begin
					if minutesFrom < subjectAt + Fields[ sc_intSubjectFor].AsInteger div 2 then
						presence := BEFORE_PRESENCE
					else
						presence := AFTER_PRESENCE;
				end
				else
					presence := FULL_PRESENCE;
			else
				presence := RAW_PRESENCE;
			end;
			recordNo := RecNo;
			nextIndex := -1;
		end;
		Inc( nextSchedule);

		Next;
	end;
	SetLength( FServers, Max( nextServer, 1));
	SortServer( Low( FServers), High( FServers));
end;

procedure TMatrixScheduleReport.Paper_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not bSummary.Printed);
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TMatrixScheduleReport.bTitle_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not bTitle.Printed);

	FCurrServer := Low( FServers);
end;

procedure TMatrixScheduleReport.bDetail_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( FCurrServer <= High( FServers));
	printif( Report.AvailableHeight > bDetail.Height + bFooter.Height);

	rProfile.Lines.Clear;
	rProfile.Lines.Add( FServers[ FCurrServer].code);
	rProfile.Lines.Add( FServers[ FCurrServer].name);
	if FServers[ FCurrServer].overlapped then
		rProfile.Brush.Color := clGray
	else
		rProfile.Brush.Color := $D0D0D0;
	// draw profile header
end;

procedure TMatrixScheduleReport.rSchedule_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
var
	Rect : TRect;
	Col : Integer;
	leftLimit, rightLimit : Integer;
	currSchedule : Integer;
begin
	Rect.Left := rProfile.Width;
	Rect.Right := bDetail.Width;
	Rect.Top := 0;
	Rect.Bottom := bDetail.Height;
	Report.BeginClip( Rect.Left, Rect.Top, Rect.Right, Rect.Bottom);
	// initialize bounds

	Report.Pen.Color := clLtGray;
	Report.Pen.Style := psSolid;
	Report.Line(
		Rect.Left, ( Rect.Top + Rect.Bottom) div 2,
		Rect.Right, ( Rect.Top + Rect.Bottom) div 2
	);
	// draw schedule axis

	Report.Font.Color := clGray;
	Report.Font.Height := 80;
	for Col := 0 to 11 do
	begin
		if ( Col mod 4 = 0) or ( FCurrServer mod 4 = 0) then
		begin
			Report.TextOut( Rect.Left + Col * 60 + 1, Rect.Top + 1,
				IfThen( ( ( FHourFrom + Col) div 12) mod 2 = 0,
					Format( 'AM%d:00', [ ( FHourFrom + Col) mod 12]),
					Format( 'PM%d:00', [ ( FHourFrom + Col) mod 12])
				),
				true
			);
		end;

		Report.Line(
			Rect.Left + Col * 60, Rect.Top,
			Rect.Left + Col * 60, Rect.Bottom
		);
	end;
	// draw time label

	Report.Font.Color := clBlack;
	Report.Font.Height := 80;
	currSchedule := FServers[ FCurrServer].scheduleIndex;
	while currSchedule >= 0 do with Report do
	begin
		with FSchedules[ currSchedule] do case scheduleType of
		CARE_SCHEDULE, MENAGE_SCHEDULE :
			begin
				Brush.Color := IfThen( scheduleType = CARE_SCHEDULE, clCare, clMenage);
				Brush.Style := bsSolid;
				if progress = UNCLEAR_PROGRESS then Brush.Style := bsDiagCross;

				Pen.Color := Brush.Color;
				Pen.Style := psSolid;

				leftLimit := Rect.Left + minutesFrom- FHourFrom * 60;
				rightLimit := Rect.Left + minutesTo- FHourFrom * 60;
				Rectangle( leftLimit, Rect.Top + 10, rightLimit, Rect.Top + 19);
			end;

		MIGRATION_SCHEDULE :
			begin
				leftLimit := Rect.Left + minutesFrom- FHourFrom * 60;
				rightLimit := leftLimit + 15;
				if progress <> UNCLEAR_PROGRESS then
					Draw( leftLimit, Rect.Top + 7, rightLimit, Rect.Top + 22, Migration.Picture.Graphic)
				else
					Draw( leftLimit, Rect.Top + 7, rightLimit, Rect.Top + 22, Undefined.Picture.Graphic);
			end;

		TRANSFER_SCHEDULE :
			if presence = FULL_PRESENCE then
			begin
				leftLimit := Rect.Left + minutesFrom- FHourFrom * 60;
				rightLimit := leftLimit + 15;
				if progress <> UNCLEAR_PROGRESS then
					Draw( leftLimit, Rect.Top + 7, rightLimit, Rect.Top + 22, Transfer.Picture.Graphic)
				else
					Draw( leftLimit, Rect.Top + 7, rightLimit, Rect.Top + 22, Undefined.Picture.Graphic);
			end
			else
			begin
				leftLimit := Rect.Left + minutesFrom- FHourFrom * 60;
				rightLimit := leftLimit + 15;
				if progress <> UNCLEAR_PROGRESS then
					Draw( leftLimit, Rect.Top + 7, rightLimit, Rect.Top + 22, Escort.Picture.Graphic)
				else
					Draw( leftLimit, Rect.Top + 7, rightLimit, Rect.Top + 22, Undefined.Picture.Graphic);
			end;
		end;

		Brush.Color := clWhite;
		Brush.Style := bsSolid;
		TextOut(
			( ( leftLimit + rightLimit) - TextWidth( FSchedules[ currSchedule].opponent)) div 2,
			Rect.Top + 20,
			FSchedules[ currSchedule].opponent,
			false
		);

		currSchedule := FSchedules[ currSchedule].nextIndex;
	end;
	// draw schedule

	Inc( FCurrServer);
	Report.EndClip();
end;

procedure TMatrixScheduleReport.bSummary_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( FCurrServer > High( FServers));
	printif( Report.AvailableHeight > bSummary.Height + bFooter.Height);

	rTotalCount.Value := High( FServers) + 1;
end;

end.
