unit Report_Paybacks;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, Base_Report, FlexReport, StdCtrls, Buttons, ExtCtrls, ComCtrls,
  DateUtils, DBClient, Provider, DB, IBCustomDataSet, IBQuery, IBDatabase,
  MainDataStore;

type
  TPaybacksReport = class(TReportTemplate)

    bTitle: TFlexReportBand;
    FlexReportPanel1: TFlexReportPanel;
    rTimeStamp: TFlexReportDateTime;
    bFooter: TFlexReportBand;
    bSummary: TFlexReportBand;
    bTable: TFlexReportLayout;
    bTableHeader: TFlexReportBand;
    FlexReportPanel3: TFlexReportPanel;
    FlexReportPanel4: TFlexReportPanel;
    bTableDetail: TFlexReportBand;
    rPublished: TFlexReportPanel;
    rCode: TFlexReportPanel;
    rPageNumber: TFlexReportPageNumber;
    rScheduleFrom: TFlexReportDateTime;
    rScheduleTo: TFlexReportDateTime;
    FlexReportPanel2: TFlexReportPanel;
    FlexReportPanel5: TFlexReportPanel;
    rPayback: TFlexReportDecimal;
    rMargin: TFlexReportDecimal;
    MainTransaction: TIBTransaction;
    SourceOf_Payback: TIBQuery;
    ProviderOf_Payback: TDataSetProvider;
    Payback: TClientDataSet;
    rMigrationPoint: TFlexReportDecimal;
    rTransferPoint: TFlexReportDecimal;
    rCarePoint: TFlexReportDecimal;
    rMenagePoint: TFlexReportDecimal;
    rName: TFlexReportPanel;
    FlexReportPanel7: TFlexReportPanel;
    FlexReportPanel8: TFlexReportPanel;
    FlexReportPanel9: TFlexReportPanel;
    FlexReportPanel10: TFlexReportPanel;
    FlexReportPanel12: TFlexReportPanel;
    FlexReportPanel15: TFlexReportPanel;
    rCareTotal: TFlexReportDecimal;
    rMenageTotal: TFlexReportDecimal;
    rMigrationTotal: TFlexReportDecimal;
    rTransferTotal: TFlexReportDecimal;
    rPaybackTotal: TFlexReportDecimal;
    rMarginTotal: TFlexReportDecimal;
    rCount: TFlexReportDecimal;
    rPricePerPoint: TFlexReportDecimal;
    FlexReportPanel6: TFlexReportPanel;

    procedure Report_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure Paper_BeforePrint(Sender: TObject; Report: TFlexCustomReport);

    procedure bTitle_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure bTable_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure bTableDetail_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure bSummary_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
  private
    { Private 錾 }
    FFrom : TDate;
    FTo : TDate;

    FCareTotal : Currency;
    FMenageTotal : Currency;
    FMigrationTotal : Currency;
    FTransferTotal : Currency;

    FMarginTotal : Currency;
    FPaybackTotal : Currency;
  public
    { Public 錾 }
    constructor Prepare( datFrom, datTo : TDate; collation : String);
  end;

var
  PaybacksReport: TPaybacksReport;

implementation

{$R *.dfm}

{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

constructor TPaybacksReport.Prepare( datFrom, datTo : TDate; collation : String);
begin
	inherited Create( Screen.ActiveForm);

	FFrom := datFrom;
	FTo := datTo;

	SourceOf_Payback.ParamByName( 'datFrom').AsDate := FFrom;
	SourceOf_Payback.ParamByName( 'datTo').AsDate := FTo;
	Payback.IndexFieldNames := collation;
	Payback.Open;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPaybacksReport.Report_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not Payback.IsEmpty);
end;

procedure TPaybacksReport.Paper_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not bSummary.Printed);
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPaybacksReport.bTitle_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not bTitle.Printed);

	rScheduleFrom.Value := FFrom;
	rScheduleTo.Value := FTo;

	FCareTotal := 0;
	FMenageTotal := 0;
	FMigrationTotal := 0;
	FTransferTotal := 0;

	FMarginTotal := 0;
	FPaybackTotal := 0;
end;

procedure TPaybacksReport.bTable_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not Payback.Eof);
end;

procedure TPaybacksReport.bTableDetail_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not Payback.Eof);
	printif( Report.AvailableHeight > bTableDetail.Height + bFooter.Height);

	with Payback do
	begin
		rCode.Lines.Text := FieldByName( 'strCode').AsString;
		rName.Lines.Text := FieldByName( 'strName').AsString;

		rPricePerPoint.Value := FieldByName( 'intPricePerPoint').AsCurrency;

		rCarePoint.Value := FieldByName( 'curCarePoint').AsCurrency;
		rMenagePoint.Value := FieldByName( 'curMenagePoint').AsCurrency;
		rMigrationPoint.Value := FieldByName( 'curMigrationPoint').AsCurrency;
		rTransferPoint.Value := FieldByName( 'curTransferPoint').AsCurrency;

		rMargin.Value := FieldByName( 'intMargin').AsCurrency;
		rPayback.Value := FieldByName( 'intPayback').AsCurrency;

		rPublished.Lines.Text := FormatDateTime( 'MM""dd""', FieldByName( 'datPublished').AsDateTime);
	end;

	FCareTotal := FCareTotal + rCarePoint.Value;
	FMenageTotal := FMenageTotal + rMenagePoint.Value;
	FMigrationTotal := FMigrationTotal + rMigrationPoint.Value;
	FTransferTotal := FTransferTotal + rTransferPoint.Value;

	FMarginTotal := FMarginTotal + rMargin.Value;
	FPaybackTotal := FPaybackTotal + rPayback.Value;

	Payback.Next;
end;

procedure TPaybacksReport.bSummary_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( Payback.Eof);
	printif( Report.AvailableHeight > bSummary.Height + bFooter.Height);

	rCareTotal.Value := FCareTotal;
	rMenageTotal.Value := FMenageTotal;
	rMigrationTotal.Value := FMigrationTotal;
	rTransferTotal.Value := FTransferTotal;

	rMarginTotal.Value := FMarginTotal;
	rPaybackTotal.Value := FPaybackTotal;

	rCount.Value := Payback.RecordCount;
end;

end.
