unit Report_Profile;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, Base_Report, FlexReport, StdCtrls, Buttons, ExtCtrls, ComCtrls,
  DateUtils, DBClient, Provider, DB, IBCustomDataSet, IBQuery, IBDatabase,
  StrUtils, MainDataStore, Misc_Constants, Misc_Utilities;

type
  TProfileReport = class(TReportTemplate)
    bNotice: TFlexReportBand;
    MainTransaction: TIBTransaction;
    Profile: TIBQuery;
    Notice: TIBQuery;
    FlexReportPanel26: TFlexReportPanel;
    rContent: TFlexReportPanel;
    FlexReportPanel30: TFlexReportPanel;
    rAvailableTo: TFlexReportDateTime;
    rAvailableFrom: TFlexReportDateTime;
    FlexReportPanel28: TFlexReportPanel;
    rTitle: TFlexReportPanel;
    bHeader: TFlexReportLayout;
    bTitle: TFlexReportBand;
    rHeader: TFlexReportPanel;
    rTimeStamp: TFlexReportDateTime;
    FlexReportBand10: TFlexReportBand;
    FlexReportBand14: TFlexReportBand;
    FlexReportPanel6: TFlexReportPanel;
    rRegion: TFlexReportPanel;
    FlexReportBand9: TFlexReportBand;
    FlexReportPanel4: TFlexReportPanel;
    rCode: TFlexReportPanel;
    bTable: TFlexReportLayout;
    bTableDetail: TFlexReportBand;
    rName: TFlexReportPanel;
    FlexReportPanel2: TFlexReportPanel;
    bTableHeader: TFlexReportBand;
    FlexReportPanel3: TFlexReportPanel;
    rNameRead: TFlexReportPanel;
    FlexReportBand11: TFlexReportBand;
    FlexReportPanel13: TFlexReportPanel;
    rBirthday: TFlexReportDateTime;
    rSex: TFlexReportPanel;
    FlexReportPanel17: TFlexReportPanel;
    rAge: TFlexReportInteger;
    FlexReportLayout1: TFlexReportLayout;
    FlexReportBand2: TFlexReportBand;
    FlexReportPanel8: TFlexReportPanel;
    FlexReportPanel9: TFlexReportPanel;
    rAddress: TFlexReportPanel;
    rZip: TFlexReportPanel;
    FlexReportBand1: TFlexReportBand;
    FlexReportPanel5: TFlexReportPanel;
    rAddressRead: TFlexReportPanel;
    FlexReportLayout3: TFlexReportLayout;
    FlexReportBand6: TFlexReportBand;
    FlexReportPanel11: TFlexReportPanel;
    rPhoneNumber3: TFlexReportPanel;
    FlexReportBand7: TFlexReportBand;
    FlexReportPanel19: TFlexReportPanel;
    rPhoneNumber2: TFlexReportPanel;
    FlexReportBand8: TFlexReportBand;
    FlexReportPanel21: TFlexReportPanel;
    rPhoneNumber1: TFlexReportPanel;
    FlexReportLayout2: TFlexReportLayout;
    FlexReportBand3: TFlexReportBand;
    FlexReportPanel12: TFlexReportPanel;
    rFaxNumber3: TFlexReportPanel;
    FlexReportBand4: TFlexReportBand;
    FlexReportPanel14: TFlexReportPanel;
    rFaxNumber2: TFlexReportPanel;
    FlexReportBand5: TFlexReportBand;
    FlexReportPanel16: TFlexReportPanel;
    rFaxNumber1: TFlexReportPanel;
    FlexReportBand12: TFlexReportBand;
    FlexReportPanel7: TFlexReportPanel;
    rBranch: TFlexReportPanel;

    procedure Report_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure Paper_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure Header_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure Notice_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
  private
    { Private 錾 }
  public
    { Public 錾 }
    constructor Prepare( keyInstance : Integer);
  end;

var
  ProfileReport: TProfileReport;

implementation

{$R *.dfm}

{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

constructor TProfileReport.Prepare( keyInstance : Integer);
begin
	inherited Create( Screen.ActiveForm);

	Profile.ParamByName( 'keyInstance').AsInteger := keyInstance;
	Profile.ParamByName( 'datAvailableAt').AsDate := Today;
	Profile.Open;

	Notice.ParamByName( 'keyProfile').AsInteger := keyInstance;
	Notice.Open;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TProfileReport.Report_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not Profile.IsEmpty);
end;

procedure TProfileReport.Paper_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( ( not bHeader.Printed) or ( not Notice.Eof));
end;

procedure TProfileReport.Header_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not bHeader.Printed);

	with Profile do
	begin
		case FieldByName( 'typCategory').AsInteger of
		CLIENT_PROFILE : rHeader.Lines.Text := 'pҏ';
		SERVER_PROFILE : rHeader.Lines.Text := '񋟎ҏ';
		end;

		rBranch.Lines.Text := FieldByName( 'strBranch').AsString;
		rRegion.Lines.Text := FieldByName( 'strRegion').AsString;
		rCode.Lines.Text := FieldByName( 'strCode').AsString;

		rNameRead.Lines.Text := FieldByName( 'strNameRead').AsString;
		rName.Lines.Text := FieldByName( 'strName').AsString;

		rBirthday.Value := FieldByName( 'datBirthday').AsDateTime;
		rAge.Value := YearsBetween( Today, FieldByName( 'datBirthday').AsDateTime);
		rSex.Lines.Text := aSex[ FieldByName( 'typSex').AsInteger];

		rZip.Lines.Text := '' + ToZipText( FieldByName( 'refZip').AsInteger);
		rAddressRead.Lines.Text := FieldByName( 'strAddressRead').AsString;
		rAddress.Lines.Text := FieldByName( 'strAddress').AsString;

		rPhoneNumber1.Lines.Text := FieldByName( 'strPhoneNumber1').AsString;
		rPhoneNumber2.Lines.Text := FieldByName( 'strPhoneNumber2').AsString;
		rPhoneNumber3.Lines.Text := FieldByName( 'strPhoneNumber3').AsString;

		rFaxNumber1.Lines.Text := FieldByName( 'strFaxNumber1').AsString;
		rFaxNumber2.Lines.Text := FieldByName( 'strFaxNumber2').AsString;
		rFaxNumber3.Lines.Text := FieldByName( 'strFaxNumber3').AsString;
	end;
end;

procedure TProfileReport.Notice_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not Notice.Eof);
	printif( Report.AvailableHeight > bNotice.Height);

	with Notice do
	begin
		rTitle.Lines.Text := FieldByName( 'strTitle').AsString;
		rAvailableFrom.Value := FieldByName( 'datAvailableFrom').AsDateTime;
		rAvailableTo.Value := FieldByName( 'datAvailableTo').AsDateTime;
		rContent.Lines.Text := FieldByName( 'strContent').AsString;
	end;

	Notice.Next;
end;

end.
