unit Report_Services;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, Base_Report, FlexReport, StdCtrls, Buttons, ExtCtrls, ComCtrls,
  DateUtils, DBClient, Provider, DB, IBCustomDataSet, IBQuery, IBDatabase,
  StrUtils, MainDataStore, Misc_Utilities, Misc_Constants;

type
  TServicesReport = class(TReportTemplate)
    MainTransaction: TIBTransaction;
    SourceOf_Service: TIBQuery;

    bTitle: TFlexReportBand;
    FlexReportPanel1: TFlexReportPanel;
    rTimeStamp: TFlexReportDateTime;
    bFooter: TFlexReportBand;
    rPageNumber: TFlexReportPageNumber;
    bSummary: TFlexReportBand;
    FlexReportPanel11: TFlexReportPanel;
    rTotalCount: TFlexReportDecimal;
    bTable: TFlexReportLayout;
    Service: TClientDataSet;
    ProviderOf_Service: TDataSetProvider;
    bServices: TFlexReportLayout;
    bTableHeader: TFlexReportBand;
    FlexReportPanel5: TFlexReportPanel;
    FlexReportPanel6: TFlexReportPanel;
    FlexReportPanel2: TFlexReportPanel;
    bTableDetail: TFlexReportBand;
    rName: TFlexReportPanel;
    rAvailableFrom: TFlexReportDateTime;
    rAvailableTo: TFlexReportDateTime;
    rAvailability: TFlexReportPanel;
    rCategory: TFlexReportPanel;
    FlexReportPanel4: TFlexReportPanel;
    rCatalogue: TFlexReportPanel;

    procedure Report_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure Paper_BeforePrint(Sender: TObject; Report: TFlexCustomReport);

    procedure bTitle_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure bTable_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure bTableDetail_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure bSummary_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
  private
    { Private 錾 }
  public
    { Public 錾 }
    constructor Prepare( typCatalogue : Integer);
  end;

var
  ServicesReport: TServicesReport;

implementation

{$R *.dfm}

{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

constructor TServicesReport.Prepare( typCatalogue : Integer);
begin
	inherited Create( Screen.ActiveForm);

	Service.Filter := CatalogueFilter( typCatalogue);
	Service.Open;

	rCatalogue.Lines.Text := aCatalogue[ typCatalogue];
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TServicesReport.Report_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not Service.IsEmpty);
end;

procedure TServicesReport.Paper_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not bSummary.Printed);
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TServicesReport.bTitle_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not bTitle.Printed);
end;

procedure TServicesReport.bTable_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not Service.Eof);
end;

procedure TServicesReport.bTableDetail_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
var
	availabilityBits : Integer;
	availabilityLabel : String;
begin
	printif( not Service.Eof);
	printif( Report.AvailableHeight > bTableDetail.Height + bFooter.Height);

	availabilityBits := Service.FieldByName( 'optAvailability').AsInteger;
	availabilityLabel := availabilityLabel + IfThen( ( availabilityBits and SUNDAY_AVAILABLE) <> 0, ' ', '~ ');
	availabilityLabel := availabilityLabel + IfThen( ( availabilityBits and MONDAY_AVAILABLE) <> 0, ' ', '~ ');
	availabilityLabel := availabilityLabel + IfThen( ( availabilityBits and TUESDAY_AVAILABLE) <> 0, ' ', '~ ');
	availabilityLabel := availabilityLabel + IfThen( ( availabilityBits and WEDNESDAY_AVAILABLE) <> 0, ' ', '~ ');
	availabilityLabel := availabilityLabel + IfThen( ( availabilityBits and THURSDAY_AVAILABLE) <> 0, ' ', '~ ');
	availabilityLabel := availabilityLabel + IfThen( ( availabilityBits and FRIDAY_AVAILABLE) <> 0, ' ', '~ ');
	availabilityLabel := availabilityLabel + IfThen( ( availabilityBits and SATURDAY_AVAILABLE) <> 0, 'y ', '~ ');

	with Service do
	begin
		rCategory.Lines.Text := aServiceInShort[ FieldByName( 'typCategory').AsInteger];
		rName.Lines.Text := FieldByName( 'strName').AsString;
		rAvailability.Lines.Text := availabilityLabel;
		rAvailableFrom.Value := FieldByName( 'datAvailableFrom').AsDateTime;
		rAvailableTo.Value := FieldByName( 'datAvailableTo').AsDateTime;
	end;

	Service.Next;
end;

procedure TServicesReport.bSummary_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( Service.Eof);
	printif( Report.AvailableHeight > bSummary.Height + bFooter.Height);

	rTotalCount.Value := Service.RecordCount;
end;

end.
