unit Report_Ticket;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, Base_Report, FlexReport, StdCtrls, Buttons, ExtCtrls, ComCtrls,
  DateUtils, DBClient, Provider, DB, IBCustomDataSet, IBQuery, IBDatabase,
  MainDataStore, Misc_Utilities, Misc_Constants;

type
  TTicketReport = class(TReportTemplate)
    MainTransaction: TIBTransaction;
    Ticket: TIBQuery;

    bFooter: TFlexReportBand;
    rPageNumber: TFlexReportPageNumber;
    bSummary: TFlexReportBand;
    bTitle: TFlexReportLayout;
    FlexReportBand1: TFlexReportBand;
    FlexReportPanel1: TFlexReportPanel;
    rTimeStamp: TFlexReportDateTime;
    rTicketCode: TFlexReportInteger;
    FlexReportBand9: TFlexReportBand;
    FlexReportPanel2: TFlexReportPanel;
    rCode: TFlexReportPanel;
    FlexReportLayout1: TFlexReportLayout;
    FlexReportBand2: TFlexReportBand;
    FlexReportPanel3: TFlexReportPanel;
    rNameRead: TFlexReportPanel;
    FlexReportBand3: TFlexReportBand;
    rName: TFlexReportPanel;
    FlexReportPanel6: TFlexReportPanel;
    FlexReportLayout2: TFlexReportLayout;
    FlexReportBand4: TFlexReportBand;
    FlexReportPanel8: TFlexReportPanel;
    rAddressRead: TFlexReportPanel;
    FlexReportBand5: TFlexReportBand;
    FlexReportPanel9: TFlexReportPanel;
    FlexReportPanel10: TFlexReportPanel;
    rAddress: TFlexReportPanel;
    rZip: TFlexReportPanel;
    FlexReportBand6: TFlexReportBand;
    FlexReportBand7: TFlexReportBand;
    FlexReportPanel13: TFlexReportPanel;
    rPublished: TFlexReportDateTime;
    FlexReportPanel12: TFlexReportPanel;
    rSummary: TFlexReportPanel;
    Padding: TFlexReportBand;
    rCenterCall: TFlexReportPanel;
    rCenterName: TFlexReportPanel;
    rCenterLocation: TFlexReportPanel;
    Center: TIBQuery;

    procedure Report_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure Paper_BeforePrint(Sender: TObject; Report: TFlexCustomReport);

    procedure bTitle_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure bSummary_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
  private
    { Private 錾 }
  public
    { Public 錾 }
    constructor Prepare( keyInstance : Integer);
  end;

var
  TicketReport: TTicketReport;

implementation

{$R *.dfm}

{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

constructor TTicketReport.Prepare( keyInstance : Integer);
begin
	inherited Create( Screen.ActiveForm);

	Ticket.ParamByName( 'keyInstance').AsInteger := keyInstance;
	Ticket.Open;

	Center.Open;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TTicketReport.Report_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not Ticket.IsEmpty);
end;

procedure TTicketReport.Paper_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not bSummary.Printed);
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TTicketReport.bTitle_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not bTitle.Printed);

	with Ticket do
	begin
		rTicketCode.Value := FieldByName( 'keyInstance').AsInteger;

		rPublished.Value := FieldByName( 'datPublished').AsDateTime;

		rCode.Lines.Text := FieldByName( 'strCode').AsString;

		rNameRead.Lines.Text := FieldByName( 'strNameRead').AsString;
		rName.Lines.Text := FieldByName( 'strName').AsString;

		rZip.Lines.Text := '' + ToZipText( FieldByName( 'refZip').AsInteger);
		rAddressRead.Lines.Text := FieldByName( 'strAddressRead').AsString;
		rAddress.Lines.Text := FieldByName( 'strAddress').AsString;

		if FieldByName( 'intMargin').AsCurrency > 0 then
			rSummary.Lines.Text := Format(
				' %0.2n _ ~ %0.0n ~ { %0.0n ~(萔)  %0.0n ~', [
					FieldByName( 'curPoint').AsCurrency,
					FieldByName( 'intPricePerPoint').AsCurrency,
					FieldByName( 'intMargin').AsCurrency,
					CurrToMoney( FieldByName( 'curPoint').AsCurrency * FieldByName( 'intPricePerPoint').AsCurrency)
						+ FieldByName( 'intMargin').AsCurrency
				])
		else
			rSummary.Lines.Text := Format(
				' %0.2n _ ~ %0.0n ~  %0.0n ~', [
					FieldByName( 'curPoint').AsCurrency,
					FieldByName( 'intPricePerPoint').AsCurrency,
					CurrToMoney( FieldByName( 'curPoint').AsCurrency * FieldByName( 'intPricePerPoint').AsCurrency)
				]);
	end;
end;

procedure TTicketReport.bSummary_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( Report.AvailableHeight > bSummary.Height + bFooter.Height);

	with Center do
	begin
		rCenterLocation.Lines.Strings[ 0] := Format( '%s@%s%s', [
		ToZipText( FieldByName( 'refZip').AsInteger),
			FieldByName( 'strZipAddress').AsString,
			FieldByName( 'strAddress').AsString
		]);
		rCenterLocation.Lines.Strings[ 1] := FieldByName( 'strLegalName').AsString;
		rCenterName.Lines.Text := FieldByName( 'strTradeName').AsString;

		if FieldByName( 'strPhoneNumber2').AsString <> '' then
			rCenterCall.Lines.Strings[ 0] := Format( 'dbF%s & %s', [
				FieldByName( 'strPhoneNumber1').AsString,
				FieldByName( 'strPhoneNumber2').AsString
			])
		else
			rCenterCall.Lines.Strings[ 0] := Format( 'dbF%s', [
				FieldByName( 'strPhoneNumber1').AsString
			]);

		if FieldByName( 'strFaxNumber2').AsString <> '' then
			rCenterCall.Lines.Strings[ 1] := Format( 'FAXF%s & %s', [
				FieldByName( 'strFaxNumber1').AsString,
				FieldByName( 'strFaxNumber2').AsString
			])
		else
			rCenterCall.Lines.Strings[ 1] := Format( 'FAXF%s', [
				FieldByName( 'strFaxNumber1').AsString
			]);
	end;
end;

end.
