unit Set_Billing;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, IBSQL, IBDatabase, StdCtrls, ExtCtrls, ComCtrls, Grids, DBGrids,
  DB, DBClient, Provider, IBCustomDataSet, IBQuery, StrUtils, DateUtils,
  DBCtrls, Base_Set, IBEvents, Math, ValEdit, IBUpdateSQL,
  Misc_Constants, Misc_Utilities;

type
  TBillingSet = class(TSetTemplate)
    Center: TIBQuery;

    Unregistered_Billing: TIBQuery;
    UpdaterOf_Billing: TIBUpdateSQL;
    Registered_Billing: TIBQuery;

    Unregistered_Receipt: TIBQuery;
    UpdaterOf_Receipt: TIBUpdateSQL;
    Registered_Receipt: TIBQuery;
    ProviderOf_Receipt: TDataSetProvider;
    Receipt: TClientDataSet;
    DataSourceOf_Receipt: TDataSource;

    PrevLastday: TIBQuery;

    lblCode: TLabel;
    lblPublish: TLabel;
    dtpPublish: TDateTimePicker;
    bvlUpperBorder: TBevel;

    txtCode: TLabeledEdit;
    btnBrowseProfile: TButton;
    btnChooseProfile: TButton;
    txtFamilyNameRead: TLabeledEdit;
    txtFamilyName: TLabeledEdit;
    txtFirstNameRead: TLabeledEdit;
    txtFirstName: TLabeledEdit;
    lblBirthday: TLabel;
    pnlSex: TPanel;
    pnlBirthday: TPanel;
    txtInformation: TEdit;
    vlstCash: TValueListEditor;
    vlstCount: TValueListEditor;
    bvlMidBorder: TBevel;
    txtSummary: TEdit;
    txtMargin: TLabeledEdit;
    lblMargin: TLabel;
    bvlLowerBorder: TBevel;

    pnlSpan: TPanel;
    btnChooseSpan: TButton;
    btnQuoteSpanHead: TButton;

    gridReceipt: TDBGrid;

    btnBrowseReceipt: TButton;
    btnRemoveReceipt: TButton;

    btnPrint: TButton;

    procedure dtpPublish_Change(Sender: TObject);

    procedure btnBrowseProfile_Click(Sender: TObject);
    procedure btnChooseProfile_Click(Sender: TObject);

    procedure txtAmount_Change(Sender: TObject);
    procedure txtMargin_Change(Sender: TObject);

    procedure btnChooseSpan_Click(Sender: TObject);
    procedure btnQuoteSpanHead_Click(Sender: TObject);

    procedure Billing_AfterOpen(DataSet: TDataSet);
    procedure Receipt_AfterOpen(DataSet: TDataSet);

    procedure Grid_DrawColumnCell(Sender: TObject; const Rect: TRect; DataCol: Integer; Column: TColumn; State: TGridDrawState);

    procedure btnBrowseReceipt_Click(Sender: TObject);
    procedure btnRemoveReceipt_Click(Sender: TObject);

    procedure btnPrint_Click(Sender: TObject);

  private
    { Private 錾 }
    FMonthFirstday : TDate;
    FMonthLastday : TDate;
    FProfileKey : Integer;

    FCash : array[ CARE_SCHEDULE..TRANSFER_SCHEDULE] of Integer;
    FCount : array[ CARE_SCHEDULE..TRANSFER_SCHEDULE] of Integer;

    procedure Recount();
    procedure Roundup();
  protected
    { Protected 錾 }
    procedure DefineTable( var nameOfTable : String; var modifyFlag, cancelFlag : Boolean); override;

    procedure BeforeInput(); override;
    procedure AfterInput(); override;

    procedure BeforeSelect(); override;
    procedure AfterSelect(); override;

    procedure BeforeAppend(); override;
    procedure AfterAppend(); override;

    procedure BeforePopup(); override;
    procedure AfterPopup(); override;
  public
    { Public 錾 }
    constructor Prepare; overload; override;
    constructor Prepare( datMonthFirstday, datMonthLastday, datPublished : TDate; keyClient : Integer); overload;
  end;

var
  BillingSet: TBillingSet;

implementation

{$R *.dfm}

uses Chooser_Client, Set_Client, Chooser_Span, Dialog_Snapshot, Report_Billing, MainDatastore;

{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

function SumOfArray( aInteger : array of Integer) : Integer; overload;
var
	Index : Integer;
begin
	result := 0;
	for Index := Low( aInteger) to High( aInteger) do result := result + aInteger[ Index];
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

constructor TBillingSet.Prepare;
begin
	inherited Prepare;

	FMonthFirstday := StartOfTheMonth( Today);
	FMonthLastday := EndOfTheMonth( Today);
	FProfileKey := -1;
	dtpPublish.Date := Today;
end;

constructor TBillingSet.Prepare( datMonthFirstday, datMonthLastday, datPublished : TDate; keyClient : Integer);
begin
	inherited Prepare;

	FMonthFirstday := datMonthFirstday;
	FMonthLastday := datMonthLastday;
	FProfileKey := keyClient;
	dtpPublish.Date := datPublished;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TBillingSet.Recount();
begin
	pnlSpan.Caption := Format( '%s ` %s', [
		FormatDateTime( 'gg ee" N "yyyy" N "MM"  "dd" "', FMonthFirstday),
		FormatDateTime( 'gg ee" N "yyyy" N "MM"  "dd" "', FMonthLastday)
	]);

	if Appending then
	begin
		Receipt.Close;
		Unregistered_Receipt.ParamByName( 'keyClient').AsInteger := FProfileKey;
		Unregistered_Receipt.ParamByName( 'datFrom').AsDate := FMonthFirstday;
		Unregistered_Receipt.ParamByName( 'datTo').AsDate := FMonthLastday;
		Receipt.Open;
	end
	else
	begin
		Receipt.Close;
		Registered_Receipt.ParamByName( 'keyBilling').AsInteger := PrimaryKey;
		Receipt.Open;
	end;

	gridReceipt.SelectedRows.CurrentRowSelected := true;
end;

procedure TBillingSet.Roundup();
var
	Bookmark : String;
begin
	FillChar( FCash, SizeOf( FCash), 0);
	FillChar( FCount, SizeOf( FCount), 0);

	Receipt.DisableControls;
	Bookmark := Receipt.Bookmark;
	Receipt.First;
	with Receipt do while not EOF do
	begin
		Edit;
		FieldByName( 'intExchange').AsCurrency := AmountOf(
			FieldByName( 'typExchange').AsInteger,
			FieldByName( 'curAmountPerCount').AsCurrency,
			FieldByName( 'curAmountPerHour').AsCurrency,
			FieldByName( 'intMinutesFor').AsInteger
		);
		Post;

		with FieldByName( 'typSchedule') do
		begin
			FCash[ AsInteger] := FCash[ AsInteger] + FieldByName( 'intExchange').AsInteger;
			FCount[ AsInteger] := FCount[ AsInteger] + 1;
		end;

		Next;
	end;
	Receipt.Bookmark := Bookmark;
	Receipt.EnableControls;

	vlstCash.Values[ 'T[rXz'] := Format( '%0.0n ~', [ Int( FCash[ CARE_SCHEDULE])]);
	vlstCash.Values[ 'ƎT[rXz'] := Format( '%0.0n ~', [ Int( FCash[ MENAGE_SCHEDULE])]);
	vlstCash.Values[ '}T[rXz'] := Format( '%0.0n ~', [ Int( FCash[ MIGRATION_SCHEDULE])]);
	vlstCash.Values[ 'ڑT[rXz'] := Format( '%0.0n ~', [ Int( FCash[ TRANSFER_SCHEDULE])]);
	vlstCash.Values[ 'v'] := Format( '%0.0n ~', [ Int( SumOfArray( FCash))]);

	vlstCount.Values[ 'T[rX'] := Format( '%d ', [ FCount[ CARE_SCHEDULE]]);
	vlstCount.Values[ 'ƎT[rX'] := Format( '%d ', [ FCount[ MENAGE_SCHEDULE]]);
	vlstCount.Values[ '}T[rX'] := Format( '%d ', [ FCount[ MIGRATION_SCHEDULE]]);
	vlstCount.Values[ 'ڑT[rX'] := Format( '%d ', [ FCount[ TRANSFER_SCHEDULE]]);
	vlstCount.Values[ 'v'] := Format( '%d ', [ SumOfArray( FCount)]);

	btnBrowseReceipt.Enabled := not Receipt.IsEmpty;
	btnRemoveReceipt.Enabled := ( not Receipt.IsEmpty) and Appending;

	txtAmount_Change( self);
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TBillingSet.DefineTable( var nameOfTable : String; var modifyFlag, cancelFlag : Boolean);
begin
	nameOfTable := 'Billing';
	modifyFlag := false;
	cancelFlag := true;
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TBillingSet.BeforeInput();
begin
end;

procedure TBillingSet.AfterInput();
begin
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TBillingSet.BeforeSelect();
begin
	Registered_Billing.ParamByName( 'keyInstance').AsInteger := PrimaryKey;
	Registered_Billing.Open;

	ProviderOf_Receipt.DataSet := Registered_Receipt;
	// query setup

	with Registered_Billing do
	begin
		lblCode.Caption := 'ԍF' + IntToStr( PrimaryKey);
		FMonthFirstday := FieldByName( 'datMonthFirstday').AsDateTime;
		FMonthLastday := FieldByName( 'datMonthLastday').AsDateTime;

		dtpPublish.Date := FieldByName( 'datPublished').AsDateTime;
		txtMargin.Text := FieldByName( 'intMargin').AsString;
	end;
	// other components setup
end;

procedure TBillingSet.AfterSelect();
begin
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TBillingSet.BeforeAppend();
begin
	Center.Open;

	Unregistered_Billing.ParamByName( 'keyProfile').AsInteger := FProfileKey;
	Unregistered_Billing.ParamByName( 'datPublished').AsDateTime := dtpPublish.Date;
	Unregistered_Billing.Open;

	ProviderOf_Receipt.DataSet := Unregistered_Receipt;
end;

procedure TBillingSet.AfterAppend();
begin
	with Unregistered_Billing do
	begin
		Edit;
		FieldByName( 'keyInstance').AsInteger := RealizedKey;

		FieldByName( 'datMonthFirstday').AsDateTime := FMonthFirstday;
		FieldByName( 'datMonthLastday').AsDateTime := FMonthLastday;
		FieldByName( 'datPublished').AsDateTime := dtpPublish.Date;

		FieldByName( 'intCash').AsCurrency := SumOfArray( FCash);
		FieldByName( 'intMargin').AsInteger := StrToInt( txtMargin.Text);

		FieldByName( 'intCareCash').AsCurrency := FCash[ CARE_SCHEDULE];
		FieldByName( 'intMenageCash').AsCurrency := FCash[ MENAGE_SCHEDULE];
		FieldByName( 'intMigrationCash').AsCurrency := FCash[ MIGRATION_SCHEDULE];
		FieldByName( 'intTransferCash').AsCurrency := FCash[ TRANSFER_SCHEDULE];

		Post;
		UpdaterOf_Billing.Apply( ukInsert);
	end;

	with Unregistered_Receipt do
	begin
		Open;
		Receipt.ApplyUpdates( 0);
		First;
		while not Eof do
		begin
			Edit;
			FieldByName( 'refBilling').AsInteger := RealizedKey;
			Post;
			UpdaterOf_Receipt.Apply( ukInsert);
			Next;
		end;
	end;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TBillingSet.BeforePopup();
begin
	dtpPublish.Enabled := Appending;
	dtpPublish_Change( dtpPublish);

	btnChooseProfile.Enabled := Appending;

	txtMargin.ReadOnly := Browsing;

	btnPrint.Visible := not Appending;

	Caption := Format( '%s - %s ` %s', [
		Caption,
		FormatDateTime( 'yyyy" N "MM"  "dd" "', FMonthFirstday),
		FormatDateTime( 'yyyy" N "MM"  "dd" "', FMonthLastday)
	]);

	Recount;

	if not Appending then lblCode.Caption := Format( 'ԍF(%d)', [ PrimaryKey]);
end;

procedure TBillingSet.AfterPopup();
var
	Margin : Integer;
begin
	with Unregistered_Billing do if IsEmpty then
		ErrorMessages.Add( 'w肳ꂽL[ɊYo^҂̋L^͂܂B');

	with Unregistered_Billing do if ( not IsEmpty) and FieldByName( 'strAddress').IsNull then
		ErrorMessages.Add( '̓o^҂ɂ͐ɂ鎩Z̓o^܂B');

	if dtpPublish.Date < FMonthLastday then
		ErrorMessages.Add( 'sWvԓɂȂĂ܂B');

	Margin := StrToIntDef( txtMargin.Text, -1);

	if Margin < 0 then
		ErrorMessages.Add( '萔͔p݂̂pĎw肵ĂB');

	if SumOfArray( FCash) + Margin = 0 then
		ErrorMessages.Add( 'ΏۂƂȂт萔̎w܂B');

	if Center.FieldByName( 'typBillingMarginPerEvent').AsInteger = MARGIN_BY_MANUAL then
		if SilentAction then
			ErrorMessages.Add( 'N/A');
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TBillingSet.dtpPublish_Change(Sender: TObject);
begin
	dtpPublish.Format := FormatDateTime( ' gg ee "N yyyy N MM  dd "', dtpPublish.Date);

	if Appending then
	begin
		Unregistered_Billing.Close;
		Unregistered_Billing.ParamByName( 'datPublished').AsDateTime := dtpPublish.Date;
		Unregistered_Billing.Open;
	end;
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TBillingSet.btnBrowseProfile_Click( Sender: TObject);
begin
	TClientSet.Prepare.Browse( FProfileKey);
end;

procedure TBillingSet.btnChooseProfile_Click(Sender: TObject);
begin
	if ChooseClient( Transaction, dtpPublish.Date, FProfileKey) then
	begin
		Unregistered_Billing.Close;
		Unregistered_Billing.ParamByName( 'keyProfile').AsInteger := FProfileKey;
		Unregistered_Billing.Open;

		Recount;

		txtMargin.SetFocus;
	end;
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TBillingSet.txtAmount_Change(Sender: TObject);
begin
	if Appending then case Center.FieldByName( 'typBillingMarginPerEvent').AsInteger of
	MARGIN_BY_PERMILLAGE : txtMargin.Text := IntToStr( Center.FieldByName( 'intBillingMarginPerCheck').AsInteger + SumOfArray( FCash) * Center.FieldByName( 'intBillingMarginPerEvent').AsInteger div 1000);
	MARGIN_BY_PERCOUNT : txtMargin.Text := IntToStr( Center.FieldByName( 'intBillingMarginPerCheck').AsInteger + SumOfArray( FCount) * Center.FieldByName( 'intBillingMarginPerEvent').AsInteger);
	end;

	txtMargin_Change( Sender);
end;

procedure TBillingSet.txtMargin_Change(Sender: TObject);
begin
	if SumOfArray( FCount) = 0 then
	begin
		txtSummary.Text := ' *** ΏۂƂȂт܂ ***';
		exit;
	end;

	if StrToIntDef( txtMargin.Text, 0) > 0 then
		txtSummary.Text := Format( ' %0.0n ~ { %0.0n ~  %0.0n ~', [
			Int( SumOfArray( FCash)),
			Int( StrToIntDef( txtMargin.Text, 0)),
			Int( SumOfArray( FCash) + StrToIntDef( txtMargin.Text, 0))
		])
	else
		txtSummary.Text := Format( ' %0.0n ~', [ Int( SumOfArray( FCash))]);
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TBillingSet.btnChooseSpan_Click(Sender: TObject);
begin
	if ChooseSpan( FMonthFirstday, FMonthLastday) then Recount;
end;

procedure TBillingSet.btnQuoteSpanHead_Click(Sender: TObject);
begin
	PrevLastday.ParamByName( 'keyProfile').AsInteger := FProfileKey;
	PrevLastday.Open;
	if PrevLastday.FieldByName( 'datLatestLastday').AsDateTime = 0 then
		ShowNotify( 'L^܂łB', '')
	else
		FMonthFirstday := Min( FMonthLastday, IncDay( PrevLastday.FieldByName( 'datLatestLastday').AsDateTime));
	PrevLastday.Close;
	Recount;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TBillingSet.Billing_AfterOpen(DataSet: TDataSet);
begin
	with DataSet do if IsEmpty then
	begin
		txtCode.Text := '';
		txtFamilyNameRead.Text := 'Ă傤';
		txtFamilyName.Text := '񋟎';
		txtFirstNameRead.Text := '߂';
		txtFirstName.Text := '';
		pnlBirthday.Caption := 'N N';
		pnlSex.Caption := '';
		txtInformation.Text := 'dbԍP / FAXԍP / Z';

		btnChooseSpan.Enabled := false;
		btnQuoteSpanHead.Enabled := false;
	end
	else
	begin
		FProfileKey := FieldByName( 'refProfile').AsInteger;

		txtCode.Text := Trim( FieldByName( 'strCode').AsString);
		txtFamilyNameRead.Text := Trim( FieldByName( 'strFamilyNameRead').AsString);
		txtFamilyName.Text := Trim( FieldByName( 'strFamilyName').AsString);
		txtFirstNameRead.Text := Trim( FieldByName( 'strFirstNameRead').AsString);
		txtFirstName.Text := Trim( FieldByName( 'strFirstName').AsString);
		pnlBirthday.Caption := Format( '%s %s', [
			FormatDateTime( 'yyyy" N "MM"  "dd" "', FieldByName( 'datBirthday').AsDateTime),
			ToAgeText( dtpPublish.Date, FieldByName( 'datBirthday').AsDateTime)
		]);
		pnlSex.Caption := aSex[ FieldByName( 'typSex').AsInteger];

		txtInformation.Text := Format( '%s / %s / %s', [
			Trim( FieldByName( 'strPhoneNumber1').AsString),
			Trim( FieldByName( 'strFaxNumber1').AsString),
			Trim( FieldByName( 'strAddress').AsString)
		]);

		btnChooseSpan.Enabled := Appending;
		btnQuoteSpanHead.Enabled := Appending;
	end;
end;

procedure TBillingSet.Receipt_AfterOpen(DataSet: TDataSet);
begin
	Roundup;
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TBillingSet.Grid_DrawColumnCell(Sender: TObject; const Rect: TRect; DataCol: Integer; Column: TColumn; State: TGridDrawState);
var
	strText : String;
begin
	if Column.Field.IsNull then exit;

	if Column.Field.FieldName = 'INTMINUTESAT' then
	begin
		case Receipt.FieldByName( 'typSchedule').AsInteger of
		CARE_SCHEDULE, MENAGE_SCHEDULE :
			( Sender as TDBGrid).Canvas.TextRect( Rect, Rect.Left + 2, Rect.Top + 2, RangeToText(
				Column.Field.AsInteger,
				Receipt.FieldByName( 'intMinutesFor').AsInteger
			));

		MIGRATION_SCHEDULE, TRANSFER_SCHEDULE :
			( Sender as TDBGrid).Canvas.TextRect( Rect, Rect.Left + 2, Rect.Top + 2, MinutesToText( Column.Field.AsInteger));
		end;
		exit;
	end;

	if Column.Field.FieldName = 'STRADDRESSFROM' then
	begin
		case Receipt.FieldByName( 'typSchedule').AsInteger of
		CARE_SCHEDULE, MENAGE_SCHEDULE :
			( Sender as TDBGrid).Canvas.TextRect( Rect, Rect.Left + 2, Rect.Top + 2, Column.Field.AsString);

		MIGRATION_SCHEDULE, TRANSFER_SCHEDULE :
			( Sender as TDBGrid).Canvas.TextRect( Rect, Rect.Left + 2, Rect.Top + 2, Format( '%s  %s', [
				Column.Field.AsString,
				Receipt.FieldByName( 'strAddressTo').AsString
			]));
		end;
		exit;
	end;

	if Column.Field.FieldName = 'INTEXCHANGE' then
	begin
		strText := Format( '%0.0n~', [ Column.Field.AsCurrency]);
		( Sender as TDBGrid).Canvas.TextRect(
			Rect,
			Rect.Right - 2 - ( Sender as TDBGrid).Canvas.TextWidth( strText),
			Rect.Top + 2,
			strText
		);
	end
	else
		( Sender as TDBGrid).Canvas.TextRect( Rect, Rect.Left + 2, Rect.Top + 2, Column.Field.AsString);
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TBillingSet.btnBrowseReceipt_Click(Sender: TObject);
begin
	if not btnBrowseReceipt.Enabled then exit;
	TSnapshotDialog.Prepare( '()').Browse( Transaction, Receipt);
end;

procedure TBillingSet.btnRemoveReceipt_Click(Sender: TObject);
var
	index : Integer;
begin
	Receipt.DisableControls;
	for index := 0 to gridReceipt.SelectedRows.Count - 1 do
	begin
		Receipt.Bookmark := gridReceipt.SelectedRows.Items[ index];
		Receipt.Delete;
	end;
	Receipt.EnableControls;
	gridReceipt.SelectedRows.Refresh;
	gridReceipt.SelectedRows.CurrentRowSelected := true;

	Roundup;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TBillingSet.btnPrint_Click(Sender: TObject);
begin
	TBillingReport.Prepare( PrimaryKey).Preview;
end;

end.
