unit Set_Comment;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Base_Set, StdCtrls, ComCtrls, ExtCtrls, IBSQL, IBDatabase,
  IBCustomDataSet, IBUpdateSQL, DB, IBQuery, DateUtils, Misc_Constants;

type
  TCommentSet = class(TSetTemplate)
    Comment: TIBQuery;
    UpdaterOf_Comment: TIBUpdateSQL;

    lblTimeStamp: TLabel;
    dtpTimeStamp: TDateTimePicker;
    lblCategory: TLabel;
    cboCategory: TComboBox;
    bvlUpper: TBevel;

    txtTitle: TLabeledEdit;
    lblContent: TLabel;
    txtContent: TMemo;

    procedure dtpTimeStamp_Change(Sender: TObject);
  private
    { Private 錾 }
  protected
    { Protected 錾 }
    procedure DefineTable( var nameOfTable : String; var modifyFlag, cancelFlag : Boolean); override;

    procedure BeforeInput(); override;
    procedure AfterInput(); override;

    procedure BeforeSelect(); override;
    procedure AfterSelect(); override;

    procedure BeforeAppend(); override;
    procedure AfterAppend(); override;

    procedure BeforePopup(); override;
    procedure AfterPopup(); override;
  public
    { Public 錾 }
  end;

var
  CommentSet: TCommentSet;

implementation

{$R *.dfm}

{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TCommentSet.DefineTable( var nameOfTable : String; var modifyFlag, cancelFlag : Boolean);
begin
	nameOfTable := 'Comment';
	modifyFlag := true;
	cancelFlag := true;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TCommentSet.BeforeInput();
begin
	Comment.ParamByName( 'keyInstance').AsInteger := PrimaryKey;
	Comment.Open;
end;

procedure TCommentSet.AfterInput();
begin
	with Comment do
	begin
		if Appending then Append else Edit;
		FieldByName( 'keyInstance').AsInteger := RealizedKey;
		FieldByName( 'codRevision').AsInteger := FieldByName( 'codRevision').AsInteger;
		FieldByName( 'typStatus').AsInteger := FieldByName( 'typStatus').AsInteger;
		FieldByName( 'datTimeStamp').AsDateTime := dtpTimeStamp.Date;
		FieldByName( 'typCategory').AsInteger := cboCategory.ItemIndex;
		FieldByName( 'strTitle').AsString := Trim( txtTitle.Text);
		FieldByName( 'strContent').AsString := txtContent.Lines.Text;
		Post;
		ApplyUpdates;
	end;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TCommentSet.BeforeSelect();
begin
	with Comment do
	begin
		dtpTimeStamp.Date := FieldByName( 'datTimeStamp').AsDateTime;
		cboCategory.ItemIndex := FieldByName( 'typCategory').AsInteger;
		txtTitle.Text := FieldByName( 'strTitle').AsString;
		txtContent.Lines.Text := FieldByName( 'strContent').AsString;
	end;
end;

procedure TCommentSet.AfterSelect();
begin
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TCommentSet.BeforeAppend();
begin
	dtpTimeStamp.Date := Today;
end;

procedure TCommentSet.AfterAppend();
begin
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TCommentSet.BeforePopup();
begin
	dtpTimeStamp.Enabled := not Browsing;
	cboCategory.Enabled := not Browsing;
	txtTitle.ReadOnly := Browsing;
	txtContent.ReadOnly := Browsing;

	dtpTimeStamp_Change( dtpTimeStamp);
end;

procedure TCommentSet.AfterPopup();
begin
	if Trim( txtTitle.Text) = '' then
		ErrorMessages.Add( '^Cg͂Ă܂B');

	if Trim( txtContent.Lines.Text) = '' then
		ErrorMessages.Add( '{͂Ă܂B');
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TCommentSet.dtpTimeStamp_Change(Sender: TObject);
begin
	( Sender as TDateTimePicker).Format := FormatDateTime( ' gg ee "N"', ( Sender as TDateTimePicker).Date) + ' yyyy N MM  dd ';
end;

end.
