unit Set_Picture;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, MainDatastore, DBCtrls, DB, IBCustomDataSet,
  IBTable, StrUtils, IBQuery, IB, IBErrorCodes, DBClient, Provider, IBBlob,
  DBLocal, DBLocalI, IBSQL, IBDatabase, ComCtrls, DateUtils, IBUpdateSQL, Jpeg,
  Misc_Constants, Misc_Utilities, Base_Set, Piece_ValiditySelector, ExtDlgs,
  AxCtrls, DBOleCtl, ImgeditLibCtl_TLB, OleCtrls, ScanLibCtl_TLB;

type
  TPictureSet = class(TSetTemplate)
    Picture: TIBQuery;
    UpdaterOf_Picture: TIBUpdateSQL;

    Validity: TValiditySelector;
    txtName: TLabeledEdit;
    txtNotice: TLabeledEdit;

    pnlImage: TPanel;
    ImageEditor: TImgEdit;
    ImageScanner: TImgScan;
    btnScan: TButton;
    btnPrint: TButton;

    procedure btnScan_Click(Sender: TObject);
    procedure btnPrint_Click(Sender: TObject);

  private
    { Private 錾 }
    FOwnerKey : Integer;
    FOwnerType : Integer;
  protected
    { Protected 錾 }
    procedure DefineTable( var nameOfTable : String; var modifyFlag, cancelFlag : Boolean); override;

    procedure BeforeInput(); override;
    procedure AfterInput(); override;

    procedure BeforeSelect(); override;
    procedure AfterSelect(); override;

    procedure BeforeAppend(); override;
    procedure AfterAppend(); override;

    procedure BeforePopup(); override;
    procedure AfterPopup(); override;
  public
    { Public 錾 }
    constructor Prepare( typOwner, keyOwner : Integer); overload;
  end;

var
  PictureSet: TPictureSet;

implementation

{$R *.dfm}

uses Report_Picture;

{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

constructor TPictureSet.Prepare( typOwner, keyOwner : Integer);
begin
	inherited Prepare;

	FOwnerKey := keyOwner;
	FOwnerType := typOwner;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPictureSet.DefineTable( var nameOfTable : String; var modifyFlag, cancelFlag : Boolean);
begin
	nameOfTable := 'Picture';
	modifyFlag := true;
	cancelFlag := true;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPictureSet.BeforeInput();
begin
	ImageEditor.Image := TemporaryFileName();

	Picture.ParamByName( 'keyInstance').AsInteger := Primarykey;
	Picture.Open;
end;

procedure TPictureSet.AfterInput();
var
	Temporary : TFileStream;
begin
	with Picture do
	begin
		if Appending then Append else Edit;
		FieldByName( 'keyInstance').AsInteger := RealizedKey;
		FieldByName( 'typOwner').AsInteger := FOwnerType;
		FieldByName( 'refOwner').AsInteger := FOwnerKey;
		FieldByName( 'datAvailableFrom').AsDateTime := Validity.AvailableFrom;
		FieldByName( 'datAvailableTo').AsDateTime := Validity.AvailableTo;
		FieldByName( 'strName').AsString := Trim( txtName.Text);
		FieldByName( 'strNotice').AsString := Trim( txtNotice.Text);

		if ImageEditor.ImageModified then
		begin
			ImageEditor.SaveAs( ImageEditor.Image);
			Temporary := TFileStream.Create( ImageEditor.Image, fmOpenRead);
			try
				CreateBlobStream( FieldByName( 'Stream'), bmWrite).CopyFrom( Temporary, 0);
			finally
				Temporary.Free;
			end;
			DeleteFile( ImageEditor.Image);
		end;

		Post;
		ApplyUpdates;
	end;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPictureSet.BeforeSelect();
var
	Temporary : TFileStream;
begin
	with Picture do
	begin
		FOwnerType := FieldByName( 'typOwner').AsInteger;
		FOwnerKey := FieldByName( 'refOwner').AsInteger;
		Validity.AvailableFrom := FieldByName( 'datAvailableFrom').AsDateTime;
		Validity.AvailableTo := FieldByName( 'datAvailableTo').AsDateTime;
		txtName.Text := Trim( FieldByName( 'strName').AsString);
		txtNotice.Text := Trim( FieldByName( 'strNotice').AsString);

		Temporary := TFileStream.Create( ImageEditor.Image, fmCreate);
		try
			Temporary.CopyFrom( CreateBlobStream( FieldByName( 'Stream'), bmRead), 0);
		finally
			Temporary.Free;
		end;
	end;
end;

procedure TPictureSet.AfterSelect();
begin
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPictureSet.BeforeAppend();
begin
	Validity.AvailableFrom := StartOfTheMonth( Today);
	Validity.AvailableTo := StrToDate( '2087/12/31');

	txtName.Text := '(O͂Ă)';
end;

procedure TPictureSet.AfterAppend();
begin
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPictureSet.BeforePopup();
begin
	Validity.ReadOnly := Browsing;
	txtName.ReadOnly := Browsing;

	if FileExists( ImageEditor.Image) then
	begin
		ImageEditor.Display;
		DeleteFile( ImageEditor.Image);
	end;

	btnPrint.Visible := not Appending;
end;

procedure TPictureSet.AfterPopup();
begin
	ErrorCheck_Empty( 'O', txtName.Text, ErrorMessages);

	if ImageEditor.PageCount = 0 then
		ErrorMessages.Add( '摜IĂ܂B');
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPictureSet.btnScan_Click(Sender: TObject);
begin
	Enabled := false;
	ImageScanner.StartScan;
	Enabled := true;
	Application.BringToFront;
end;

procedure TPictureSet.btnPrint_Click(Sender: TObject);
begin
	TPictureReport.Prepare( PrimaryKey, Today).Preview;
end;

end.
