unit Set_Profile;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, IBSQL, IBDatabase, StdCtrls, ExtCtrls, Grids, DBGrids, DBClient,
  Provider, DB, IBCustomDataSet, IBQuery, ComCtrls, DBCtrls, DateUtils,
  Chart, ValEdit, StrUtils, IBUpdateSQL, Buttons, Base_Set,
  Piece_ValiditySelector, Piece_RecordSelector, Misc_Constants, Misc_Utilities;

type
  TProfileSet = class(TSetTemplate)
    Branch: TIBQuery;
    DataSourceOf_Barnch: TDataSource;

    Region: TIBQuery;
    DataSourceOf_Region: TDataSource;

    Profile: TIBQuery;
    UpdaterOf_Profile: TIBUpdateSQL;

    SourceOf_Address: TIBQuery;
    UpdaterOf_Address: TIBUpdateSQL;
    ProviderOf_Address: TDataSetProvider;
    Address: TClientDataSet;

    SourceOf_Notice: TIBQuery;
    UpdaterOf_Notice: TIBUpdateSQL;
    ProviderOf_Notice: TDataSetProvider;
    Notice: TClientDataSet;

    SourceOf_Absence: TIBQuery;
    UpdaterOf_Absence: TIBUpdateSQL;
    ProviderOf_Absence: TDataSetProvider;
    Absence: TClientDataSet;
    DataSourceOf_Absence: TDataSource;

    Validity: TValiditySelector;

    lblBranch: TLabel;
    cboBranch: TDBLookupComboBox;
    lblRegion: TLabel;
    cboRegion: TDBLookupComboBox;

    txtCode: TLabeledEdit;
    txtFamilyName: TLabeledEdit;
    txtFirstName: TLabeledEdit;
    txtFamilyNameRead: TLabeledEdit;
    txtFirstNameRead: TLabeledEdit;

    grpSex: TGroupBox;
    radMale: TRadioButton;
    radFemale: TRadioButton;

    lblBirthday: TLabel;
    dtpBirthday: TDateTimePicker;

    grpAvailability: TGroupBox;
    chkMonday: TCheckBox;
    chkTuesday: TCheckBox;
    chkWednesday: TCheckBox;
    chkSaturday: TCheckBox;
    chkFriday: TCheckBox;
    chkThursday: TCheckBox;
    chkSunday: TCheckBox;
    txtAvailability: TLabeledEdit;

    bvlCenter: TBevel;

    pagesHolder: TPageControl;

    pageAddress: TTabSheet;
    AddressSelector: TRecordSelector;
    btnSelectAddress: TButton;
    btnAppendAddress: TButton;
    btnDeleteAddress: TButton;
    vlstAddress: TValueListEditor;

    pageNotice: TTabSheet;
    NoticeSelector: TRecordSelector;
    btnSelectNotice: TButton;
    btnAppendNotice: TButton;
    btnDeleteNotice: TButton;
    vlstNotice: TValueListEditor;
    txtNotice: TMemo;

    pageAbsence: TTabSheet;
    dtpAbsenceMonth: TDateTimePicker;
    btnSelectAbsence: TButton;
    btnAppendAbsence: TButton;
    btnDeleteAbsence: TButton;
    gridAbsence: TDBGrid;
    gridCalendar: TDrawGrid;

    btnPrint: TButton;
    btnPictureAlbum: TButton;
    CodePicker: TIBQuery;

    procedure Validity_Change(Sender: TObject);

    procedure dtpBirthday_Change(Sender: TObject);

    procedure Address_AfterUpdate(DataSet: TDataSet);
    procedure btnSelectAddress_Click(Sender: TObject);
    procedure btnAppendAddress_Click(Sender: TObject);
    procedure btnDeleteAddress_Click(Sender: TObject);

    procedure Notice_AfterUpdate(DataSet: TDataSet);
    procedure btnSelectNotice_Click(Sender: TObject);
    procedure btnAppendNotice_Click(Sender: TObject);
    procedure btnDeleteNotice_Click(Sender: TObject);

    procedure Absence_AfterUpdate(DataSet: TDataSet);
    procedure dtpAbsenceMonth_Change(Sender: TObject);
    procedure btnSelectAbsence_Click(Sender: TObject);
    procedure btnAppendAbsence_Click(Sender: TObject);
    procedure btnDeleteAbsence_Click(Sender: TObject);
    procedure gridCalendar_DrawCell(Sender: TObject; ACol, ARow: Integer; Rect: TRect; State: TGridDrawState);

    procedure btnPictureAlbum_Click(Sender: TObject);
    procedure btnPrint_Click(Sender: TObject);

  private
    { Private 錾 }
  protected
    { Protected 錾 }
    procedure DefineTable( var nameOfTable : String; var modifyFlag, cancelFlag : Boolean); override;

    procedure BeforeInput(); override;
    procedure AfterInput(); override;

    procedure BeforeSelect(); override;
    procedure AfterSelect(); override;

    procedure BeforeAppend(); override;
    procedure AfterAppend(); override;

    procedure BeforePopup(); override;
    procedure AfterPopup(); override;

    class function CategoryType() : Integer; virtual; abstract;
  public
    { Public 錾 }
  end;

  CProfileSet = class of TProfileSet;

var
  ProfileSet: TProfileSet;

implementation

{$R *.dfm}

uses Dialog_Address, Dialog_Notice, Dialog_Absence, Report_Profile, Misc_PictureAlbum;

{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TProfileSet.DefineTable( var nameOfTable : String; var modifyFlag, cancelFlag : Boolean);
begin
	nameOfTable := 'Profile';
	modifyFlag := true;
	cancelFlag := true;

	Validity.OnChange := Validity_Change;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TProfileSet.BeforeInput();
begin
	Profile.ParamByName( 'keyInstance').AsInteger := PrimaryKey;
	Profile.Open;
	Profile.Last;

	SourceOf_Address.ParamByName( 'keyProfile').AsInteger := PrimaryKey;
	Address.Open;

	SourceOf_Notice.ParamByName( 'keyProfile').AsInteger := PrimaryKey;
	Notice.Open;

	SourceOf_Absence.ParamByName( 'keyProfile').AsInteger := PrimaryKey;
	Absence.Open;
end;

procedure TProfileSet.AfterInput();
begin
	with Profile do
	begin
		if Appending then Append else Edit;
		FieldByName( 'keyInstance').AsInteger := RealizedKey;
		FieldByName( 'typCategory').AsInteger := CategoryType;
		FieldByName( 'datAvailableFrom').AsDateTime := Validity.AvailableFrom;
		FieldByName( 'datAvailableTo').AsDateTime := Validity.AvailableTo;
		FieldByName( 'refBranch').AsInteger := VarToInt( cboBranch.KeyValue);
		FieldByName( 'refRegion').AsInteger := VarToInt( cboRegion.KeyValue);
		FieldByName( 'strCode').AsString := Trim( txtCode.Text);
		FieldByName( 'strFamilyNameRead').AsString := Trim( txtFamilyNameRead.Text);
		FieldByName( 'strFamilyName').AsString := Trim( txtFamilyName.Text);
		FieldByName( 'strFirstNameRead').AsString := Trim( txtFirstNameRead.Text);
		FieldByName( 'strFirstName').AsString := Trim( txtFirstName.Text);
		FieldByName( 'typSex').AsInteger := BoolToInt( radFemale.Checked);
		FieldByName( 'datBirthday').AsDateTime := dtpBirthday.Date;
		FieldByName( 'optAvailability').AsInteger := CheckBoxesToOptions( [
			chkSunday, chkMonday, chkTuesday, chkWednesday, chkThursday, chkFriday, chkSaturday
		]);
		FieldByName( 'strAvailability').Value := Trim( txtAvailability.Text);
		Post;
		ApplyUpdates;
	end;

	if Address.ApplyUpdates( 0) > 0 then ErrorMessages.Add( 'Address operation error');
	if Notice.ApplyUpdates( 0) > 0 then ErrorMessages.Add( 'Notice operation error');
	if Absence.ApplyUpdates( 0) > 0 then ErrorMessages.Add( 'Absence operation error');
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TProfileSet.BeforeSelect();
begin
	with Profile do
	begin
		Validity.Reset(
			FieldByName( 'datAvailableFrom').AsDateTime,
			FieldByName( 'datAvailableTo').AsDateTime
		);

		SelectComboWithoutFail( cboBranch, FieldByName( 'refBranch').AsInteger);
		SelectComboWithoutFail( cboRegion, FieldByName( 'refRegion').AsInteger);
		txtCode.Text := Trim( FieldByName( 'strCode').AsString);
		txtFamilyNameRead.Text := Trim( FieldByName( 'strFamilyNameRead').AsString);
		txtFamilyName.Text := Trim( FieldByName( 'strFamilyName').AsString);
		txtFirstNameRead.Text := Trim( FieldByName( 'strFirstNameRead').AsString);
		txtFirstName.Text := Trim( FieldByName( 'strFirstName').AsString);
		if FieldByName( 'typSex').AsInteger = MALE_SEX then radMale.Checked := true else radFemale.Checked := true;
		dtpBirthday.Date := FieldByName( 'datBirthday').AsDateTime;
		dtpBirthday_Change( dtpBirthday);

		OptionsToCheckBoxes( FieldByName( 'optAvailability').AsInteger, [
			chkSunday, chkMonday, chkTuesday, chkWednesday, chkThursday, chkFriday, chkSaturday
		]);
		txtAvailability.Text := Trim( FieldByName( 'strAvailability').AsString);
	end;
end;

procedure TProfileSet.AfterSelect();
begin
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TProfileSet.BeforeAppend();
begin
	Validity.Reset( StartOfTheMonth( Today), StrToDate( '2087/12/31'));

	if Branch.IsEmpty then
	begin
		ErrorMessages.Add( 'o^敪o^ł');
		exit;
	end;

	if Region.IsEmpty then
	begin
		ErrorMessages.Add( 'Zn悪o^ł');
		exit;
	end;

	SelectComboWithoutFail( cboBranch, -1);
	SelectComboWithoutFail( cboRegion, -1);

	CodePicker.Open;
	txtCode.Text := Format( '%.5d', [ CodePicker.FieldByName( 'nextKey').AsInteger]);
	CodePicker.Close;
end;

procedure TProfileSet.AfterAppend();
begin
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TProfileSet.BeforePopup();
begin
	Validity.ReadOnly := Browsing;

	cboBranch.Enabled := not Browsing;
	cboRegion.Enabled := not Browsing;
	txtCode.ReadOnly := Browsing;
	txtFamilyNameRead.ReadOnly := Browsing;
	txtFamilyName.ReadOnly := Browsing;
	txtFirstNameRead.ReadOnly := Browsing;
	txtFirstName.ReadOnly := Browsing;
	grpSex.Enabled := not Browsing;
	dtpBirthday.Enabled := not Browsing;
	dtpBirthday_Change( dtpBirthday);
	grpAvailability.Enabled := not Browsing;

	btnPictureAlbum.Visible := not Appending;
	btnPrint.Visible := not Appending;

	Address_AfterUpdate( Address);
	Notice_AfterUpdate( Notice);

	dtpAbsenceMonth.Date := StartOfTheMonth( Today);
	dtpAbsenceMonth_Change(dtpAbsenceMonth);

	if Browsing then txtCode.SetFocus else cboBranch.SetFocus;
end;

procedure TProfileSet.AfterPopup();
begin
	ErrorCheck_Empty( 'o^敪', cboBranch.Text, ErrorMessages);
	ErrorCheck_Empty( 'Zn', cboRegion.Text, ErrorMessages);
	ErrorCheck_Code( 'o^ԍ', txtCode.Text, ErrorMessages);
	ErrorCheck_Empty( '', txtFamilyName.Text, ErrorMessages);
	ErrorCheck_Empty( '݂', txtFamilyNameRead.Text, ErrorMessages);
	ErrorCheck_Reading( '݂', txtFamilyNameRead.Text, ErrorMessages);
	ErrorCheck_Empty( '', txtFirstName.Text, ErrorMessages);
	ErrorCheck_Empty( '݂', txtFirstNameRead.Text, ErrorMessages);
	ErrorCheck_Reading( '݂', txtFirstNameRead.Text, ErrorMessages);
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TProfileSet.Validity_Change(Sender: TObject);
begin
	Branch.Close;
	Branch.ParamByName( 'datAvailableFrom').AsDate := Validity.AvailableFrom;
	Branch.ParamByName( 'datAvailableTo').AsDate := Validity.AvailableTo;
	Branch.ParamByName( 'keyInstance').AsInteger := Profile.FieldByName( 'refBranch').AsInteger;
	Branch.Open;
	Branch.FetchAll;
	SelectComboWithoutFail( cboBranch, VarToInt( cboBranch.KeyValue));

	Region.Close;
	Region.ParamByName( 'datAvailableFrom').AsDate := Validity.AvailableFrom;
	Region.ParamByName( 'datAvailableTo').AsDate := Validity.AvailableTo;
	Region.ParamByName( 'keyInstance').AsInteger := Profile.FieldByName( 'refRegion').AsInteger;
	Region.Open;
	Region.FetchAll;
	SelectComboWithoutFail( cboRegion, VarToInt( cboRegion.KeyValue));
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TProfileSet.dtpBirthday_Change(Sender: TObject);
begin
	dtpBirthday.Format := FormatDateTime( '  gg ee "N"', dtpBirthday.Date) + ' yyyy N MM  dd ';
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TProfileSet.Address_AfterUpdate(DataSet: TDataSet);
begin
	with Address, vlstAddress do
	begin
		Values[ ''] := IfThen( IsEmpty, ' ', aAddress[ FieldByName( 'typCategory').AsInteger]);
		Values[ 'L'] := IfThen( IsEmpty, ' ', Format( '%s ` %s', [
			FormatDateTime( 'yyyy"N"MM""dd""', FieldByName( 'datAvailableFrom').AsDateTime),
			FormatDateTime( 'yyyy"N"MM""dd""', FieldByName( 'datAvailableTo').AsDateTime)
		]));
		Values[ 'O݂'] := FieldByName( 'strNameRead').AsString + ' ';
		Values[ 'O'] := FieldByName( 'strName').AsString + ' ';
		Values[ 'X֔ԍ'] := IfThen( FieldByName( 'refZip').IsNull, ' ', ToZipText( FieldByName( 'refZip').AsInteger));
		Values[ 'Z݂'] := FieldByName( 'strZipAddressRead').AsString + FieldByName( 'strAddressRead').AsString + ' ';
		Values[ 'Z'] := FieldByName( 'strZipAddress').AsString + FieldByName( 'strAddress').AsString + ' ';
		Values[ 'dbԍP'] := FieldByName( 'strPhoneNumber1').AsString + ' ';
		Values[ 'dbԍQ'] := FieldByName( 'strPhoneNumber2').AsString + ' ';
		Values[ 'dbԍR'] := FieldByName( 'strPhoneNumber3').AsString + ' ';
		Values[ 'FAXԍP'] := FieldByName( 'strFaxNumber1').AsString + ' ';
		Values[ 'FAXԍQ'] := FieldByName( 'strFaxNumber2').AsString + ' ';
		Values[ 'FAXԍR'] := FieldByName( 'strFaxNumber3').AsString + ' ';
	end;

	btnSelectAddress.Enabled := not Address.IsEmpty;
	btnAppendAddress.Enabled := not Browsing;
	btnDeleteAddress.Enabled := ( not Browsing) and ( not Address.IsEmpty);

	AddressSelector.Reset( Address);
end;

procedure TProfileSet.btnSelectAddress_Click(Sender: TObject);
begin
	if not btnSelectAddress.Enabled then exit;
	if Browsing then
		TAddressDialog.Prepare( RealizedKey).Browse( Transaction, Address)
	else
		TAddressDialog.Prepare( RealizedKey).Select( Transaction, Address);
end;

procedure TProfileSet.btnAppendAddress_Click(Sender: TObject);
begin
	TAddressDialog.Prepare( RealizedKey).Append( Transaction, Address);
end;

procedure TProfileSet.btnDeleteAddress_Click(Sender: TObject);
begin
	TAddressDialog.Prepare( RealizedKey).Delete( Transaction, Address);
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TProfileSet.Notice_AfterUpdate(DataSet: TDataSet);
begin
	with Notice, vlstNotice do
	begin
		Values[ 'L'] := IfThen( IsEmpty, ' ', Format( '%s ` %s', [
			FormatDateTime( 'yyyy"N"MM""dd""', FieldByName( 'datAvailableFrom').AsDateTime),
			FormatDateTime( 'yyyy"N"MM""dd""', FieldByName( 'datAvailableTo').AsDateTime)
		]));
		Values[ '^Cg'] := FieldByName( 'strTitle').AsString + ' ';
		txtNotice.Lines.Text := FieldByName( 'strContent').AsString;
	end;

	btnSelectNotice.Enabled := not Notice.IsEmpty;
	btnAppendNotice.Enabled := not Browsing;
	btnDeleteNotice.Enabled := ( not Browsing) and ( not Notice.IsEmpty);

	NoticeSelector.Reset( Notice);
end;

procedure TProfileSet.btnSelectNotice_Click(Sender: TObject);
begin
	if not btnSelectNotice.Enabled then exit;
	if Browsing then
		TNoticeDialog.Prepare( RealizedKey).Browse( Transaction, Notice)
	else
		TNoticeDialog.Prepare( RealizedKey).Select( Transaction, Notice);
end;

procedure TProfileSet.btnAppendNotice_Click(Sender: TObject);
begin
	TNoticeDialog.Prepare( RealizedKey).Append( Transaction, Notice);
end;

procedure TProfileSet.btnDeleteNotice_Click(Sender: TObject);
begin
	TNoticeDialog.Prepare( RealizedKey).Delete( Transaction, Notice);
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TProfileSet.Absence_AfterUpdate(DataSet: TDataSet);
begin
	btnSelectAbsence.Enabled := not Absence.IsEmpty;
	btnAppendAbsence.Enabled := not Browsing;
	btnDeleteAbsence.Enabled := ( not Browsing) and ( not Absence.IsEmpty);
	gridCalendar.Invalidate;
end;

procedure TProfileSet.dtpAbsenceMonth_Change(Sender: TObject);
begin
	dtpAbsenceMonth.Format := FormatDateTime( '      gg ee "N"', dtpAbsenceMonth.Date) + ' yyyy N MM ';
	Absence.Filter := Format( 'typStatus=%d and datMonthFirstday=''%s''', [
		DATA_ENABLED,
		DateToStr( StartOfTheMonth( dtpAbsenceMonth.Date))
	]);
end;

procedure TProfileSet.btnSelectAbsence_Click(Sender: TObject);
begin
	if not btnSelectAbsence.Enabled then exit;
	if Browsing then
		TAbsenceDialog.Prepare( RealizedKey, dtpAbsenceMonth.Date).Browse( Transaction, Absence)
	else
		TAbsenceDialog.Prepare( RealizedKey, dtpAbsenceMonth.Date).Select( Transaction, Absence);
end;

procedure TProfileSet.btnAppendAbsence_Click(Sender: TObject);
begin
	TAbsenceDialog.Prepare( RealizedKey, dtpAbsenceMonth.Date).Append( Transaction, Absence);
end;

procedure TProfileSet.btnDeleteAbsence_Click(Sender: TObject);
begin
	TAbsenceDialog.Prepare( RealizedKey, dtpAbsenceMonth.Date).Delete( Transaction, Absence);
end;

procedure TProfileSet.gridCalendar_DrawCell(Sender: TObject; ACol, ARow: Integer; Rect: TRect; State: TGridDrawState);
const
	aWeekday : array[ 0..6] of String = ( '', '', '', '', '', '', 'y');
var
	DayValue : Integer;
	DayLabel : String;
begin
	with gridCalendar.Canvas do case ACol of
	0 : Font.Color := clRed;
	6 : Font.Color := clBlue;
	else Font.Color := clBlack;
	end;

	if ARow = 0 then
		DayLabel := aWeekday[ ACol]
	else
	begin
		DayValue := 7 * ( ARow - 1) + ACol - DayOfWeek( StartOfTheMonth( dtpAbsenceMonth.Date)) + 2;
		if ( 1 <= DayValue) and ( DayValue <= DaysInMonth( dtpAbsenceMonth.Date)) then
		begin
			DayLabel := IntToStr( DayValue);
			if ( Absence.FieldByName( 'optAbsence').AsInteger and ( 1 shl ( DayValue - 1))) <> 0 then
				gridCalendar.Canvas.Brush.Color := clDefaultExcluded
			else
				gridCalendar.Canvas.Brush.Color := clCream;
		end
		else
		begin
			DayLabel := ' ';
			gridCalendar.Canvas.Brush.Color := clCream;
		end;
	end;

	gridCalendar.Canvas.TextRect( Rect, Rect.Left + 2, Rect.Top + 2, DayLabel);
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TProfileSet.btnPictureAlbum_Click(Sender: TObject);
begin
	PopupPictureAlbum( OWNER_PROFILE, PrimaryKey);
end;

procedure TProfileSet.btnPrint_Click(Sender: TObject);
begin
	TProfileReport.Prepare( PrimaryKey).Preview;
end;

end.
