unit Set_Region;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, MainDatastore, DBCtrls, DB, IBCustomDataSet,
  IBTable, StrUtils, IBQuery, IB, IBErrorCodes, DBClient, Provider,
  DBLocal, DBLocalI, IBSQL, IBDatabase, ComCtrls, DateUtils, IBUpdateSQL,
  Misc_Constants, Misc_Utilities, Base_Set, Piece_ValiditySelector;

type
  TRegionSet = class(TSetTemplate)
    Region: TIBQuery;
    UpdaterOf_Region: TIBUpdateSQL;

    Validity: TValiditySelector;
    txtName: TLabeledEdit;

  private
    { Private 錾 }
  protected
    { Protected 錾 }
    procedure DefineTable( var nameOfTable : String; var modifyFlag, cancelFlag : Boolean); override;

    procedure BeforeInput(); override;
    procedure AfterInput(); override;

    procedure BeforeSelect(); override;
    procedure AfterSelect(); override;

    procedure BeforeAppend(); override;
    procedure AfterAppend(); override;

    procedure BeforePopup(); override;
    procedure AfterPopup(); override;
  public
    { Public 錾 }
  end;

var
  RegionSet: TRegionSet;

implementation

{$R *.dfm}

{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TRegionSet.DefineTable( var nameOfTable : String; var modifyFlag, cancelFlag : Boolean);
begin
	nameOfTable := 'Region';
	modifyFlag := true;
	cancelFlag := true;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TRegionSet.BeforeInput();
begin
	Region.ParamByName( 'keyInstance').AsInteger := Primarykey;
	Region.Open;
end;

procedure TRegionSet.AfterInput();
begin
	with Region do
	begin
		if Appending then Append else Edit;
		FieldByName( 'keyInstance').AsInteger := RealizedKey;
		FieldByName( 'datAvailableFrom').AsDateTime := Validity.AvailableFrom;
		FieldByName( 'datAvailableTo').AsDateTime := Validity.AvailableTo;
		FieldByName( 'strName').AsString := Trim( txtName.Text);
		Post;
		ApplyUpdates;
	end;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TRegionSet.BeforeSelect();
begin
	with Region do
	begin
		Validity.AvailableFrom := FieldByName( 'datAvailableFrom').AsDateTime;
		Validity.AvailableTo := FieldByName( 'datAvailableTo').AsDateTime;
		txtName.Text := Trim( FieldByName( 'strName').AsString);
	end;
end;

procedure TRegionSet.AfterSelect();
begin
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TRegionSet.BeforeAppend();
begin
	Validity.AvailableFrom := StartOfTheMonth( Today);
	Validity.AvailableTo := StrToDate( '2087/12/31');

	txtName.Text := '(O͂Ă)';
end;

procedure TRegionSet.AfterAppend();
begin
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TRegionSet.BeforePopup();
begin
	Validity.ReadOnly := Browsing;
	txtName.ReadOnly := Browsing;
end;

procedure TRegionSet.AfterPopup();
begin
	ErrorCheck_Empty( 'O', txtName.Text, ErrorMessages);
end;

end.
