unit Toolbox_CarrySchedules;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, StrUtils, ExtCtrls, Provider, DB, DBClient, DBLocal,
  MainDatastore, DBLocalI, IB, IBErrorCodes, IBSQL, IBDatabase, IBCustomDataSet,
  IBQuery, DBCtrls, ComCtrls, DateUtils, Base_Toolbox, Grids, DBGrids, Math,
  Misc_Constants, Misc_Utilities, Buttons;

procedure CarrySchedules( keyComplexTail : Integer);

type
  TCarrySchedulesToolbox = class(TToolboxTemplate)
    SourceOf_Schedule: TIBQuery;
    ProviderOf_Schedule: TDataSetProvider;
    Schedule: TClientDataSet;
    DataSourceOf_Schedule: TDataSource;

    lblPrograms: TLabel;
    btnDay_1: TSpeedButton;
    btnDay_2: TSpeedButton;
    btnDay_3: TSpeedButton;
    btnDay_4: TSpeedButton;
    btnDay_5: TSpeedButton;
    btnDay_6: TSpeedButton;
    btnDay_7: TSpeedButton;
    btnDay_8: TSpeedButton;
    btnDay_9: TSpeedButton;
    btnDay_10: TSpeedButton;
    btnDay_11: TSpeedButton;
    btnDay_12: TSpeedButton;
    btnDay_13: TSpeedButton;
    btnDay_14: TSpeedButton;
    btnDay_15: TSpeedButton;
    btnDay_16: TSpeedButton;
    btnDay_17: TSpeedButton;
    btnDay_18: TSpeedButton;
    btnDay_19: TSpeedButton;
    btnDay_20: TSpeedButton;
    btnDay_21: TSpeedButton;
    btnDay_22: TSpeedButton;
    btnDay_23: TSpeedButton;
    btnDay_24: TSpeedButton;
    btnDay_25: TSpeedButton;
    btnDay_26: TSpeedButton;
    btnDay_27: TSpeedButton;
    btnDay_28: TSpeedButton;
    btnDay_29: TSpeedButton;
    btnDay_30: TSpeedButton;
    btnDay_31: TSpeedButton;

    bvlCarry: TBevel;
    gridSchedule: TDBGrid;
    Root: TIBQuery;
    btnBrowseSchedule: TButton;
    btnExcludeSchedule: TButton;
    SubjectPromoter: TIBSQL;

    procedure gridSchedule_DrawColumnCell(Sender: TObject; const Rect: TRect; DataCol: Integer; Column: TColumn; State: TGridDrawState);

    procedure btnBrowseSchedule_Click(Sender : TObject);
    procedure btnExcludeSchedule_Click(Sender : TObject);

  private
    { Private 錾 }
    FComplexTail : Integer;
    FMonthFirstday : TDate;
    FMonthLastday : TDate;
  protected
    { Protected 錾 }
    procedure BeforePopup(); override;
    procedure AfterPopup(); override;
  end;

var
  CarrySchedulesToolbox: TCarrySchedulesToolbox;

implementation

{$R *.dfm}

uses Misc_Scheduler, Set_Care, Set_Menage, Set_Migration, Set_Transfer;

{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure CarrySchedules( keyComplexTail : Integer);
begin
	if keyComplexTail <= 0 then exit;
	with TCarrySchedulesToolbox.Create( Screen.ActiveForm) do
	begin
		FComplexTail := keyComplexTail;
		Popup;
		Release;
	end;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TCarrySchedulesToolbox.BeforePopup();
var
	index : Integer;
	dateStamp : TDateTime;
	dayButton : TSpeedButton;
begin
	if not DataStore.VerifyRecord( 'Schedule', FComplexTail) then
		ErrorMessages.Add( 'YXPW[̏͑̒[ŗpłB');

	Root.ParamByName( 'keyInstance').AsInteger := FComplexTail;
	Root.Open;

	SourceOf_Schedule.ParamByName( 'keyPattern').AsInteger := Root.FieldByName( 'keyPattern').AsInteger;
	SourceOf_Schedule.ParamByName( 'datAnchor').AsDate := Root.FieldByName( 'datSchedule').AsDateTime;
	Schedule.Open;

	if Schedule.IsEmpty then
		ErrorMessages.Add( 'ł\肪܂B');

	if ErrorMessages.Count > 0 then exit;
	// update query

	FMonthFirstday := StartOfTheMonth( IncMonth( Root.FieldByName( 'datSchedule').AsDateTime));
	FMonthLastday := DateOf( EndOfTheMonth( FMonthFirstday));

	for index := 0 to 30 do
	begin
		dateStamp := IncDay( FMonthFirstday, index);
		dayButton := FindComponent( 'btnDay_' + IntToStr( index + 1)) as TSpeedButton;

		if ( dateStamp <= FMonthLastday) then
		begin
			dayButton.Caption := IntToStr( DayOf( dateStamp));
			case DayOfWeek( dateStamp) of
			1 : dayButton.Font.Color := $0000CC;
			2..6 : dayButton.Font.Color := clWindowText;
			7 : dayButton.Font.Color := $CC0000;
			end;
			dayButton.Enabled := true;
		end
		else
		begin
			dayButton.Caption := '*';
			dayButton.Enabled := false;
		end;
	end;
	// setup calender
end;

procedure TCarrySchedulesToolbox.AfterPopup();

	procedure AssignScheduleToScheduler();
	begin
		with Scheduler do
		begin
			keyPattern := Schedule.FieldByName( 'keyPattern').AsInteger;
			typPattern := Schedule.FieldByName( 'typPattern').AsInteger;
			optElement := Schedule.FieldByName( 'optElement').AsInteger;

			typProgress := Schedule.FieldByName( 'typProgress').AsInteger;
			refService := Schedule.FieldByName( 'refService').AsInteger;
			refExchange := Schedule.FieldByName( 'refExchange').AsInteger;

			intMinutesAt := Schedule.FieldByName( 'intMinutesAt').AsInteger;
			intMinutesFor := Schedule.FieldByName( 'intMinutesFor').AsInteger;
			refAddressFrom := Schedule.FieldByName( 'refAddressFrom').AsInteger;
			refAddressTo := Schedule.FieldByName( 'refAddressTo').AsInteger;
			strNotice := Schedule.FieldByName( 'strNotice').AsString;

			refClient := Schedule.FieldByName( 'refClient').AsInteger;
			refServer := Schedule.FieldByName( 'refServer').AsInteger;
		end;
	end;
begin
	Scheduler.optPattern := SpeedButtonsToOptions( [
		btnDay_1, btnDay_2, btnDay_3, btnDay_4, btnDay_5, btnDay_6, btnDay_7, btnDay_8, btnDay_9, btnDay_10,
		btnDay_11, btnDay_12, btnDay_13, btnDay_14, btnDay_15, btnDay_16, btnDay_17, btnDay_18, btnDay_19, btnDay_20,
		btnDay_21, btnDay_22, btnDay_23, btnDay_24, btnDay_25, btnDay_26, btnDay_27, btnDay_28, btnDay_29, btnDay_30,
		btnDay_31
	]);

	if Scheduler.optPattern = 0 then
	begin
		ErrorMessages.Add( 'Ώۓw肳Ă܂B');
		exit;
	end;

	Scheduler.Transaction := DataStore.MainTransaction;
	Scheduler.datAnchor := EndOfTheMonth( Root.FieldByName( 'datSchedule').AsDateTime);

	Schedule.DisableControls;

	Schedule.Filter := 'blnAvailable<>0 and refSubject IS NULL';
	AssignScheduleToScheduler;
	Scheduler.CopyAsSubject( EndOfTheMonth( IncMonth( Root.FieldByName( 'datSchedule').AsDateTime)));

	Schedule.Filter := Format( 'blnAvailable<>0 and refSubject IS NOT NULL and typSchedule=%d', [ Root.FieldByName( 'typSchedule').AsInteger]);
	if not Schedule.IsEmpty then
	begin
		AssignScheduleToScheduler;
		Scheduler.CopyAsLemma( Root.FieldByName( 'keyPattern').AsInteger);
	end;

	Schedule.Filter := Format( 'blnAvailable<>0 and refSubject IS NOT NULL and typSchedule<>%d', [ Root.FieldByName( 'typSchedule').AsInteger]);
	while not Schedule.Eof do
	begin
		AssignScheduleToScheduler;
		Scheduler.CopyAsLemma( Schedule.FieldByName( 'keySubjectPattern').AsInteger);
		Schedule.Next;
	end;

	Schedule.Filter := '';

	SubjectPromoter.ParamByName( 'keyInstance').AsInteger := FComplexTail;
	SubjectPromoter.ExecQuery;

	Schedule.EnableControls;

	Application.MessageBox( 'ɐ܂', 'XPW[̉', MB_OK);
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TCarrySchedulesToolbox.gridSchedule_DrawColumnCell(Sender: TObject; const Rect: TRect; DataCol: Integer; Column: TColumn; State: TGridDrawState);
var
	strExchange : String;
begin
	gridSchedule.Canvas.Font.Size := gridSchedule.Font.Size div 2;
	if IntToBool( Schedule.FieldByName( 'blnAvailable').AsInteger) then
	begin
		gridSchedule.Canvas.Font.Color := IfThen( gdSelected in State, clHighlightText, Column.Font.Color);
		gridSchedule.Canvas.Brush.Color := IfThen( gdSelected in State, clHighlight, Column.Color);
	end
	else
	begin
		gridSchedule.Canvas.Font.Color := IfThen( gdSelected in State, clHighlightText, clWindowText);
		gridSchedule.Canvas.Brush.Color := IfThen( gdSelected in State, clSelectedExcluded, clDefaultExcluded);
	end;

	if Column.Field.IsNull then
	begin
		gridSchedule.Canvas.TextRect( Rect, Rect.Left + 2, Rect.Top + 2, ' ');
		exit;
	end;

	if Column.Field.FieldName = 'INTMINUTESAT' then with Schedule do
	begin
		case FieldByName( 'typSchedule').AsInteger of
		CARE_SCHEDULE, MENAGE_SCHEDULE :
			gridSchedule.Canvas.TextRect( Rect,
				Rect.Left + 2,
				Rect.Top + ( Rect.Bottom - Rect.Top) div 4,
				RangeToText( Column.Field.AsInteger, FieldByName( 'intMinutesFor').AsInteger)
			);
		else
			gridSchedule.Canvas.TextRect( Rect,
				Rect.Left + 2,
				Rect.Top + ( Rect.Bottom - Rect.Top) div 4,
				MinutesToText( Column.Field.AsInteger)
			);
		end;
		exit;
	end;

	if Column.Field.FieldName = 'STRSERVICE' then with Schedule do
	begin
		strExchange := AmountToText(
			FieldByName( 'typExchange').AsInteger,
			FieldByName( 'curAmountPerCount').AsCurrency,
			FieldByName( 'curAmountPerHour').AsCurrency,
			FieldByName( 'intMinutesFor').AsInteger
		);
		gridSchedule.Canvas.TextRect( Rect,
			Rect.Left + 2,
			Rect.Top + 2,
			Column.Field.AsString
		);
		gridSchedule.Canvas.TextOut(
			Rect.Right - 2 - gridSchedule.Canvas.TextWidth( strExchange),
			Rect.Top + ( Rect.Bottom - Rect.Top) div 2 + 2,
			strExchange
		);
		exit;
	end;

	if Column.Field.FieldName = 'STRADDRESSFROM' then
	begin
		case Schedule.FieldByName( 'typSchedule').AsInteger of
		CARE_SCHEDULE, MENAGE_SCHEDULE :
			gridSchedule.Canvas.TextRect( Rect,
				Rect.Left + 2,
				Rect.Top + ( Rect.Bottom - Rect.Top) div 4,
				Column.Field.AsString
			);
		else
			begin
				gridSchedule.Canvas.TextRect( Rect, Rect.Left + 2, Rect.Top + 2, Column.Field.AsString);
				gridSchedule.Canvas.TextOut(
					Rect.Left + 2,
					Rect.Top + ( Rect.Bottom - Rect.Top) div 2 + 1,
					'  ' + Schedule.FieldByName( 'strAddressTo').AsString
				);
			end;
		end;
		exit;
	end;

	if ( Column.PickList.Count > 0) and ( not Column.Field.IsNull) then
	begin
		gridSchedule.Canvas.TextRect( Rect,
			Rect.Left + 2,
			Rect.Top + ( Rect.Bottom - Rect.Top) div 4,
			Column.PickList[ Column.Field.AsInteger]
		);
		exit;
	end;

	gridSchedule.Canvas.TextRect( Rect,
		Rect.Left + 2,
		Rect.Top + ( Rect.Bottom - Rect.Top) div 4,
		Column.Field.AsString
	);
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TCarrySchedulesToolbox.btnBrowseSchedule_Click( Sender : TObject);
begin
	with Schedule do case FieldByName( 'typSchedule').AsInteger of
	     CARE_SCHEDULE : TCareSet.Prepare.Browse( FieldByName( 'keyInstance').AsInteger);
	   MENAGE_SCHEDULE : TMenageSet.Prepare.Browse( FieldByName( 'keyInstance').AsInteger);
	MIGRATION_SCHEDULE : TMigrationSet.Prepare.Browse( FieldByName( 'keyInstance').AsInteger);
	 TRANSFER_SCHEDULE : TTransferSet.Prepare.Browse( FieldByName( 'keyInstance').AsInteger);
	end;
end;

procedure TCarrySchedulesToolbox.btnExcludeSchedule_Click( Sender : TObject);
var
	index : Integer;

	procedure DisableLemma( Target : TDataSet; keySubject : Integer);
	var
		defaultBookmark : String;
	begin
		defaultBookmark := Target.Bookmark;
		Target.First;
		with Target do while not EOF do
		begin
			if FieldByName( 'refSubject').AsInteger = keySubject then
			begin
				DisableLemma( Target, FieldByName( 'keyInstance').AsInteger);
				Edit;
				FieldByName( 'blnAvailable').AsInteger := BoolToInt( false);
				Post;
			end;
			Next;
		end;
		Target.Bookmark := defaultBookmark;
	end;

	procedure EnableSubject( Target : TDataSet; keySubject : Integer);
	var
		defaultBookmark : String;
	begin
		if keySubject <= 0 then exit;
		defaultBookmark := Target.Bookmark;
		Target.First;
		with Target do while not EOF do
		begin
			if FieldByName( 'keyInstance').AsInteger = keySubject then
			begin
				EnableSubject( Target, FieldByName( 'refSubject').AsInteger);
				Edit;
				FieldByName( 'blnAvailable').AsInteger := BoolToInt( true);
				Post;
			end;
			Next;
		end;
		Target.Bookmark := defaultBookmark;
	end;
begin
	Schedule.DisableControls;
	for index := 0 to gridSchedule.SelectedRows.Count - 1 do
        begin
		with Schedule do
		begin
			Bookmark := gridSchedule.SelectedRows.Items[ index];

			if IntToBool( FieldByName( 'blnAvailable').AsInteger) then
				DisableLemma( Schedule, FieldByName( 'keyInstance').AsInteger)
			else
				EnableSubject( Schedule, FieldByName( 'refSubject').AsInteger);

			Edit;
			FieldByName( 'blnAvailable').AsInteger := BoolToInt( not IntToBool( FieldByName( 'blnAvailable').AsInteger));
			Post;
		end;
	end;
	Schedule.EnableControls;
end;

end.
