unit Toolbox_DuplicateSchedules;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, StrUtils, ExtCtrls, Provider, DB, DBClient, DBLocal,
  MainDatastore, DBLocalI, IB, IBErrorCodes, IBSQL, IBDatabase, IBCustomDataSet,
  IBQuery, DBCtrls, ComCtrls, DateUtils, Base_Toolbox, Grids, DBGrids, Math,
  Misc_Constants, Misc_Utilities, Buttons;

procedure DuplicateSchedules( datPivot : TDate; keyClient : Integer);

type
  TDuplicateSchedulesToolbox = class(TToolboxTemplate)
    SourceOf_Schedule: TIBQuery;
    ProviderOf_Schedule: TDataSetProvider;
    Schedule: TClientDataSet;
    DataSourceOf_Schedule: TDataSource;

    lblPrograms: TLabel;
    btnDay_1: TSpeedButton;
    btnDay_2: TSpeedButton;
    btnDay_3: TSpeedButton;
    btnDay_4: TSpeedButton;
    btnDay_5: TSpeedButton;
    btnDay_6: TSpeedButton;
    btnDay_7: TSpeedButton;
    btnDay_8: TSpeedButton;
    btnDay_9: TSpeedButton;
    btnDay_10: TSpeedButton;
    btnDay_11: TSpeedButton;
    btnDay_12: TSpeedButton;
    btnDay_13: TSpeedButton;
    btnDay_14: TSpeedButton;
    btnDay_15: TSpeedButton;
    btnDay_16: TSpeedButton;
    btnDay_17: TSpeedButton;
    btnDay_18: TSpeedButton;
    btnDay_19: TSpeedButton;
    btnDay_20: TSpeedButton;
    btnDay_21: TSpeedButton;
    btnDay_22: TSpeedButton;
    btnDay_23: TSpeedButton;
    btnDay_24: TSpeedButton;
    btnDay_25: TSpeedButton;
    btnDay_26: TSpeedButton;
    btnDay_27: TSpeedButton;
    btnDay_28: TSpeedButton;
    btnDay_29: TSpeedButton;
    btnDay_30: TSpeedButton;
    btnDay_31: TSpeedButton;

    bvlDuplicate: TBevel;

    pnlPivotDate: TPanel;
    gridSchedule: TDBGrid;
    btnBrowseSchedule: TButton;
    btnExcludeSchedule: TButton;

    pbrProgress: TProgressBar;

    procedure gridSchedule_DrawColumnCell(Sender: TObject; const Rect: TRect; DataCol: Integer; Column: TColumn; State: TGridDrawState);

    procedure btnBrowseSchedule_Click( Sender : TObject);
    procedure btnExcludeSchedule_Click( Sender : TObject);

  private
    { Private 錾 }
    FPivotDate : TDate;
    FMonthFirstday : TDate;
    FMonthLastday : TDate;
    FClientKey : Integer;
  protected
    { Protected 錾 }
    procedure BeforePopup(); override;
    procedure AfterPopup(); override;
  end;

var
  DuplicateSchedulesToolbox: TDuplicateSchedulesToolbox;

implementation

{$R *.dfm}

uses Set_Care, Set_Menage, Set_Migration, Set_Transfer;

{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure DuplicateSchedules( datPivot : TDate; keyClient : Integer);
begin
	if keyClient <= 0 then exit;
	with TDuplicateSchedulesToolbox.Create( Screen.ActiveForm) do
	begin
		FPivotDate := datPivot;
		FMonthFirstday := datPivot;
		FMonthLastday := IncDay( IncMonth( datPivot), -1);
		FClientKey := keyClient;
		Popup;
		Release;
	end;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TDuplicateSchedulesToolbox.BeforePopup();
var
	index : Integer;
	dateStamp : TDateTime;
	dayButton : TSpeedButton;
begin
	if not DataStore.VerifyRecord( 'Profile', FClientKey) then
		ErrorMessages.Add( 'Y闘p҂̏͑̒[ŗpłB');

	SourceOf_Schedule.ParamByName( 'keyClient').AsInteger := FClientKey;
	SourceOf_Schedule.ParamByName( 'datSchedule').AsDate := FPivotDate;
	Schedule.Open;

	if Schedule.IsEmpty then
		ErrorMessages.Add( 'ł\肪܂B');

	if ErrorMessages.Count > 0 then exit;
	// update query

	pnlPivotDate.Caption := FormatDateTime( 'gg ee "N" yyyy "N" MM "" dd ""', FPivotDate);
	// update control

	for index := 0 to 30 do
	begin
		dateStamp := IncDay( FMonthFirstday, index);
		dayButton := FindComponent( 'btnDay_' + IntToStr( index + 1)) as TSpeedButton;

		if ( FPivotDate < dateStamp) and ( dateStamp <= FMonthLastday) then
		begin
			dayButton.Caption := IntToStr( DayOf( dateStamp));
			case DayOfWeek( dateStamp) of
			1 : dayButton.Font.Color := $0000CC;
			2..6 : dayButton.Font.Color := clWindowText;
			7 : dayButton.Font.Color := $CC0000;
			end;
			dayButton.Enabled := true;
		end
		else
		begin
			dayButton.Caption := '*';
			dayButton.Enabled := false;
		end;
	end;
	// setup calender
end;

procedure TDuplicateSchedulesToolbox.AfterPopup();

	procedure InsertSchedule( Source : TDataSet; keyInstance, keySubject : Integer; datSchedule : TDate);
	var
		optElement : Integer;
	begin
		optElement := Source.FieldByName( 'optElement').AsInteger;

		with Source do DataStore.InsertSQL( 'Schedule', [
			'keyInstance',
			'typProgress',
			'datSchedule',
			'typPattern',
			'optPattern',
			'typSequence',
			'optElement',
			'refSubject',
			'refService',
			'refExchange',
			'intMinutesAt', 'intMinutesFor',
			'refAddressFrom', 'refAddressTo',
			'strNotice',
			'refClient',
			'refServer'
		], [
			keyInstance,
			FieldByName( 'typProgress').AsInteger,
			DateToStr( datSchedule),
			FieldByName( 'typPattern').AsInteger,
			FieldByName( 'optPattern').AsInteger,
			FieldByName( 'typSequence').AsInteger,
			optElement,
			ZeroToNull( keySubject),
			FieldByName( 'refService').AsInteger,
			FieldByName( 'refExchange').AsInteger,
			FieldByName( 'intMinutesAt').AsInteger, FieldByName( 'intMinutesFor').AsInteger,
			FieldByName( 'refAddressFrom').AsInteger, FieldByName( 'refAddressTo').AsInteger,
			IfThen( ( optElement and ELEMENT_NOTICE) <> 0, FieldByName( 'strNotice').AsString, ''),
			ZeroToNull( FieldByName( 'refClient').AsInteger),
			ZeroToNull( IfThen( ( optElement and ELEMENT_SERVER) <> 0, FieldByName( 'refServer').AsInteger, 0))
		]);
	end;

	function CountOfBits( val : Integer) : Integer;
	begin
		result := 0;
		while val <> 0 do
		begin
			if ( val and $80000000) <> 0 then Inc( result);
			val := val shl 1;
		end;
	end;
var
	optDays, index, key : Integer;
	datSchedule : TDate;
	generatedKeys : TStringList;
begin
	optDays := SpeedButtonsToOptions( [
		btnDay_1, btnDay_2, btnDay_3, btnDay_4, btnDay_5, btnDay_6, btnDay_7, btnDay_8, btnDay_9, btnDay_10,
		btnDay_11, btnDay_12, btnDay_13, btnDay_14, btnDay_15, btnDay_16, btnDay_17, btnDay_18, btnDay_19, btnDay_20,
		btnDay_21, btnDay_22, btnDay_23, btnDay_24, btnDay_25, btnDay_26, btnDay_27, btnDay_28, btnDay_29, btnDay_30,
		btnDay_31
	]);

	if optDays = 0 then
	begin
		ErrorMessages.Add( 'Ώۓw肳Ă܂B');
		exit;
	end;

	Schedule.DisableControls;
	Schedule.Filter := Format( 'blnAvailable=%d', [ BoolToInt( true)]);
	Schedule.Filtered := true;
	key := DataStore.ReserveRevision( Schedule.RecordCount * CountOfBits( optDays));
	pbrProgress.Max := DaysBetween( FMonthLastday, IncDay( FPivotDate));
	for index := 0 to pbrProgress.Max do
	begin
		pbrProgress.Position := index;
		datSchedule := IncDay( FPivotDate, index + 1);
		if ( ( 1 shl DaysBetween( datSchedule, FMonthFirstday)) and optDays) = 0 then continue;

		generatedKeys := TStringList.Create;

		Schedule.Filter := Format( 'refSubject IS NULL and typSchedule IN ( %d, %d, %d)', [ TRANSFER_SCHEDULE, CARE_SCHEDULE, MENAGE_SCHEDULE]);
		Schedule.Filtered := true;
		Schedule.First;
		with Schedule do while not EOF do
		begin
			if IntToBool( FieldByName( 'blnAvailable').AsInteger) then
			begin
				InsertSchedule( Schedule, key, 0, datSchedule);
				generatedKeys.Values[ FieldByName( 'keyInstance').AsString] := IntToStr( key);
				Inc( key);
			end;
			Next;
		end;
		Schedule.Filtered := false;

		Schedule.Filter := Format( 'refSubject IS NOT NULL and typSchedule IN ( %d, %d)', [ CARE_SCHEDULE, MENAGE_SCHEDULE]);
		Schedule.Filtered := true;
		Schedule.First;
		with Schedule do while not EOF do
		begin
			if IntToBool( FieldByName( 'blnAvailable').AsInteger) then
			begin
				InsertSchedule( Schedule, key, StrToInt( generatedKeys.Values[ FieldByName( 'refSubject').AsString]), datSchedule);
				generatedKeys.Values[ FieldByName( 'keyInstance').AsString] := IntToStr( key);
				Inc( key);
			end;
			Next;
		end;
		Schedule.Filtered := false;

		Schedule.Filter := Format( 'refSubject IS NOT NULL and typSchedule = %d', [ TRANSFER_SCHEDULE]);
		Schedule.Filtered := true;
		Schedule.First;
		with Schedule do while not EOF do
		begin
			if IntToBool( FieldByName( 'blnAvailable').AsInteger) then
			begin
				InsertSchedule( Schedule, key, StrToInt( generatedKeys.Values[ FieldByName( 'refSubject').AsString]), datSchedule);
				generatedKeys.Values[ FieldByName( 'keyInstance').AsString] := IntToStr( key);
				Inc( key);
			end;
			Next;
		end;
		Schedule.Filtered := false;

		Schedule.Filter := Format( 'refSubject IS NOT NULL and typSchedule=%d', [ MIGRATION_SCHEDULE]);
		Schedule.Filtered := true;
		Schedule.First;
		with Schedule do while not EOF do
		begin
			if IntToBool( FieldByName( 'blnAvailable').AsInteger) then
			begin
				InsertSchedule( Schedule, key, StrToInt( generatedKeys.Values[ FieldByName( 'refSubject').AsString]), datSchedule);
				generatedKeys.Values[ FieldByName( 'keyInstance').AsString] := IntToStr( key);
				Inc( key);
			end;
			Next;
		end;
		Schedule.Filtered := false;

		generatedKeys.Free;
	end;
	// record generation

	Application.MessageBox( 'ɐ܂', 'ꊇ', MB_OK);
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TDuplicateSchedulesToolbox.gridSchedule_DrawColumnCell(Sender: TObject; const Rect: TRect; DataCol: Integer; Column: TColumn; State: TGridDrawState);
var
	selected : Boolean;
	dummy : Integer;
	strExchange : String;
begin
	gridSchedule.Canvas.Font.Size := gridSchedule.Font.Size div 2; 
	selected := gridSchedule.SelectedRows.Find( Schedule.Bookmark, dummy);
	if IntToBool( Schedule.FieldByName( 'blnAvailable').AsInteger) then
	begin
		gridSchedule.Canvas.Font.Color := IfThen( selected, clHighlightText, Column.Font.Color);
		gridSchedule.Canvas.Brush.Color := IfThen( selected, clHighlight, Column.Color);
	end
	else
	begin
		gridSchedule.Canvas.Font.Color := IfThen( selected, clHighlightText, clWindowText);
		gridSchedule.Canvas.Brush.Color := IfThen( selected, clSelectedExcluded, clDefaultExcluded);
	end;

	if Column.Field.IsNull then
        begin
		gridSchedule.Canvas.TextRect( Rect, Rect.Left + 2, Rect.Top + 2, ' ');
        	exit;
        end;

	if Column.Field.FieldName = 'INTMINUTESAT' then with Schedule do
	begin
		case FieldByName( 'typSchedule').AsInteger of
		CARE_SCHEDULE, MENAGE_SCHEDULE :
			gridSchedule.Canvas.TextRect( Rect,
				Rect.Left + 2,
				Rect.Top + ( Rect.Bottom - Rect.Top) div 4,
				RangeToText( Column.Field.AsInteger, FieldByName( 'intMinutesFor').AsInteger)
			);
		else
			gridSchedule.Canvas.TextRect( Rect,
				Rect.Left + 2,
				Rect.Top + ( Rect.Bottom - Rect.Top) div 4,
				MinutesToText( Column.Field.AsInteger)
			);
		end;
		exit;
	end;

	if Column.Field.FieldName = 'STRSERVICE' then with Schedule do
	begin
		strExchange := AmountToText(
			FieldByName( 'typExchange').AsInteger,
			FieldByName( 'curAmountPerCount').AsCurrency,
			FieldByName( 'curAmountPerHour').AsCurrency,
			FieldByName( 'intMinutesFor').AsInteger
		);
		gridSchedule.Canvas.TextRect( Rect,
			Rect.Left + 2,
			Rect.Top + 2,
			Column.Field.AsString
		);
		gridSchedule.Canvas.TextOut(
			Rect.Right - 2 - gridSchedule.Canvas.TextWidth( strExchange),
			Rect.Top + ( Rect.Bottom - Rect.Top) div 2 + 2,
			strExchange
		);
		exit;
	end;

	if Column.Field.FieldName = 'STRADDRESSFROM' then
	begin
		case Schedule.FieldByName( 'typSchedule').AsInteger of
		CARE_SCHEDULE, MENAGE_SCHEDULE :
			gridSchedule.Canvas.TextRect( Rect,
				Rect.Left + 2,
				Rect.Top + ( Rect.Bottom - Rect.Top) div 4,
				Column.Field.AsString
			);
		else
			begin
				gridSchedule.Canvas.TextRect( Rect, Rect.Left + 2, Rect.Top + 2, Column.Field.AsString);
				gridSchedule.Canvas.TextOut(
					Rect.Left + 2,
					Rect.Top + ( Rect.Bottom - Rect.Top) div 2 + 1,
					'  ' + Schedule.FieldByName( 'strAddressTo').AsString
				);
			end;
		end;
		exit;
	end;

	if ( Column.PickList.Count > 0) and ( not Column.Field.IsNull) then
	begin
		gridSchedule.Canvas.TextRect( Rect,
			Rect.Left + 2,
			Rect.Top + ( Rect.Bottom - Rect.Top) div 4,
			Column.PickList[ Column.Field.AsInteger]
		);
		exit;
	end;

	gridSchedule.Canvas.TextRect( Rect,
		Rect.Left + 2,
		Rect.Top + ( Rect.Bottom - Rect.Top) div 4,
		Column.Field.AsString
	);
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TDuplicateSchedulesToolbox.btnBrowseSchedule_Click( Sender : TObject);
begin
	with Schedule do case FieldByName( 'typSchedule').AsInteger of
	     CARE_SCHEDULE : TCareSet.Prepare.Browse( FieldByName( 'keyInstance').AsInteger);
	   MENAGE_SCHEDULE : TMenageSet.Prepare.Browse( FieldByName( 'keyInstance').AsInteger);
	MIGRATION_SCHEDULE : TMigrationSet.Prepare.Browse( FieldByName( 'keyInstance').AsInteger);
	 TRANSFER_SCHEDULE : TTransferSet.Prepare.Browse( FieldByName( 'keyInstance').AsInteger);
	end;
end;

procedure TDuplicateSchedulesToolbox.btnExcludeSchedule_Click( Sender : TObject);
var
	index : Integer;

	procedure DisableLemma( Target : TDataSet; keySubject : Integer);
	var
		defaultBookmark : String;
	begin
		defaultBookmark := Target.Bookmark;
		Target.First;
		with Target do while not EOF do
		begin
			if FieldByName( 'refSubject').AsInteger = keySubject then
			begin
				DisableLemma( Target, FieldByName( 'keyInstance').AsInteger);
				Edit;
				FieldByName( 'blnAvailable').AsInteger := BoolToInt( false);
				Post;
			end;
			Next;
		end;
		Target.Bookmark := defaultBookmark;
	end;

	procedure EnableSubject( Target : TDataSet; keySubject : Integer);
	var
		defaultBookmark : String;
	begin
		if keySubject <= 0 then exit;
		defaultBookmark := Target.Bookmark;
		Target.First;
		with Target do while not EOF do
		begin
			if FieldByName( 'keyInstance').AsInteger = keySubject then
			begin
				EnableSubject( Target, FieldByName( 'refSubject').AsInteger);
				Edit;
				FieldByName( 'blnAvailable').AsInteger := BoolToInt( true);
				Post;
			end;
			Next;
		end;
		Target.Bookmark := defaultBookmark;
	end;
begin
	if Schedule.IsEmpty then exit;

	Schedule.DisableControls;
	for index := 0 to gridSchedule.SelectedRows.Count - 1 do
        begin
		with Schedule do
		begin
			Bookmark := gridSchedule.SelectedRows.Items[ index];

			if IntToBool( FieldByName( 'blnAvailable').AsInteger) then
				DisableLemma( Schedule, FieldByName( 'keyInstance').AsInteger)
			else
				EnableSubject( Schedule, FieldByName( 'refSubject').AsInteger);

			Edit;
			FieldByName( 'blnAvailable').AsInteger := BoolToInt( not IntToBool( FieldByName( 'blnAvailable').AsInteger));
			Post;
		end;
	end;
	Schedule.EnableControls;
end;

end.
