unit Toolbox_GeneratePaybacks;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, StrUtils, ExtCtrls, Provider, DB, DBClient, DBLocal,
  MainDatastore, DBLocalI, IB, IBErrorCodes, IBSQL, IBDatabase, IBCustomDataSet,
  IBQuery, DBCtrls, ComCtrls, DateUtils, Base_Toolbox, Grids, DBGrids, Math,
  Misc_Constants, Misc_Utilities;

procedure GeneratePaybacks( datFirstday, datLastday : TDate);

type
  TGeneratePaybacksToolbox = class(TToolboxTemplate)
    Payee: TIBQuery;

    lblPublished: TLabel;
    dtpPublished: TDateTimePicker;
    pbrProgress: TProgressBar;
    btnAbort: TButton;
    lblSpan: TLabel;
    dtpSpanFrom: TDateTimePicker;
    dtpSpanTo: TDateTimePicker;
    lblOver: TLabel;

    procedure dtpCalendar_Change(Sender: TObject);
    procedure btnAbort_Click(Sender: TObject);

  private
    { Private 錾 }
    FGenerating : Boolean;
  protected
    { Protected 錾 }
    procedure BeforePopup(); override;
    procedure AfterPopup(); override;
  end;

var
  GeneratePaybacksToolbox: TGeneratePaybacksToolbox;

implementation

{$R *.dfm}

uses Set_Payback;

{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure GeneratePaybacks( datFirstday, datLastday : TDate);
begin
	with TGeneratePaybacksToolbox.Create( Screen.ActiveForm) do
	begin
		dtpSpanFrom.Date := DateOf( datFirstday);
		dtpSpanTo.Date := DateOf( datLastday);
		dtpPublished.Date := IncDay( DateOf( datLastday));
		Popup;
		Release;
	end;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TGeneratePaybacksToolbox.BeforePopup();
begin
	dtpCalendar_Change( dtpSpanFrom);
	dtpCalendar_Change( dtpSpanTo);
	dtpCalendar_Change( dtpPublished);
end;

procedure TGeneratePaybacksToolbox.AfterPopup();
begin
	if dtpSpanFrom.Date >= dtpSpanTo.Date then
		ErrorMessages.Add( 'WvԂ̓ttɂȂĂ܂B');

	if dtpPublished.Date < dtpSpanTo.Date then
		ErrorMessages.Add( 'sWvԓɂȂĂ܂B');

	if ErrorMessages.Count > 0 then exit;

	FGenerating := true;
	dtpPublished.Enabled := false;
	dtpSpanFrom.Enabled := false;
	dtpSpanTo.Enabled := false;
	btnOK.Enabled := false;
	btnCancel.Enabled := false;
	btnAbort.Enabled := true;

	Payee.ParamByName( 'datFrom').AsDate := dtpSpanFrom.Date;
	Payee.ParamByName( 'datTo').AsDate := dtpSpanTo.Date;
	Payee.Open;
	Payee.Last;
	Payee.First;
	pbrProgress.Max := Payee.RecordCount;
	with Payee do while FGenerating and ( not EOF) do
	begin
		TPaybackSet.Prepare(
			dtpSpanFrom.Date,
			dtpSpanTo.Date,
			dtpPublished.Date,
			ReadInstanceKey( Payee)
		).Append( true);

		pbrProgress.Position := RecNo;
		Next;

                Application.ProcessMessages;
	end;

	if not FGenerating then
		Application.MessageBox( '𒆎~܂', 'Z', MB_OK)
	else
		Application.MessageBox( '܂', 'Z', MB_OK);

	Close;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TGeneratePaybacksToolbox.dtpCalendar_Change(Sender: TObject);
begin
	( Sender as TDateTimePicker).Format := FormatDateTime( ' gg ee "N"', ( Sender as TDateTimePicker).Date) + ' yyyy N MM  dd ';
end;

procedure TGeneratePaybacksToolbox.btnAbort_Click(Sender: TObject);
begin
	FGenerating := false;
end;

end.
