unit Toolbox_ModifySchedules;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, StrUtils, ExtCtrls, Provider, DB, DBClient, DBLocal,
  MainDatastore, DBLocalI, IB, IBErrorCodes, IBSQL, IBDatabase, IBCustomDataSet,
  IBQuery, DBCtrls, ComCtrls, DateUtils, Base_Toolbox, Grids, DBGrids, Math,
  ActnList, Misc_Constants, Misc_Utilities, Piece_AddressSelector,
  Piece_MinutesSelector, Buttons;

procedure ModifySchedules( datAt : TDate; keyClient : Integer);

type
  TModifySchedulesToolbox = class(TToolboxTemplate)
    SourceOf_Schedule: TIBQuery;
    ProviderOf_Schedule: TDataSetProvider;
    Schedule: TClientDataSet;
    DataSourceOf_Schedule: TDataSource;

    ProviderOf_Modification: TDataSetProvider;
    Modification: TClientDataSet;

    Service: TIBQuery;
    Exchange: TIBQuery;
    DataSourceOf_Exchange: TDataSource;
    DataSourceOf_Service: TDataSource;

    Client: TIBQuery;
    Server: TIBQuery;

    lblPrograms: TLabel;
    btnDay_1: TSpeedButton;
    btnDay_2: TSpeedButton;
    btnDay_3: TSpeedButton;
    btnDay_4: TSpeedButton;
    btnDay_5: TSpeedButton;
    btnDay_6: TSpeedButton;
    btnDay_7: TSpeedButton;
    btnDay_8: TSpeedButton;
    btnDay_9: TSpeedButton;
    btnDay_10: TSpeedButton;
    btnDay_11: TSpeedButton;
    btnDay_12: TSpeedButton;
    btnDay_13: TSpeedButton;
    btnDay_14: TSpeedButton;
    btnDay_15: TSpeedButton;
    btnDay_16: TSpeedButton;
    btnDay_17: TSpeedButton;
    btnDay_18: TSpeedButton;
    btnDay_19: TSpeedButton;
    btnDay_20: TSpeedButton;
    btnDay_21: TSpeedButton;
    btnDay_22: TSpeedButton;
    btnDay_23: TSpeedButton;
    btnDay_24: TSpeedButton;
    btnDay_25: TSpeedButton;
    btnDay_26: TSpeedButton;
    btnDay_27: TSpeedButton;
    btnDay_28: TSpeedButton;
    btnDay_29: TSpeedButton;
    btnDay_30: TSpeedButton;
    btnDay_31: TSpeedButton;

    gridSchedule: TDBGrid;

    cboSchedule: TComboBox;
    btnBrowseSchedule: TButton;
    btnExcludeSchedule: TButton;

    bvlModification: TBevel;

    pnlService: TPanel;
    chkModifyService: TCheckBox;
    cboService: TDBLookupComboBox;
    lblExchange: TLabel;
    cboExchange: TDBLookupComboBox;
    pnlExchange: TPanel;
    bvlService: TBevel;

    chkModifyAddress: TCheckBox;
    AddressFrom: TAddressSelector;
    lblLocationTo: TLabel;
    AddressTo: TAddressSelector;

    chkModifyMinutes: TCheckBox;
    MinutesFrom: TMinutesSelector;
    lblMinutesOver: TLabel;
    MinutesTo: TMinutesSelector;

    chkModifyNotice: TCheckBox;
    txtNotice: TLabeledEdit;

    bvlServer: TBevel;
    ServerFrame: TShape;
    pnlServer: TPanel;
    chkModifyServer: TCheckBox;
    txtServerRead: TEdit;
    txtServerName: TEdit;
    txtServerZipAddress: TEdit;
    txtServerAddress: TEdit;
    txtServerPhone: TEdit;
    pnlServerAge: TPanel;
    pnlServerSex: TPanel;
    btnBrowseServer: TButton;
    btnReleaseServer: TButton;
    btnChooseServer: TButton;

    pbrProgress: TProgressBar;

    ShortCuts: TActionList;
    actSelectAddressFrom: TAction;
    actSelectAddressTo: TAction;

    procedure Selector_Change( Sender : TObject);

    procedure Schedule_AfterRefresh(DataSet: TDataSet);

    procedure gridSchedule_DrawColumnCell(Sender: TObject; const Rect: TRect; DataCol: Integer; Column: TColumn; State: TGridDrawState);

    procedure btnBrowseSchedule_Click( Sender : TObject);
    procedure btnExcludeSchedule_Click( Sender : TObject);

    procedure chkModifyService_Click( Sender : TObject);
    procedure chkModifyMinutes_Click( Sender : TObject);
    procedure chkModifyAddress_Click( Sender : TObject);
    procedure chkModifyNotice_Click(Sender: TObject);

    procedure cboService_Click(Sender: TObject);
    procedure cboExchange_Click(Sender: TObject);

    procedure MinutesFrom_Change(Sender: TObject);

    procedure Server_AfterOpen(DataSet: TDataSet);
    procedure btnBrowseServer_Click(Sender: TObject);
    procedure btnReleaseServer_Click(Sender: TObject);
    procedure btnChooseServer_Click(Sender: TObject);

  private
    { Private 錾 }
    FMonthFirstday : TDate;
    FMonthLastday : TDate;
    FClientKey : Integer;
  protected
    { Protected 錾 }
    procedure BeforePopup(); override;
    procedure AfterPopup(); override;
  public
    { Public 錾 }
  end;

var
  ModifySchedulesToolbox: TModifySchedulesToolbox;

implementation

{$R *.dfm}

uses Set_Care, Set_Menage, Set_Migration, Set_Transfer, Chooser_Server, Set_Server;

{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure ModifySchedules( datAt : TDate; keyClient : Integer);
begin
	if keyClient <= 0 then exit;
	with TModifySchedulesToolbox.Create( Screen.ActiveForm) do
	begin
		FMonthFirstday := StartOfTheMonth( datAt);
		FMonthLastday := EndOfTheMonth( datAt);
		FClientKey := keyClient;
		Popup;
		Release;
	end;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TModifySchedulesToolbox.BeforePopup();
var
	index : Integer;
	dateStamp : TDateTime;
	dayButton : TSpeedButton;
begin
	if not DataStore.VerifyRecord( 'Profile', FClientKey) then
		ErrorMessages.Add( 'Y闘p҂̏͑̒[ŗpłB');

	if ErrorMessages.Count > 0 then exit;
	// error check

	MinutesFrom.OnChange := MinutesFrom_Change;

	Client.ParamByName( 'keyInstance').AsInteger := FClientKey;
	Client.ParamByName( 'datAvailableAt').AsDate := FMonthFirstday;
	Client.Open;

	Selector_Change( self);
        SelectComboWithoutFail( cboService, -1);
	// setup controls

	for index := 0 to 30 do
	begin
		dateStamp := IncDay( FMonthFirstday, index);
		dayButton := FindComponent( 'btnDay_' + IntToStr( index + 1)) as TSpeedButton;

		if dateStamp <= FMonthLastday then
		begin
			dayButton.Caption := IntToStr( DayOf( dateStamp));
			case DayOfWeek( dateStamp) of
			1 : dayButton.Font.Color := $0000CC;
			2..6 : dayButton.Font.Color := clWindowText;
			7 : dayButton.Font.Color := $CC0000;
			end;
			dayButton.Enabled := true;
		end
		else
		begin
			dayButton.Caption := '*';
			dayButton.Enabled := false;
		end;
	end;
	// setup calender

	chkModifyService_Click( chkModifyService);
	chkModifyMinutes_Click( chkModifyMinutes);
	chkModifyAddress_Click( chkModifyAddress);
	chkModifyNotice_Click( chkModifyNotice);
	// disable controls
end;

procedure TModifySchedulesToolbox.AfterPopup();
var
	failed : Boolean;
	selector : String;
label
	do_retry;
begin
	if chkModifyService.Checked and ( cboService.Text = '') then
		ErrorMessages.Add( 'T[rXIĂ܂B');

	if chkModifyService.Checked and ( cboExchange.Text = '') then
		ErrorMessages.Add( 'ӗ炪IĂ܂B');

	if chkModifyMinutes.Checked and MinutesTo.Visible and ( MinutesFrom.Value >= MinutesTo.Value) then
		ErrorMessages.Add( 'IJnɂȂĂ܂B');

	if chkModifyAddress.Checked and ( AddressFrom.Unclear or ( AddressTo.Visible and AddressTo.Unclear)) then
		ErrorMessages.Add( 'ꏊwɋ󗓂܂͉͂̍ڂ܂B');

	if chkModifyServer.Checked and Server.IsEmpty then
		ErrorMessages.Add( 'hCo[/wp[IĂ܂B');

	if chkModifyServer.Checked and ( Server.FieldByName( 'keyInstance').AsInteger = FClientKey) then
		ErrorMessages.Add( 'hCo[/wp[Ɨp҂ɓ̓o^҂IԂƂ͂ł܂B');

	if ErrorMessages.Count > 0 then exit;
	// error check

	Modification.Close;
	Modification.Open;
	Modification.Refresh;

	Modification.First;
	with Modification do while not EOF do
	begin
		Edit;

		if chkModifyService.Checked then
                begin
			FieldByName( 'refService').AsInteger := cboService.KeyValue;
			FieldByName( 'refExchange').AsInteger := cboExchange.KeyValue;
                end;

		if chkModifyMinutes.Checked then
			FieldByName( 'intMinutesAt').AsInteger := MinutesFrom.Value;

		if chkModifyMinutes.Checked and MinutesTo.Visible then
			FieldByName( 'intMinutesFor').AsInteger := MinutesTo.Value - MinutesFrom.Value;

		if chkModifyAddress.Checked then
			FieldByName( 'refAddressFrom').AsInteger := AddressFrom.KeyValue;

		if chkModifyAddress.Checked and AddressTo.Visible then
			FieldByName( 'refAddressTo').AsInteger := AddressTo.KeyValue;

		if chkModifyNotice.Checked then
			FieldByName( 'strNotice').AsString := Trim( txtNotice.Text);

		if chkModifyServer.Checked then
			FieldByName( 'refServer').AsInteger := Server.FieldByName( 'keyInstance').AsInteger;

		Post;
		Next;
	end;

do_retry:
	failed := false;
	Modification.First;
	pbrProgress.Max := Modification.RecordCount;
	with Modification do while not EOF do
	begin
		selector := Format( 'keyInstance=%d and typStatus=%d', [ FieldByName( 'keyInstance').AsInteger, DATA_ENABLED]);
		try
			if IntToBool( FieldByName( 'blnAvailable').AsInteger) and ( not IntToBool( FieldByName( 'blnModified').AsInteger)) then
			begin
				DataStore.UpdateSQL( 'Schedule', selector, [
					'refService',
					'refExchange',
					'intMinutesAt',
					'intMinutesFor',
					'refAddressFrom',
					'refAddressTo',
					'strNotice',
					'refServer'
				], [
					FieldByName( 'refService').AsInteger,
					FieldByName( 'refExchange').AsInteger,
					FieldByName( 'intMinutesAt').AsInteger,
					FieldByName( 'intMinutesFor').AsInteger,
					FieldByName( 'refAddressFrom').AsInteger,
					FieldByName( 'refAddressTo').AsInteger,
					FieldByName( 'strNotice').AsString,
					ZeroToNull( FieldByName( 'refServer').AsInteger)
				]);

				Edit;
				FieldByName( 'blnModified').AsInteger := BoolToInt( true);
				Post;
			end;
		except
			on err : EIBInterBaseError do
			begin
				failed := true;
			end;
		end;

		pbrProgress.Position := RecNo;
		Next;
	end;

	if failed then
	begin
		if Application.MessageBox(
			'̒[ŗpĂꕔ̏̕ύXɎs܂B' + #13#10 +
			'xύX݂ꍇɂ́uĎsv{^' + #13#10 +
			'̂܂܏Iꍇɂ́uLZv{^NbNĂ',
			'ꊇύX',
			MB_RETRYCANCEL
		) = IDRETRY then
			goto do_retry;
	end;

	Application.MessageBox( 'ύXɐ܂', 'ꊇύX', MB_OK);
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TModifySchedulesToolbox.Selector_Change( Sender : TObject);
begin
	Schedule.Close;
	SourceOf_Schedule.ParamByName( 'keyClient').AsInteger := FClientKey;
	SourceOf_Schedule.ParamByName( 'datFrom').AsDate := FMonthFirstday;
	SourceOf_Schedule.ParamByName( 'datTo').AsDate := FMonthLastday;
	SourceOf_Schedule.ParamByName( 'optDays').AsInteger := SpeedButtonsToOptions( [
		btnDay_1, btnDay_2, btnDay_3, btnDay_4, btnDay_5, btnDay_6, btnDay_7, btnDay_8, btnDay_9, btnDay_10,
		btnDay_11, btnDay_12, btnDay_13, btnDay_14, btnDay_15, btnDay_16, btnDay_17, btnDay_18, btnDay_19, btnDay_20,
		btnDay_21, btnDay_22, btnDay_23, btnDay_24, btnDay_25, btnDay_26, btnDay_27, btnDay_28, btnDay_29, btnDay_30,
		btnDay_31
	]);
	SourceOf_Schedule.ParamByName( 'typSchedule').AsInteger := cboSchedule.ItemIndex;
	Schedule.Open;

	Service.Close;
	Service.ParamByName( 'typCategory').AsInteger := cboSchedule.ItemIndex;
	Service.ParamByName( 'datMonthFirstday').AsDate := FMonthFirstday;
	Service.ParamByName( 'datMonthLastday').AsDate := FMonthLastday;
	Service.Open;
	Service.FetchAll;
	SelectComboWithoutFail( cboService, VarToInt( cboService.KeyValue));
	cboService_Click( cboService);

	AddressFrom.Reset( DataStore.MainTransaction, FMonthFirstday, -1, FClientKey, -1);
	AddressTo.Reset( DataStore.MainTransaction, FMonthFirstday, -1, FClientKey, -1);

	Server.Close;
	Server.ParamByName( 'datAvailableAt').AsDate := FMonthLastday;
	Server.Open;
	// update query

	case cboSchedule.ItemIndex of
	CARE_SCHEDULE, MENAGE_SCHEDULE :
		begin
			chkModifyMinutes.Caption := '{';
			lblMinutesOver.Visible := true;
			MinutesTo.Visible := true;

			chkModifyAddress.Caption := 'Jnꏊ';
			lblLocationTo.Visible := false;
			AddressTo.Visible := false;

			chkModifyServer.Caption := 'wp[';
		end;

	MIGRATION_SCHEDULE, TRANSFER_SCHEDULE :
		begin
			chkModifyMinutes.Caption := 'o';
			lblMinutesOver.Visible := false;
			MinutesTo.Visible := false;

			chkModifyAddress.Caption := 'ړs';
			lblLocationTo.Visible := true;
			AddressTo.Visible := true;

			chkModifyServer.Caption := 'hCo[';
		end;
	end;

	btnOK.Enabled := not Client.IsEmpty;
	// update control
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TModifySchedulesToolbox.Schedule_AfterRefresh(DataSet: TDataSet);
begin
	btnBrowseSchedule.Enabled := not Schedule.IsEmpty;
	btnExcludeSchedule.Enabled := not Schedule.IsEmpty;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TModifySchedulesToolbox.gridSchedule_DrawColumnCell(Sender: TObject; const Rect: TRect; DataCol: Integer; Column: TColumn; State: TGridDrawState);
var
	selected : Boolean;
	dummy : Integer;
	strExchange : String;
begin
	gridSchedule.Canvas.Font.Size := gridSchedule.Font.Size div 2; 
	selected := gridSchedule.SelectedRows.Find( Schedule.Bookmark, dummy);
	if IntToBool( Schedule.FieldByName( 'blnAvailable').AsInteger) then
	begin
		gridSchedule.Canvas.Font.Color := IfThen( selected, clHighlightText, Column.Font.Color);
		gridSchedule.Canvas.Brush.Color := IfThen( selected, clHighlight, Column.Color);
	end
	else
	begin
		gridSchedule.Canvas.Font.Color := IfThen( selected, clHighlightText, clWindowText);
		gridSchedule.Canvas.Brush.Color := IfThen( selected, clSelectedExcluded, clDefaultExcluded);
	end;

	if Column.Field.IsNull then
        begin
		gridSchedule.Canvas.TextRect( Rect, Rect.Left + 2, Rect.Top + 2, ' ');
        	exit;
        end;

	if Column.Field.FieldName = 'INTMINUTESAT' then with Schedule do
	begin
		case FieldByName( 'typSchedule').AsInteger of
		CARE_SCHEDULE, MENAGE_SCHEDULE :
			gridSchedule.Canvas.TextRect( Rect,
				Rect.Left + 2,
				Rect.Top + ( Rect.Bottom - Rect.Top) div 4,
				RangeToText( Column.Field.AsInteger, FieldByName( 'intMinutesFor').AsInteger)
			);
		else
			gridSchedule.Canvas.TextRect( Rect,
				Rect.Left + 2,
				Rect.Top + ( Rect.Bottom - Rect.Top) div 4,
				MinutesToText( Column.Field.AsInteger)
			);
		end;
		exit;
	end;

	if Column.Field.FieldName = 'STRSERVICE' then with Schedule do
	begin
		strExchange := AmountToText(
			FieldByName( 'typExchange').AsInteger,
			FieldByName( 'curAmountPerCount').AsCurrency,
			FieldByName( 'curAmountPerHour').AsCurrency,
			FieldByName( 'intMinutesFor').AsInteger
		);
		gridSchedule.Canvas.TextRect( Rect,
			Rect.Left + 2,
			Rect.Top + 2,
			Column.Field.AsString
		);
		gridSchedule.Canvas.TextOut(
			Rect.Right - 2 - gridSchedule.Canvas.TextWidth( strExchange),
			Rect.Top + ( Rect.Bottom - Rect.Top) div 2 + 2,
			strExchange
		);
		exit;
	end;

	if Column.Field.FieldName = 'STRADDRESSFROM' then
	begin
		case Schedule.FieldByName( 'typSchedule').AsInteger of
		CARE_SCHEDULE, MENAGE_SCHEDULE :
			gridSchedule.Canvas.TextRect( Rect,
				Rect.Left + 2,
				Rect.Top + ( Rect.Bottom - Rect.Top) div 4,
				Column.Field.AsString
			);
		else
			begin
				gridSchedule.Canvas.TextRect( Rect, Rect.Left + 2, Rect.Top + 2, Column.Field.AsString);
				gridSchedule.Canvas.TextOut(
					Rect.Left + 2,
					Rect.Top + ( Rect.Bottom - Rect.Top) div 2 + 1,
					'  ' + Schedule.FieldByName( 'strAddressTo').AsString
				);
			end;
		end;
		exit;
	end;

	if ( Column.PickList.Count > 0) and ( not Column.Field.IsNull) then
	begin
		gridSchedule.Canvas.TextRect( Rect,
			Rect.Left + 2,
			Rect.Top + ( Rect.Bottom - Rect.Top) div 4,
			Column.PickList[ Column.Field.AsInteger]
		);
		exit;
	end;

	gridSchedule.Canvas.TextRect( Rect,
		Rect.Left + 2,
		Rect.Top + ( Rect.Bottom - Rect.Top) div 4,
		Column.Field.AsString
	);
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TModifySchedulesToolbox.btnBrowseSchedule_Click( Sender : TObject);
begin
	with Schedule do case FieldByName( 'typSchedule').AsInteger of
	     CARE_SCHEDULE : TCareSet.Prepare.Browse( FieldByName( 'keyInstance').AsInteger);
	   MENAGE_SCHEDULE : TMenageSet.Prepare.Browse( FieldByName( 'keyInstance').AsInteger);
	MIGRATION_SCHEDULE : TMigrationSet.Prepare.Browse( FieldByName( 'keyInstance').AsInteger);
	 TRANSFER_SCHEDULE : TTransferSet.Prepare.Browse( FieldByName( 'keyInstance').AsInteger);
	end;
end;

procedure TModifySchedulesToolbox.btnExcludeSchedule_Click( Sender : TObject);
var
	index : Integer;
begin
	if Schedule.IsEmpty then exit;
	for index := 0 to gridSchedule.SelectedRows.Count - 1 do
	begin
		with Schedule do
		begin
			Bookmark := gridSchedule.SelectedRows.Items[ index];
			Edit;
			FieldByName( 'blnAvailable').AsInteger := BoolToInt( not IntToBool( FieldByName( 'blnAvailable').AsInteger));
			Post;
		end;
	end;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TModifySchedulesToolbox.chkModifyService_Click( Sender : TObject);
begin
	cboService.Enabled := chkModifyService.Checked;
	cboExchange.Enabled := chkModifyService.Checked;
end;

procedure TModifySchedulesToolbox.chkModifyMinutes_Click( Sender : TObject);
begin
	MinutesFrom.ReadOnly := not chkModifyMinutes.Checked;
	MinutesTo.ReadOnly := not chkModifyMinutes.Checked;
end;

procedure TModifySchedulesToolbox.chkModifyAddress_Click( Sender : TObject);
begin
	AddressFrom.ReadOnly := not chkModifyAddress.Checked;
	AddressTo.ReadOnly := not chkModifyAddress.Checked;
end;

procedure TModifySchedulesToolbox.chkModifyNotice_Click( Sender : TObject);
begin
	txtNotice.Enabled := chkModifyNotice.Checked;
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TModifySchedulesToolbox.cboService_Click(Sender: TObject);
begin
	Exchange.Close;
	Exchange.ParamByName( 'keyService').AsInteger := Service.FieldByName( 'keyInstance').AsInteger;
	Exchange.ParamByName( 'datMonthFirstday').AsDate := FMonthFirstday;
	Exchange.ParamByName( 'datMonthLastday').AsDate := FMonthLastday;
	Exchange.Open;
	Exchange.FetchAll;
	SelectComboWithoutFail( cboExchange, VarToInt( cboExchange.KeyValue));
	cboExchange_Click( cboExchange);
end;

procedure TModifySchedulesToolbox.cboExchange_Click(Sender: TObject);
begin
	with Exchange do
	begin
		pnlExchange.Caption := AmountToText(
			FieldByName( 'typCategory').AsInteger,
			FieldByName( 'curAmountPerCount').AsCurrency,
			FieldByName( 'curAmountPerHour').AsCurrency,
			60
		);
	end;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TModifySchedulesToolbox.MinutesFrom_Change(Sender: TObject);
begin
	MinutesTo.Value := MinutesFrom.Value + MinutesTo.Value - MinutesFrom.PrevValue;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TModifySchedulesToolbox.Server_AfterOpen(DataSet: TDataSet);
begin
	with Server do if IsEmpty then
	begin
		txtServerRead.Text := 'Ă傤@߂';
		txtServerName.Text := '99999 񋟎ҁ@';
		txtServerZipAddress.Text := 'ZP';
		txtServerAddress.Text := 'ZQ';
		txtServerPhone.Text := 'dbԍP';
		pnlServerAge.Caption := '';
		pnlServerSex.Caption := '';
		btnBrowseServer.Enabled := false;
		btnReleaseServer.Enabled := false;
	end
	else
	begin
		txtServerRead.Text := Trim( FieldByName( 'strNameRead').AsString);
		txtServerName.Text := Trim( FieldByName( 'strName').AsString);
		txtServerZipAddress.Text := Trim( FieldByName( 'strZipAddress').AsString);
		txtServerAddress.Text := Trim( FieldByName( 'strAddress').AsString);
		txtServerPhone.Text := Trim( FieldByName( 'strPhoneNumber1').AsString);
		pnlServerAge.Caption := ToAgeText( FMonthFirstday, FieldByName( 'datBirthday').AsDateTime);
		pnlServerSex.Caption := aSex[ FieldByName( 'typSex').AsInteger];
		btnBrowseServer.Enabled := true;
		btnReleaseServer.Enabled := true;
	end;

	btnChooseServer.Enabled := chkModifyServer.Checked;

	AddressFrom.ServerKey := Server.FieldByName( 'keyInstance').AsInteger;
	AddressTo.ServerKey := Server.FieldByName( 'keyInstance').AsInteger;
end;

procedure TModifySchedulesToolbox.btnBrowseServer_Click(Sender: TObject);
begin
	TServerSet.Prepare.Browse( Server.FieldByName( 'keyInstance').AsInteger);
end;

procedure TModifySchedulesToolbox.btnReleaseServer_Click(Sender: TObject);
begin
	Server.Close;
	Server.ParamByName( 'keyInstance').AsInteger := -1;
	Server.Open;
end;

procedure TModifySchedulesToolbox.btnChooseServer_Click(Sender: TObject);
var
	keyProfile : Integer;
begin
	if ChooseServer( DataStore.MainTransaction, FMonthLastday, keyProfile) then
	begin
		Server.Close;
		Server.ParamByName( 'keyInstance').AsInteger := keyProfile;
		Server.Open;
	end;
end;

end.
