unit Toolbox_StopSchedules;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, StrUtils, ExtCtrls, Provider, DB, DBClient, DBLocal,
  MainDatastore, DBLocalI, IB, IBErrorCodes, IBSQL, IBDatabase, IBCustomDataSet,
  IBQuery, DBCtrls, ComCtrls, DateUtils, Base_Toolbox, Grids, DBGrids, Math,
  Misc_Constants, Misc_Utilities, Buttons;

procedure StopSchedules( datPivot : TDate; keyClient : Integer);

type
  TStopSchedulesToolbox = class(TToolboxTemplate)
    SourceOf_Schedule: TIBQuery;
    ProviderOf_Schedule: TDataSetProvider;
    Schedule: TClientDataSet;
    DataSourceOf_Schedule: TDataSource;

    pnlPivotDate: TPanel;
    gridSchedule: TDBGrid;
    btnBrowseSchedule: TButton;
    btnExcludeSchedule: TButton;

    pbrProgress: TProgressBar;
    ScheduleStopper: TIBSQL;
    PivotStopper: TIBSQL;

    procedure gridSchedule_DrawColumnCell(Sender: TObject; const Rect: TRect; DataCol: Integer; Column: TColumn; State: TGridDrawState);

    procedure btnBrowseSchedule_Click( Sender : TObject);
    procedure btnExcludeSchedule_Click( Sender : TObject);

  private
    { Private 錾 }
    FPivotDate : TDate;
    FClientKey : Integer;
  protected
    { Protected 錾 }
    procedure BeforePopup(); override;
    procedure AfterPopup(); override;
  end;

var
  StopSchedulesToolbox: TStopSchedulesToolbox;

implementation

{$R *.dfm}

uses Set_Care, Set_Menage, Set_Migration, Set_Transfer;

{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure StopSchedules( datPivot : TDate; keyClient : Integer);
begin
	if keyClient <= 0 then exit;
	with TStopSchedulesToolbox.Create( Screen.ActiveForm) do
	begin
		FPivotDate := datPivot;
		FClientKey := keyClient;
		Popup;
		Release;
	end;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TStopSchedulesToolbox.BeforePopup();
begin
	if not DataStore.VerifyRecord( 'Profile', FClientKey) then
		ErrorMessages.Add( 'Y闘p҂̏͑̒[ŗpłB');

	Schedule.Close;
	SourceOf_Schedule.ParamByName( 'keyClient').AsInteger := FClientKey;
	SourceOf_Schedule.ParamByName( 'datSchedule').AsDate := FPivotDate;
	Schedule.Open;

	if Schedule.IsEmpty then
		ErrorMessages.Add( 'ł؂ɂł\肪܂B');

	if ErrorMessages.Count > 0 then exit;
	// update query

	pnlPivotDate.Caption := FormatDateTime( 'gg ee "N" yyyy "N" MM "" dd ""', FPivotDate);
	btnBrowseSchedule.Enabled := not Schedule.IsEmpty;
	btnExcludeSchedule.Enabled := not Schedule.IsEmpty;
	// update control
end;

procedure TStopSchedulesToolbox.AfterPopup();
var
	failed : Boolean;
label
	do_retry;
begin
	Schedule.DisableControls;
	Schedule.Filter := Format( 'blnAvailable=%d', [ BoolToInt( true)]);
	Schedule.Filtered := true;

do_retry:
	failed := false;

	pbrProgress.Max := Schedule.RecordCount;
	pbrProgress.Position := 0;

	Schedule.First;
	while not Schedule.Eof do
	begin
		if not IntToBool( Schedule.FieldByName( 'blnStopped').AsInteger) then
		begin
			try
				ScheduleStopper.ParamByName( 'keyPattern').AsInteger := Schedule.FieldByName( 'keyPattern').AsInteger;
				ScheduleStopper.ParamByName( 'datFrom').AsDate := FPivotDate;
				ScheduleStopper.ExecQuery;
				ScheduleStopper.Close;
			except
				on err : EIBInterBaseError do
				begin
					failed := true;
					break;
				end;
			end;

			if not failed then
			begin
				try
					PivotStopper.ParamByName( 'keyInstance').AsInteger := Schedule.FieldByName( 'keyInstance').AsInteger;
					PivotStopper.ExecQuery;
					PivotStopper.Close;
				except
					on err : EIBInterBaseError do
					begin
						failed := true;
						break;
					end;
				end;
			end;
		end;

		Schedule.Edit;
		Schedule.FieldByName( 'blnStopped').AsInteger := BoolToInt( not failed);
		Schedule.Post;

		Schedule.Next;

		pbrProgress.Position := pbrProgress.Position + 1;
	end;
	// stop schedule

	if failed then
	begin
		if Application.MessageBox(
			'̒[ŗpĂꕔ̏̕ύXɎs܂B' + #13#10 +
			'xύX݂ꍇɂ́uĎsv{^' + #13#10 +
			'~߂ꍇɂ́uLZv{^NbNĂ',
			'ł؂',
			MB_RETRYCANCEL
		) = IDRETRY then
			goto do_retry;

		ModalResult := mrCancel;
	end
	else
		Application.MessageBox( 'ɐ܂', 'ł؂', MB_OK);
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TStopSchedulesToolbox.gridSchedule_DrawColumnCell(Sender: TObject; const Rect: TRect; DataCol: Integer; Column: TColumn; State: TGridDrawState);
var
	selected : Boolean;
	dummy : Integer;
	strExchange : String;
begin
	gridSchedule.Canvas.Font.Size := gridSchedule.Font.Size div 2; 
	selected := gridSchedule.SelectedRows.Find( Schedule.Bookmark, dummy);
	if IntToBool( Schedule.FieldByName( 'blnAvailable').AsInteger) then
	begin
		gridSchedule.Canvas.Font.Color := IfThen( selected, clHighlightText, Column.Font.Color);
		gridSchedule.Canvas.Brush.Color := IfThen( selected, clHighlight, Column.Color);
	end
	else
	begin
		gridSchedule.Canvas.Font.Color := IfThen( selected, clHighlightText, clWindowText);
		gridSchedule.Canvas.Brush.Color := IfThen( selected, clSelectedExcluded, clDefaultExcluded);
	end;

	if Column.Field.IsNull then
        begin
		gridSchedule.Canvas.TextRect( Rect, Rect.Left + 2, Rect.Top + 2, ' ');
        	exit;
        end;

	if Column.Field.FieldName = 'INTMINUTESAT' then with Schedule do
	begin
		case FieldByName( 'typSchedule').AsInteger of
		CARE_SCHEDULE, MENAGE_SCHEDULE :
			gridSchedule.Canvas.TextRect( Rect,
				Rect.Left + 2,
				Rect.Top + ( Rect.Bottom - Rect.Top) div 4,
				RangeToText( Column.Field.AsInteger, FieldByName( 'intMinutesFor').AsInteger)
			);
		else
			gridSchedule.Canvas.TextRect( Rect,
				Rect.Left + 2,
				Rect.Top + ( Rect.Bottom - Rect.Top) div 4,
				MinutesToText( Column.Field.AsInteger)
			);
		end;
		exit;
	end;

	if Column.Field.FieldName = 'STRSERVICE' then with Schedule do
	begin
		strExchange := AmountToText(
			FieldByName( 'typExchange').AsInteger,
			FieldByName( 'curAmountPerCount').AsCurrency,
			FieldByName( 'curAmountPerHour').AsCurrency,
			FieldByName( 'intMinutesFor').AsInteger
		);
		gridSchedule.Canvas.TextRect( Rect,
			Rect.Left + 2,
			Rect.Top + 2,
			Column.Field.AsString
		);
		gridSchedule.Canvas.TextOut(
			Rect.Right - 2 - gridSchedule.Canvas.TextWidth( strExchange),
			Rect.Top + ( Rect.Bottom - Rect.Top) div 2 + 2,
			strExchange
		);
		exit;
	end;

	if Column.Field.FieldName = 'STRADDRESSFROM' then
	begin
		case Schedule.FieldByName( 'typSchedule').AsInteger of
		CARE_SCHEDULE, MENAGE_SCHEDULE :
			gridSchedule.Canvas.TextRect( Rect,
				Rect.Left + 2,
				Rect.Top + ( Rect.Bottom - Rect.Top) div 4,
				Column.Field.AsString
			);
		else
			begin
				gridSchedule.Canvas.TextRect( Rect, Rect.Left + 2, Rect.Top + 2, Column.Field.AsString);
				gridSchedule.Canvas.TextOut(
					Rect.Left + 2,
					Rect.Top + ( Rect.Bottom - Rect.Top) div 2 + 1,
					'  ' + Schedule.FieldByName( 'strAddressTo').AsString
				);
			end;
		end;
		exit;
	end;

	if ( Column.PickList.Count > 0) and ( not Column.Field.IsNull) then
	begin
		gridSchedule.Canvas.TextRect( Rect,
			Rect.Left + 2,
			Rect.Top + ( Rect.Bottom - Rect.Top) div 4,
			Column.PickList[ Column.Field.AsInteger]
		);
		exit;
	end;

	gridSchedule.Canvas.TextRect( Rect,
		Rect.Left + 2,
		Rect.Top + ( Rect.Bottom - Rect.Top) div 4,
		Column.Field.AsString
	);
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TStopSchedulesToolbox.btnBrowseSchedule_Click( Sender : TObject);
begin
	with Schedule do case FieldByName( 'typSchedule').AsInteger of
	     CARE_SCHEDULE : TCareSet.Prepare.Browse( FieldByName( 'keyInstance').AsInteger);
	   MENAGE_SCHEDULE : TMenageSet.Prepare.Browse( FieldByName( 'keyInstance').AsInteger);
	MIGRATION_SCHEDULE : TMigrationSet.Prepare.Browse( FieldByName( 'keyInstance').AsInteger);
	 TRANSFER_SCHEDULE : TTransferSet.Prepare.Browse( FieldByName( 'keyInstance').AsInteger);
	end;
end;

procedure TStopSchedulesToolbox.btnExcludeSchedule_Click( Sender : TObject);
var
	index : Integer;

	procedure DisableLemma( Target : TDataSet; keySubject : Integer);
	var
		defaultBookmark : String;
	begin
		defaultBookmark := Target.Bookmark;
		Target.First;
		with Target do while not EOF do
		begin
			if FieldByName( 'refSubject').AsInteger = keySubject then
			begin
				DisableLemma( Target, FieldByName( 'keyInstance').AsInteger);
				Edit;
				FieldByName( 'blnAvailable').AsInteger := BoolToInt( false);
				Post;
			end;
			Next;
		end;
		Target.Bookmark := defaultBookmark;
	end;

	procedure EnableSubject( Target : TDataSet; keySubject : Integer);
	var
		defaultBookmark : String;
	begin
		if keySubject <= 0 then exit;
		defaultBookmark := Target.Bookmark;
		Target.First;
		with Target do while not EOF do
		begin
			if FieldByName( 'keyInstance').AsInteger = keySubject then
			begin
				EnableSubject( Target, FieldByName( 'refSubject').AsInteger);
				Edit;
				FieldByName( 'blnAvailable').AsInteger := BoolToInt( true);
				Post;
			end;
			Next;
		end;
		Target.Bookmark := defaultBookmark;
	end;
begin
	Schedule.DisableControls;
	for index := 0 to gridSchedule.SelectedRows.Count - 1 do
        begin
		with Schedule do
		begin
			Bookmark := gridSchedule.SelectedRows.Items[ index];

			if IntToBool( FieldByName( 'blnAvailable').AsInteger) then
				DisableLemma( Schedule, FieldByName( 'keyInstance').AsInteger)
			else
				EnableSubject( Schedule, FieldByName( 'refSubject').AsInteger);

			Edit;
			FieldByName( 'blnAvailable').AsInteger := BoolToInt( not IntToBool( FieldByName( 'blnAvailable').AsInteger));
			Post;
		end;
	end;
	Schedule.EnableControls;
end;

end.
