unit Workspace_Addresses;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, DB, IBCustomDataSet, IBQuery, IBEvents, StdCtrls, Grids,
  DBGrids, ExtCtrls, IB, IBErrorCodes, IBDatabase, DBCtrls,
  Provider, DBClient, Math, ActnList, DateUtils, MainDatastore, ComCtrls,
  Misc_Constants, Misc_Utilities, Base_Workspace;

type
  TAddressesWorkspace = class(TWorkspaceTemplate)

    SourceOf_Address: TIBQuery;
    ProviderOf_Address: TDataSetProvider;
    Address: TClientDataSet;
    DataSourceOf_Address: TDataSource;

    cboCategory: TComboBox;
    btnLookup: TButton;
    gridView: TDBGrid;
    radShowAvailable: TRadioButton;
    radShowDisabled: TRadioButton;
    lblCounter: TLabel;
    bvlBorder: TBevel;

    btnSelect: TButton;
    btnAppend: TButton;
    btnDelete: TButton;
    btnRestore: TButton;

    ShortCuts: TActionList;
    Shortcut_LookupAddress: TAction;
    radShowUnavailable: TRadioButton;

    procedure Selector_Change(Sender: TObject);
    procedure btnLookup_Click(Sender: TObject);

    procedure gridView_TitleClick(Column: TColumn);

    procedure btnSelect_Click(Sender: TObject);
    procedure btnAppend_Click(Sender: TObject);
    procedure btnDelete_Click(Sender: TObject);
    procedure btnRestore_Click(Sender: TObject);

    procedure Report_MenuSetup( MenuRegistrar : TMenuRegistrar); override;
    procedure Report_Addresses(Sender: TObject);

  private
    { Private 錾 }
  protected
    { Protected 錾 }
    procedure BeforePopup(); override;
    procedure AfterPopup(); override;
    procedure AfterNotify(); override;
  public
    { Public 錾 }
  end;

var
  AddressesWorkspace: TAddressesWorkspace;

implementation

{$R *.dfm}

uses Set_Address, Chooser_Address, Report_Addresses;

{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TAddressesWorkspace.BeforePopup();
begin
	Address.Open;

	SortByDefault( gridView);
	Selector_Change( self);
end;

procedure TAddressesWorkspace.AfterPopup();
begin
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TAddressesWorkspace.Selector_Change(Sender: TObject);
begin
	if cboCategory.Itemindex = ALL_ADDRESS then
		Address.Filter := CatalogueFilter( radShowAvailable, radShowUnavailable, radShowDisabled)
	else
		Address.Filter := CatalogueFilter( radShowAvailable, radShowUnavailable, radShowDisabled) + ' and strUserAddress=''''';

	lblCounter.Caption := 'vF' + IntToStr( Address.RecordCount) + ' ';

	btnSelect.Enabled := ( not Address.IsEmpty);
	btnDelete.Enabled := ( not Address.IsEmpty) and ( not radShowDisabled.Checked);
	btnRestore.Enabled := ( not Address.IsEmpty) and radShowDisabled.Checked;
end;

procedure TAddressesWorkspace.btnLookup_Click(Sender: TObject);
var
	keyAddress : Integer;
begin
	if ChooseAddress( DataStore.MainTransaction, keyAddress) then
	begin
		Address.Locate( 'keyInstance', keyAddress, []);
	end;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TAddressesWorkspace.gridView_TitleClick(Column: TColumn);
var
	ACol : Integer;
begin
	if Column.Title.Color = clMenu then exit;

	if Column.FieldName = 'STRNAME' then Address.IndexFieldNames := 'strNameRead;keyInstance';
	if Column.FieldName = 'STRADDRESS' then Address.IndexFieldNames := 'strAddressRead;strAddress;keyInstance';
	if Column.FieldName = 'STRPHONENUMBER1' then Address.IndexFieldNames := 'strPhoneNumber1;strNameRead;keyInstance';

	with gridView.Columns do for ACol := 0 to Count - 1 do Items[ ACol].Color := clWindow;

	Column.Color := clSorted;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TAddressesWorkspace.btnSelect_Click(Sender: TObject);
begin
	if not radShowDisabled.Checked then
		TAddressSet.Prepare.Select( ReadInstanceKey( Address))
	else
		TAddressSet.Prepare.Browse( ReadInstanceKey( Address));
end;

procedure TAddressesWorkspace.btnAppend_Click(Sender: TObject);
begin
	TAddressSet.Prepare.Append;
end;

procedure TAddressesWorkspace.btnDelete_Click(Sender: TObject);
begin
	TAddressSet.Prepare.Delete( ReadInstanceKey( Address));
end;

procedure TAddressesWorkspace.btnRestore_Click(Sender: TObject);
begin
	TAddressSet.Prepare.Restore( ReadInstanceKey( Address));
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TAddressesWorkspace.Report_MenuSetup( MenuRegistrar : TMenuRegistrar);
begin
	MenuRegistrar( 'ꏊꗗ̈(&P)', Report_Addresses, ( not Address.IsEmpty));
end;

procedure TAddressesWorkspace.Report_Addresses(Sender: TObject);
begin
	TAddressesReport.Prepare(
		CatalogueType( radShowAvailable, radShowUnavailable, radShowDisabled),
		cboCategory.Itemindex,
		Address.IndexFieldNames
	).Preview;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TAddressesWorkspace.AfterNotify();
var
	Position : TDataSetPosition;
begin
	DisableGridSet( gridView, Position);
	Address.Refresh;
	Selector_Change( self);
	EnableGridSet( gridView, Position);
end;

end.
