unit Workspace_Billing;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, DB, IBCustomDataSet, IBQuery, IBEvents, StdCtrls, Grids,
  DBGrids, ExtCtrls, IB, IBErrorCodes, IBDatabase, DateUtils, Buttons,
  DBClient, Provider, Math, ComCtrls, ActnList, DBCtrls,
  MainDatastore, Misc_Constants, Misc_Utilities, Base_Workspace;

type
  TBillingWorkspace = class(TWorkspaceTemplate)
    Center: TIBQuery;

    SourceOf_Payer: TIBQuery;
    ProviderOf_Payer: TDataSetProvider;
    Payer: TClientDataSet;
    DataSourceOf_Payer: TDataSource;

    btnNextMonth: TSpeedButton;
    pnlMonth: TPanel;
    btnPrevMonth: TSpeedButton;
    btnSelectMonth: TButton;
    btnLookupProfile: TButton;

    gridView: TDBGrid;

    lblCounter: TLabel;
    radShowEnabled: TRadioButton;
    radShowDisabled: TRadioButton;

    bvlBorder: TBevel;

    btnSelect: TButton;
    btnBilling: TButton;
    btnDelete: TButton;

    btnAutoBilling: TButton;

    Shortcuts: TActionList;
    Shortcut_SelectMonth: TAction;
    Shortcut_Lookup: TAction;

    procedure Selector_Change(Sender: TObject);

    procedure btnPrevMonth_Click(Sender: TObject);
    procedure btnNextMonth_Click(Sender: TObject);
    procedure btnSelectMonth_Click(Sender: TObject);

    procedure btnLookupProfile_Click(Sender: TObject);

    procedure gridView_TitleClick(Column: TColumn);

    procedure btnSelect_Click(Sender: TObject);
    procedure btnBilling_Click(Sender: TObject);
    procedure btnDelete_Click(Sender: TObject);

    procedure btnAutoBilling_Click(Sender: TObject);

    procedure Report_MenuSetup( MenuRegistrar : TMenuRegistrar); override;
    procedure Report_Billings(Sender: TObject);
    procedure Report_Pressrun(Sender: TObject);
    procedure Report_NameLabels(Sender: TObject);

  private
    { Private 錾 }
    FTargetMonth : TDate;
    FClosingDay : Integer;

    function MonthFirstday() : TDate;
    function MonthLastday() : TDate;

    function BillingKey() : Integer;
    function ProfileKey() : Integer;
  protected
    { Protected 錾 }
    procedure BeforePopup(); override;
    procedure AfterPopup(); override;
    procedure AfterNotify(); override;
  public
    { Public 錾 }
  end;

var
  BillingWorkspace: TBillingWorkspace;

implementation

{$R *.dfm}

uses Chooser_Date, Chooser_Client, Set_Client,
     Set_Billing,
     Toolbox_GenerateBillings,
     Report_Billings,
     Publisher_Billings,
     Publisher_BillingLabels;

{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

function TBillingWorkspace.MonthFirstday() : TDate;
begin
	result := IncDay( IncMonth( MonthLastday, -1));
end;

function TBillingWorkspace.MonthLastday() : TDate;
begin
	result := RecodeDay( FTargetMonth, Min( FClosingDay, DaysInMonth( FTargetMonth)));
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

function TBillingWorkspace.BillingKey() : Integer;
begin
	if Payer.IsEmpty then
		result := -1
	else
		result := Payer.FieldByName( 'keyBilling').AsInteger;
end;

function TBillingWorkspace.ProfileKey() : Integer;
begin
	if Payer.IsEmpty then
		result := -1
	else
		result := Payer.FieldByName( 'keyInstance').AsInteger;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TBillingWorkspace.BeforePopup();
begin
	Center.Open;
	FTargetMonth := Today;
	FClosingDay := Center.FieldByName( 'intBillingClosingDay').AsInteger;
	Center.Close;

	SortByDefault( gridView);
	Selector_Change( self);
end;

procedure TBillingWorkspace.AfterPopup();
begin
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TBillingWorkspace.Selector_Change(Sender: TObject);
var
	Position : TDataSetPosition;
begin
	DisableGridSet( gridView, Position);
	Payer.Close;
	SourceOf_Payer.ParamByName( 'datFrom').AsDate := MonthFirstday;
	SourceOf_Payer.ParamByName( 'datTo').AsDate := MonthLastday;
	SourceOf_Payer.ParamByName( 'typStatus').AsInteger := BoolToInt( radShowDisabled.Checked);
	Payer.Open;
	EnableGridSet( gridView, Position);
	// update query

	pnlMonth.Caption := Format( '%s ` %s', [
		FormatDateTime( 'gg ee "N" yyyy "N" MM "" dd ""', MonthFirstday),
		FormatDateTime( 'MM "" dd ""', MonthLastday)
	]);
	lblCounter.Caption := 'vF' + IntToStr( Payer.RecordCount) + ' ';

	btnSelect.Enabled := not Payer.IsEmpty;
	btnDelete.Enabled := btnSelect.Enabled;
	// update control
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TBillingWorkspace.btnPrevMonth_Click(Sender: TObject);
begin
	FTargetMonth := IncMonth( FTargetMonth, -1);
	Selector_Change( btnPrevMonth);
end;

procedure TBillingWorkspace.btnNextMonth_Click(Sender: TObject);
begin
	FTargetMonth := IncMonth( FTargetMonth);
	Selector_Change( btnNextMonth);
end;

procedure TBillingWorkspace.btnSelectMonth_Click(Sender: TObject);
begin
	if ChooseMonth( FTargetMonth, FTargetMonth) then
	begin
		Selector_Change( btnSelectMonth);
	end;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TBillingWorkspace.btnLookupProfile_Click(Sender: TObject);
var
	keyClient : Integer;
begin
	if ChooseClient( DataStore.MainTransaction, MonthLastday, keyClient) then
	begin
		Payer.Locate( 'keyInstance', keyClient, []);
	end;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TBillingWorkspace.gridView_TitleClick(Column: TColumn);
var
	ACol : Integer;
begin
	if Column.Title.Color = clMenu then exit;

	if Column.FieldName = 'STRCODE' then Payer.IndexFieldNames := 'strCode;datPublished';
	if Column.FieldName = 'STRNAMEREAD' then Payer.IndexFieldNames := 'strNameRead;strCode;datPublished';
	if Column.FieldName = 'INTCARECASH' then Payer.IndexFieldNames := 'intCareCash;strNameRead;strCode;datPublished';
	if Column.FieldName = 'INTMENAGECASH' then Payer.IndexFieldNames := 'intMenageCash;strNameRead;strCode;datPublished';
	if Column.FieldName = 'INTMIGRATIONCASH' then Payer.IndexFieldNames := 'intMigrationCash;strNameRead;strCode;datPublished';
	if Column.FieldName = 'INTTRANSFERCASH' then Payer.IndexFieldNames := 'intTransferCash;strNameRead;strCode;datPublished';
	if Column.FieldName = 'INTMARGIN' then Payer.IndexFieldNames := 'intMargin;strNameRead;strCode;datPublished';
	if Column.FieldName = 'INTBILLING' then Payer.IndexFieldNames := 'intBilling;strNameRead;strCode;datPublished';
	if Column.FieldName = 'DATPUBLISHED' then Payer.IndexFieldNames := 'datPublished;strNameRead;strCode';

	with gridView.Columns do for ACol := 0 to Count - 1 do Items[ ACol].Color := clWindow;

	Column.Color := clSorted;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TBillingWorkspace.btnSelect_Click(Sender: TObject);
begin
	TBillingSet.Prepare.Browse( BillingKey);
end;

procedure TBillingWorkspace.btnBilling_Click(Sender: TObject);
begin
	TBillingSet.Prepare( IncMonth( MonthFirstday, -1), IncDay( MonthFirstday, -1), Today, ProfileKey).Append;
	Payer.Next;
end;

procedure TBillingWorkspace.btnDelete_Click(Sender: TObject);
begin
	TBillingSet.Prepare.Delete( BillingKey);
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TBillingWorkspace.btnAutoBilling_Click(Sender: TObject);
begin
	GenerateBillings( IncMonth( MonthFirstday, -1), IncDay( MonthFirstday, -1));
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TBillingWorkspace.Report_MenuSetup( MenuRegistrar : TMenuRegistrar);
begin
	MenuRegistrar( '׈ꗗ̈(&O)', Report_Billings, ( not Payer.IsEmpty));
	MenuRegistrar( 'ׂ̈ꊇ(&P)', Report_Pressrun, ( not Payer.IsEmpty));
	MenuRegistrar( 'V[̈(&N)', Report_NameLabels, ( not Payer.IsEmpty));
end;

procedure TBillingWorkspace.Report_Billings(Sender: TObject);
begin
	TBillingsReport.Prepare( MonthFirstday, MonthLastday, Payer.IndexFieldNames).Preview;
end;

procedure TBillingWorkspace.Report_Pressrun(Sender: TObject);
begin
	TBillingsPublisher.Prepare( MonthFirstday, MonthLastday).Popup;
end;

procedure TBillingWorkspace.Report_NameLabels(Sender: TObject);
begin
	TBillingLabelsPublisher.Prepare( MonthFirstday, MonthLastday).Popup;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TBillingWorkspace.AfterNotify();
begin
	if Happened( 'Center_Update') then
	begin
		Center.Open;
		FClosingDay := Center.FieldByName( 'intBillingClosingDay').AsInteger;
		Center.Close;
	end;

	Selector_Change( self);
end;

end.
