unit Workspace_ClientSchedule;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, DB, IBCustomDataSet, IBQuery, IBEvents, StdCtrls, Grids,
  DBGrids, ExtCtrls, IB, IBErrorCodes, IBDatabase, DateUtils, StrUtils,
  ImgList, ComCtrls, DBClient, Provider, DBCtrls, Buttons, Math, Menus,
  Base_Workspace, ActnList, Frame_ClientPrivateTable, Frame_ClientPrivateGraph,
  Frame_ClientOfficialTable, MainDatastore, Frame_ClientOfficialGraph, Frame_Clients,
  Piece_SchedulePalette, Misc_Constants, Misc_Utilities, Base_Frame,
  Frame_Reserves;

type
  TClientScheduleWorkspace = class(TWorkspaceTemplate)

    btnPrevMonth: TSpeedButton;
    btnYesterday: TSpeedButton;
    pnlScheduleAt: TPanel;
    btnTomorrow: TSpeedButton;
    btnNextMonth: TSpeedButton;
    btnSelectSchedule: TButton;

    pagesSchedule: TPageControl;
    pageOfficialGraph: TTabSheet;
    OfficialGraph: TClientOfficialGraphFrame;

    pageOfficialTable: TTabSheet;
    OfficialTable: TClientOfficialTableFrame;

    pageReserves: TTabSheet;
    Reserves: TReservesFrame;

    pageClients: TTabSheet;
    Clients: TClientsFrame;

    pagePrivateGraph: TTabSheet;
    PrivateGraph: TClientPrivateGraphFrame;

    pagePrivateTable: TTabSheet;
    PrivateTable: TClientPrivateTableFrame;

    bvlBorder: TBevel;

    SchedulePalette: TSchedulePalette;
    btnDuplicate: TButton;
    btnModify: TButton;
    btnRemove: TButton;
    btnStop: TButton;

    ShortCuts: TActionList;
    Shortcut_SelectSchedule: TAction;

    timRedraw: TTimer;

    procedure Schedule_Change(Sender: TObject);
    procedure btnPrevMonth_Click(Sender: TObject);
    procedure btnYesterday_Click(Sender: TObject);
    procedure btnTomorrow_Click(Sender: TObject);
    procedure btnNextMonth_Click(Sender: TObject);
    procedure btnSelectSchedule_Click(Sender: TObject);

    procedure pageOfficialGraph_Show(Sender: TObject);
    procedure pageOfficialGraph_Hide(Sender: TObject);
    procedure pageOfficialTable_Show(Sender: TObject);
    procedure pageOfficialTable_Hide(Sender: TObject);
    procedure pageReserves_Show(Sender: TObject);
    procedure pageReserves_Hide(Sender: TObject);
    procedure pageClients_Show(Sender: TObject);
    procedure pageClients_Hide(Sender: TObject);
    procedure pagePrivateGraph_Show(Sender: TObject);
    procedure pagePrivateGraph_Hide(Sender: TObject);
    procedure pagePrivateTable_Show(Sender: TObject);
    procedure pagePrivateTable_Hide(Sender: TObject);

    procedure btnDuplicate_Click(Sender: TObject);
    procedure btnModify_Click(Sender: TObject);
    procedure btnRemove_Click(Sender: TObject);
    procedure btnStop_Click(Sender: TObject);

    procedure Report_MenuSetup( MenuRegistrar : TMenuRegistrar); override;
    procedure Report_OfficialSchedule(Sender: TObject);
    procedure Report_Clients(Sender: TObject);
    procedure Report_PickupSchedule(Sender: TObject);
    procedure Report_DailySchedule(Sender: TObject);
    procedure Report_WeeklySchedule(Sender: TObject);
    procedure Report_MonthlySchedule(Sender: TObject);
    procedure Report_DailySurvey(Sender: TObject);
    procedure Report_WeeklySurvey(Sender: TObject);
    procedure Report_MonthlySurvey(Sender: TObject);

    procedure timRedraw_Timer(Sender: TObject);

  private
    { Private 錾 }
    FScheduleAt : TDate;
    FActivePage : TTabSheet;
    FActiveProfile : Integer;
  protected
    { Protected 錾 }
    procedure BeforePopup(); override;
    procedure AfterPopup(); override;

    procedure AfterNotify(); override;
  public
    { Public 錾 }
  end;

var
  ClientScheduleWorkspace: TClientScheduleWorkspace;

implementation

{$R *.dfm}

uses Chooser_Date, Chooser_Client,
     Toolbox_DuplicateSchedules,
     Toolbox_ModifySchedules,
     Toolbox_RemoveSchedules,
     Toolbox_StopSchedules,
     Report_OfficialSchedule,
     Report_Clients,
     Report_PickupSchedule,
     Report_DailyClientSchedule,
     Report_WeeklyClientSchedule,
     Report_MonthlyClientSchedule,
     Report_DailySurvey,
     Report_WeeklySurvey,
     Report_MonthlySurvey;

{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TClientScheduleWorkspace.BeforePopup();
begin
	FScheduleAt := Today;
	FActivePage := pagesSchedule.ActivePage;

	if FileExists( ExtractFilePath( Application.ExeName) + 'ClientOfficialTable.cols') then
		OfficialTable.LoadStyleFromFile( ExtractFilePath( Application.ExeName) + 'ClientOfficialTable.cols');

	if FileExists( ExtractFilePath( Application.ExeName) + 'ClientPrivateTable.cols') then
		PrivateTable.LoadStyleFromFile( ExtractFilePath( Application.ExeName) + 'ClientPrivateTable.cols');

	if FileExists( ExtractFilePath( Application.ExeName) + 'Clients.cols') then
		Clients.LoadStyleFromFile( ExtractFilePath( Application.ExeName) + 'Clients.cols');

	if FileExists( ExtractFilePath( Application.ExeName) + 'Reserves.cols') then
		Reserves.LoadStyleFromFile( ExtractFilePath( Application.ExeName) + 'Reserves.cols');

	Schedule_Change( self);
end;

procedure TClientScheduleWorkspace.AfterPopup();
begin
	OfficialTable.SaveStyleToFile( ExtractFilePath( Application.ExeName) + 'ClientOfficialTable.cols');
	PrivateTable.SaveStyleToFile( ExtractFilePath( Application.ExeName) + 'ClientPrivateTable.cols');
	Clients.SaveStyleToFile( ExtractFilePath( Application.ExeName) + 'Clients.cols');
	Reserves.SaveStyleToFile( ExtractFilePath( Application.ExeName) + 'Reserves.cols');
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TClientScheduleWorkspace.Schedule_Change(Sender: TObject);
begin
	pnlScheduleAt.Caption := FormatDateTime( 'gg ee "N" yyyy" N "MM"  "dd" " (ddd)', FScheduleAt);

	OfficialGraph.Obsolete := true;
	OfficialTable.Obsolete := true;
	Reserves.Obsolete := true;
	Clients.Obsolete := true;
	PrivateGraph.Obsolete := true;
	PrivateTable.Obsolete := true;

	pagesSchedule.ActivePage.OnHide( pagesSchedule.ActivePage);
	pagesSchedule.ActivePage.OnShow( pagesSchedule.ActivePage);
end;

procedure TClientScheduleWorkspace.btnPrevMonth_Click(Sender: TObject);
begin
	FScheduleAt := IncMonth( FScheduleAt, -1);
	Schedule_Change( btnPrevMonth);
end;

procedure TClientScheduleWorkspace.btnYesterday_Click(Sender: TObject);
begin
	FScheduleAt := IncDay( FScheduleAt, -1);
	Schedule_Change( btnYesterday);
end;

procedure TClientScheduleWorkspace.btnTomorrow_Click(Sender: TObject);
begin
	FScheduleAt := IncDay( FScheduleAt);
	Schedule_Change( btnTomorrow);
end;

procedure TClientScheduleWorkspace.btnNextMonth_Click(Sender: TObject);
begin
	FScheduleAt := IncMonth( FScheduleAt);
	Schedule_Change( btnNextMonth);
end;

procedure TClientScheduleWorkspace.btnSelectSchedule_Click(Sender: TObject);
begin
	if ChooseDate( FScheduleAt) then Schedule_Change( btnSelectSchedule);
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TClientScheduleWorkspace.pageOfficialGraph_Show(Sender: TObject);
begin
	FActivePage.OnHide( FActivePage);
	with OfficialGraph do if Obsolete then Reset( FScheduleAt);
	btnDuplicate.Enabled := false;
	btnModify.Enabled := false;
	btnRemove.Enabled := false;
	btnStop.Enabled := false;
	FActivePage := pageOfficialGraph;
	OfficialGraph.Shortcuts.State := asNormal;
end;

procedure TClientScheduleWorkspace.pageOfficialGraph_Hide(Sender: TObject);
begin
	FActiveProfile := OfficialGraph.ClientKey;
	OfficialGraph.Shortcuts.State := asSuspended;
end;

procedure TClientScheduleWorkspace.pageOfficialTable_Show(Sender: TObject);
begin
	FActivePage.OnHide( FActivePage);
	with OfficialTable do if Obsolete then Reset( FScheduleAt);
	btnDuplicate.Enabled := false;
	btnModify.Enabled := false;
	btnRemove.Enabled := false;
	btnStop.Enabled := false;
	FActivePage := pageOfficialTable;
	OfficialTable.Shortcuts.State := asNormal;
end;

procedure TClientScheduleWorkspace.pageOfficialTable_Hide(Sender: TObject);
begin
	FActiveProfile := OfficialTable.ClientKey;
	OfficialTable.Shortcuts.State := asSuspended;
end;

procedure TClientScheduleWorkspace.pageReserves_Show(Sender: TObject);
begin
	FActivePage.OnHide( FActivePage);
	with Reserves do if Obsolete then Reset( FScheduleAt);
	btnDuplicate.Enabled := false;
	btnModify.Enabled := false;
	btnRemove.Enabled := false;
	btnStop.Enabled := ( Reserves.ReserveKey > 0);
	FActivePage := pageReserves;
	Reserves.Shortcuts.State := asNormal;
end;

procedure TClientScheduleWorkspace.pageReserves_Hide(Sender: TObject);
begin
	FActiveProfile := Reserves.ClientKey;
	Reserves.Shortcuts.State := asSuspended;
end;

procedure TClientScheduleWorkspace.pageClients_Show(Sender: TObject);
begin
	FActivePage.OnHide( FActivePage);
	with Clients do if Obsolete then Reset( FScheduleAt);
	btnDuplicate.Enabled := false;
	btnModify.Enabled := false;
	btnRemove.Enabled := false;
	btnStop.Enabled := false;
	Clients.Lookup( FActiveProfile);
        FActivePage := pageClients;
	Clients.Shortcuts.State := asNormal;
end;

procedure TClientScheduleWorkspace.pageClients_Hide(Sender: TObject);
begin
	FActiveProfile := Clients.ClientKey;
	Clients.Shortcuts.State := asSuspended;
end;

procedure TClientScheduleWorkspace.pagePrivateGraph_Show(Sender: TObject);
begin
	FActivePage.OnHide( FActivePage);
	with PrivateGraph do if Obsolete or ( ClientKey <> FActiveProfile) then
		Reset( FActiveProfile, StartOfTheMonth( FScheduleAt), EndOfTheMonth( FScheduleAt));
	btnDuplicate.Enabled := true;
	btnModify.Enabled := true;
	btnRemove.Enabled := true;
	btnStop.Enabled := true;
	FActivePage := pagePrivateGraph;
	PrivateGraph.Shortcuts.State := asNormal;
end;

procedure TClientScheduleWorkspace.pagePrivateGraph_Hide(Sender: TObject);
begin
	FActiveProfile := PrivateGraph.ClientKey;
	PrivateGraph.Shortcuts.State := asSuspended;
end;

procedure TClientScheduleWorkspace.pagePrivateTable_Show(Sender: TObject);
begin
	FActivePage.OnHide( FActivePage);
	with PrivateTable do if Obsolete or ( ClientKey <> FActiveProfile) then
		Reset( FActiveProfile, StartOfTheMonth( FScheduleAt), EndOfTheMonth( FScheduleAt));
	btnDuplicate.Enabled := true;
	btnModify.Enabled := true;
	btnRemove.Enabled := true;
	btnStop.Enabled := true;
	FActivePage := pagePrivateTable;
	PrivateTable.Shortcuts.State := asNormal;
end;

procedure TClientScheduleWorkspace.pagePrivateTable_Hide(Sender: TObject);
begin
	FActiveProfile := PrivateTable.ClientKey;
	PrivateTable.Shortcuts.State := asSuspended;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TClientScheduleWorkspace.btnDuplicate_Click(Sender: TObject);
begin
	with PrivateGraph do if Active then DuplicateSchedules( ScheduleAt, ClientKey);
	with PrivateTable do if Active then DuplicateSchedules( ScheduleAt, ClientKey);
end;

procedure TClientScheduleWorkspace.btnModify_Click(Sender: TObject);
begin
	with PrivateGraph do if Active then ModifySchedules( FScheduleAt, ClientKey);
	with PrivateTable do if Active then ModifySchedules( FScheduleAt, ClientKey);
end;

procedure TClientScheduleWorkspace.btnRemove_Click(Sender: TObject);
begin
	with PrivateGraph do if Active then RemoveSchedules( FScheduleAt, ClientKey);
	with PrivateTable do if Active then RemoveSchedules( FScheduleAt, ClientKey);
end;

procedure TClientScheduleWorkspace.btnStop_Click(Sender: TObject);
begin
	with Reserves do if Active then
	try
		DataStore.UpdateSQL( 'Schedule', Format( 'keyInstance=%d', [ Reserves.ReserveKey]), [
			'typSequence'
		], [
			SEQUENCE_BODY
		]);
		DataStore.Commit;
	except
		DataStore.Rollback;
		Application.MessageBox(
			'̒[ŗpĂꕔ̏̕ύXɎs܂B' + #13#10 +
				'ԂčēxB',
			'ł؂',
			MB_OK
		);
	end;

	with PrivateGraph do if Active then StopSchedules( ScheduleAt, ClientKey);
	with PrivateTable do if Active then StopSchedules( ScheduleAt, ClientKey);
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TClientScheduleWorkspace.Report_MenuSetup( MenuRegistrar : TMenuRegistrar);
begin
	MenuRegistrar( 'S̃XPW[\̈(&O)', Report_OfficialSchedule, ( OfficialGraph.Active or OfficialTable.Active));
	MenuRegistrar( 'Äڑꗗ̈(&R)', Report_PickupSchedule, true);
	MenuRegistrar( 'p҈ꗗ̈(&C)', Report_Clients, ( Clients.Active));
	MenuRegistrar( '-', nil, true);
	MenuRegistrar( 'ԃXPW[\̈(&D)', Report_DailySchedule, true);
	MenuRegistrar( 'TԃXPW[\̈(&W)', Report_WeeklySchedule, true);
	MenuRegistrar( 'ԃXPW[\̈(&M)', Report_MonthlySchedule, true);
	MenuRegistrar( '-', nil, true);
	MenuRegistrar( 'ѓ̈(&Q)', Report_DailySurvey, true);
	MenuRegistrar( 'яT̈(&R)', Report_WeeklySurvey, true);
	MenuRegistrar( 'ь̈(&S)', Report_MonthlySurvey, true);
end;

procedure TClientScheduleWorkspace.Report_OfficialSchedule(Sender: TObject);
begin
	with OfficialGraph do if Active then
		TOfficialScheduleReport.Prepare( FScheduleAt, -1, -1, 'ׂ').Preview;

	with OfficialTable do if Active then
		TOfficialScheduleReport.Prepare( ScheduleAt, ServiceMask, ProgressMask, ConditionName).Preview;
end;

procedure TClientScheduleWorkspace.Report_PickupSchedule(Sender: TObject);
begin
	TPickupScheduleReport.Prepare( FScheduleAt).Preview;
end;

procedure TClientScheduleWorkspace.Report_Clients(Sender: TObject);
begin
	case Clients.Category of
	DAILY_CLIENTS : TClientsReport.Daily( FScheduleAt).Preview;
	MONTHLY_CLIENTS : TClientsReport.Monthly( FScheduleAt).Preview;
	end;
end;

procedure TClientScheduleWorkspace.Report_DailySchedule(Sender: TObject);
begin
	with OfficialGraph do if Active then
		TDailyClientScheduleReport.Prepare( ClientKey, ScheduleAt).Preview;

	with OfficialTable do if Active then
		TDailyClientScheduleReport.Prepare( ClientKey, ScheduleAt).Preview;

	with PrivateGraph do if Active then
		TDailyClientScheduleReport.Prepare( ClientKey, ScheduleAt).Preview;

	with PrivateTable do if Active then
		TDailyClientScheduleReport.Prepare( ClientKey, ScheduleAt).Preview;
end;

procedure TClientScheduleWorkspace.Report_WeeklySchedule(Sender: TObject);
begin
	with OfficialGraph do if Active then
		TWeeklyClientScheduleReport.Prepare( ClientKey, ScheduleAt).Preview;

	with OfficialTable do if Active then
		TWeeklyClientScheduleReport.Prepare( ClientKey, ScheduleAt).Preview;

	with PrivateGraph do if Active then
		TWeeklyClientScheduleReport.Prepare( ClientKey, ScheduleAt).Preview;

	with PrivateTable do if Active then
		TWeeklyClientScheduleReport.Prepare( ClientKey, ScheduleAt).Preview;
end;

procedure TClientScheduleWorkspace.Report_MonthlySchedule(Sender: TObject);
begin
	with OfficialGraph do if Active then
		TMonthlyClientScheduleReport.Prepare( ClientKey, ScheduleAt).Preview;

	with OfficialTable do if Active then
		TMonthlyClientScheduleReport.Prepare( ClientKey, ScheduleAt).Preview;

	with PrivateGraph do if Active then
		TMonthlyClientScheduleReport.Prepare( ClientKey, ScheduleAt).Preview;

	with PrivateTable do if Active then
		TMonthlyClientScheduleReport.Prepare( ClientKey, ScheduleAt).Preview;
end;

procedure TClientScheduleWorkspace.Report_DailySurvey(Sender: TObject);
begin
	TDailySurveyReport.Prepare( FScheduleAt).Preview;
end;

procedure TClientScheduleWorkspace.Report_WeeklySurvey(Sender: TObject);
begin
	TWeeklySurveyReport.Prepare( FScheduleAt).Preview;
end;

procedure TClientScheduleWorkspace.Report_MonthlySurvey(Sender: TObject);
begin
	TMonthlySurveyReport.Prepare( FScheduleAt).Preview;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TClientScheduleWorkspace.timRedraw_Timer(Sender: TObject);
begin
	with OfficialGraph do if Active then Invalidate;
	with PrivateGraph do if Active then Invalidate;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TClientScheduleWorkspace.AfterNotify();
begin
	Schedule_Change( self);
end;

end.
