unit Workspace_Profiles;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, DB, IBCustomDataSet, IBQuery, IBEvents, StdCtrls, Grids,
  DBGrids, ExtCtrls, IB, IBErrorCodes, IBDatabase, DBCtrls, Base_Workspace,
  Provider, DBClient, Math, ActnList, DateUtils, MainDatastore, ComCtrls,
  Misc_Constants, Misc_Utilities, Set_Profile, Publisher_NameLabels;

type
  TProfilesWorkspace = class(TWorkspaceTemplate)

    Branch: TIBQuery;
    DataSourceOf_Branch: TDataSource;

    Region: TIBQuery;
    DataSourceOf_Region: TDataSource;

    SourceOf_Profile: TIBQuery;
    ProviderOf_Profile: TDataSetProvider;
    Profile: TClientDataSet;
    DataSourceOf_Profile: TDataSource;

    cboRegion: TDBLookupComboBox;
    cboBranch: TDBLookupComboBox;
    btnLookup: TButton;

    gridView: TDBGrid;

    radShowAvailable: TRadioButton;
    radShowDisabled: TRadioButton;
    radShowUnavailable: TRadioButton;
    lblCounter: TLabel;
    bvlBorder: TBevel;

    btnSelect: TButton;
    btnAppend: TButton;
    btnDelete: TButton;
    btnRestore: TButton;

    ShortCuts: TActionList;
    Shortcut_LookupProfile: TAction;

    procedure Selector_Change(Sender: TObject);
    procedure btnLookup_Click(Sender: TObject);
    procedure gridView_DrawColumnCell(Sender: TObject; const Rect: TRect; DataCol: Integer; Column: TColumn; State: TGridDrawState);
    procedure gridView_TitleClick(Column: TColumn);

    procedure btnSelect_Click(Sender: TObject);
    procedure btnAppend_Click(Sender: TObject);
    procedure btnDelete_Click(Sender: TObject);
    procedure btnRestore_Click(Sender: TObject);

    procedure Report_MenuSetup( MenuRegistrar : TMenuRegistrar); override;
    procedure Report_Profiles(Sender: TObject);
    procedure Report_NameLabels(Sender: TObject);
    procedure Report_CandidatesName(Sender: TObject);
    procedure Report_CandidatesCount(Sender: TObject);
  private
    { Private 錾 }
  protected
    { Protected 錾 }
    procedure BeforePopup(); override;
    procedure AfterPopup(); override;
    procedure AfterNotify(); override;

    class function CategoryType() : Integer; virtual; abstract;
    class function CategoryClass() : CProfileSet; virtual; abstract;
    class function NameLabelsPublisher() : CNameLabelsPublisher; virtual; abstract;
    class function ChooseProfile( _tran : TIBTransaction; var keyInstance : Integer) : Boolean; virtual; abstract;
  public
    { Public 錾 }
  end;

var
  ProfilesWorkspace: TProfilesWorkspace;

implementation

{$R *.dfm}

uses Report_Profiles, Publisher_CandidatesName, Publisher_CandidatesCount;

{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TProfilesWorkspace.BeforePopup();
begin
	Region.ParamByName( 'datAt').AsDate := Today;
	Region.Open;
	Region.FetchAll;
	SelectComboWithoutFail( cboRegion, -1);

	Branch.ParamByName( 'datAt').AsDate := Today;
	Branch.Open;
	Branch.FetchAll;
	SelectComboWithoutFail( cboBranch, -1);

	SourceOf_Profile.ParamByName( 'typCategory').AsInteger := CategoryType;
	Profile.Open;

	SortByDefault( gridView);
	Selector_Change( self);
end;

procedure TProfilesWorkspace.AfterPopup();
begin
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TProfilesWorkspace.Selector_Change(Sender: TObject);

	function CategoryFilter : String;
	begin
		if Branch.FieldByName( 'keyInstance').AsInteger <> -1 then
		begin
			result := Format( ' and refBranch=%d', [ Branch.FieldByName( 'keyInstance').AsInteger]);
		end;

		if Region.FieldByName( 'keyInstance').AsInteger <> -1 then
		begin
			result := result + Format( ' and refRegion=%d', [ Region.FieldByName( 'keyInstance').AsInteger]);
		end;
	end;
begin
	case CatalogueType( radShowAvailable, radShowUnavailable, radShowDisabled) of
	AVAILABLE_ITEM :
		Profile.Filter := CatalogueFilter( AVAILABLE_ITEM) + ' and optAvailability <> 0' + CategoryFilter;

	UNAVAILABLE_ITEM :
		Profile.Filter := Format(
			'( (%s) or ( typStatus=%d and optAvailability = 0))',
			[ CatalogueFilter( UNAVAILABLE_ITEM), DATA_ENABLED]
		) + CategoryFilter;

	DISABLED_ITEM :
		Profile.Filter := CatalogueFilter( DISABLED_ITEM) + CategoryFilter;
	end;

	lblCounter.Caption := 'vF' + IntToStr( Profile.RecordCount) + ' ';

	btnSelect.Enabled := ( not Profile.IsEmpty);
	btnDelete.Enabled := ( not Profile.IsEmpty) and ( not radShowDisabled.Checked);
	btnRestore.Enabled := ( not Profile.IsEmpty) and radShowDisabled.Checked;
end;

procedure TProfilesWorkspace.btnLookup_Click(Sender: TObject);
var
	keyProfile : Integer;
begin
	if ChooseProfile( DataStore.MainTransaction, keyProfile) then
	begin
		Profile.Locate( 'keyInstance', keyProfile, []);
	end;
end;

procedure TProfilesWorkspace.gridView_DrawColumnCell(Sender: TObject; const Rect: TRect; DataCol: Integer; Column: TColumn; State: TGridDrawState);
begin
	with Column do if ( PickList.Count > 0) and ( not Field.IsNull) then
	begin
		gridView.Canvas.TextRect(
			Rect,
			Rect.Left + ( ( Rect.Right - Rect.Left) - gridView.Canvas.TextWidth( PickList[ Field.AsInteger])) div 2,
			Rect.Top + 2,
			PickList[ Field.AsInteger]
		);
	end;
end;

procedure TProfilesWorkspace.gridView_TitleClick(Column: TColumn);
var
	ACol : Integer;
begin
	if Column.Title.Color = clMenu then exit;

	if Column.FieldName = 'STRCODE' then Profile.IndexFieldNames := 'strCode;keyInstance';
	if Column.FieldName = 'STRNAMEREAD' then Profile.IndexFieldNames := 'strNameRead;keyInstance';
	if Column.FieldName = 'STRADDRESS' then Profile.IndexFieldNames := 'strAddressRead;strNameRead;keyInstance';
	if Column.FieldName = 'STRPHONENUMBER1' then Profile.IndexFieldNames := 'strPhoneNumber1;strNameRead;keyInstance';

	with gridView.Columns do for ACol := 0 to Count - 1 do Items[ ACol].Color := clWindow;

	Column.Color := clSorted;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TProfilesWorkspace.btnSelect_Click(Sender: TObject);
begin
	if not radShowDisabled.Checked then
		CategoryClass.Prepare.Select( ReadInstanceKey( Profile))
	else
		CategoryClass.Prepare.Browse( ReadInstanceKey( Profile));
end;

procedure TProfilesWorkspace.btnAppend_Click(Sender: TObject);
begin
	CategoryClass.Prepare.Append;
end;

procedure TProfilesWorkspace.btnDelete_Click(Sender: TObject);
begin
	CategoryClass.Prepare.Delete( ReadInstanceKey( Profile));
end;

procedure TProfilesWorkspace.btnRestore_Click(Sender: TObject);
begin
	CategoryClass.Prepare.Restore( ReadInstanceKey( Profile));
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TProfilesWorkspace.Report_MenuSetup( MenuRegistrar : TMenuRegistrar);
begin
	MenuRegistrar( 'o^҈ꗗ̈(&P)', Report_Profiles, ( not Profile.IsEmpty));
	MenuRegistrar( 'V[̈(&N)', Report_NameLabels, ( not Profile.IsEmpty));
	MenuRegistrar( '-', nil, true);
	MenuRegistrar( 'iݏY҂̖Oꗗ(&C)', Report_CandidatesName, true);
	MenuRegistrar( 'iݏY҂̌ʐ(&T)', Report_CandidatesCount, true);
end;

procedure TProfilesWorkspace.Report_Profiles(Sender: TObject);
begin
	TProfilesReport.Prepare(
		CatalogueType( radShowAvailable, radShowUnavailable, radShowDisabled),
		CategoryType,
		Region.FieldByName( 'keyInstance').AsInteger,
		Branch.FieldByName( 'keyInstance').AsInteger,
		Profile.IndexFieldNames
	).Preview;
end;

procedure TProfilesWorkspace.Report_NameLabels(Sender: TObject);
begin
	NameLabelsPublisher.Prepare.Popup;
end;

procedure TProfilesWorkspace.Report_CandidatesName(Sender: TObject);
begin
	TCandidatesNamePublisher.Prepare.Popup;
end;

procedure TProfilesWorkspace.Report_CandidatesCount(Sender: TObject);
begin
	TCandidatesCountPublisher.Prepare.Popup;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TProfilesWorkspace.AfterNotify();
var
	Position : TDataSetPosition;
begin
	if Happened( 'Region_Update') then
	begin
		DisableComboSet( cboRegion, Position);
		Region.Close;
		Region.Open;
		Region.FetchAll;
		EnableComboSet( cboRegion, Position);
	end;

	if Happened( 'Branch_Update') then
	begin
		DisableComboSet( cboBranch, Position);
		Branch.Close;
		Branch.Open;
		Branch.FetchAll;
		EnableComboSet( cboBranch, Position);
	end;

	DisableGridSet( gridView, Position);
	Profile.Refresh;
	Selector_Change( self);
	EnableGridSet( gridView, Position);
end;

end.
