unit Workspace_ServerSchedule;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, DB, IBCustomDataSet, IBQuery, IBEvents, StdCtrls, Grids,
  DBGrids, ExtCtrls, IB, IBErrorCodes, IBDatabase, DateUtils, StrUtils,
  ImgList, ComCtrls, DBClient, Provider, DBCtrls, Buttons, Math, Base_Workspace,
  ActnList, Frame_ServerPrivateTable, Frame_ServerPrivateGraph,
  Frame_Servers, Frame_ServerOfficialTable, MainDatastore,
  Frame_ServerOfficialGraph, Piece_JobPalette, Misc_Constants, Misc_Utilities,
  DBLocal, DBLocalI, Base_Frame;

type
  TServerScheduleWorkspace = class(TWorkspaceTemplate)

    btnTomorrow: TSpeedButton;
    btnYesterday: TSpeedButton;
    btnNextMonth: TSpeedButton;
    btnPrevMonth: TSpeedButton;
    pnlScheduleAt: TPanel;
    btnSelectSchedule: TButton;

    pagesSchedule: TPageControl;
    pageOfficialGraph: TTabSheet;
    OfficialGraph: TServerOfficialGraphFrame;

    pageOfficialTable: TTabSheet;
    OfficialTable: TServerOfficialTableFrame;

    pageServers: TTabSheet;
    Servers: TServersFrame;

    pagePrivateGraph: TTabSheet;
    PrivateGraph: TServerPrivateGraphFrame;

    pagePrivateTable: TTabSheet;
    PrivateTable: TServerPrivateTableFrame;

    bvlBorder: TBevel;
    JobPalette: TJobPalette;
    btnReleaseSchedules: TButton;

    ShortCuts: TActionList;
    Shortcut_SelectSchedule: TAction;

    timRedraw: TTimer;

    procedure Schedule_Change(Sender: TObject);
    procedure btnPrevMonth_Click(Sender: TObject);
    procedure btnYesterday_Click(Sender: TObject);
    procedure btnTomorrow_Click(Sender: TObject);
    procedure btnNextMonth_Click(Sender: TObject);
    procedure btnSelectSchedule_Click(Sender: TObject);

    procedure pageOfficialGraph_Show(Sender: TObject);
    procedure pageOfficialGraph_Hide(Sender: TObject);
    procedure pageOfficialTable_Show(Sender: TObject);
    procedure pageOfficialTable_Hide(Sender: TObject);
    procedure pageServers_Show(Sender: TObject);
    procedure pageServers_Hide(Sender: TObject);
    procedure pagePrivateGraph_Show(Sender: TObject);
    procedure pagePrivateGraph_Hide(Sender: TObject);
    procedure pagePrivateTable_Show(Sender: TObject);
    procedure pagePrivateTable_Hide(Sender: TObject);

    procedure JobPalette_JobSelected(Sender: TObject);

    procedure btnReleaseSchedules_Click(Sender: TObject);

    procedure Report_MenuSetup( MenuRegistrar : TMenuRegistrar); override;
    procedure Report_OfficialSchedule(Sender: TObject);
    procedure Report_MatrixSchedule(Sender: TObject);
    procedure Report_Jobs(Sender: TObject);
    procedure Report_Servers(Sender: TObject);
    procedure Report_DailySchedule(Sender: TObject);
    procedure Report_WeeklySchedule(Sender: TObject);
    procedure Report_MonthlySchedule(Sender: TObject);
    procedure Report_DailyScheduleWithMap(Sender: TObject);
    procedure Report_WeeklyScheduleWithMap(Sender: TObject);
    procedure Report_MonthlyScheduleWithMap(Sender: TObject);
    procedure Report_DailySurvey(Sender: TObject);
    procedure Report_WeeklySurvey(Sender: TObject);
    procedure Report_MonthlySurvey(Sender: TObject);
    procedure Report_Schedules(Sender: TObject);

    procedure timRedraw_Timer(Sender: TObject);

  private
    { Private 錾 }
    FScheduleAt : TDate;
    FActivePage : TTabSheet;
    FActiveProfile : Integer;
  protected
    { Protected 錾 }
    procedure BeforePopup(); override;
    procedure AfterPopup(); override;
    procedure AfterNotify(); override;
  public
    { Public 錾 }
  end;

var
  ServerScheduleWorkspace: TServerScheduleWorkspace;

implementation

{$R *.dfm}

uses Chooser_Date, Chooser_Server,
     Toolbox_ReleaseSchedules,
     Report_OfficialSchedule,
     Report_MatrixSchedule,
     Report_Jobs,
     Report_Servers,
     Report_DailyServerSchedule,
     Report_WeeklyServerSchedule,
     Report_MonthlyServerSchedule,
     Report_DailyServerScheduleWithMap,
     Report_WeeklyServerScheduleWithMap,
     Report_MonthlyServerScheduleWithMap,
     Report_DailySurvey,
     Report_WeeklySurvey,
     Report_MonthlySurvey,
     Publisher_ServerSchedules;

{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TServerScheduleWorkspace.BeforePopup();
begin
	JobPalette.OnJobSelected := JobPalette_JobSelected;

	FScheduleAt := Today;
	FActivePage := pagesSchedule.ActivePage;

	if FileExists( ExtractFilePath( Application.ExeName) + 'ServerOfficialTable.cols') then
		OfficialTable.LoadStyleFromFile( ExtractFilePath( Application.ExeName) + 'ServerOfficialTable.cols');

	if FileExists( ExtractFilePath( Application.ExeName) + 'ServerPrivateTable.cols') then
		PrivateTable.LoadStyleFromFile( ExtractFilePath( Application.ExeName) + 'ServerPrivateTable.cols');

	if FileExists( ExtractFilePath( Application.ExeName) + 'Servers.cols') then
		Servers.LoadStyleFromFile( ExtractFilePath( Application.ExeName) + 'Servers.cols');

	Schedule_Change( self);
end;

procedure TServerScheduleWorkspace.AfterPopup();
begin
	OfficialTable.SaveStyleToFile( ExtractFilePath( Application.ExeName) + 'ServerOfficialTable.cols');
	PrivateTable.SaveStyleToFile( ExtractFilePath( Application.ExeName) + 'ServerPrivateTable.cols');
	Servers.SaveStyleToFile( ExtractFilePath( Application.ExeName) + 'Servers.cols');
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TServerScheduleWorkspace.Schedule_Change(Sender: TObject);
begin
	pnlScheduleAt.Caption := FormatDateTime( 'gg ee "N" yyyy" N "MM"  "dd" " (ddd)', FScheduleAt);
	FActiveProfile := -1;

	OfficialGraph.Obsolete := true;
	OfficialTable.Obsolete := true;
	Servers.Obsolete := true;
	PrivateGraph.Obsolete := true;
	PrivateTable.Obsolete := true;

	pagesSchedule.ActivePage.OnHide( pagesSchedule.ActivePage);
	pagesSchedule.ActivePage.OnShow( pagesSchedule.ActivePage);

	JobPalette.Reset( FScheduleAt);
end;

procedure TServerScheduleWorkspace.btnPrevMonth_Click(Sender: TObject);
begin
	FScheduleAt := IncMonth( FScheduleAt, -1);
	Schedule_Change( btnPrevMonth);
end;

procedure TServerScheduleWorkspace.btnYesterday_Click(Sender: TObject);
begin
	FScheduleAt := IncDay( FScheduleAt, -1);
	Schedule_Change( btnYesterday);
end;

procedure TServerScheduleWorkspace.btnTomorrow_Click(Sender: TObject);
begin
	FScheduleAt := IncDay( FScheduleAt);
	Schedule_Change( btnTomorrow);
end;

procedure TServerScheduleWorkspace.btnNextMonth_Click(Sender: TObject);
begin
	FScheduleAt := IncMonth( FScheduleAt);
	Schedule_Change( btnNextMonth);
end;

procedure TServerScheduleWorkspace.btnSelectSchedule_Click(Sender: TObject);
begin
	if ChooseDate( FScheduleAt) then Schedule_Change( btnSelectSchedule);
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TServerScheduleWorkspace.pageOfficialGraph_Show(Sender: TObject);
begin
	FActivePage.OnHide( FActivePage);
	with OfficialGraph do if Obsolete then Reset( FScheduleAt);
	btnReleaseSchedules.Enabled := false;
	JobPalette_JobSelected( JobPalette);
	FActivePage := pageOfficialGraph;
	OfficialGraph.Shortcuts.State := asNormal;
end;

procedure TServerScheduleWorkspace.pageOfficialGraph_Hide(Sender: TObject);
begin
	FActiveProfile := OfficialGraph.ServerKey;
	OfficialGraph.Shortcuts.State := asSuspended;
end;

procedure TServerScheduleWorkspace.pageOfficialTable_Show(Sender: TObject);
begin
	FActivePage.OnHide( FActivePage);
	with OfficialTable do if Obsolete then Reset( FScheduleAt);
	btnReleaseSchedules.Enabled := false;
        FActivePage := pageOfficialTable;
	OfficialTable.Shortcuts.State := asNormal;
end;

procedure TServerScheduleWorkspace.pageOfficialTable_Hide(Sender: TObject);
begin
	FActiveProfile := OfficialTable.ServerKey;
	OfficialTable.Shortcuts.State := asSuspended;
end;

procedure TServerScheduleWorkspace.pageServers_Show(Sender: TObject);
begin
	FActivePage.OnHide( FActivePage);
	with Servers do if Obsolete then Reset( FScheduleAt);
	btnReleaseSchedules.Enabled := false;
	Servers.Lookup( FActiveProfile);
	FActivePage := pageServers;
	Servers.Shortcuts.State := asNormal;
end;

procedure TServerScheduleWorkspace.pageServers_Hide(Sender: TObject);
begin
	FActiveProfile := Servers.ServerKey;
	Servers.Shortcuts.State := asSuspended;
end;

procedure TServerScheduleWorkspace.pagePrivateGraph_Show(Sender: TObject);
begin
	FActivePage.OnHide( FActivePage);
	with PrivateGraph do if Obsolete or ( ServerKey <> FActiveProfile) then
		Reset( FActiveProfile, StartOfTheMonth( FScheduleAt), EndOfTheMonth( FScheduleAt));
	btnReleaseSchedules.Enabled := true;
	JobPalette_JobSelected( JobPalette);
	FActivePage := pagePrivateGraph;
	PrivateGraph.Shortcuts.State := asNormal;
end;

procedure TServerScheduleWorkspace.pagePrivateGraph_Hide(Sender: TObject);
begin
	FActiveProfile := PrivateGraph.ServerKey;
	PrivateGraph.Shortcuts.State := asSuspended;
end;

procedure TServerScheduleWorkspace.pagePrivateTable_Show(Sender: TObject);
begin
	FActivePage.OnHide( FActivePage);
	with PrivateTable do if Obsolete or ( ServerKey <> FActiveProfile) then
		Reset( FActiveProfile, StartOfTheMonth( FScheduleAt), EndOfTheMonth( FScheduleAt));
	btnReleaseSchedules.Enabled := true;
	FActivePage := pagePrivateTable;
	PrivateTable.Shortcuts.State := asNormal;
end;

procedure TServerScheduleWorkspace.pagePrivateTable_Hide(Sender: TObject);
begin
	FActiveProfile := PrivateTable.ServerKey;
	PrivateTable.Shortcuts.State := asSuspended;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TServerScheduleWorkspace.JobPalette_JobSelected(Sender: TObject);
begin
	with OfficialGraph do if Active then with JobPalette do Enclose( JobMinutesFrom, JobMinutesTo);
	with PrivateGraph do if Active then with JobPalette do Enclose( JobMinutesFrom, JobMinutesTo);
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TServerScheduleWorkspace.btnReleaseSchedules_Click(Sender: TObject);
begin
	with PrivateGraph do if Active then ReleaseSchedules( FScheduleAt, ServerKey);
	with PrivateTable do if Active then ReleaseSchedules( FScheduleAt, ServerKey);
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TServerScheduleWorkspace.Report_MenuSetup( MenuRegistrar : TMenuRegistrar);
begin
	MenuRegistrar( 'S̃XPW[\̈(&O)', Report_OfficialSchedule, ( OfficialGraph.Active or OfficialTable.Active));
	MenuRegistrar( 'hXPW[Oẗ(&G)', Report_MatrixSchedule, OfficialGraph.Active);
	MenuRegistrar( 'XPW[\̈(&T)', Report_Jobs, JobPalette.JobKey > 0);
	MenuRegistrar( '񋟎҈ꗗ̈(&S)', Report_Servers, ( Servers.Active));
	MenuRegistrar( '-', nil, true);
	MenuRegistrar( 'ԃXPW[\̈(&D)', Report_DailySchedule, true);
	MenuRegistrar( 'TԃXPW[\̈(&W)', Report_WeeklySchedule, true);
	MenuRegistrar( 'ԃXPW[\̈(&M)', Report_MonthlySchedule, true);
	MenuRegistrar( '-', nil, true);
	MenuRegistrar( 'ԃXPW[\̈(n})(&X)', Report_DailyScheduleWithMap, true);
	MenuRegistrar( 'TԃXPW[\̈(n})(&Y)', Report_WeeklyScheduleWithMap, true);
	MenuRegistrar( 'ԃXPW[\̈(n})(&Z)', Report_MonthlyScheduleWithMap, true);
	MenuRegistrar( '-', nil, true);
	MenuRegistrar( 'ѓ̈(&Q)', Report_DailySurvey, true);
	MenuRegistrar( 'яT̈(&R)', Report_WeeklySurvey, true);
	MenuRegistrar( 'ь̈(&V)', Report_MonthlySurvey, true);
	MenuRegistrar( '-', nil, true);
	MenuRegistrar( 'hXPW[\̈ꊇ(&P)', Report_Schedules, true);
end;

procedure TServerScheduleWorkspace.Report_OfficialSchedule(Sender: TObject);
begin
	with OfficialGraph do if Active then
		TOfficialScheduleReport.Prepare( FScheduleAt, -1, -1, 'ׂ').Preview;

	with OfficialTable do if Active then
		TOfficialScheduleReport.Prepare( ScheduleAt, ServiceMask, ProgressMask, ConditionName).Preview;
end;

procedure TServerScheduleWorkspace.Report_MatrixSchedule(Sender: TObject);
begin
	with OfficialGraph do TMatrixScheduleReport.Prepare( FScheduleAt, TopHour, BranchKey, RegionKey).Preview;
end;

procedure TServerScheduleWorkspace.Report_Jobs(Sender: TObject);
begin
	with JobPalette do
		TJobsReport.Prepare( FScheduleAt, JobMask, JobMaskName).Preview;
end;

procedure TServerScheduleWorkspace.Report_Servers(Sender: TObject);
begin
	case Servers.Category of
	DAILY_SERVERS : TServersReport.Daily( FScheduleAt).Preview;
	MONTHLY_SERVERS : TServersReport.Monthly( FScheduleAt).Preview;
	end;
end;

procedure TServerScheduleWorkspace.Report_DailySchedule(Sender: TObject);
begin
	with OfficialGraph do if Active then
		TDailyServerScheduleReport.Prepare( ServerKey, ScheduleAt).Preview;

	with OfficialTable do if Active then
		TDailyServerScheduleReport.Prepare( ServerKey, ScheduleAt).Preview;

	with PrivateGraph do if Active then
		TDailyServerScheduleReport.Prepare( ServerKey, ScheduleAt).Preview;

	with PrivateTable do if Active then
		TDailyServerScheduleReport.Prepare( ServerKey, ScheduleAt).Preview;
end;

procedure TServerScheduleWorkspace.Report_WeeklySchedule(Sender: TObject);
begin
	with OfficialGraph do if Active then
		TWeeklyServerScheduleReport.Prepare( ServerKey, ScheduleAt).Preview;

	with OfficialTable do if Active then
		TWeeklyServerScheduleReport.Prepare( ServerKey, ScheduleAt).Preview;

	with PrivateGraph do if Active then
		TWeeklyServerScheduleReport.Prepare( ServerKey, ScheduleAt).Preview;

	with PrivateTable do if Active then
		TWeeklyServerScheduleReport.Prepare( ServerKey, ScheduleAt).Preview;
end;

procedure TServerScheduleWorkspace.Report_MonthlySchedule(Sender: TObject);
begin
	with OfficialGraph do if Active then
		TMonthlyServerScheduleReport.Prepare( ServerKey, ScheduleAt).Preview;

	with OfficialTable do if Active then
		TMonthlyServerScheduleReport.Prepare( ServerKey, ScheduleAt).Preview;

	with PrivateGraph do if Active then
		TMonthlyServerScheduleReport.Prepare( ServerKey, ScheduleAt).Preview;

	with PrivateTable do if Active then
		TMonthlyServerScheduleReport.Prepare( ServerKey, ScheduleAt).Preview;
end;

procedure TServerScheduleWorkspace.Report_DailyScheduleWithMap(Sender: TObject);
begin
	with OfficialGraph do if Active then
		TDailyServerScheduleWithMapReport.Prepare( ServerKey, ScheduleAt).Preview;

	with OfficialTable do if Active then
		TDailyServerScheduleWithMapReport.Prepare( ServerKey, ScheduleAt).Preview;

	with PrivateGraph do if Active then
		TDailyServerScheduleWithMapReport.Prepare( ServerKey, ScheduleAt).Preview;

	with PrivateTable do if Active then
		TDailyServerScheduleWithMapReport.Prepare( ServerKey, ScheduleAt).Preview;
end;

procedure TServerScheduleWorkspace.Report_WeeklyScheduleWithMap(Sender: TObject);
begin
	with OfficialGraph do if Active then
		TWeeklyServerScheduleWithMapReport.Prepare( ServerKey, ScheduleAt).Preview;

	with OfficialTable do if Active then
		TWeeklyServerScheduleWithMapReport.Prepare( ServerKey, ScheduleAt).Preview;

	with PrivateGraph do if Active then
		TWeeklyServerScheduleWithMapReport.Prepare( ServerKey, ScheduleAt).Preview;

	with PrivateTable do if Active then
		TWeeklyServerScheduleWithMapReport.Prepare( ServerKey, ScheduleAt).Preview;
end;

procedure TServerScheduleWorkspace.Report_MonthlyScheduleWithMap(Sender: TObject);
begin
	with OfficialGraph do if Active then
		TMonthlyServerScheduleWithMapReport.Prepare( ServerKey, ScheduleAt).Preview;

	with OfficialTable do if Active then
		TMonthlyServerScheduleWithMapReport.Prepare( ServerKey, ScheduleAt).Preview;

	with PrivateGraph do if Active then
		TMonthlyServerScheduleWithMapReport.Prepare( ServerKey, ScheduleAt).Preview;

	with PrivateTable do if Active then
		TMonthlyServerScheduleWithMapReport.Prepare( ServerKey, ScheduleAt).Preview;
end;

procedure TServerScheduleWorkspace.Report_DailySurvey(Sender: TObject);
begin
	TDailySurveyReport.Prepare( FScheduleAt).Preview;
end;

procedure TServerScheduleWorkspace.Report_WeeklySurvey(Sender: TObject);
begin
	TWeeklySurveyReport.Prepare( FScheduleAt).Preview;
end;

procedure TServerScheduleWorkspace.Report_MonthlySurvey(Sender: TObject);
begin
	TMonthlySurveyReport.Prepare( FScheduleAt).Preview;
end;

procedure TServerScheduleWorkspace.Report_Schedules(Sender: TObject);
begin
	TServerSchedulesPublisher.Prepare( FScheduleAt).Popup;
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TServerScheduleWorkspace.timRedraw_Timer(Sender: TObject);
begin
	with OfficialGraph do if Active then Invalidate;
	with PrivateGraph do if Active then Invalidate;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TServerScheduleWorkspace.AfterNotify();
begin
	Schedule_Change( self);
end;

end.
