
/*******************************************************************************
  @file: Catalogue_Privilege.sql
  @subject: access permission for catalogue tables
  @update: 2004/05/08 (Sat) 00:00:00
  = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
 *******************************************************************************/

INPUT 'Locator.sql';

/*=========================================================*
  @subject: Zip
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*/

GRANT INSERT, UPDATE, SELECT, REFERENCES ON Zip TO User_Client;


/*=========================================================*
  @subject: Center
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*/

GRANT INSERT                             ON Center_Selector TO TRIGGER AfterInsert_Center;
GRANT                 SELECT, REFERENCES ON Center_Selector TO User_Client;
GRANT         UPDATE, SELECT, REFERENCES ON Center TO User_Client;
REVOKE UPDATE ( keyInstance) ON Center FROM User_Client;


/*=========================================================*
  @subject: Branch, Region
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*/

GRANT INSERT                             ON Branch_Selector TO TRIGGER AfterInsert_Branch;
GRANT                 SELECT, REFERENCES ON Branch_Selector TO User_Client;
GRANT INSERT, UPDATE, SELECT, REFERENCES ON Branch TO User_Client;
REVOKE UPDATE ( keyInstance) ON Branch FROM User_Client;

GRANT INSERT                             ON Region_Selector TO TRIGGER AfterInsert_Region;
GRANT                 SELECT, REFERENCES ON Region_Selector TO User_Client;
GRANT INSERT, UPDATE, SELECT, REFERENCES ON Region TO User_Client;
REVOKE UPDATE ( keyInstance) ON Region FROM User_Client;


/*=========================================================*
  @subject: Profile, Address, Notice, Absence
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*/

GRANT INSERT                             ON Profile_Selector TO TRIGGER AfterInsert_Profile;
GRANT                 SELECT, REFERENCES ON Profile_Selector TO TRIGGER User_Client;
GRANT INSERT, UPDATE, SELECT, REFERENCES ON Profile TO User_Client;
REVOKE UPDATE ( keyInstance, typCategory) ON Profile FROM User_Client;

GRANT INSERT                             ON Notice_Selector TO TRIGGER AfterInsert_Notice;
GRANT                 SELECT, REFERENCES ON Notice_Selector TO TRIGGER User_Client;
GRANT INSERT, UPDATE, SELECT, REFERENCES ON Notice TO User_Client;
REVOKE UPDATE ( keyInstance, refProfile) ON Notice FROM User_Client;

GRANT INSERT                             ON Absence_Selector TO TRIGGER AfterInsert_Absence;
GRANT                 SELECT, REFERENCES ON Absence_Selector TO TRIGGER User_Client;
GRANT INSERT, UPDATE, SELECT, REFERENCES ON Absence TO User_Client;
REVOKE UPDATE ( keyInstance, refProfile) ON Absence FROM User_Client;


/*=========================================================*
  @subject: Address
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*/

GRANT INSERT                             ON Address_Selector TO TRIGGER AfterInsert_Address;
GRANT                 SELECT, REFERENCES ON Address_Selector TO TRIGGER User_Client;
GRANT INSERT, UPDATE, SELECT, REFERENCES ON Address TO User_Client;
REVOKE UPDATE ( keyInstance, typCategory, refProfile) ON Address FROM User_Client;


/*=========================================================*
  @subject: Service, Exchange, Reward
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*/

GRANT INSERT                             ON Service_Selector TO TRIGGER AfterInsert_Service;
GRANT                 SELECT, REFERENCES ON Service_Selector TO User_Client;
GRANT INSERT, UPDATE, SELECT, REFERENCES ON Service TO User_Client;
REVOKE UPDATE ( keyInstance, typCategory) ON Service FROM User_Client;

GRANT INSERT                             ON Exchange_Selector TO TRIGGER AfterInsert_Exchange;
GRANT                 SELECT, REFERENCES ON Exchange_Selector TO User_Client;
GRANT INSERT, UPDATE, SELECT, REFERENCES ON Exchange TO User_Client;
REVOKE UPDATE ( keyInstance, refService, typCategory, intAmountPerCount, intAmountPerHour, intAmountPerCancel) ON Exchange FROM User_Client;


/*=========================================================*
  @subject: Picture
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*/

GRANT INSERT                             ON Picture_Selector TO TRIGGER AfterInsert_Picture;
GRANT DELETE                             ON Picture_Selector TO TRIGGER BeforeUpdate_Picture;
GRANT                 SELECT, REFERENCES ON Picture_Selector TO User_Client;
GRANT INSERT, UPDATE, SELECT, REFERENCES ON Picture TO User_Client;
REVOKE UPDATE ( keyInstance, typOwner, refOwner) ON Picture FROM User_Client;


