
/*******************************************************************************
  @file: Catalogue_Structure.sql
  @subject: table definition for catalogue table
  @update: 2004/05/08 (Sat) 00:00:00
  = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
 *******************************************************************************/

INPUT 'Locator.sql';

/*=========================================================*
  @subject: Zip
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*/

CREATE TABLE Zip (
	keyZIP  INTEGER NOT NULL PRIMARY KEY,
	strAddress  VARCHAR(64) NOT NULL,
	strAddressRead  VARCHAR(128) NOT NULL
);

CREATE TABLE Zip_Selector (
	keyZIP  INTEGER NOT NULL PRIMARY KEY REFERENCES Zip ON DELETE CASCADE
);


/*=========================================================*
  @subject: Center
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*/

CREATE TABLE Center (
	keyInstance  INTEGER NOT NULL PRIMARY KEY,
	codRevision  REVISION,
	typStatus  TYPECODE DEFAULT 0 NOT NULL,
		/*************************************
		 * ENUM - typStatus
		 * - - - - - - - - - - - - - - - - - -
		 *  DATA_ENABLED  0
		 *  DATA_DISABLED  1
		 */
	/*------------------------------------------*/
	strLegalName  VARCHAR(64) NOT NULL,
	strTradeName  VARCHAR(64) NOT NULL,
	/*------------------------------------------*/
	refZip  INTEGER NOT NULL REFERENCES Zip_Selector,
	strAddress  VARCHAR(64) DEFAULT '' NOT NULL,
	strAddressRead  VARCHAR(128) DEFAULT '' NOT NULL,
	strPhoneNumber1  VARCHAR(16) DEFAULT '' NOT NULL,
	strPhoneNumber2  VARCHAR(16) DEFAULT '' NOT NULL,
	strPhoneNumber3  VARCHAR(16) DEFAULT '' NOT NULL,
	strFaxNumber1  VARCHAR(16) DEFAULT '' NOT NULL,
	strFaxNumber2  VARCHAR(16) DEFAULT '' NOT NULL,
	strFaxNumber3  VARCHAR(16) DEFAULT '' NOT NULL,
	/*------------------------------------------*/
	intPricePerPoint  INTEGER NOT NULL,
	/*------------------------------------------*/
	intTicketMarginPerCheck  INTEGER NOT NULL,
	typTicketMarginPerEvent  TYPECODE DEFAULT 0 NOT NULL,
		/*************************************
		 * ENUM - typTicketMargin
		 * - - - - - - - - - - - - - - - - - -
		 *  MARGIN_BY_PERMILLAGE  0
		 *  MARGIN_BY_PERCOUNT  1
		 *  MARGIN_BY_MANUAL  2
		 */
	intTicketMarginPerEvent  INTEGER NOT NULL,
	intTicketClosingDay  INTEGER NOT NULL,
	/*------------------------------------------*/
	intPaybackMarginPerCheck  INTEGER NOT NULL,
	typPaybackMarginPerEvent  TYPECODE DEFAULT 0 NOT NULL,
		/*************************************
		 * ENUM - typPaybackMargin
		 * - - - - - - - - - - - - - - - - - -
		 *  MARGIN_BY_PERMILLAGE  0
		 *  MARGIN_BY_PERCOUNT  1
		 *  MARGIN_BY_MANUAL  2
		 */
	intPaybackMarginPerEvent  INTEGER NOT NULL,
	intPaybackClosingDay  INTEGER NOT NULL,
	/*------------------------------------------*/
	intBillingMarginPerCheck  INTEGER NOT NULL,
	typBillingMarginPerEvent  TYPECODE DEFAULT 0 NOT NULL,
		/*************************************
		 * ENUM - typBillingMargin
		 * - - - - - - - - - - - - - - - - - -
		 *  MARGIN_BY_PERMILLAGE  0
		 *  MARGIN_BY_PERCOUNT  1
		 *  MARGIN_BY_MANUAL  2
		 */
	intBillingMarginPerEvent  INTEGER NOT NULL,
	intBillingClosingDay  INTEGER NOT NULL,
	/*------------------------------------------*/
	intPaymentMarginPerCheck  INTEGER NOT NULL,
	typPaymentMarginPerEvent  TYPECODE DEFAULT 0 NOT NULL,
		/*************************************
		 * ENUM - typPaymentMargin
		 * - - - - - - - - - - - - - - - - - -
		 *  MARGIN_BY_PERMILLAGE  0
		 *  MARGIN_BY_PERCOUNT  1
		 *  MARGIN_BY_MANUAL  2
		 */
	intPaymentMarginPerEvent  INTEGER NOT NULL,
	intPaymentClosingDay  INTEGER NOT NULL
);

CREATE TABLE Center_Selector (
	keyInstance  INTEGER NOT NULL PRIMARY KEY REFERENCES Center ON DELETE CASCADE
);


/*=========================================================*
  @subject: Branch, Region
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*/

CREATE TABLE Branch (
	keyInstance  INTEGER NOT NULL PRIMARY KEY,
	codRevision  REVISION,
	typStatus  TYPECODE DEFAULT 0 NOT NULL,
		/*************************************
		 * ENUM - typStatus
		 * - - - - - - - - - - - - - - - - - -
		 *  DATA_ENABLED  0
		 *  DATA_DISABLED  1
		 */
	/*------------------------------------------*/
	datAvailableFrom  DATE NOT NULL,
	datAvailableTo  DATE NOT NULL,
	/*------------------------------------------*/
	strName  VARCHAR(32) NOT NULL
);

CREATE TABLE Branch_Selector (
	keyInstance  INTEGER NOT NULL PRIMARY KEY REFERENCES Branch ON DELETE CASCADE
);

CREATE TABLE Region (
	keyInstance  INTEGER NOT NULL PRIMARY KEY,
	codRevision  REVISION,
	typStatus  TYPECODE DEFAULT 0 NOT NULL,
		/*************************************
		 * ENUM - typStatus
		 * - - - - - - - - - - - - - - - - - -
		 *  DATA_ENABLED  0
		 *  DATA_DISABLED  1
		 */
	/*------------------------------------------*/
	datAvailableFrom  DATE NOT NULL,
	datAvailableTo  DATE NOT NULL,
	/*------------------------------------------*/
	strName  VARCHAR(32) NOT NULL
);

CREATE TABLE Region_Selector (
	keyInstance  INTEGER NOT NULL PRIMARY KEY REFERENCES Region ON DELETE CASCADE
);


/*=========================================================*
  @subject: Profile, Notice, Absence
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*/

CREATE TABLE Profile (
	keyInstance  INTEGER NOT NULL PRIMARY KEY,
	codRevision  REVISION,
	typStatus  TYPECODE DEFAULT 0 NOT NULL,
		/*************************************
		 * ENUM - typStatus
		 * - - - - - - - - - - - - - - - - - -
		 *  DATA_ENABLED  0
		 *  DATA_DISABLED  1
		 */
	/*------------------------------------------*/
	typCategory  TYPECODE DEFAULT 0 NOT NULL,
		/*************************************
		 * ENUM - typCategory
		 * - - - - - - - - - - - - - - - - - -
		 *  CLIENT_PROFILE  0
		 *  SERVER_PROFILE  1
		 */
	/*------------------------------------------*/
	datAvailableFrom  DATE NOT NULL,
	datAvailableTo  DATE NOT NULL,
	/*------------------------------------------*/
	refBranch  INTEGER NOT NULL REFERENCES Branch_Selector,
	refRegion  INTEGER NOT NULL REFERENCES Region_Selector,
	/*------------------------------------------*/
	strCode  VARCHAR(16) NOT NULL,
	strFamilyName  VARCHAR(16) NOT NULL,
	strFamilyNameRead  VARCHAR(32) NOT NULL,
	strFirstName  VARCHAR(16) NOT NULL,
	strFirstNameRead  VARCHAR(32) NOT NULL,
	typSex  TYPECODE DEFAULT 0 NOT NULL,
		/*************************************
		 * ENUM - typSex
		 * - - - - - - - - - - - - - - - - - -
		 *  MALE_SEX  0
		 *  FEMALE_SEX  1
		 */
	datBirthday  DATE,
	/*------------------------------------------*/
	strAvailability  VARCHAR(64) DEFAULT '' NOT NULL,
	optAvailability  OPTIONS DEFAULT 0 NOT NULL,
		/*************************************
		 * ENUM - optAvailability
		 * - - - - - - - - - - - - - - - - - -
		 *  SUNDAY_AVAILABLE  1
		 *  MONDAY_AVAILABLE  2
		 *  TUESDAY_AVAILABLE  4
		 *  WEDNESDAY_AVAILABLE  8
		 *  THURSDAY_AVAILABLE  16
		 *  FRIDAY_AVAILABLE  32
		 *  SATURDAY_AVAILABLE  64
		 *  PROFILE_AVAILABLE  128
		 */
	/*------------------------------------------*/
	strName  VARCHAR(64) COMPUTED BY ( trim( strFamilyName) || '@' || trim( strFirstName)),
	strNameRead  VARCHAR(128) COMPUTED BY ( trim( strFamilyNameRead) || '@' || trim( strFirstNameRead)),
	strSignature  VARCHAR(64) COMPUTED BY ( trim( strCode) || '@' || trim( strFamilyName) || '@' || trim( strFirstName))
);

CREATE TABLE Profile_Selector (
	keyInstance  INTEGER NOT NULL PRIMARY KEY REFERENCES Profile ON DELETE CASCADE
);

CREATE TABLE Notice (
	keyInstance  INTEGER NOT NULL PRIMARY KEY,
	codRevision  REVISION,
	typStatus  TYPECODE DEFAULT 0 NOT NULL,
		/*************************************
		 * ENUM - typStatus
		 * - - - - - - - - - - - - - - - - - -
		 *  DATA_ENABLED  0
		 *  DATA_DISABLED  1
		 */
	/*------------------------------------------*/
	refProfile  INTEGER NOT NULL REFERENCES Profile_Selector,
	/*------------------------------------------*/
	datAvailableFrom  DATE NOT NULL,
	datAvailableTo  DATE NOT NULL,
	/*------------------------------------------*/
	strTitle  VARCHAR(32) NOT NULL,
	/*------------------------------------------*/
	strContent  VARCHAR(1024) NOT NULL
);

CREATE TABLE Notice_Selector (
	keyInstance  INTEGER NOT NULL PRIMARY KEY REFERENCES Notice ON DELETE CASCADE
);

CREATE TABLE Absence (
	keyInstance  INTEGER NOT NULL PRIMARY KEY,
	codRevision  REVISION,
	typStatus  TYPECODE DEFAULT 0 NOT NULL,
		/*************************************
		 * ENUM - typStatus
		 * - - - - - - - - - - - - - - - - - -
		 *  DATA_ENABLED  0
		 *  DATA_DISABLED  1
		 */
	/*------------------------------------------*/
	refProfile  INTEGER NOT NULL REFERENCES Profile_Selector,
	/*------------------------------------------*/
	datMonthFirstday  DATE NOT NULL,
	datMonthLastday  DATE NOT NULL,
	optAbsence  OPTIONS DEFAULT 0 NOT NULL,
	/*------------------------------------------*/
	strReason  VARCHAR(64) NOT NULL
);

CREATE TABLE Absence_Selector (
	keyInstance  INTEGER NOT NULL PRIMARY KEY REFERENCES Absence ON DELETE CASCADE
);


/*=========================================================*
  @subject: Address
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*/

CREATE TABLE Address (
	keyInstance  INTEGER NOT NULL PRIMARY KEY,
	codRevision  REVISION,
	typStatus  TYPECODE DEFAULT 0 NOT NULL,
		/*************************************
		 * ENUM - typStatus
		 * - - - - - - - - - - - - - - - - - -
		 *  DATA_ENABLED  0
		 *  DATA_DISABLED  1
		 */
	/*------------------------------------------*/
	typCategory  TYPECODE NOT NULL,
		/*************************************
		 * ENUM - typCategory
		 * - - - - - - - - - - - - - - - - - -
		 *  PROFILE_ADDRESS  0
		 *  FREQUENT_ADDRESS  1
		 *  GUARDIAN_ADDRESS  2
		 *  PUBLIC_ADDRESS  3
		 */
	/*------------------------------------------*/
	refProfile  INTEGER REFERENCES Profile_Selector,
	/*------------------------------------------*/
	datAvailableFrom  DATE NOT NULL,
	datAvailableTo  DATE NOT NULL,
	/*------------------------------------------*/
	strName  VARCHAR(64) NOT NULL,
	strNameRead  VARCHAR(128) NOT NULL,
	/*------------------------------------------*/
	refZip  INTEGER NOT NULL REFERENCES Zip_Selector,
	strAddress  VARCHAR(64) DEFAULT '' NOT NULL,
	strAddressRead  VARCHAR(128) DEFAULT '' NOT NULL,
	strPhoneNumber1  VARCHAR(16) DEFAULT '' NOT NULL,
	strPhoneNumber2  VARCHAR(16) DEFAULT '' NOT NULL,
	strPhoneNumber3  VARCHAR(16) DEFAULT '' NOT NULL,
	strFaxNumber1  VARCHAR(16) DEFAULT '' NOT NULL,
	strFaxNumber2  VARCHAR(16) DEFAULT '' NOT NULL,
	strFaxNumber3  VARCHAR(16) DEFAULT '' NOT NULL,
	/*------------------------------------------*/
	intLocatorX  INTEGER DEFAULT 0 NOT NULL,
	intLocatorY  INTEGER DEFAULT 0 NOT NULL
);

CREATE TABLE Address_Selector (
	keyInstance  INTEGER NOT NULL PRIMARY KEY REFERENCES Address ON DELETE CASCADE
);


/*=========================================================*
  @subject: Service, Exchange
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*/

CREATE TABLE Service (
	keyInstance  INTEGER NOT NULL PRIMARY KEY,
	codRevision  REVISION,
	typStatus  TYPECODE DEFAULT 0 NOT NULL,
		/*************************************
		 * ENUM - typStatus
		 * - - - - - - - - - - - - - - - - - -
		 *  DATA_ENABLED  0
		 *  DATA_DISABLED  1
		 */
	/*------------------------------------------*/
	typCategory  TYPECODE NOT NULL,
		/*************************************
		 * ENUM - typCategory
		 * - - - - - - - - - - - - - - - - - -
		 *  CARE_SERVICE  0
		 *  MENAGE_SERVICE  1
		 *  MIGRATION_SERVICE  2
		 *  TRANSFER_SERVICE  3
		 */
	/*------------------------------------------*/
	datAvailableFrom  DATE NOT NULL,
	datAvailableTo  DATE NOT NULL,
	/*------------------------------------------*/
	strName  VARCHAR(32) NOT NULL,
	/*------------------------------------------*/
	optAvailability  OPTIONS DEFAULT 0 NOT NULL
		/*************************************
		 * ENUM - optAvailability
		 * - - - - - - - - - - - - - - - - - -
		 *  SUNDAY_AVAILABLE  1
		 *  MONDAY_AVAILABLE  2
		 *  TUESDAY_AVAILABLE  4
		 *  WEDNESDAY_AVAILABLE  8
		 *  THURSDAY_AVAILABLE  16
		 *  FRIDAY_AVAILABLE  32
		 *  SATURDAY_AVAILABLE  64
		 */
);

CREATE TABLE Service_Selector (
	keyInstance  INTEGER NOT NULL PRIMARY KEY REFERENCES Service ON DELETE CASCADE
);

CREATE TABLE Exchange (
	keyInstance  INTEGER NOT NULL PRIMARY KEY,
	codRevision  REVISION,
	typStatus  TYPECODE DEFAULT 0 NOT NULL,
		/*************************************
		 * ENUM - typStatus
		 * - - - - - - - - - - - - - - - - - -
		 *  DATA_ENABLED  0
		 *  DATA_DISABLED  1
		 */
	/*------------------------------------------*/
	refService  INTEGER NOT NULL REFERENCES Service_Selector,
	/*------------------------------------------*/
	typCategory  TYPECODE NOT NULL,
		/*************************************
		 * ENUM - typCategory
		 * - - - - - - - - - - - - - - - - - -
		 *  TICKET_EXCHANGE  0
		 *  MONEY_EXCHANGE  1
		 */
	/*------------------------------------------*/
	datAvailableFrom  DATE NOT NULL,
	datAvailableTo  DATE NOT NULL,
	/*------------------------------------------*/
	strName  VARCHAR(64) NOT NULL,
	/*------------------------------------------*/
	curAmountPerCount  CURRENCY DEFAULT 0 NOT NULL,
	curAmountPerHour  CURRENCY DEFAULT 0 NOT NULL
);

CREATE TABLE Exchange_Selector (
	keyInstance  INTEGER NOT NULL PRIMARY KEY REFERENCES Exchange ON DELETE CASCADE
);


/*=========================================================*
  @subject: Picture
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*/

CREATE TABLE Picture (
	keyInstance  INTEGER NOT NULL PRIMARY KEY,
	codRevision  REVISION,
	typStatus  TYPECODE DEFAULT 0 NOT NULL,
		/*************************************
		 * ENUM - typStatus
		 * - - - - - - - - - - - - - - - - - -
		 *  DATA_ENABLED  0
		 *  DATA_DISABLED  1
		 */
	/*------------------------------------------*/
	typOwner  TYPECODE DEFAULT 0 NOT NULL,
		/*************************************
		 * ENUM - typOwner
		 * - - - - - - - - - - - - - - - - - -
		 *  OWNER_CENTER  0
		 *  OWNER_PROFILE  1
		 *  OWNER_ADDRESS  2
		 */
	refOwner  INTEGER NOT NULL,
	/*------------------------------------------*/
	datAvailableFrom  DATE NOT NULL,
	datAvailableTo  DATE NOT NULL,
	/*------------------------------------------*/
	strName  VARCHAR(32) NOT NULL,
	strNotice  VARCHAR(128) DEFAULT '' NOT NULL,
	/*------------------------------------------*/
	Stream  BLOB
);

CREATE TABLE Picture_Selector (
	keyInstance  INTEGER NOT NULL PRIMARY KEY REFERENCES Picture ON DELETE CASCADE
);

CREATE INDEX Index_Picture_Owner ON Picture ( refOwner);


