
/*******************************************************************************
  @file: Catalogue_Trigger.sql
  @subject: trigger definition for catalogue tables
  @update: 2004/05/08 (Sat) 00:00:00
  = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
 *******************************************************************************/

INPUT 'Locator.sql';

/*=========================================================*
  @subject: Zip
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*/

SET TERM !! ;
CREATE TRIGGER AfterInsert_Zip FOR Zip AFTER INSERT AS
	BEGIN
		INSERT INTO Zip_Selector VALUES ( New.keyZip);
	END !!
SET TERM ; !!


/*=========================================================*
  @subject: Center
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*/

SET TERM !! ;
CREATE TRIGGER BeforeInsert_Center FOR Center BEFORE INSERT AS
	BEGIN
		/**** FOR BUG COUNTERMEASURE PURPOSE ***/
		New.strAddress = trim( New.strAddress);
		New.strAddressRead = trim( New.strAddressRead);
		New.strPhoneNumber1 = trim( New.strPhoneNumber1);
		New.strPhoneNumber2 = trim( New.strPhoneNumber2);
		New.strPhoneNumber3 = trim( New.strPhoneNumber3);
		New.strFaxNumber1 = trim( New.strFaxNumber1);
		New.strFaxNumber2 = trim( New.strFaxNumber2);
		New.strFaxNumber3 = trim( New.strFaxNumber3);
		/**** FOR BUG COUNTERMEASURE PURPOSE ***/

		New.keyInstance = 1;
		New.codRevision = New.keyInstance;

		POST_EVENT 'Center_Update';
	END !!
SET TERM ; !!

SET TERM !! ;
CREATE TRIGGER AfterInsert_Center FOR Center AFTER INSERT AS
	BEGIN
		INSERT INTO Center_Selector VALUES ( New.keyInstance);
	END !!
SET TERM ; !!

SET TERM !! ;
CREATE TRIGGER BeforeUpdate_Center FOR Center BEFORE UPDATE AS
	BEGIN
		/**** FOR BUG COUNTERMEASURE PURPOSE ***/
		New.strAddress = trim( New.strAddress);
		New.strAddressRead = trim( New.strAddressRead);
		New.strPhoneNumber1 = trim( New.strPhoneNumber1);
		New.strPhoneNumber2 = trim( New.strPhoneNumber2);
		New.strPhoneNumber3 = trim( New.strPhoneNumber3);
		New.strFaxNumber1 = trim( New.strFaxNumber1);
		New.strFaxNumber2 = trim( New.strFaxNumber2);
		New.strFaxNumber3 = trim( New.strFaxNumber3);
		/**** FOR BUG COUNTERMEASURE PURPOSE ***/

		IF ( New.typStatus = 0 /* DATA_ENABLED */) THEN
		BEGIN
			SELECT Revision FROM NewRevision INTO New.codRevision;
		END

		IF ( New.typStatus = 1 /* DATA_DISABLED */) THEN
		BEGIN
			SELECT Revision FROM NewRevision INTO New.codRevision;
		END

		New.typStatus = ifNegative( New.typStatus, Old.typStatus, New.typStatus);

		POST_EVENT 'Center_Update';
	END !!
SET TERM ; !!


/*=========================================================*
  @subject: Branch, Region
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*/

SET TERM !! ;
CREATE TRIGGER BeforeInsert_Branch FOR Branch BEFORE INSERT AS
	BEGIN
		IF ( New.keyInstance <= 0) THEN SELECT Revision FROM NewRevision INTO New.keyInstance;
		New.codRevision = New.keyInstance;

		POST_EVENT 'Branch_Update';
	END !!
SET TERM ; !!

SET TERM !! ;
CREATE TRIGGER AfterInsert_Branch FOR Branch AFTER INSERT AS
	BEGIN
		INSERT INTO Branch_Selector VALUES ( New.keyInstance);
	END !!
SET TERM ; !!

SET TERM !! ;
CREATE TRIGGER BeforeUpdate_Branch FOR Branch BEFORE UPDATE AS
	BEGIN
		IF ( New.typStatus = 0 /* DATA_ENABLED */) THEN
		BEGIN
			SELECT Revision FROM NewRevision INTO New.codRevision;
		END

		IF ( New.typStatus = 1 /* DATA_DISABLED */) THEN
		BEGIN
			SELECT Revision FROM NewRevision INTO New.codRevision;
		END

		New.typStatus = ifNegative( New.typStatus, Old.typStatus, New.typStatus);

		POST_EVENT 'Branch_Update';
	END !!
SET TERM ; !!

SET TERM !! ;
CREATE TRIGGER BeforeInsert_Region FOR Region BEFORE INSERT AS
	BEGIN
		IF ( New.keyInstance <= 0) THEN SELECT Revision FROM NewRevision INTO New.keyInstance;
		New.codRevision = New.keyInstance;

		POST_EVENT 'Region_Update';
	END !!
SET TERM ; !!

SET TERM !! ;
CREATE TRIGGER AfterInsert_Region FOR Region AFTER INSERT AS
	BEGIN
		INSERT INTO Region_Selector VALUES ( New.keyInstance);
	END !!
SET TERM ; !!

SET TERM !! ;
CREATE TRIGGER BeforeUpdate_Region FOR Region BEFORE UPDATE AS
	BEGIN
		IF ( New.typStatus = 0 /* DATA_ENABLED */) THEN
		BEGIN
			SELECT Revision FROM NewRevision INTO New.codRevision;
		END

		IF ( New.typStatus = 1 /* DATA_DISABLED */) THEN
		BEGIN
			SELECT Revision FROM NewRevision INTO New.codRevision;
		END

		New.typStatus = ifNegative( New.typStatus, Old.typStatus, New.typStatus);

		POST_EVENT 'Region_Update';
	END !!
SET TERM ; !!


/*=========================================================*
  @subject: Profile, Notice, Absence
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*/

SET TERM !! ;
CREATE TRIGGER BeforeInsert_Profile FOR Profile BEFORE INSERT AS
	BEGIN
		/**** FOR BUG COUNTERMEASURE PURPOSE ***/
		New.strAvailability = trim( New.strAvailability);
		/**** FOR BUG COUNTERMEASURE PURPOSE ***/

		IF ( New.keyInstance <= 0) THEN SELECT Revision FROM NewRevision INTO New.keyInstance;
		New.codRevision = New.keyInstance;

		POST_EVENT 'Profile_Update';
	END !!
SET TERM ; !!

SET TERM !! ;
CREATE TRIGGER AfterInsert_Profile FOR Profile AFTER INSERT AS
	BEGIN
		INSERT INTO Profile_Selector VALUES ( New.keyInstance);
	END !!
SET TERM ; !!

SET TERM !! ;
CREATE TRIGGER BeforeUpdate_Profile FOR Profile BEFORE UPDATE AS
	BEGIN
		/**** FOR BUG COUNTERMEASURE PURPOSE ***/
		New.strAvailability = trim( New.strAvailability);
		/**** FOR BUG COUNTERMEASURE PURPOSE ***/

		UPDATE Address SET typStatus = -1 WHERE refProfile = New.keyInstance;

		IF ( New.typStatus = 0 /* DATA_ENABLED */) THEN
		BEGIN
			SELECT Revision FROM NewRevision INTO New.codRevision;
		END

		IF ( New.typStatus = 1 /* DATA_DISABLED */) THEN
		BEGIN
			SELECT Revision FROM NewRevision INTO New.codRevision;
		END

		New.typStatus = ifNegative( New.typStatus, Old.typStatus, New.typStatus);

		POST_EVENT 'Profile_Update';
	END !!
SET TERM ; !!

SET TERM !! ;
CREATE TRIGGER AfterUpdate_Profile FOR Profile AFTER UPDATE AS
	DECLARE VARIABLE keyAddress  INTEGER;
	BEGIN
		IF ( New.strCode <> Old.strCode
		  or New.strFamilyName <> Old.strFamilyName
		  or New.strFamilyNameRead <> Old.strFamilyNameRead
		  or New.strFirstName <> Old.strFirstName
		  or New.strFirstNameRead <> Old.strFirstNameRead
		) THEN
		BEGIN
			UPDATE Address SET
				strName = New.strSignature,
				strNameRead = New.strNameRead
			WHERE refProfile = New.keyInstance
			  and typCategory = 0 /* PROFILE_ADDRESS */
			  and typStatus = 0 /* DATA_ENABLED */;
		END
	END !!
SET TERM ; !!

SET TERM !! ;
CREATE TRIGGER BeforeInsert_Notice FOR Notice BEFORE INSERT AS
	BEGIN
		IF ( New.keyInstance <= 0) THEN SELECT Revision FROM NewRevision INTO New.keyInstance;
		New.codRevision = New.keyInstance;

		POST_EVENT 'Notice_Update';
	END !!
SET TERM ; !!

SET TERM !! ;
CREATE TRIGGER AfterInsert_Notice FOR Notice AFTER INSERT AS
	BEGIN
		INSERT INTO Notice_Selector VALUES ( New.keyInstance);
	END !!
SET TERM ; !!

SET TERM !! ;
CREATE TRIGGER BeforeUpdate_Notice FOR Notice BEFORE UPDATE AS
	BEGIN
		IF ( New.typStatus = 0 /* DATA_ENABLED */) THEN
		BEGIN
			SELECT Revision FROM NewRevision INTO New.codRevision;
		END

		IF ( New.typStatus = 1 /* DATA_DISABLED */) THEN
		BEGIN
			SELECT Revision FROM NewRevision INTO New.codRevision;
		END

		New.typStatus = ifNegative( New.typStatus, Old.typStatus, New.typStatus);

		POST_EVENT 'Notice_Update';
	END !!
SET TERM ; !!

SET TERM !! ;
CREATE TRIGGER BeforeInsert_Absence FOR Absence BEFORE INSERT AS
	BEGIN
		IF ( New.keyInstance <= 0) THEN SELECT Revision FROM NewRevision INTO New.keyInstance;
		New.codRevision = New.keyInstance;

		POST_EVENT 'Absence_Update';
	END !!
SET TERM ; !!

SET TERM !! ;
CREATE TRIGGER AfterInsert_Absence FOR Absence AFTER INSERT AS
	BEGIN
		INSERT INTO Absence_Selector VALUES ( New.keyInstance);
	END !!
SET TERM ; !!

SET TERM !! ;
CREATE TRIGGER BeforeUpdate_Absence FOR Absence BEFORE UPDATE AS
	BEGIN
		IF ( New.typStatus = 0 /* DATA_ENABLED */) THEN
		BEGIN
			SELECT Revision FROM NewRevision INTO New.codRevision;
		END

		IF ( New.typStatus = 1 /* DATA_DISABLED */) THEN
		BEGIN
			SELECT Revision FROM NewRevision INTO New.codRevision;
		END

		New.typStatus = ifNegative( New.typStatus, Old.typStatus, New.typStatus);

		POST_EVENT 'Absence_Update';
	END !!
SET TERM ; !!


/*=========================================================*
  @subject: Address
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*/

SET TERM !! ;
CREATE TRIGGER BeforeInsert_Address FOR Address BEFORE INSERT AS
	BEGIN
		/**** FOR BUG COUNTERMEASURE PURPOSE ***/
		New.strAddress = trim( New.strAddress);
		New.strAddressRead = trim( New.strAddressRead);
		New.strPhoneNumber1 = trim( New.strPhoneNumber1);
		New.strPhoneNumber2 = trim( New.strPhoneNumber2);
		New.strPhoneNumber3 = trim( New.strPhoneNumber3);
		New.strFaxNumber1 = trim( New.strFaxNumber1);
		New.strFaxNumber2 = trim( New.strFaxNumber2);
		New.strFaxNumber3 = trim( New.strFaxNumber3);
		/**** FOR BUG COUNTERMEASURE PURPOSE ***/

		IF ( New.keyInstance <= 0) THEN SELECT Revision FROM NewRevision INTO New.keyInstance;
		New.codRevision = New.keyInstance;

		IF ( New.typCategory = 0 /* PROFILE_ADDRESS */) THEN
		BEGIN
			SELECT pr.strSignature, pr.strNameRead
			FROM Profile pr WHERE pr.keyInstance = New.refProfile
			INTO New.strName, New.strNameRead;
		END

		POST_EVENT 'Address_Update';
	END !!
SET TERM ; !!

SET TERM !! ;
CREATE TRIGGER AfterInsert_Address FOR Address AFTER INSERT AS
	BEGIN
		INSERT INTO Address_Selector VALUES ( New.keyInstance);
	END !!
SET TERM ; !!

SET TERM !! ;
CREATE TRIGGER BeforeUpdate_Address FOR Address BEFORE UPDATE AS
	BEGIN
		/**** FOR BUG COUNTERMEASURE PURPOSE ***/
		New.strAddress = trim( New.strAddress);
		New.strAddressRead = trim( New.strAddressRead);
		New.strPhoneNumber1 = trim( New.strPhoneNumber1);
		New.strPhoneNumber2 = trim( New.strPhoneNumber2);
		New.strPhoneNumber3 = trim( New.strPhoneNumber3);
		New.strFaxNumber1 = trim( New.strFaxNumber1);
		New.strFaxNumber2 = trim( New.strFaxNumber2);
		New.strFaxNumber3 = trim( New.strFaxNumber3);
		/**** FOR BUG COUNTERMEASURE PURPOSE ***/

		IF ( New.typCategory = 0 /* PROFILE_ADDRESS */) THEN
		BEGIN
			SELECT pr.strSignature, pr.strNameRead
			FROM Profile pr WHERE pr.keyInstance = New.refProfile
			INTO New.strName, New.strNameRead;
		END

		IF ( New.typStatus = 0 /* DATA_ENABLED */) THEN
		BEGIN
			SELECT Revision FROM NewRevision INTO New.codRevision;
		END

		IF ( New.typStatus = 1 /* DATA_DISABLED */) THEN
		BEGIN
			SELECT Revision FROM NewRevision INTO New.codRevision;
		END

		New.typStatus = ifNegative( New.typStatus, Old.typStatus, New.typStatus);

		POST_EVENT 'Address_Update';
	END !!
SET TERM ; !!


/*=========================================================*
  @subject: Service, Exchange
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*/

SET TERM !! ;
CREATE TRIGGER BeforeInsert_Service FOR Service BEFORE INSERT AS
	BEGIN
		IF ( New.keyInstance <= 0) THEN SELECT Revision FROM NewRevision INTO New.keyInstance;
		New.codRevision = New.keyInstance;

		POST_EVENT 'Service_Update';
	END !!
SET TERM ; !!

SET TERM !! ;
CREATE TRIGGER AfterInsert_Service FOR Service AFTER INSERT AS
	BEGIN
		INSERT INTO Service_Selector VALUES ( New.keyInstance);
	END !!
SET TERM ; !!

SET TERM !! ;
CREATE TRIGGER BeforeUpdate_Service FOR Service BEFORE UPDATE AS
	BEGIN
		IF ( New.typStatus = 0 /* DATA_ENABLED */) THEN
		BEGIN
			SELECT Revision FROM NewRevision INTO New.codRevision;
		END

		IF ( New.typStatus = 1 /* DATA_DISABLED */) THEN
		BEGIN
			SELECT Revision FROM NewRevision INTO New.codRevision;
		END

		New.typStatus = ifNegative( New.typStatus, Old.typStatus, New.typStatus);

		POST_EVENT 'Service_Update';
	END !!
SET TERM ; !!

SET TERM !! ;
CREATE TRIGGER BeforeInsert_Exchange FOR Exchange BEFORE INSERT AS
	BEGIN
		IF ( New.keyInstance <= 0) THEN SELECT Revision FROM NewRevision INTO New.keyInstance;
		New.codRevision = New.keyInstance;

		POST_EVENT 'Exchange_Update';
	END !!
SET TERM ; !!

SET TERM !! ;
CREATE TRIGGER AfterInsert_Exchange FOR Exchange AFTER INSERT AS
	BEGIN
		INSERT INTO Exchange_Selector VALUES ( New.keyInstance);
	END !!
SET TERM ; !!

SET TERM !! ;
CREATE TRIGGER BeforeUpdate_Exchange FOR Exchange BEFORE UPDATE AS
	BEGIN
		IF ( New.typStatus = 0 /* DATA_ENABLED */) THEN
		BEGIN
			SELECT Revision FROM NewRevision INTO New.codRevision;
		END

		IF ( New.typStatus = 1 /* DATA_DISABLED */) THEN
		BEGIN
			SELECT Revision FROM NewRevision INTO New.codRevision;
		END

		New.typStatus = ifNegative( New.typStatus, Old.typStatus, New.typStatus);

		POST_EVENT 'Exchange_Update';
	END !!
SET TERM ; !!


/*=========================================================*
  @subject: Picture
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*/

SET TERM !! ;
CREATE TRIGGER BeforeInsert_Picture FOR Picture BEFORE INSERT AS
	BEGIN
		/**** FOR BUG COUNTERMEASURE PURPOSE ***/
		New.strNotice = trim( New.strNotice);
		/**** FOR BUG COUNTERMEASURE PURPOSE ***/

		IF ( New.keyInstance <= 0) THEN SELECT Revision FROM NewRevision INTO New.keyInstance;
		New.codRevision = New.keyInstance;

		POST_EVENT 'Picture_Update';
	END !!
SET TERM ; !!

SET TERM !! ;
CREATE TRIGGER AfterInsert_Picture FOR Picture AFTER INSERT AS
	BEGIN
		INSERT INTO Picture_Selector VALUES ( New.keyInstance);
	END !!
SET TERM ; !!

SET TERM !! ;
CREATE TRIGGER BeforeUpdate_Picture FOR Picture BEFORE UPDATE AS
	BEGIN
		/**** FOR BUG COUNTERMEASURE PURPOSE ***/
		New.strNotice = trim( New.strNotice);
		/**** FOR BUG COUNTERMEASURE PURPOSE ***/

		IF ( New.typStatus = 0 /* DATA_ENABLED */) THEN
		BEGIN
			SELECT Revision FROM NewRevision INTO New.codRevision;
		END

		IF ( New.typStatus = 1 /* DATA_DISABLED */) THEN
		BEGIN
			DELETE FROM Picture WHERE keyInstance = New.keyInstance;
		END

		New.typStatus = ifNegative( New.typStatus, Old.typStatus, New.typStatus);

		POST_EVENT 'Picture_Update';
	END !!
SET TERM ; !!


