
/*******************************************************************************
  @file: Journal_Structure.sql
  @subject: table definition for journal tables
  @update: 2004/05/08 (Sat) 00:00:00
  = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
 *******************************************************************************/

INPUT 'Locator.sql';

/*=========================================================*
  @subject: Schedule
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*/

CREATE TABLE Schedule (
	keyInstance  INTEGER NOT NULL PRIMARY KEY,
	codRevision  REVISION,
	typStatus  TYPECODE DEFAULT 0 NOT NULL,
		/*************************************
		 * ENUM - typStatus
		 * - - - - - - - - - - - - - - - - - -
		 *  DATA_ENABLED  0
		 *  DATA_DISABLED  1
		 */
	/*------------------------------------------*/
	datSchedule  DATE NOT NULL,
	/*------------------------------------------*/
	keyPattern  INTEGER DEFAULT 0 NOT NULL,
	typPattern  TYPECODE DEFAULT 0 NOT NULL,
		/*************************************
		 * ENUM - typPattern
		 * - - - - - - - - - - - - - - - - - -
		 *  PATTERN_SINGLETON  0
		 *  PATTERN_DAY_OF_THE_EVERY_WEEK  1
		 *  PATTERN_DAY_OF_THE_SECOND_WEEK  2
		 *  PATTERN_DAY_OF_THE_MONTH  3
		 *  PATTERN_COMPLEX  4
		 *  PATTERN_MULTIPLE  5
		 */
	optPattern  OPTIONS DEFAULT 0 NOT NULL,
	optElement  OPTIONS DEFAULT 0 NOT NULL,
		/*************************************
		 * ENUM - optElement
		 * - - - - - - - - - - - - - - - - - -
		 *  ELEMENT_SERVER  1
		 *  ELEMENT_NOTICE  2
		 */
	/*------------------------------------------*/
	typSequence  TYPECODE DEFAULT 0 NOT NULL,
		/*************************************
		 * ENUM - typSequence
		 * - - - - - - - - - - - - - - - - - -
		 *  SEQUENCE_BODY  0
		 *  SEQUENCE_TAIL  1
		 */
	/*------------------------------------------*/
	typProgress  TYPECODE NOT NULL,
		/*************************************
		 * ENUM - typProgress
		 * - - - - - - - - - - - - - - - - - -
		 *  UNCLEAR_PROGRESS  0
		 *  DEFINED_PROGRESS  1
		 */
	/*------------------------------------------*/
	/* refSubject  INTEGER REFERENCES Schedule_Selector, */
	refService  INTEGER NOT NULL REFERENCES Service_Selector,
	refExchange  INTEGER NOT NULL REFERENCES Exchange_Selector,
	intMinutesAt  INTEGER NOT NULL,
	intMinutesFor  INTEGER NOT NULL,
	refAddressFrom  INTEGER NOT NULL REFERENCES Address_Selector,
	refAddressTo  INTEGER NOT NULL REFERENCES Address_Selector,
	strNotice  VARCHAR(48) DEFAULT '' NOT NULL,
	/*------------------------------------------*/
	refClient  INTEGER REFERENCES Profile_Selector,
	refServer  INTEGER REFERENCES Profile_Selector
);

CREATE TABLE Schedule_Selector (
	keyInstance  INTEGER NOT NULL PRIMARY KEY REFERENCES Schedule ON DELETE CASCADE
);

ALTER TABLE Schedule ADD refSubject  INTEGER REFERENCES Schedule_Selector;
ALTER TABLE Schedule ALTER refSubject  POSITION 11;

CREATE INDEX Index_Schedule_Schedule ON Schedule ( datSchedule);
CREATE INDEX Index_Schedule_Pattern ON Schedule ( keyPattern);


/*=========================================================*
  @subject: Comment
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*/

CREATE TABLE Comment (
	keyInstance  INTEGER NOT NULL PRIMARY KEY,
	codRevision  REVISION,
	typStatus  TYPECODE DEFAULT 0 NOT NULL,
		/*************************************
		 * ENUM - typStatus
		 * - - - - - - - - - - - - - - - - - -
		 *  DATA_ENABLED  0
		 *  DATA_DISABLED  1
		 */
	/*------------------------------------------*/
	datTimeStamp  DATE NOT NULL,
	/*------------------------------------------*/
	typCategory  TYPECODE NOT NULL,
		/*************************************
		 * ENUM - typCategory
		 * - - - - - - - - - - - - - - - - - -
		 *  STATIC_COMMENT  0
		 *  WAITING_COMMENT  1
		 *  PROCESSED_COMMENT  2
		 */
	/*------------------------------------------*/
	strTitle  VARCHAR(32) NOT NULL,
	strContent  VARCHAR(1024) DEFAULT '' NOT NULL
);

CREATE TABLE Comment_Selector (
	keyInstance  INTEGER NOT NULL PRIMARY KEY REFERENCES Comment ON DELETE CASCADE
);

CREATE INDEX Index_Comment_TimeStamp ON Comment ( datTimeStamp);


/*=========================================================*
  @subject: Ticket, Payback, Proof
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*/

CREATE TABLE Ticket (
	keyInstance  INTEGER NOT NULL PRIMARY KEY,
	codRevision  REVISION,
	typStatus  TYPECODE DEFAULT 0 NOT NULL,
		/*************************************
		 * ENUM - typStatus
		 * - - - - - - - - - - - - - - - - - -
		 *  DATA_ENABLED  0
		 *  DATA_DISABLED  1
		 */
	/*------------------------------------------*/
	datPublished  DATE,
	/*------------------------------------------*/
	refProfile  INTEGER NOT NULL REFERENCES Profile_Selector,
	/*------------------------------------------*/
	strCode  VARCHAR(16) NOT NULL,
	strFamilyName  VARCHAR(16) NOT NULL,
	strFamilyNameRead  VARCHAR(32) NOT NULL,
	strFirstName  VARCHAR(16) NOT NULL,
	strFirstNameRead  VARCHAR(32) NOT NULL,
	typSex  TYPECODE DEFAULT 0 NOT NULL,
		/*************************************
		 * ENUM - typSex
		 * - - - - - - - - - - - - - - - - - -
		 *  MALE_SEX  0
		 *  FEMALE_SEX  1
		 */
	datBirthday  DATE,
	/*------------------------------------------*/
	intPricePerPoint  INTEGER NOT NULL,
	curPoint  CURRENCY NOT NULL,
	intMargin  INTEGER NOT NULL,
	/*------------------------------------------*/
	strName  VARCHAR(64) COMPUTED BY ( trim( strFamilyName) || '@' || trim( strFirstName)),
	strNameRead  VARCHAR(128) COMPUTED BY ( trim( strFamilyNameRead) || '@' || trim( strFirstNameRead)),
	strSignature  VARCHAR(64) COMPUTED BY ( trim( strCode) || '@' || trim( strFamilyName) || '@' || trim( strFirstName))
);

CREATE TABLE Ticket_Selector (
	keyInstance  INTEGER NOT NULL PRIMARY KEY REFERENCES Ticket ON DELETE CASCADE
);

CREATE TABLE Payback (
	keyInstance  INTEGER NOT NULL PRIMARY KEY,
	codRevision  REVISION,
	typStatus  TYPECODE DEFAULT 0 NOT NULL,
		/*************************************
		 * ENUM - typStatus
		 * - - - - - - - - - - - - - - - - - -
		 *  DATA_ENABLED  0
		 *  DATA_DISABLED  1
		 */
	/*------------------------------------------*/
	datPublished  DATE NOT NULL,
	/*------------------------------------------*/
	refProfile  INTEGER NOT NULL REFERENCES Profile_Selector,
	/*------------------------------------------*/
	strCode  VARCHAR(16) NOT NULL,
	strFamilyName  VARCHAR(16) NOT NULL,
	strFamilyNameRead  VARCHAR(32) NOT NULL,
	strFirstName  VARCHAR(16) NOT NULL,
	strFirstNameRead  VARCHAR(32) NOT NULL,
	typSex  TYPECODE DEFAULT 0 NOT NULL,
		/*************************************
		 * ENUM - typSex
		 * - - - - - - - - - - - - - - - - - -
		 *  MALE_SEX  0
		 *  FEMALE_SEX  1
		 */
	datBirthday  DATE,
	/*------------------------------------------*/
	datMonthFirstday  DATE NOT NULL,
	datMonthLastday  DATE NOT NULL,
	/*------------------------------------------*/
	intPricePerPoint  INTEGER NOT NULL,
	curPoint  CURRENCY NOT NULL,
	intMargin  INTEGER NOT NULL,
	/*------------------------------------------*/
	curCarePoint  CURRENCY NOT NULL,
	curMenagePoint  CURRENCY NOT NULL,
	curMigrationPoint  CURRENCY NOT NULL,
	curTransferPoint  CURRENCY NOT NULL,
	/*------------------------------------------*/
	strName  VARCHAR(64) COMPUTED BY ( trim( strFamilyName) || '@' || trim( strFirstName)),
	strNameRead  VARCHAR(128) COMPUTED BY ( trim( strFamilyNameRead) || '@' || trim( strFirstNameRead)),
	strSignature  VARCHAR(64) COMPUTED BY ( trim( strCode) || '@' || trim( strFamilyName) || '@' || trim( strFirstName))
);

CREATE TABLE Payback_Selector (
	keyInstance  INTEGER NOT NULL PRIMARY KEY REFERENCES Payback ON DELETE CASCADE
);

CREATE TABLE Proof (
	keyInstance  INTEGER NOT NULL PRIMARY KEY,
	codRevision  REVISION,
	typStatus  TYPECODE DEFAULT 0 NOT NULL,
		/*************************************
		 * ENUM - typStatus
		 * - - - - - - - - - - - - - - - - - -
		 *  DATA_ENABLED  0
		 *  DATA_DISABLED  1
		 */
	/*------------------------------------------*/
	refPayback  INTEGER NOT NULL REFERENCES Payback_Selector ON DELETE CASCADE,
	/*------------------------------------------*/
	refSchedule  INTEGER NOT NULL REFERENCES Schedule_Selector,
	/*------------------------------------------*/
	typProgress  TYPECODE DEFAULT 0 NOT NULL,
		/*************************************
		 * ENUM - typProgress
		 * - - - - - - - - - - - - - - - - - -
		 *  UNCLEAR_PROGRESS  0 - never appears in Receipt
		 *  DEFINED_PROGRESS  1
		 */
	/*------------------------------------------*/
	refService  INTEGER NOT NULL REFERENCES Service_Selector,
	refExchange  INTEGER NOT NULL REFERENCES Exchange_Selector,
	intMinutesAt  INTEGER NOT NULL,
	intMinutesFor  INTEGER NOT NULL,
	refAddressFrom  INTEGER NOT NULL REFERENCES Address_Selector,
	refAddressTo  INTEGER NOT NULL REFERENCES Address_Selector,
	strNotice  VARCHAR(64) DEFAULT '' NOT NULL,
	/*------------------------------------------*/
	refClient  INTEGER NOT NULL REFERENCES Profile_Selector
);

CREATE TABLE Proof_Selector (
	keyInstance  INTEGER NOT NULL PRIMARY KEY REFERENCES Proof ON DELETE CASCADE
);


/*=========================================================*
  @subject: Billing, Receipt
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*/

RECREATE TABLE Billing (
	keyInstance  INTEGER NOT NULL PRIMARY KEY,
	codRevision  REVISION,
	typStatus  TYPECODE DEFAULT 0 NOT NULL,
		/*************************************
		 * ENUM - typStatus
		 * - - - - - - - - - - - - - - - - - -
		 *  DATA_ENABLED  0
		 *  DATA_DISABLED  1
		 */
	/*------------------------------------------*/
	datPublished  DATE,
	/*------------------------------------------*/
	refProfile  INTEGER NOT NULL REFERENCES Profile_Selector,
	/*------------------------------------------*/
	strCode  VARCHAR(16) NOT NULL,
	strFamilyName  VARCHAR(16) NOT NULL,
	strFamilyNameRead  VARCHAR(32) NOT NULL,
	strFirstName  VARCHAR(16) NOT NULL,
	strFirstNameRead  VARCHAR(32) NOT NULL,
	typSex  TYPECODE DEFAULT 0 NOT NULL,
		/*************************************
		 * ENUM - typSex
		 * - - - - - - - - - - - - - - - - - -
		 *  MALE_SEX  0
		 *  FEMALE_SEX  1
		 */
	datBirthday  DATE,
	/*------------------------------------------*/
	datMonthFirstday  DATE NOT NULL,
	datMonthLastday  DATE NOT NULL,
	/*------------------------------------------*/
	intCash  INTEGER NOT NULL,
	intMargin  INTEGER NOT NULL,
	/*------------------------------------------*/
	intCareCash  INTEGER NOT NULL,
	intMenageCash  INTEGER NOT NULL,
	intMigrationCash  INTEGER NOT NULL,
	intTransferCash  INTEGER NOT NULL,
	/*------------------------------------------*/
	strName  VARCHAR(64) COMPUTED BY ( trim( strFamilyName) || '@' || trim( strFirstName)),
	strNameRead  VARCHAR(128) COMPUTED BY ( trim( strFamilyNameRead) || '@' || trim( strFirstNameRead)),
	strSignature  VARCHAR(64) COMPUTED BY ( trim( strCode) || '@' || trim( strFamilyName) || '@' || trim( strFirstName))
);

CREATE TABLE Billing_Selector (
	keyInstance  INTEGER NOT NULL PRIMARY KEY REFERENCES Billing ON DELETE CASCADE
);

CREATE TABLE Receipt (
	keyInstance  INTEGER NOT NULL PRIMARY KEY,
	codRevision  REVISION,
	typStatus  TYPECODE DEFAULT 0 NOT NULL,
		/*************************************
		 * ENUM - typStatus
		 * - - - - - - - - - - - - - - - - - -
		 *  DATA_ENABLED  0
		 *  DATA_DISABLED  1
		 */
	/*------------------------------------------*/
	refBilling  INTEGER NOT NULL REFERENCES Billing_Selector ON DELETE CASCADE,
	/*------------------------------------------*/
	refSchedule  INTEGER NOT NULL REFERENCES Schedule_Selector,
	/*------------------------------------------*/
	typProgress  TYPECODE DEFAULT 0 NOT NULL,
		/*************************************
		 * ENUM - typProgress
		 * - - - - - - - - - - - - - - - - - -
		 *  UNCLEAR_PROGRESS  0 - never appears in Receipt
		 *  DEFINED_PROGRESS  1
		 */
	/*------------------------------------------*/
	refService  INTEGER NOT NULL REFERENCES Service_Selector,
	refExchange  INTEGER NOT NULL REFERENCES Exchange_Selector,
	intMinutesAt  INTEGER NOT NULL,
	intMinutesFor  INTEGER NOT NULL,
	refAddressFrom  INTEGER NOT NULL REFERENCES Address_Selector,
	refAddressTo  INTEGER NOT NULL REFERENCES Address_Selector,
	strNotice  VARCHAR(48) DEFAULT '' NOT NULL,
	/*------------------------------------------*/
	refClient  INTEGER NOT NULL REFERENCES Profile_Selector,
	refServer  INTEGER NOT NULL REFERENCES Profile_Selector
);

CREATE TABLE Receipt_Selector (
	keyInstance  INTEGER NOT NULL PRIMARY KEY REFERENCES Receipt ON DELETE CASCADE
);


/*=========================================================*
  @subject: Payment, Supply
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*/

RECREATE TABLE Payment (
	keyInstance  INTEGER NOT NULL PRIMARY KEY,
	codRevision  REVISION,
	typStatus  TYPECODE DEFAULT 0 NOT NULL,
		/*************************************
		 * ENUM - typStatus
		 * - - - - - - - - - - - - - - - - - -
		 *  DATA_ENABLED  0
		 *  DATA_DISABLED  1
		 */
	/*------------------------------------------*/
	datPublished  DATE,
	/*------------------------------------------*/
	refProfile  INTEGER NOT NULL REFERENCES Profile_Selector,
	/*------------------------------------------*/
	strCode  VARCHAR(16) NOT NULL,
	strFamilyName  VARCHAR(16) NOT NULL,
	strFamilyNameRead  VARCHAR(32) NOT NULL,
	strFirstName  VARCHAR(16) NOT NULL,
	strFirstNameRead  VARCHAR(32) NOT NULL,
	typSex  TYPECODE DEFAULT 0 NOT NULL,
		/*************************************
		 * ENUM - typSex
		 * - - - - - - - - - - - - - - - - - -
		 *  MALE_SEX  0
		 *  FEMALE_SEX  1
		 */
	datBirthday  DATE,
	/*------------------------------------------*/
	datMonthFirstday  DATE NOT NULL,
	datMonthLastday  DATE NOT NULL,
	/*------------------------------------------*/
	intCash  INTEGER NOT NULL,
	intMargin  INTEGER NOT NULL,
	/*------------------------------------------*/
	intCareCash  INTEGER NOT NULL,
	intMenageCash  INTEGER NOT NULL,
	intMigrationCash  INTEGER NOT NULL,
	intTransferCash  INTEGER NOT NULL,
	/*------------------------------------------*/
	strName  VARCHAR(64) COMPUTED BY ( trim( strFamilyName) || '@' || trim( strFirstName)),
	strNameRead  VARCHAR(128) COMPUTED BY ( trim( strFamilyNameRead) || '@' || trim( strFirstNameRead)),
	strSignature  VARCHAR(64) COMPUTED BY ( trim( strCode) || '@' || trim( strFamilyName) || '@' || trim( strFirstName))
);

CREATE TABLE Payment_Selector (
	keyInstance  INTEGER NOT NULL PRIMARY KEY REFERENCES Payment ON DELETE CASCADE
);

CREATE TABLE Supply (
	keyInstance  INTEGER NOT NULL PRIMARY KEY,
	codRevision  REVISION,
	typStatus  TYPECODE DEFAULT 0 NOT NULL,
		/*************************************
		 * ENUM - typStatus
		 * - - - - - - - - - - - - - - - - - -
		 *  DATA_ENABLED  0
		 *  DATA_DISABLED  1
		 */
	/*------------------------------------------*/
	refPayment  INTEGER NOT NULL REFERENCES Payment_Selector ON DELETE CASCADE,
	/*------------------------------------------*/
	refSchedule  INTEGER NOT NULL REFERENCES Schedule_Selector,
	/*------------------------------------------*/
	typProgress  TYPECODE DEFAULT 0 NOT NULL,
		/*************************************
		 * ENUM - typProgress
		 * - - - - - - - - - - - - - - - - - -
		 *  UNCLEAR_PROGRESS  0 - never appears in Receipt
		 *  DEFINED_PROGRESS  1
		 */
	/*------------------------------------------*/
	refService  INTEGER NOT NULL REFERENCES Service_Selector,
	refExchange  INTEGER NOT NULL REFERENCES Exchange_Selector,
	intMinutesAt  INTEGER NOT NULL,
	intMinutesFor  INTEGER NOT NULL,
	refAddressFrom  INTEGER NOT NULL REFERENCES Address_Selector,
	refAddressTo  INTEGER NOT NULL REFERENCES Address_Selector,
	strNotice  VARCHAR(48) DEFAULT '' NOT NULL,
	/*------------------------------------------*/
	refClient  INTEGER NOT NULL REFERENCES Profile_Selector
);

CREATE TABLE Supply_Selector (
	keyInstance  INTEGER NOT NULL PRIMARY KEY REFERENCES Supply ON DELETE CASCADE
);


