
/*******************************************************************************
  @file: Journal_Trigger.sql
  @subject: trigger definition for journal tables
  @update: 2004/05/08 (Sat) 00:00:00
  = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
 *******************************************************************************/

INPUT 'Locator.sql';

/*=========================================================*
  @subject: Schedule
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*/

SET TERM !! ;
CREATE TRIGGER BeforeInsert_Schedule FOR Schedule BEFORE INSERT AS
	BEGIN
		/**** FOR BUG COUNTERMEASURE PURPOSE ***/
		New.strNotice = trim( New.strNotice);
		/**** FOR BUG COUNTERMEASURE PURPOSE ***/

		IF ( New.keyInstance <= 0) THEN SELECT Revision FROM NewRevision INTO New.keyInstance;
		New.codRevision = New.keyInstance;

		POST_EVENT 'Schedule_Update';
	END !!
SET TERM ; !!

SET TERM !! ;
CREATE TRIGGER AfterInsert_Schedule FOR Schedule AFTER INSERT AS
	BEGIN
		INSERT INTO Schedule_Selector VALUES ( New.keyInstance);
	END !!
SET TERM ; !!

SET TERM !! ;
CREATE TRIGGER BeforeUpdate_Schedule FOR Schedule BEFORE UPDATE AS
	DECLARE VARIABLE keyInstance  INTEGER;
	DECLARE VARIABLE typService  INTEGER;
	DECLARE VARIABLE blnEscorted  INTEGER;
	DECLARE VARIABLE intMinutesAt  INTEGER;
	DECLARE VARIABLE intMinutesFor  INTEGER;
	DECLARE VARIABLE refAddressFrom  INTEGER;
	DECLARE VARIABLE refAddressTo  INTEGER;
	DECLARE VARIABLE keyServerAddress  INTEGER;
	BEGIN
		/**** FOR BUG COUNTERMEASURE PURPOSE ***/
		New.strNotice = trim( New.strNotice);
		/**** FOR BUG COUNTERMEASURE PURPOSE ***/

		UPDATE Schedule SET typStatus = New.typStatus WHERE refSubject = New.keyInstance and typStatus = 0 /* DATA_ENABLED */;

		IF ( New.typStatus = 0 /* DATA_ENABLED */) THEN
		BEGIN
			IF ( Old.typStatus = 1 /* DATA_DISABLED */) THEN
			BEGIN
				UPDATE Schedule SET typStatus = New.typStatus WHERE keyInstance = Old.refSubject;
			END

			IF ( New.intMinutesAt <> Old.intMinutesAt or New.intMinutesFor <> Old.intMinutesFor) THEN
			BEGIN
				FOR SELECT
					sch.keyInstance,
					sch.intMinutesAt,
					sch.intMinutesFor,
					sv.typCategory

				FROM Schedule sch
					LEFT JOIN Service sv ON sv.keyInstance = sch.refService

				WHERE sch.refSubject = Old.keyInstance
				  and sch.typStatus = 0 /* DATA_ENABLED */

				INTO	:keyInstance,
					:intMinutesAt,
					:intMinutesFor,
					:typService
				DO
				BEGIN
					IF ( typService = 0 /* CARE_SERVICE */ or typService = 1 /* MENAGE_SERVICE */) THEN
					BEGIN
						intMinutesAt = intMinutesAt + ( New.intMinutesAt - Old.intMinutesAt);
						intMinutesFor = intMinutesFor + ( New.intMinutesFor - Old.intMinutesFor);
					END
					ELSE
					BEGIN
						intMinutesAt = intMinutesAt + ( New.intMinutesAt - Old.intMinutesAt);
					END

					UPDATE Schedule
					   SET intMinutesAt = :intMinutesAt,
					       intMinutesFor = :intMinutesFor
					 WHERE keyInstance = :keyInstance;
				END
			END

			IF ( Ne( New.refAddressFrom, Old.refAddressFrom) <> 0 or Ne( New.refAddressTo, Old.refAddressTo) <> 0) THEN
			BEGIN
				SELECT typCategory FROM Service WHERE keyInstance = New.refService INTO :typService;

				blnEscorted = 0;

				FOR SELECT
					sch.keyInstance,
					sch.intMinutesAt,
					sch.refAddressFrom,
					sch.refAddressTo

				FROM Schedule sch
					LEFT JOIN Service sv ON sv.keyInstance = sch.refService

				WHERE sch.refSubject = Old.keyInstance
				  and sch.typStatus = 0 /* DATA_ENABLED */
				  and sv.typCategory = 3 /* TRANSFER_SERVICE */

				INTO	:keyInstance,
					:intMinutesAt,
					:refAddressFrom,
					:refAddressTo
				DO
				BEGIN
					IF ( typService <> 3 /* TRANSFER_SERVICE */) THEN
					BEGIN
						IF ( intMinutesAt < New.intMinutesAt + New.intMinutesFor / 2) THEN
						BEGIN
							IF ( refAddressFrom = refAddressTo) THEN
							BEGIN
								refAddressFrom = New.refAddressFrom;
								refAddressTo = New.refAddressFrom;
							END
							ELSE
								refAddressTo = New.refAddressFrom;
						END
						ELSE
						BEGIN
							IF ( refAddressFrom = refAddressTo) THEN
							BEGIN
								refAddressFrom = New.refAddressTo;
								refAddressTo = New.refAddressTo;
							END
							ELSE
								refAddressFrom = New.refAddressTo;
						END

						blnEscorted = 1;
					END
					ELSE
					BEGIN
						refAddressFrom = New.refAddressFrom;
						refAddressTo = New.refAddressTo;
					END

					UPDATE Schedule
					   SET refAddressFrom = :refAddressFrom,
					       refAddressTo = :refAddressTo
					 WHERE keyInstance = :keyInstance;
				END

				IF ( blnEscorted = 0) THEN
				BEGIN
					FOR SELECT
						sch.keyInstance,
						sch.intMinutesAt,
						sch.refAddressFrom,
						sch.refAddressTo

					FROM Schedule sch
						LEFT JOIN Service sv ON sv.keyInstance = sch.refService

					WHERE sch.refSubject = Old.keyInstance
					  and sch.typStatus = 0 /* DATA_ENABLED */
					  and sv.typCategory = 2 /* MIGRATION_SERVICE */

					INTO	:keyInstance,
						:intMinutesAt,
						:refAddressFrom,
						:refAddressTo
					DO
					BEGIN
						IF ( intMinutesAt < New.intMinutesAt + New.intMinutesFor / 2) THEN
						BEGIN
							IF ( refAddressFrom = refAddressTo) THEN
							BEGIN
								refAddressFrom = New.refAddressFrom;
								refAddressTo = New.refAddressFrom;
							END
							ELSE
								refAddressTo = New.refAddressFrom;
						END
						ELSE
						BEGIN
							IF ( refAddressFrom = refAddressTo) THEN
							BEGIN
								refAddressFrom = New.refAddressTo;
								refAddressTo = New.refAddressTo;
							END
							ELSE
								refAddressFrom = New.refAddressTo;
						END

						UPDATE Schedule
						   SET refAddressFrom = :refAddressFrom,
						       refAddressTo = :refAddressTo
						 WHERE keyInstance = :keyInstance;
					END
				END
			END

			IF ( Ne( New.refServer, Old.refServer) <> 0) THEN
			BEGIN
				IF ( New.refServer IS NOT NULL) THEN
				BEGIN
					SELECT ad.keyInstance
					  FROM Address ad
					 WHERE ad.refProfile = New.refServer
					   and ad.codRevision = (
						SELECT Max( ad2.codRevision) FROM Address ad2
						 WHERE ad2.refProfile = ad.refProfile
						   and ad2.typStatus = 0 /* DATA_ENABLED */
						   and ad2.typCategory = 0 /* PROFILE_ADDRESS */
						   and New.datSchedule BETWEEN ad2.datAvailableFrom and ad2.datAvailableTo
						)
					  INTO :keyServerAddress;
				END

				FOR SELECT
					sch.keyInstance,
					sch.intMinutesAt,
					sch.refAddressFrom,
					sch.refAddressTo

				FROM Schedule sch
					LEFT JOIN Service sv ON sv.keyInstance = sch.refService

				WHERE sch.refSubject = Old.keyInstance
				  and sch.typStatus = 0 /* DATA_ENABLED */
				  and sv.typCategory = 2 /* MIGRATION_SERVICE */

				INTO	:keyInstance,
					:intMinutesAt,
					:refAddressFrom,
					:refAddressTo
				DO
				BEGIN
					IF ( intMinutesAt < New.intMinutesAt + New.intMinutesFor / 2) THEN
					BEGIN
						IF ( keyServerAddress IS NOT NULL) THEN
							refAddressFrom = keyServerAddress;
						ELSE
							refAddressFrom = refAddressTo;
					END
					ELSE
					BEGIN
						IF ( keyServerAddress IS NOT NULL) THEN
							refAddressTo = keyServerAddress;
						ELSE
							refAddressTo = refAddressFrom;
					END

					UPDATE Schedule
					   SET refClient = New.refServer,
					       refAddressFrom = :refAddressFrom,
					       refAddressTo = :refAddressTo
					 WHERE keyInstance = :keyInstance;
				END
			END

			SELECT Revision FROM NewRevision INTO New.codRevision;
		END

		IF ( New.typStatus = 1 /* DATA_DISABLED */) THEN
		BEGIN
			SELECT Revision FROM NewRevision INTO New.codRevision;
		END

		New.typStatus = ifNegative( New.typStatus, Old.typStatus, New.typStatus);

		POST_EVENT 'Schedule_Update';
	END !!
SET TERM ; !!


/*=========================================================*
  @subject: Comment
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*/

SET TERM !! ;
CREATE TRIGGER BeforeInsert_Comment FOR Comment BEFORE INSERT AS
	BEGIN
		IF ( New.keyInstance <= 0) THEN SELECT Revision FROM NewRevision INTO New.keyInstance;
		New.codRevision = New.keyInstance;

		POST_EVENT 'Comment_Update';
	END !!
SET TERM ; !!

SET TERM !! ;
CREATE TRIGGER AfterInsert_Comment FOR Comment AFTER INSERT AS
	BEGIN
		INSERT INTO Comment_Selector VALUES ( New.keyInstance);
	END !!
SET TERM ; !!

SET TERM !! ;
CREATE TRIGGER BeforeUpdate_Comment FOR Comment BEFORE UPDATE AS
	BEGIN
		IF ( New.typStatus = 0 /* DATA_ENABLED */) THEN
		BEGIN
			SELECT Revision FROM NewRevision INTO New.codRevision;
		END

		IF ( New.typStatus = 1 /* DATA_DISABLED */) THEN
		BEGIN
			SELECT Revision FROM NewRevision INTO New.codRevision;
		END

		New.typStatus = ifNegative( New.typStatus, Old.typStatus, New.typStatus);

		POST_EVENT 'Comment_Update';
	END !!
SET TERM ; !!


/*=========================================================*
  @subject: Ticket, Payback, Proof
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*/

CREATE EXCEPTION Ticket_Exception  'Ticket is unrestorable';

SET TERM !! ;
CREATE TRIGGER BeforeInsert_Ticket FOR Ticket BEFORE INSERT AS
	BEGIN
		IF ( New.keyInstance <= 0) THEN SELECT Revision FROM NewRevision INTO New.keyInstance;
		New.codRevision = New.keyInstance;

		SELECT	strCode,
			strFamilyName,
			strFamilyNameRead,
			strFirstName,
			strFirstNameRead,
			typSex,
			datBirthday
		FROM Profile WHERE keyInstance = New.refProfile
		INTO	New.strCode,
			New.strFamilyName,
			New.strFamilyNameRead,
			New.strFirstName,
			New.strFirstNameRead,
			New.typSex,
			New.datBirthday;

		POST_EVENT 'Ticket_Update';
	END !!
SET TERM ; !!

SET TERM !! ;
CREATE TRIGGER AfterInsert_Ticket FOR Ticket AFTER INSERT AS
	BEGIN
		INSERT INTO Ticket_Selector VALUES ( New.keyInstance);
	END !!
SET TERM ; !!

SET TERM !! ;
CREATE TRIGGER BeforeUpdate_Ticket FOR Ticket BEFORE UPDATE AS
	BEGIN
		IF ( Old.typStatus = 1 /* DATA_DISABLED */) THEN EXCEPTION Ticket_Exception;

		IF ( New.typStatus = 0 /* DATA_ENABLED */) THEN
		BEGIN
			SELECT Revision FROM NewRevision INTO New.codRevision;
		END

		IF ( New.typStatus = 1 /* DATA_DISABLED */) THEN
		BEGIN
			SELECT Revision FROM NewRevision INTO New.codRevision;
		END

		New.typStatus = ifNegative( New.typStatus, Old.typStatus, New.typStatus);

		POST_EVENT 'Ticket_Update';
	END !!
SET TERM ; !!

CREATE EXCEPTION Payback_Exception  'Payback is unrestorable';

SET TERM !! ;
CREATE TRIGGER BeforeInsert_Payback FOR Payback BEFORE INSERT AS
	BEGIN
		IF ( New.keyInstance <= 0) THEN SELECT Revision FROM NewRevision INTO New.keyInstance;
		New.codRevision = New.keyInstance;

		SELECT	strCode,
			strFamilyName,
			strFamilyNameRead,
			strFirstName,
			strFirstNameRead,
			typSex,
			datBirthday
		FROM Profile WHERE keyInstance = New.refProfile
		INTO	New.strCode,
			New.strFamilyName,
			New.strFamilyNameRead,
			New.strFirstName,
			New.strFirstNameRead,
			New.typSex,
			New.datBirthday;

		POST_EVENT 'Payback_Update';
	END !!
SET TERM ; !!

SET TERM !! ;
CREATE TRIGGER AfterInsert_Payback FOR Payback AFTER INSERT AS
	BEGIN
		INSERT INTO Payback_Selector VALUES ( New.keyInstance);
	END !!
SET TERM ; !!

SET TERM !! ;
CREATE TRIGGER BeforeUpdate_Payback FOR Payback BEFORE UPDATE AS
	BEGIN
		IF ( Old.typStatus = 1 /* DATA_DISABLED */) THEN EXCEPTION Payback_Exception;

		IF ( New.typStatus = 0 /* DATA_ENABLED */) THEN
		BEGIN
			SELECT Revision FROM NewRevision INTO New.codRevision;
		END

		IF ( New.typStatus = 1 /* DATA_DISABLED */) THEN
		BEGIN
			SELECT Revision FROM NewRevision INTO New.codRevision;
		END

		New.typStatus = ifNegative( New.typStatus, Old.typStatus, New.typStatus);

		POST_EVENT 'Payback_Update';
	END !!
SET TERM ; !!

CREATE EXCEPTION Proof_Exception  'Proof is unrestorable';

SET TERM !! ;
CREATE TRIGGER BeforeInsert_Proof FOR Proof BEFORE INSERT AS
	BEGIN
		IF ( New.keyInstance <= 0) THEN SELECT Revision FROM NewRevision INTO New.keyInstance;
		New.codRevision = New.keyInstance;
	END !!
SET TERM ; !!

SET TERM !! ;
CREATE TRIGGER AfterInsert_Proof FOR Proof AFTER INSERT AS
	BEGIN
		INSERT INTO Proof_Selector VALUES ( New.keyInstance);
	END !!
SET TERM ; !!

SET TERM !! ;
CREATE TRIGGER BeforeUpdate_Proof FOR Proof BEFORE UPDATE AS
	BEGIN
		IF ( Old.typStatus = 1 /* DATA_DISABLED */) THEN EXCEPTION Proof_Exception;

		IF ( New.typStatus = 0 /* DATA_ENABLED */) THEN
		BEGIN
			SELECT Revision FROM NewRevision INTO New.codRevision;
		END

		IF ( New.typStatus = 1 /* DATA_DISABLED */) THEN
		BEGIN
			SELECT Revision FROM NewRevision INTO New.codRevision;
		END

		New.typStatus = ifNegative( New.typStatus, Old.typStatus, New.typStatus);
	END !!
SET TERM ; !!


/*=========================================================*
  @subject: Billing, Receipt
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*/

CREATE EXCEPTION Billing_Exception  'Billing is unrestorable';

SET TERM !! ;
CREATE TRIGGER BeforeInsert_Billing FOR Billing BEFORE INSERT AS
	BEGIN
		IF ( New.keyInstance <= 0) THEN SELECT Revision FROM NewRevision INTO New.keyInstance;
		New.codRevision = New.keyInstance;

		SELECT	strCode,
			strFamilyName,
			strFamilyNameRead,
			strFirstName,
			strFirstNameRead,
			typSex,
			datBirthday
		FROM Profile WHERE keyInstance = New.refProfile
		INTO	New.strCode,
			New.strFamilyName,
			New.strFamilyNameRead,
			New.strFirstName,
			New.strFirstNameRead,
			New.typSex,
			New.datBirthday;

		POST_EVENT 'Billing_Update';
	END !!
SET TERM ; !!

SET TERM !! ;
CREATE TRIGGER AfterInsert_Billing FOR Billing AFTER INSERT AS
	BEGIN
		INSERT INTO Billing_Selector VALUES ( New.keyInstance);
	END !!
SET TERM ; !!

SET TERM !! ;
CREATE TRIGGER BeforeUpdate_Billing FOR Billing BEFORE UPDATE AS
	BEGIN
		IF ( Old.typStatus = 1 /* DATA_DISABLED */) THEN EXCEPTION Billing_Exception;

		IF ( New.typStatus = 0 /* DATA_ENABLED */) THEN
		BEGIN
			SELECT Revision FROM NewRevision INTO New.codRevision;
		END

		IF ( New.typStatus = 1 /* DATA_DISABLED */) THEN
		BEGIN
			SELECT Revision FROM NewRevision INTO New.codRevision;
		END

		New.typStatus = ifNegative( New.typStatus, Old.typStatus, New.typStatus);

		POST_EVENT 'Billing_Update';
	END !!
SET TERM ; !!

CREATE EXCEPTION Receipt_Exception  'Receipt is unrestorable';

SET TERM !! ;
CREATE TRIGGER BeforeInsert_Receipt FOR Receipt BEFORE INSERT AS
	BEGIN
		IF ( New.keyInstance <= 0) THEN SELECT Revision FROM NewRevision INTO New.keyInstance;
		New.codRevision = New.keyInstance;
	END !!
SET TERM ; !!

SET TERM !! ;
CREATE TRIGGER AfterInsert_Receipt FOR Receipt AFTER INSERT AS
	BEGIN
		INSERT INTO Receipt_Selector VALUES ( New.keyInstance);
	END !!
SET TERM ; !!

SET TERM !! ;
CREATE TRIGGER BeforeUpdate_Receipt FOR Receipt BEFORE UPDATE AS
	BEGIN
		IF ( Old.typStatus = 1 /* DATA_DISABLED */) THEN EXCEPTION Receipt_Exception;

		IF ( New.typStatus = 0 /* DATA_ENABLED */) THEN
		BEGIN
			SELECT Revision FROM NewRevision INTO New.codRevision;
		END

		IF ( New.typStatus = 1 /* DATA_DISABLED */) THEN
		BEGIN
			SELECT Revision FROM NewRevision INTO New.codRevision;
		END

		New.typStatus = ifNegative( New.typStatus, Old.typStatus, New.typStatus);
	END !!
SET TERM ; !!


/*=========================================================*
  @subject: Payment, Supply
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*/

CREATE EXCEPTION Payment_Exception  'Payment is unrestorable';

SET TERM !! ;
CREATE TRIGGER BeforeInsert_Payment FOR Payment BEFORE INSERT AS
	BEGIN
		IF ( New.keyInstance <= 0) THEN SELECT Revision FROM NewRevision INTO New.keyInstance;
		New.codRevision = New.keyInstance;

		SELECT	strCode,
			strFamilyName,
			strFamilyNameRead,
			strFirstName,
			strFirstNameRead,
			typSex,
			datBirthday
		FROM Profile WHERE keyInstance = New.refProfile
		INTO	New.strCode,
			New.strFamilyName,
			New.strFamilyNameRead,
			New.strFirstName,
			New.strFirstNameRead,
			New.typSex,
			New.datBirthday;

		POST_EVENT 'Payment_Update';
	END !!
SET TERM ; !!

SET TERM !! ;
CREATE TRIGGER AfterInsert_Payment FOR Payment AFTER INSERT AS
	BEGIN
		INSERT INTO Payment_Selector VALUES ( New.keyInstance);
	END !!
SET TERM ; !!

SET TERM !! ;
CREATE TRIGGER BeforeUpdate_Payment FOR Payment BEFORE UPDATE AS
	BEGIN
		IF ( Old.typStatus = 1 /* DATA_DISABLED */) THEN EXCEPTION Payment_Exception;

		IF ( New.typStatus = 0 /* DATA_ENABLED */) THEN
		BEGIN
			SELECT Revision FROM NewRevision INTO New.codRevision;
		END

		IF ( New.typStatus = 1 /* DATA_DISABLED */) THEN
		BEGIN
			SELECT Revision FROM NewRevision INTO New.codRevision;
		END

		New.typStatus = ifNegative( New.typStatus, Old.typStatus, New.typStatus);

		POST_EVENT 'Payment_Update';
	END !!
SET TERM ; !!

CREATE EXCEPTION Supply_Exception  'Supply is unrestorable';

SET TERM !! ;
CREATE TRIGGER BeforeInsert_Supply FOR Supply BEFORE INSERT AS
	BEGIN
		IF ( New.keyInstance <= 0) THEN SELECT Revision FROM NewRevision INTO New.keyInstance;
		New.codRevision = New.keyInstance;
	END !!
SET TERM ; !!

SET TERM !! ;
CREATE TRIGGER AfterInsert_Supply FOR Supply AFTER INSERT AS
	BEGIN
		INSERT INTO Supply_Selector VALUES ( New.keyInstance);
	END !!
SET TERM ; !!

SET TERM !! ;
CREATE TRIGGER BeforeUpdate_Supply FOR Supply BEFORE UPDATE AS
	BEGIN
		IF ( Old.typStatus = 1 /* DATA_DISABLED */) THEN EXCEPTION Supply_Exception;

		IF ( New.typStatus = 0 /* DATA_ENABLED */) THEN
		BEGIN
			SELECT Revision FROM NewRevision INTO New.codRevision;
		END

		IF ( New.typStatus = 1 /* DATA_DISABLED */) THEN
		BEGIN
			SELECT Revision FROM NewRevision INTO New.codRevision;
		END

		New.typStatus = ifNegative( New.typStatus, Old.typStatus, New.typStatus);
	END !!
SET TERM ; !!


