
INPUT 'Locator.sql';

CREATE DOMAIN CURRENCY AS NUMERIC(9,2);
CREATE DOMAIN TYPECODE AS SMALLINT;
CREATE DOMAIN OPTIONS AS INTEGER;
CREATE DOMAIN BOOLEAN AS SMALLINT DEFAULT 0;
CREATE DOMAIN REVISION AS INTEGER DEFAULT 0 NOT NULL;

CREATE GENERATOR Counter_Revision;
SET GENERATOR Counter_Revision TO 1;

SET TERM !! ;
CREATE PROCEDURE NewRevision RETURNS ( Revision  INTEGER) AS
	BEGIN
		Revision = gen_id( Counter_Revision, 1);
		SUSPEND;
	END !!
SET TERM ; !!

SET TERM !! ;
CREATE PROCEDURE CurrRevision RETURNS ( Revision  INTEGER) AS
	BEGIN
		Revision = gen_id( Counter_Revision, 0);
		SUSPEND;
	END !!
SET TERM ; !!

SET TERM !! ;
CREATE PROCEDURE ReservedRevision ( ReserveCount  INTEGER) RETURNS ( Revision  INTEGER) AS
	BEGIN
		Revision = gen_id( Counter_Revision, ReserveCount) - ReserveCount;
		SUSPEND;
	END !!
SET TERM ; !!

GRANT EXECUTE ON PROCEDURE NewRevision TO User_Client;
GRANT EXECUTE ON PROCEDURE CurrRevision TO User_Client;
GRANT EXECUTE ON PROCEDURE ReservedRevision TO User_Client;


