
/*******************************************************************************
  @file: customUDF.cpp
  @subject: custom UDF library
  @update: 2004/05/08 (Sat) 00:00:00
  = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
 *******************************************************************************/

#include <windows.h>
#include <ibase.h>
#include <time.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <memory.h>
#include <mbstring.h>

BOOL APIENTRY DllEntryPoint( HANDLE hModule, DWORD  ul_reason_for_call,  LPVOID lpReserved){
	return TRUE;
}

/*=========================================================*
  @subject: mod
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*/

extern "C" int  ISC_EXPORT mod( int*  op1, int*  op2){
	return *op1 % *op2;
}


/*=========================================================*
  @subject: bitAnd
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  Make bit based AND-value of two integer.
 *=========================================================*/

extern "C" int  ISC_EXPORT bitAnd( int*  op1, int*  op2){
	return *op1 & *op2;
}


/*=========================================================*
  @subject: bitOr
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  Make bit based OR-value of two integer.
 *=========================================================*/

extern "C" int  ISC_EXPORT bitOr( int*  op1, int*  op2){
	return *op1 | *op2;
}


/*=========================================================*
  @subject: shiftLeft
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  Shift bits to left.
 *=========================================================*/

extern "C" int  ISC_EXPORT shiftLeft( int*  op1, int*  op2){
	return *op1 << *op2;
}


/*=========================================================*
  @subject: shiftRight
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  Shift bits to right.
 *=========================================================*/

extern "C" int  ISC_EXPORT shiftRight( int*  op1, int*  op2){
	return *op1 >> *op2;
}


/*******************************************************************************
  @subject: Date Value Extraction
  @update: 2004/05/08 (Sat) 00:00:00
  = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
 *******************************************************************************/

/*=========================================================*
  @subject: yearOf
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  Extract year number from the date.
 *=========================================================*/

extern "C" int  ISC_EXPORT yearOf( ISC_TIMESTAMP*  timeStamp){

	tm  tmInput;

	isc_decode_timestamp( timeStamp, &tmInput);

	return tmInput.tm_year + 1900;
}


/*=========================================================*
  @subject: monthOf
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  Extract month number from the date.
 *=========================================================*/

extern "C" int  ISC_EXPORT monthOf( ISC_TIMESTAMP*  timeStamp){

	tm  tmInput;

	isc_decode_timestamp( timeStamp, &tmInput);

	return tmInput.tm_mon + 1;
}


/*=========================================================*
  @subject: dayOf
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  Extract day number from the date.
 *=========================================================*/

extern "C" int  ISC_EXPORT dayOf( ISC_TIMESTAMP*  timeStamp){

	tm  tmInput;

	isc_decode_timestamp( timeStamp, &tmInput);

	return tmInput.tm_mday;
}


/*=========================================================*
  @subject: dayOfWeekOf
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  Extract day of week number from the date.
  Day of week number is ranged from 0(Sun) to 6(Sat).
 *=========================================================*/

extern "C" int  ISC_EXPORT dayOfWeekOf( ISC_TIMESTAMP*  timeStamp){

	tm  tmInput;

	isc_decode_timestamp( timeStamp, &tmInput);

	return tmInput.tm_wday;
}


/*=========================================================*
  @subject: dayOfYearOf
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  Extract day number counted from the year top from the date.
  Day of year is ranged from 0 to 365.
 *=========================================================*/

extern "C" int  ISC_EXPORT dayOfYearOf( ISC_TIMESTAMP*  timeStamp){

	tm  tmInput;

	isc_decode_timestamp( timeStamp, &tmInput);

	return tmInput.tm_yday;
}


/*******************************************************************************
  @subject: Time Value Extraction
  @update: 2004/05/08 (Sat) 00:00:00
  = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
 *******************************************************************************/

/*=========================================================*
  @subject: hourOf
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  Extract hour number counted from the date.
  Hour number is ranged from 0 to 23.
 *=========================================================*/

extern "C" int  ISC_EXPORT hourOf( ISC_TIMESTAMP*  timeStamp){

	tm  tmInput;

	isc_decode_timestamp( timeStamp, &tmInput);

	return tmInput.tm_hour;
}


/*=========================================================*
  @subject: minuteOf
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  Extract hour number counted from the date.
  Hour number is ranged from 0 to 59.
 *=========================================================*/

extern "C" int  ISC_EXPORT minuteOf( ISC_TIMESTAMP*  timeStamp){

	tm  tmInput;

	isc_decode_timestamp( timeStamp, &tmInput);

	return tmInput.tm_min;
}


/*=========================================================*
  @subject: secondOf
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  Extract second number counted from the date.
  Second number is ranged from 0 to 59.
 *=========================================================*/

extern "C" int  ISC_EXPORT secondOf( ISC_TIMESTAMP*  timeStamp){

	tm  tmInput;

	isc_decode_timestamp( timeStamp, &tmInput);

	return tmInput.tm_sec;
}


/*******************************************************************************
  @subject: Date Time Subtraction
  @update: 2004/05/08 (Sat) 00:00:00
  = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
 *******************************************************************************/

/*=========================================================*
  @subject: diffSeconds
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  Subtract timeStamp2 from timeStamp1 and returns the result in seconds.
 *=========================================================*/

extern "C" int  ISC_EXPORT diffSeconds( ISC_TIMESTAMP*  timeStamp1, ISC_TIMESTAMP*  timeStamp2){

	tm  tm1;
	tm  tm2;

	isc_decode_timestamp( timeStamp1, &tm1);
	isc_decode_timestamp( timeStamp2, &tm2);

	return mktime( &tm1) - mktime( &tm2);
}


/*=========================================================*
  @subject: diffMinutes
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  Subtract timeStamp2 from timeStamp1 and returns the result in minutes.
 *=========================================================*/

extern "C" int  ISC_EXPORT diffMinutes( ISC_TIMESTAMP*  timeStamp1, ISC_TIMESTAMP*  timeStamp2){
	return diffSeconds( timeStamp1, timeStamp2) / 60;
}


/*=========================================================*
  @subject: diffHours
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  Subtract timeStamp2 from timeStamp1 and returns the result in hours.
 *=========================================================*/

extern "C" int  ISC_EXPORT diffHours( ISC_TIMESTAMP*  timeStamp1, ISC_TIMESTAMP*  timeStamp2){
	return diffSeconds( timeStamp1, timeStamp2) / 3600;
}


/*=========================================================*
  @subject: diffDays
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  Subtract timeStamp2 from timeStamp1 and returns the result in days.
 *=========================================================*/

extern "C" int  ISC_EXPORT diffDays( ISC_TIMESTAMP*  timeStamp1, ISC_TIMESTAMP*  timeStamp2){
	return diffSeconds( timeStamp1, timeStamp2) / 3600 / 24;
}


/*******************************************************************************
  @subject: Value Comparison
  @update: 2004/05/08 (Sat) 00:00:00
  = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
 *******************************************************************************/

extern "C" double  ISC_EXPORT largerOf( double*  op1, double*  op2){
	return *op1 > *op2 ? *op1 : *op2;
}

extern "C" double  ISC_EXPORT smallerOf( double*  op1, double*  op2){
	return *op1 < *op2 ? *op1 : *op2;
}


/*******************************************************************************
  @subject: String Operation
  @update: 2004/05/08 (Sat) 00:00:00
  = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
 *******************************************************************************/

/*=========================================================*
  @subject: lengthOf
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  Count up the byte size of the string.
 *=========================================================*/

extern "C" int  ISC_EXPORT lengthOf( char*  s){
	return strlen( s);
}


/*=========================================================*
  @subject: trim
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  Remove whitespaces on head or on rear of the string.
 *=========================================================*/

extern "C" char*  ISC_EXPORT trim( char*  s){

	char*  p = s;
	while( *p && isspace( (int)(unsigned char)*p)) p ++;

	char*  head = p;
	char*  rear = p;

	while( *p){
		while( *p && !isspace( (int)(unsigned char)*p)) p += _ismbblead( (int)(unsigned char)*p) ? 2 : 1;
		rear = p;
		while( *p && isspace( (int)(unsigned char)*p)) p ++;
	}

	char*  r = (char*)malloc( rear - head + 1);
	if( !r) return 0;

	strncpy( r, head, rear - head);
	r[ rear - head] = 0;

	return r;
}


/*=========================================================*
  @subject: sweep
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  Remove all whitespaces from the string.
 *=========================================================*/

extern "C" char*  ISC_EXPORT sweep( char*  s){

	char*  r = (char*)malloc( strlen( s) + 1);
	if( !r) return 0;

	char*  p = s;
	char*  q = r;

	while( *p){
		if( _ismbblead( *p)){
			if( *(short*)p != 0x4081) *(short*)q = *(short*)p, q += 2;
			p += 2;
		}else{
			if( !isspace( (int)(unsigned char)*p)) *q = *p, q ++;
			p ++;
		}
	}

	*q = 0;

	return r;
}


/*=========================================================*
  @subject: iprintf
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*/

extern "C" char*  ISC_EXPORT iprint( char*  s, int*  val){

	char  buff[ 1024];
	int  len = sprintf( buff, s, *val);

	char*  r = (char*)malloc( len + 1);
	if( !r) return 0;

	strncpy( r, buff, len);
	r[ len] = 0;

	return r;
}


/*=========================================================*
  @subject: sprintf
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*/

extern "C" char*  ISC_EXPORT sprint( char*  s, char*  val){

	char  buff[ 1024];
	int  len = sprintf( buff, s, val);

	char*  r = (char*)malloc( len + 1);
	if( !r) return 0;

	strncpy( r, buff, len);
	r[ len] = 0;

	return r;
}


/*=========================================================*
  @subject: digitsOf
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  Remove non-digits caracters from the string.
 *=========================================================*/

extern "C" char*  ISC_EXPORT digitsOf( char*  s){

	char*  r = (char*)malloc( strlen( s) + 1);
	if( !r) return 0;

	char*  p = r;
	char*  q = s;
	while( *q){
		if( '0' <= *q && *q <= '9') *p ++ = *q;
		q += _ismbblead( *q) ? 2 : 1;
	}
	*p = 0;

	return r;
}


/*=========================================================*
  @subject: capitalsOf
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  Convert string to single byte capital alnums.
 *=========================================================*/

extern "C" char*  ISC_EXPORT capitalsOf( char*  s){

	char*  r = (char*)malloc( strlen( s) + 1);
	if( !r) return 0;

	r[ LCMapString( 0, LCMAP_HALFWIDTH | LCMAP_UPPERCASE, s, strlen( s), r, strlen( s) + 1)] = 0;

	char*  p = r;
	char*  q = r;
	while( *q){
		if( ( '0' <= *q && *q <= '9') || ( 'A' <= *q && *q <= 'Z')) *p ++ = *q;
		q += _ismbblead( *q) ? 2 : 1;
	}
	*p = 0;

	return r;
}


/*******************************************************************************
  @subject: Value Selection
  @update: 2004/05/08 (Sat) 00:00:00
  = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
 *******************************************************************************/

/*=========================================================*
  @subject: ifThen
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  Select integer value from two alternatives by boolean check.
 *=========================================================*/

extern "C" int  ISC_EXPORT ifThen( int*  flag, int*  op1, int*  op2){
	return *flag ? *op1 : *op2;
}


/*=========================================================*
  @subject: ifNothing
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  Select integer value from two alternatives by check if the value is zero or not.
 *=========================================================*/

extern "C" int  ISC_EXPORT ifNothing( int*  flag, int*  op1, int*  op2){
	return *flag == 0 ? *op1 : *op2;
}


/*=========================================================*
  @subject: ifPositive
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  Select integer value from two alternatives by check if the value is positive or not.
 *=========================================================*/

extern "C" int  ISC_EXPORT ifPositive( int*  flag, int*  op1, int*  op2){
	return *flag > 0 ? *op1 : *op2;
}


/*=========================================================*
  @subject: ifNegative
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  Select integer value from two alternatives by check if the value is negative or not.
 *=========================================================*/

extern "C" int  ISC_EXPORT ifNegative( int*  flag, int*  op1, int*  op2){
	return *flag < 0 ? *op1 : *op2;
}


/*=========================================================*
  @subject: Eq
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  Check integer values equality and returns non-zero if true.
 *=========================================================*/

extern "C" int  ISC_EXPORT Eq( int*  op1, int*  op2){
	return *op1 == *op2;
}


/*=========================================================*
  @subject: Ne
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  Resersible version of Eq.
 *=========================================================*/

extern "C" int  ISC_EXPORT Ne( int*  op1, int*  op2){
	return *op1 != *op2;
}


/*=========================================================*
  @subject: EmptyInteger
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*/

extern "C" int  ISC_EXPORT EmptyInteger( int*  op, int*  def){
	return !*op ? *def : *op;
}


/*=========================================================*
  @subject: EmptyString
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*/

extern "C" char*  ISC_EXPORT EmptyString( char*  op, char*  def){
	return ( !op || !strlen( op)) ? def : op;
}


/*=========================================================*
  @subject: EmptyDateTime
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*/

extern "C" ISC_TIMESTAMP*  ISC_EXPORT EmptyDateTime( ISC_TIMESTAMP*  op, ISC_TIMESTAMP*  def){
	return ( !op->timestamp_date && !op->timestamp_time) ? def : op;
}


