/* 
 * Copyright 2007 Tatooine Project <http://tatooine.sourceforge.jp/> 
 *  
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *  
 *     http://www.apache.org/licenses/LICENSE-2.0
 *  
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.tatooine.gtx.filter;

import jp.sf.tatooine.gtx.Filter;

import org.apache.commons.lang.ArrayUtils;

/**
 * Delete.
 *
 * @author  Tooru Noda
 * @version 1.0 2007/04/19
 * @since   JDK5.0 Tiger
 */
public class Delete implements Filter {

	/**
	 * @see jp.sf.tatooine.gtx.Filter#invoke(java.lang.String, java.lang.String[])
	 */
	public String invoke(String value, String[] args) {
		
		if (args.length != 1) {
			throw new IllegalArgumentException("引数が合致しません。delete(str):" + ArrayUtils.toString(args));
		}
		for (int i = 0; i < args[0].length(); i++) {
			value = value.replace(Character.toString(args[0].charAt(i)), "");
		}
		return value;
	}

}
