/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.tatooine.gtx;

import com.sun.org.apache.xerces.internal.parsers.DOMParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import jp.sf.tatooine.base.utils.NameUtils;
import jp.sf.tatooine.gtx.Filter;
import jp.sf.tatooine.gtx.GtxConsts;
import jp.sf.tatooine.gtx.GtxContext;
import jp.sf.tatooine.gtx.GtxException;
import jp.sf.tatooine.gtx.GtxSyntaxException;
import jp.sf.tatooine.gtx.LoopRange;
import jp.sf.tatooine.gtx.Tag;
import jp.sf.tatooine.gtx.filter.Abs;
import jp.sf.tatooine.gtx.filter.Append;
import jp.sf.tatooine.gtx.filter.Binary;
import jp.sf.tatooine.gtx.filter.Capitalize;
import jp.sf.tatooine.gtx.filter.Ceil;
import jp.sf.tatooine.gtx.filter.Center;
import jp.sf.tatooine.gtx.filter.Chomp;
import jp.sf.tatooine.gtx.filter.Chop;
import jp.sf.tatooine.gtx.filter.Classify;
import jp.sf.tatooine.gtx.filter.Default;
import jp.sf.tatooine.gtx.filter.Delete;
import jp.sf.tatooine.gtx.filter.Escape;
import jp.sf.tatooine.gtx.filter.Floor;
import jp.sf.tatooine.gtx.filter.Format;
import jp.sf.tatooine.gtx.filter.Hex;
import jp.sf.tatooine.gtx.filter.Left;
import jp.sf.tatooine.gtx.filter.Length;
import jp.sf.tatooine.gtx.filter.Lowercase;
import jp.sf.tatooine.gtx.filter.Lpad;
import jp.sf.tatooine.gtx.filter.Mid;
import jp.sf.tatooine.gtx.filter.Octal;
import jp.sf.tatooine.gtx.filter.RegexReplace;
import jp.sf.tatooine.gtx.filter.Replace;
import jp.sf.tatooine.gtx.filter.Right;
import jp.sf.tatooine.gtx.filter.Rpad;
import jp.sf.tatooine.gtx.filter.Substring;
import jp.sf.tatooine.gtx.filter.Swapcase;
import jp.sf.tatooine.gtx.filter.Trim;
import jp.sf.tatooine.gtx.filter.Truncate;
import jp.sf.tatooine.gtx.filter.Uncapitalize;
import jp.sf.tatooine.gtx.filter.Underscore;
import jp.sf.tatooine.gtx.filter.Uppercase;
import org.apache.commons.jexl.Expression;
import org.apache.commons.jexl.ExpressionFactory;
import org.apache.commons.jexl.JexlContext;
import org.apache.commons.jexl.JexlHelper;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class GtxParser {
    private static final Pattern PTN_EL = Pattern.compile("\\$\\{(.*?)\\}");
    private static final String REGEXP_IDENTIFIER = "[a-zA-Z_$][a-zA-Z0-9_\\-#$]*";
    private static final String FILTER_SEPARATOR = "\\|";
    private static final String REGEXP_FUNC = "([a-zA-Z_$][a-zA-Z0-9_\\-#$]*)\\s*(\\((.*)\\))?";
    private static final Pattern PTN_FUNC = Pattern.compile("([a-zA-Z_$][a-zA-Z0-9_\\-#$]*)\\s*(\\((.*)\\))?");
    private static final int POS_IDENTIFIER = 1;
    private static final int POS_PARAM_LIST = 3;
    private GtxContext _context = new GtxContext();
    private HashMap<String, Filter> _filterMap = new HashMap();
    private Document _templateXml = null;
    private boolean _outputComment = false;

    public GtxParser() {
        this.initFilterMap();
    }

    private void initFilterMap() {
        this.addFilter(new Abs());
        this.addFilter(new Append());
        this.addFilter(new Binary());
        this.addFilter(new Capitalize());
        this.addFilter(new Ceil());
        this.addFilter(new Center());
        this.addFilter(new Chomp());
        this.addFilter(new Chop());
        this.addFilter(new Classify());
        this.addFilter(new Default());
        this.addFilter(new Delete());
        this.addFilter(new Escape());
        this.addFilter(new Floor());
        this.addFilter(new Format());
        this.addFilter(new Hex());
        this.addFilter(new Left());
        this.addFilter(new Length());
        this.addFilter(new Lowercase());
        this.addFilter(new Lpad());
        this.addFilter(new Mid());
        this.addFilter(new Octal());
        this.addFilter(new RegexReplace());
        this.addFilter(new Replace());
        this.addFilter(new Right());
        this.addFilter(new Rpad());
        this.addFilter(new Substring());
        this.addFilter(new Swapcase());
        this.addFilter(new Trim());
        this.addFilter(new Truncate());
        this.addFilter(new Uncapitalize());
        this.addFilter(new Underscore());
        this.addFilter(new Uppercase());
    }

    public final void addFilter(Filter filter) {
        this._filterMap.put(NameUtils.underscore(filter.getClass().getSimpleName()), filter);
    }

    public final void setContext(GtxContext context) {
        this._context = context;
    }

    public final GtxContext getContext() {
        return this._context;
    }

    public final void parse(InputStream stream) throws IOException, SAXException, GtxSyntaxException {
        this.parse(stream, new GtxContext());
    }

    public boolean isOutputComment() {
        return this._outputComment;
    }

    public void setOutputComment(boolean outputComment) {
        this._outputComment = outputComment;
    }

    public final void parse(InputStream stream, GtxContext context) throws IOException, SAXException, GtxSyntaxException {
        DOMParser parser = new DOMParser();
        parser.parse(new InputSource(stream));
        this._templateXml = parser.getDocument();
        Element rootNode = this._templateXml.getDocumentElement();
        if (this._context != null) {
            context.setParent(this._context);
        }
        this.parseNode(context, rootNode);
    }

    public void print(OutputStream out) {
        try {
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer transformer = transFactory.newTransformer();
            StreamResult sr = new StreamResult(out);
            DOMSource source = new DOMSource(this._templateXml);
            transformer.transform(source, sr);
        }
        catch (TransformerException e) {
            throw new GtxException(e);
        }
    }

    private void parseNode(GtxContext context, Node currentNode) throws GtxSyntaxException {
        if (currentNode.getNodeType() == 3) {
            String value = currentNode.getNodeValue();
            value = this.evaluateEL(context, value);
            currentNode.setNodeValue(value);
        } else if (currentNode.getNodeType() == 7) {
            System.out.print(currentNode.getNodeValue());
        } else if (currentNode.getNodeType() == 1) {
            this.parseElementNode(context, currentNode);
        } else if (currentNode.getNodeType() == 8 && !this._outputComment) {
            Node parent = currentNode.getParentNode();
            parent.removeChild(currentNode);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void parseElementNode(GtxContext context, Node currentNode) throws GtxSyntaxException {
        block25: {
            block26: {
                block27: {
                    block23: {
                        block24: {
                            nsContext = new GtxContext();
                            nsContext.setParent(context);
                            attrs = currentNode.getAttributes();
                            attr = null;
                            attr = attrs.getNamedItemNS("http://tatooine.sourceforge.jp/ns/gtx", "ignore");
                            if (attr == null) break block23;
                            attr.setNodeValue(this.evaluateEL(nsContext, attr.getNodeValue()));
                            if (!Boolean.valueOf(attr.getNodeValue()).booleanValue()) break block24;
                            this.removeAllGtxAttr(attrs);
                            break block25;
                        }
                        attrs.removeNamedItemNS("http://tatooine.sourceforge.jp/ns/gtx", "ignore");
                    }
                    if ((attr = attrs.getNamedItemNS("http://tatooine.sourceforge.jp/ns/gtx", "if")) == null) break block26;
                    attr.setNodeValue(this.evaluateEL(nsContext, attr.getNodeValue()));
                    if (Boolean.valueOf(attr.getNodeValue()).booleanValue()) break block27;
                    parentNode = currentNode.getParentNode();
                    parentNode.removeChild(currentNode);
                    break block25;
                }
                attrs.removeNamedItemNS("http://tatooine.sourceforge.jp/ns/gtx", "if");
            }
            if ((attr = attrs.getNamedItemNS("http://tatooine.sourceforge.jp/ns/gtx", "unless")) == null) ** GOTO lbl35
            attr.setNodeValue(this.evaluateEL(nsContext, attr.getNodeValue()));
            if (Boolean.valueOf(attr.getNodeValue()).booleanValue()) {
                parentNode = currentNode.getParentNode();
                parentNode.removeChild(currentNode);
            } else {
                attrs.removeNamedItemNS("http://tatooine.sourceforge.jp/ns/gtx", "unless");
lbl35:
                // 2 sources

                if ((attr = attrs.getNamedItemNS("http://tatooine.sourceforge.jp/ns/gtx", "inner-text")) != null) {
                    attr.setNodeValue(this.evaluateEL(nsContext, attr.getNodeValue()));
                    innerText = attr.getNodeValue();
                    if (innerText != null) {
                        list = currentNode.getChildNodes();
                        i = 0;
                        while (i < list.getLength()) {
                            currentNode.removeChild(list.item(i));
                            ++i;
                        }
                        currentNode.appendChild(this._templateXml.createTextNode(innerText));
                    }
                    attrs.removeNamedItemNS("http://tatooine.sourceforge.jp/ns/gtx", "inner-text");
                }
                if ((attr = attrs.getNamedItemNS("http://tatooine.sourceforge.jp/ns/gtx", "null")) != null) {
                    attr.setNodeValue(this.evaluateEL(nsContext, attr.getNodeValue()));
                    attrs.removeNamedItemNS("http://tatooine.sourceforge.jp/ns/gtx", "null");
                }
                if ((attr = attrs.getNamedItemNS("http://tatooine.sourceforge.jp/ns/gtx", "for")) != null) {
                    inside = false;
                    indexNode = attrs.getNamedItemNS("http://tatooine.sourceforge.jp/ns/gtx", "index");
                    index = null;
                    if (indexNode != null) {
                        indexNode.setNodeValue(this.evaluateEL(nsContext, indexNode.getNodeValue()));
                        index = indexNode.getNodeValue();
                        if (index != null && !(index = index.trim()).matches("[a-zA-Z_$][a-zA-Z0-9_\\-#$]*")) {
                            throw new GtxSyntaxException(index);
                        }
                        attrs.removeNamedItemNS("http://tatooine.sourceforge.jp/ns/gtx", "index");
                    }
                    if ((insideNode = attrs.getNamedItemNS("http://tatooine.sourceforge.jp/ns/gtx", "inside")) != null) {
                        attrs.removeNamedItemNS("http://tatooine.sourceforge.jp/ns/gtx", "inside");
                        insideNode.setNodeValue(this.evaluateEL(nsContext, insideNode.getNodeValue()));
                        inside = Boolean.valueOf(insideNode.getNodeValue());
                    }
                    attr.setNodeValue(this.evaluateEL(nsContext, attr.getNodeValue()));
                    range = LoopRange.parse(attr.getNodeValue());
                    stepNode = attrs.getNamedItemNS("http://tatooine.sourceforge.jp/ns/gtx", "step");
                    if (stepNode != null) {
                        attrs.removeNamedItemNS("http://tatooine.sourceforge.jp/ns/gtx", "step");
                        stepNode.setNodeValue(this.evaluateEL(nsContext, stepNode.getNodeValue()));
                        range.setStep(Integer.parseInt(stepNode.getNodeValue()));
                    }
                    refNode = currentNode.getNextSibling();
                    parentNode = currentNode.getParentNode();
                    attrs.removeNamedItemNS("http://tatooine.sourceforge.jp/ns/gtx", "for");
                    if (inside) {
                        templateNode = currentNode.cloneNode(true);
                        childNodes = currentNode.getChildNodes();
                        removeCnt = childNodes.getLength();
                        i = 0;
                        while (i < removeCnt) {
                            currentNode.removeChild(childNodes.item(0));
                            ++i;
                        }
                        newChildNodes = templateNode.getChildNodes();
                        i = range.getBegin();
                        while (i < range.getEnd()) {
                            if (index != null) {
                                nsContext.put(index, i);
                            }
                            j = 0;
                            while (j < newChildNodes.getLength()) {
                                newChildNode = newChildNodes.item(j).cloneNode(true);
                                currentNode.appendChild(newChildNode);
                                this.parseNode(nsContext, newChildNode);
                                ++j;
                            }
                            i = range.getNext(i);
                        }
                    } else {
                        templateNode = currentNode.cloneNode(true);
                        parentNode.removeChild(currentNode);
                        i = range.getBegin();
                        while (i < range.getEnd()) {
                            if (index != null) {
                                nsContext.put(index, i);
                            }
                            spacer = refNode.getPreviousSibling();
                            newNode = templateNode.cloneNode(true);
                            parentNode.insertBefore(newNode, refNode);
                            if (spacer != null && spacer.getNodeType() == 3 && spacer.getNodeValue().trim().length() == 0) {
                                parentNode.insertBefore(spacer.cloneNode(false), refNode);
                            }
                            this.parseNode(nsContext, newNode);
                            i = range.getNext(i);
                        }
                    }
                    i = 0;
                    while (i < attrs.getLength()) {
                        value = attrs.item(i).getNodeValue();
                        attrs.item(i).setNodeValue(this.evaluateEL(nsContext, value));
                        ++i;
                    }
                    return;
                }
                i = 0;
                while (i < attrs.getLength()) {
                    value = attrs.item(i).getNodeValue();
                    attrs.item(i).setNodeValue(this.evaluateEL(nsContext, value));
                    ++i;
                }
            }
        }
        childNodes = currentNode.getChildNodes();
        i = 0;
        while (i < childNodes.getLength()) {
            this.parseNode(nsContext, childNodes.item(i));
            ++i;
        }
        this.editTag(nsContext, currentNode);
    }

    String evaluateEL(GtxContext context, String text) throws GtxSyntaxException {
        StringBuffer buf = new StringBuffer();
        try {
            Matcher m = PTN_EL.matcher(text);
            while (m.find()) {
                String el = m.group(1);
                String[] array = el.split(FILTER_SEPARATOR);
                String result = null;
                if (array.length != 0) {
                    Expression e = ExpressionFactory.createExpression((String)array[0].trim());
                    JexlContext jexlContext = JexlHelper.createContext();
                    jexlContext.setVars(context.flatten());
                    Object o = e.evaluate(jexlContext);
                    if (o == null) {
                        result = "null";
                    } else {
                        result = o.toString();
                        int i = 1;
                        while (i < array.length) {
                            String filter = array[i].trim();
                            if (StringUtils.isEmpty((String)filter)) {
                                throw new GtxSyntaxException(text);
                            }
                            result = this.evaluateFilter(result, filter);
                            ++i;
                        }
                        Map map = jexlContext.getVars();
                        Iterator iterator = map.entrySet().iterator();
                        while (iterator.hasNext()) {
                            Map.Entry entry;
                            Map.Entry tmp = entry = iterator.next();
                            context.put((String)tmp.getKey(), tmp.getValue());
                        }
                    }
                }
                m.appendReplacement(buf, result);
            }
            m.appendTail(buf);
        }
        catch (Exception e) {
            throw new GtxSyntaxException(e);
        }
        return buf.toString();
    }

    String evaluateFilter(String value, String filter) throws GtxSyntaxException {
        try {
            Matcher m = PTN_FUNC.matcher(filter);
            if (!m.matches()) {
                throw new GtxSyntaxException(filter);
            }
            String id = m.group(1);
            String[] params = new String[]{};
            if (m.group(3) != null) {
                params = m.group(3).split(",");
                int i = 0;
                while (i < params.length) {
                    params[i] = params[i].trim();
                    ++i;
                }
            }
            if (!this._filterMap.containsKey(id)) {
                throw new GtxSyntaxException("Unknown Filter name. : " + id);
            }
            Filter filterObj = this._filterMap.get(id);
            return filterObj.invoke(value, params);
        }
        catch (Exception e) {
            throw new GtxSyntaxException(e);
        }
    }

    private void removeAllGtxAttr(NamedNodeMap attrs) {
        for (String name : GtxConsts.ATTR_NAMES) {
            if (attrs.getNamedItemNS("http://tatooine.sourceforge.jp/ns/gtx", name) == null) continue;
            attrs.removeNamedItemNS("http://tatooine.sourceforge.jp/ns/gtx", name);
        }
    }

    private void editTag(GtxContext context, Node currentNode) {
        Tag tag;
        String nodeName = currentNode.getNodeName();
        Node id = currentNode.getAttributes().getNamedItem("id");
        if (id != null && (tag = context.getTag(id.getNodeValue())) != null) {
            String tagName = tag.getTagName();
            if (tagName != null && !nodeName.equalsIgnoreCase(tagName)) {
                throw new IllegalArgumentException("id(" + id.getNodeValue() + ")\u306e\u6574\u5408\u6027\u304c\u53d6\u308c\u3066\u3044\u307e\u305b\u3093\uff1a" + nodeName + ":" + tagName);
            }
            Map<String, String> attrMap = tag.getRawMap();
            for (String key : attrMap.keySet()) {
                Attr node = currentNode.getOwnerDocument().createAttribute(key);
                node.setNodeValue(attrMap.get(key));
                currentNode.getAttributes().setNamedItem(node);
            }
        }
    }
}

