package jp.sf.tatooine.gtx.filter;

import jp.sf.tatooine.gtx.Filter;

import org.apache.commons.lang.ArrayUtils;

public class Default implements Filter {

	/**
	 * @see jp.sf.tatooine.gtx.Filter#invoke(java.lang.String, java.lang.String[])
	 */
	public String invoke(String value, String[] args) {
		
		if (args.length != 1) {
			throw new IllegalArgumentException("引数が合致しません。default(str):" + ArrayUtils.toString(args));
		}
		if (value == null || value.trim().length() == 0) {
			return args[0];
		}
		return value;
	}

}
