package jp.sf.tatooine.gtx.filter;

import static org.junit.Assert.*;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class RoundTest {

	@Before
	public void setUp() throws Exception {
	}

	@After
	public void tearDown() throws Exception {
	}

	@Test
	public void testInvoke() {
		
		Round target = new Round();
		
		String result = null;
		result = target.invoke("12345.6789", null);
		assertEquals("12346", result);
		
		result = target.invoke("12345.4321", null);
		assertEquals("12345", result);
		
		result = target.invoke("-12345.6789", null);
		assertEquals("-12346", result);
		
		result = target.invoke("12345", null);
		assertEquals("12345", result);
		
		try {
			result = target.invoke("--12345.6789", null);
			fail();
		}
		catch (NumberFormatException e) { }
		
		try {
			result = target.invoke("abc", null);
			fail();
		}
		catch (NumberFormatException e) { }
	}

	@Test
	public void testInvoke2() {
		
		Round target = new Round();
		
		String result = null;
		String[] args = {"2"};
		result = target.invoke("12345.6789", args);
		assertEquals("12345.68", result);
		
		result = target.invoke("-12345.6789", args);
		assertEquals("-12345.68", result);
		
		String[] args2 = {"-2"};
		try {
			result = target.invoke("12345", args2);
			fail();
		}
		catch (IllegalArgumentException e) { }
		
		try {
			result = target.invoke("12345.6789", new String[] {"a"});
			fail();
		}
		catch (NumberFormatException e) { }
	}
	
}
