/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.tatooine.gtx;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import jp.sf.tatooine.gtx.Filter;
import jp.sf.tatooine.gtx.GtxContext;
import jp.sf.tatooine.gtx.GtxSyntaxException;
import jp.sf.tatooine.gtx.GtxTemplate;
import jp.sf.tatooine.gtx.GtxTemplateHandler;
import jp.sf.tatooine.gtx.node.ELUtils;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class GtxParser {
    private boolean _ignoreSpace = false;
    private boolean _ignoreComment = false;
    private GtxContext _context;

    public final void setIgnoreComment(boolean ignoreComment) {
        this._ignoreComment = ignoreComment;
    }

    public final void setIgnoreSpace(boolean ignoreSpace) {
        this._ignoreSpace = ignoreSpace;
    }

    public final void setContext(GtxContext context) {
        this._context = context;
    }

    public final void addFilter(Filter filter) {
        ELUtils.addFilter(filter);
    }

    public final GtxTemplate parse(InputStream stream) throws IOException, SAXException, GtxSyntaxException {
        GtxTemplateHandler handler = new GtxTemplateHandler();
        handler.setIgnoreSpace(this._ignoreSpace);
        handler.setIgnoreComment(this._ignoreComment);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            SAXParser parser = factory.newSAXParser();
            parser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            parser.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
            parser.setProperty("http://apache.org/xml/properties/input-buffer-size", 10000);
            parser.parse(new InputSource(stream), (DefaultHandler)handler);
            GtxTemplate template = handler.getGtxTemplate();
            if (this._context != null) {
                template.setContext(this._context);
            }
            template.setIgnoreSpace(this._ignoreSpace);
            return template;
        }
        catch (SAXException e) {
            e.printStackTrace();
            throw new IOException(e.getLocalizedMessage());
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            throw new IOException(e.getLocalizedMessage());
        }
    }
}

