/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.tatooine.gtx;

import java.io.PrintStream;
import java.util.List;
import jp.sf.tatooine.gtx.GtxContext;
import jp.sf.tatooine.gtx.GtxSyntaxException;
import jp.sf.tatooine.gtx.node.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GtxTemplate {
    private List<Node> _topLevelList;
    private GtxContext _context = null;
    private boolean _ignoreSpace = false;

    protected final void setIgnoreSpace(boolean ignoreSpace) {
        this._ignoreSpace = ignoreSpace;
    }

    protected final void setContext(GtxContext context) {
        this._context = context;
    }

    protected void setTopLevelList(List<Node> topLevelList) {
        this._topLevelList = topLevelList;
    }

    public void evaluate(PrintStream out) throws GtxSyntaxException {
        this.evaluate(out, new GtxContext());
    }

    public void evaluate(PrintStream out, GtxContext context) throws GtxSyntaxException {
        if (this._context != null) {
            context.setParent(this._context);
        }
        StringBuilder builder = new StringBuilder();
        this.evaluate(builder, context);
        out.println(builder.toString());
    }

    public void evaluate(StringBuilder builder) throws GtxSyntaxException {
        this.evaluate(builder, new GtxContext());
    }

    public void evaluate(StringBuilder builder, GtxContext context) throws GtxSyntaxException {
        if (this._context != null) {
            context.setParent(this._context);
        }
        for (Node node : this._topLevelList) {
            node.evaluate(builder, context);
            if (this._ignoreSpace) continue;
            builder.append("\n");
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Node node : this._topLevelList) {
            builder.append(node.toString()).append("\n");
        }
        return builder.toString();
    }
}

