/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.tatooine.gtx.node;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sf.tatooine.base.utils.NameUtils;
import jp.sf.tatooine.gtx.Filter;
import jp.sf.tatooine.gtx.GtxContext;
import jp.sf.tatooine.gtx.GtxSyntaxException;
import jp.sf.tatooine.gtx.filter.Abs;
import jp.sf.tatooine.gtx.filter.Append;
import jp.sf.tatooine.gtx.filter.Binary;
import jp.sf.tatooine.gtx.filter.Capitalize;
import jp.sf.tatooine.gtx.filter.Ceil;
import jp.sf.tatooine.gtx.filter.Center;
import jp.sf.tatooine.gtx.filter.Chomp;
import jp.sf.tatooine.gtx.filter.Chop;
import jp.sf.tatooine.gtx.filter.Classify;
import jp.sf.tatooine.gtx.filter.Default;
import jp.sf.tatooine.gtx.filter.Delete;
import jp.sf.tatooine.gtx.filter.Escape;
import jp.sf.tatooine.gtx.filter.Floor;
import jp.sf.tatooine.gtx.filter.Format;
import jp.sf.tatooine.gtx.filter.Hex;
import jp.sf.tatooine.gtx.filter.Left;
import jp.sf.tatooine.gtx.filter.Length;
import jp.sf.tatooine.gtx.filter.Lowercase;
import jp.sf.tatooine.gtx.filter.Lpad;
import jp.sf.tatooine.gtx.filter.Mid;
import jp.sf.tatooine.gtx.filter.Octal;
import jp.sf.tatooine.gtx.filter.RegexReplace;
import jp.sf.tatooine.gtx.filter.Replace;
import jp.sf.tatooine.gtx.filter.Right;
import jp.sf.tatooine.gtx.filter.Rpad;
import jp.sf.tatooine.gtx.filter.Substring;
import jp.sf.tatooine.gtx.filter.Swapcase;
import jp.sf.tatooine.gtx.filter.Trim;
import jp.sf.tatooine.gtx.filter.Truncate;
import jp.sf.tatooine.gtx.filter.Uncapitalize;
import jp.sf.tatooine.gtx.filter.Underscore;
import jp.sf.tatooine.gtx.filter.Uppercase;
import jp.sf.tatooine.gtx.node.GtxEvaluateable;
import org.apache.commons.jexl.Expression;
import org.apache.commons.jexl.ExpressionFactory;
import org.apache.commons.jexl.JexlContext;
import org.apache.commons.jexl.JexlHelper;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ELUtils {
    private static final Pattern PTN_EL = Pattern.compile("\\$\\{(.*?)\\}");
    private static final String REGEXP_IDENTIFIER = "[a-zA-Z_$][a-zA-Z0-9_\\-#$]*";
    private static final String FILTER_SEPARATOR = "\\|";
    private static final String REGEXP_FUNC = String.format("(%s)\\s*(\\((.*)\\))?", "[a-zA-Z_$][a-zA-Z0-9_\\-#$]*");
    private static final Pattern PTN_FUNC = Pattern.compile(REGEXP_FUNC);
    private static final int POS_IDENTIFIER = 1;
    private static final int POS_PARAM_LIST = 3;
    private static final HashMap<String, Filter> _filterMap = new HashMap();

    static {
        ELUtils.addFilter(new Abs());
        ELUtils.addFilter(new Append());
        ELUtils.addFilter(new Binary());
        ELUtils.addFilter(new Capitalize());
        ELUtils.addFilter(new Ceil());
        ELUtils.addFilter(new Center());
        ELUtils.addFilter(new Chomp());
        ELUtils.addFilter(new Chop());
        ELUtils.addFilter(new Classify());
        ELUtils.addFilter(new Default());
        ELUtils.addFilter(new Delete());
        ELUtils.addFilter(new Escape());
        ELUtils.addFilter(new Floor());
        ELUtils.addFilter(new Format());
        ELUtils.addFilter(new Hex());
        ELUtils.addFilter(new Left());
        ELUtils.addFilter(new Length());
        ELUtils.addFilter(new Lowercase());
        ELUtils.addFilter(new Lpad());
        ELUtils.addFilter(new Mid());
        ELUtils.addFilter(new Octal());
        ELUtils.addFilter(new RegexReplace());
        ELUtils.addFilter(new Replace());
        ELUtils.addFilter(new Right());
        ELUtils.addFilter(new Rpad());
        ELUtils.addFilter(new Substring());
        ELUtils.addFilter(new Swapcase());
        ELUtils.addFilter(new Trim());
        ELUtils.addFilter(new Truncate());
        ELUtils.addFilter(new Uncapitalize());
        ELUtils.addFilter(new Underscore());
        ELUtils.addFilter(new Uppercase());
    }

    private ELUtils() {
    }

    public static final void addFilter(Filter filter) {
        _filterMap.put(NameUtils.underscore(filter.getClass().getSimpleName()), filter);
    }

    public static final List<GtxEvaluateable> parse(String value) {
        return null;
    }

    public static final String evaluateEL(GtxContext context, String text) throws GtxSyntaxException {
        StringBuffer buf = new StringBuffer();
        try {
            Matcher m = PTN_EL.matcher(text);
            while (m.find()) {
                String el = m.group(1);
                String[] array = el.split(FILTER_SEPARATOR);
                String result = null;
                if (array.length != 0) {
                    Expression e = ExpressionFactory.createExpression((String)array[0].trim());
                    JexlContext jexlContext = JexlHelper.createContext();
                    jexlContext.setVars(context.flatten());
                    Object o = e.evaluate(jexlContext);
                    if (o == null) {
                        result = "";
                    } else {
                        result = o.toString();
                        int i = 1;
                        while (i < array.length) {
                            String filter = array[i].trim();
                            if (StringUtils.isEmpty((String)filter)) {
                                throw new GtxSyntaxException(text);
                            }
                            result = ELUtils.evaluateFilter(result, filter);
                            ++i;
                        }
                        Map map = jexlContext.getVars();
                        Iterator iterator = map.entrySet().iterator();
                        while (iterator.hasNext()) {
                            Map.Entry entry;
                            Map.Entry tmp = entry = iterator.next();
                            context.put((String)tmp.getKey(), tmp.getValue());
                        }
                    }
                }
                m.appendReplacement(buf, result);
            }
            m.appendTail(buf);
        }
        catch (Exception e) {
            throw new GtxSyntaxException(e);
        }
        return buf.toString();
    }

    private static final String evaluateFilter(String value, String filter) throws GtxSyntaxException {
        try {
            Matcher m = PTN_FUNC.matcher(filter);
            if (!m.matches()) {
                throw new GtxSyntaxException(filter);
            }
            String id = m.group(1);
            String[] params = new String[]{};
            if (m.group(3) != null) {
                params = m.group(3).split(",");
                int i = 0;
                while (i < params.length) {
                    params[i] = params[i].trim();
                    ++i;
                }
            }
            if (!_filterMap.containsKey(id)) {
                throw new GtxSyntaxException("Unknown Filter name. : " + id);
            }
            Filter filterObj = _filterMap.get(id);
            return filterObj.invoke(value, params);
        }
        catch (Exception e) {
            throw new GtxSyntaxException(e);
        }
    }
}

