/* 
 * Copyright 2007 Tatooine Project <http://tatooine.sourceforge.jp/> 
 *  
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *  
 *     http://www.apache.org/licenses/LICENSE-2.0
 *  
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.tatooine.gtx.node;

import jp.sf.tatooine.gtx.GtxConsts;
import jp.sf.tatooine.gtx.GtxContext;
import jp.sf.tatooine.gtx.GtxSyntaxException;

import org.apache.commons.lang.StringUtils;

/**
 * Namespace.
 *
 * @author  Tooru Noda
 * @version 1.0 2007/09/10
 * @since   JDK5.0 Tiger
 */
public class Namespace extends Attribute {

	/**
	 * コンストラクタ.
	 * 
	 * @param name		名前空間プレフィックス
	 * @param value		名前空間URI
	 */
	public Namespace(String name, String value) {
		super(GtxAttributeType.NA, name, value);
	}

	/**
	 * @see jp.sf.tatooine.gtx.node.GtxEvaluateable
	 * 		#evaluate(StringBuilder, jp.sf.tatooine.gtx.GtxContext)
	 */
	public void evaluate(StringBuilder builder, GtxContext context) 
			throws GtxSyntaxException {
		
		if (GtxConsts.GTX_SCHEMA.equals(getValue())) {
			return;
		}
		builder.append("xmlns");
		if (!StringUtils.isEmpty(super.getName())) {
			builder.append(":");
		}
		super.evaluate(builder, context);
	}

	/**
	 * @see jp.sf.tatooine.gtx.node.Attribute#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("xmlns");
		if (!StringUtils.isEmpty(super.getName())) {
			builder.append(":");
		}
		builder.append(super.toString());
		return builder.toString();
	}

}
