/* 
 * Copyright 2007 Tatooine Project <http://tatooine.sourceforge.jp/> 
 *  
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *  
 *     http://www.apache.org/licenses/LICENSE-2.0
 *  
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.tatooine.gtx;

import static org.junit.Assert.*;

import java.awt.Point;
import java.io.File;
import java.io.FileInputStream;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

/**
 * GtxTemplateTest.
 *
 * @author  Tooru Noda
 * @version 1.0 2007/04/16
 * @since   JDK5.0 Tiger
 */
public class GtxParserOldTest {
	
	private GtxParserOld _parser = null;
	
	private FileInputStream _in = null;

	@Before
	public void setUp() throws Exception {
		_parser = new GtxParserOld();
		_in = new FileInputStream(new File("./src/test/resources/test_n.xml"));
	}

	@After
	public void tearDown() throws Exception {
		if (_in != null) {
			_in.close();
		}
	}

//	@Test
	public void testExecute() throws Exception {
		
		System.out.println(new File(".").getAbsolutePath());
		
		GtxContext context = new GtxContext();
		context.put("sampleString", "abcdefg");
		
		Tag summaryTable = new Tag("table");
		summaryTable.setAttribute("summary", "uwagaki");
		summaryTable.setAttribute("testAttrName1", "testAttrValue1");
		summaryTable.setAttribute("testAttrName2", "testAttrValue2");
		summaryTable.setAttribute("testAttrName3", "testAttrValue3");
		context.bindById("summaryTable", summaryTable);
		
		_parser.parse(_in, context);
		
		_parser.print(System.out);
	}

	@Test
	public void testExecute2() throws Exception {
		
		System.out.println(new File(".").getAbsolutePath());
		
		GtxContext context = new GtxContext();
		context.put("sampleString", "abcdefg");
		
		Tag txt1 = new Tag("input");
		txt1.setAttribute("value", "1111");
		context.bindById("txt1", txt1);
		
		Tag txt2 = new Tag("input");
		txt2.setAttribute("value", "2222");
		context.bindById("txt2", txt2);
		
		Tag txt3 = new Tag("input");
		txt3.setAttribute("value", "3333");
		context.bindById("txt3", txt3);
		
		Tag txt4 = new Tag("input");
		txt4.setAttribute("value", "4444");
		context.bindById("txt4", txt4);
		
		Tag txt5 = new Tag("input");
		txt5.setAttribute("value", "5555");
		context.bindById("txt5", txt5);
		
		_parser.parse(_in, context);
		
		_parser.print(System.out);
	}
	
	@Test
	public void testEvaluateEL1() {
		String result = null;
		try {
			Point p1 = new Point(1, 2);
			GtxContext context = new GtxContext();
			context.put("p1", p1);
			result = _parser.evaluateEL(context, "${p1.x}");
			
			assertEquals(p1.getX(), Double.valueOf(result));
			
			result = _parser.evaluateEL(context, "xxxxx${p1.x}xxxxx");
			
			assertEquals("xxxxx" + p1.getX() + "xxxxx", result);
		}
		catch (GtxSyntaxException e) {
			e.printStackTrace();
			fail(result);
		}
	}
	
	@Test
	public void testEvaluateEL2() {
		String result = null;
		try {
			Point p1 = new Point(1, 2);
			GtxContext context = new GtxContext();
			context.put("p1", p1);
			result = _parser.evaluateEL(context, "${p2.x}");
			
			assertEquals("", result);
		}
		catch (GtxSyntaxException e) {
			e.printStackTrace();
			fail(result);
		}
	}
}
