/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.tatooine.gtx.node;

import jp.sf.tatooine.gtx.GtxContext;
import jp.sf.tatooine.gtx.GtxSyntaxException;
import jp.sf.tatooine.gtx.node.Node;

public class DTDNode
extends Node {
    private static final String DOCTYPE_PREFIX = "<!DOCTYPE ";
    private static final String PUBLIC_DECL_START = " PUBLIC \"";
    private static final String SYSTEM_DECL_START1 = " SYSTEM \"";
    private static final String SYSTEM_DECL_START2 = "\" \"";
    private static final String DECL_END = "\"";
    private String _name;
    private String _publicId;
    private String _systemId;

    public DTDNode(String name, String publicId, String systemId) {
        this._name = name;
        this._publicId = publicId;
        this._systemId = systemId;
    }

    public void evaluate(StringBuilder builder, GtxContext context) throws GtxSyntaxException {
        builder.append(this.toString());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(DOCTYPE_PREFIX);
        builder.append(this._name);
        if (this._publicId == null) {
            builder.append(SYSTEM_DECL_START1);
        } else {
            builder.append(PUBLIC_DECL_START);
            builder.append(this._publicId);
            builder.append(SYSTEM_DECL_START2);
        }
        builder.append(this._systemId);
        builder.append(DECL_END);
        builder.append(">");
        return builder.toString();
    }
}

