#ifndef _TMDLISTED_PTR_HPP
#define _TMDLISTED_PTR_HPP


//#include <cstddef>            // std::::std::size_t
#include <algorithm>          // std::swap

namespace tempest{
	
template<class T>
class dlisted_ptr{
public:
	typedef dlisted_ptr<T> this_type;
	typedef const this_type link_type;

	typedef T element_type;
public:
	
	explicit dlisted_ptr(T * p = 0):ptr(p){
		isolate();
	}
	
	dlisted_ptr(const this_type & other):ptr(other.ptr){
		(next = other.next)->prev = this;
		(prev = &other    )->next = this;
		/*
		next = other.next;
		prev = &other;
		other.next->prev = this;
		other.next = this;
		*/		
	}
	
	~dlisted_ptr() throw(){
		withdrawal();	
	}
	
	this_type& operator=(const this_type & other) {
		if( other.ptr != ptr ){//not same group!
			withdrawal();			
			(next = other.next)->prev = this;
            (prev = &other    )->next = this;
			/*
			next = other.next;
			prev = &other;
			other.next->prev = this;
			other.next = this;
			*/
			ptr = other.ptr;		
		}
		
		return *this;
	}
	
	void reset(T* p = 0) throw() {
		if(p != ptr){//not same group!
			withdrawal();			
			isolate();
			ptr = p;
		}
	}
	
	
	T & operator*()  const throw() { return *ptr; }
	T * operator->() const throw() { return  ptr; }
	T * get()        const throw() { return  ptr; }
	
	void swap( this_type & other ) throw() {
		 this_type * that           = &other;
         bool	this_isolated  = is_only();
         bool	that_isolated  = that->is_only();
		
		//
		
		std::swap( ptr, other.ptr );
		
		//

		 if ( this_isolated )
		 {								  // if both isolated, do nothing
			if ( !that_isolated )		  // but if only this is:
			{
			   next = that->next;
			   prev = that->prev;

			   next->prev = this;			// adjust back pointers
			   prev->next = this;

			   that->isolate();
			}
		 }
		 else if ( that_isolated )		  // and this isn't
		 {								  
			that->next = next;
			that->prev = prev;
		 
			next->prev = that;			// adjust back pointers
			prev->next = that;

			isolate();
		 }
		 else							  // neither isolated - full blown swap
		 {
			next->prev = that;			// adjust back pointers
			prev->next = that;

			std::swap( next, that->next );
			std::swap( prev, that->prev );

			next->prev = this;			// adjust back pointers
			prev->next = this;
		 }		
	}
	
	//utilties
	bool is_only()const throw(){
		return (this == next);	
	}
	
private:
	void isolate() throw(){
         next = prev = this;
	}
	
	void withdrawal() throw(){
		if(is_only()){//this-->this
			delete ptr;
		}else{
			prev->next = next;
			next->prev = prev;
		}	
	}
private:
	mutable link_type * next;
	mutable link_type * prev;
	T* ptr;
};

}

namespace std{
	template<class T>
	inline void swap(tempest::dlisted_ptr<T> & lhs,tempest::dlisted_ptr<T> & rhs){
		lhs.swap(rhs);
	}
}


#endif


