#include"../vector/matrix.hpp"
#include"../vector/matrix4.hpp"
#include"../vector/matrix3.hpp"
#include"../vector/matrix2.hpp"
#include"../vector/transform.hpp"
#include"../vector/matrix_generator.hpp"

#include"../vector/vector.hpp"
#include"../vector/vector3.hpp"
//#include"../vector/safety_matrix.hpp"

#include<cstring>

#include <cppunit/extensions/HelperMacros.h>
#include <cppunit/TestAssert.h>

#include <cppunit/ui/text/TestRunner.h>
#include <cppunit/TextOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>


#include<iostream>

using namespace std;

class MatrixTest : public CppUnit::TestFixture {
	CPPUNIT_TEST_SUITE(MatrixTest); // [4]
		CPPUNIT_TEST(testStyle);      // [5]
		CPPUNIT_TEST(testOperation);
	
	CPPUNIT_TEST_SUITE_END();    // [4]	
public:
	virtual void setUp() {}
	virtual void tearDown() {}	
public:
	void testStyle();
	void testOperation();

private:
	typedef tempest::vector<double ,3> VEC;
	typedef tempest::matrix<double ,2> V2;
	typedef tempest::matrix<double ,3> V3;
	typedef tempest::matrix<double ,4> V4;
	typedef tempest::matrix<double ,5> V5;
	//typedef tempest::safety_matrix<double ,3> SV;
	
	//SV sv;
	typedef tempest::matrix_generator<V2> V2GEN;
	typedef tempest::matrix_generator<V3> V3GEN;
	typedef tempest::matrix_generator<V4> V4GEN;
	typedef tempest::matrix_generator<V5> V5GEN;
	
	V2 v2;
	V3 v3;
	V4 v4;
	V5 v5;
};
/*
CPPUNIT_ASSERT( condition );
conditionU(false,0)łƂAs܂B

CPPUNIT_ASSERT_MESSAGE( message, condition );
conditionUłƂAs܂B̂Ƃmessageo͂܂B

CPPUNIT_FAIL( message );
Ks܂Bmessageo͂܂B

CPPUNIT_ASSERT_EQUAL( expected, actual );
ꂽactual҂lexpectedłȂƂAȂ킿expected != actual̂ƂɎs܂B

CPPUNIT_ASSERT_EQUAL_MESSAGE( message, expected, actual );
ꂽactual҂lexpectedłȂƂAȂ킿expected != actual̂ƂɎs܂B̂Ƃmessageo͂܂B

CPPUNIT_ASSERT_DOUBLES_EQUAL( expected, actual, delta );
ꂽactualƊ҂lexpectedƂ̍delta傫ƂAs܂B
*/

void MatrixTest::testStyle(){	
	CPPUNIT_ASSERT(strcmp( v2.debug(), "tempest::matrix<T,2>" ) == 0);
	CPPUNIT_ASSERT(strcmp( v3.debug(), "tempest::matrix<T,3>" ) == 0);
	CPPUNIT_ASSERT(strcmp( v4.debug(), "tempest::matrix<T,4>" ) == 0);
	CPPUNIT_ASSERT(strcmp( v5.debug(), "tempest::matrix<T,RowSz,ColumnSz>" ) == 0);
	//CPPUNIT_ASSERT(strcmp( sv.debug(), "tempest::safety_matrix<T,Sz>" ) == 0);
}
//-------------------//
#define _DEBUG
template<class T, std::size_t Sz>
tempest::matrix<T,Sz> helper(const tempest::matrix<T,Sz> & rhs){
	tempest::matrix<T,Sz> temp;
	for(int i = 0;i < Sz;++i){
		for(int j = 0;j < Sz;++j){
			if(std::fabs(rhs[i][j])< 0.0001){
				temp[i][j] = T(0);				
			}else{
				temp[i][j] = rhs[i][j];
			}
		}
	}
	return temp;
}

void MatrixTest::testOperation(){
	double a[100];
	for(int i = 0;i < 100; i++){a[i] = (i+1);}	
	CPPUNIT_ASSERT( (V2(a)+V2(a+4)*V2(a+8)/2.) != V2GEN::identity()  );
	CPPUNIT_ASSERT( (V3(a)+V3(a+9)*V3(a+18)/2.) != V3GEN::identity()  );
	CPPUNIT_ASSERT( (V4(a)+V4(a+16)*V4(a+32)/2.) != V4GEN::identity()  );
	CPPUNIT_ASSERT( (V5(a)+V5(a+25)*V5(a+50)/2.) != V5GEN::identity()  );
	
	
	CPPUNIT_ASSERT_EQUAL(helper(V2GEN::identity()), helper(~V2GEN::rotation_z(30/180.*3.1415)*V2GEN::rotation_z(30/180.*3.1415) ) );
	CPPUNIT_ASSERT_EQUAL(helper(V3GEN::identity()), helper(~V3GEN::rotation_y(30/180.*3.1415)*V3GEN::rotation_y(30/180.*3.1415) ) );
	CPPUNIT_ASSERT_EQUAL(helper(V4GEN::identity()), helper(~V4GEN::rotation_x(30/180.*3.1415)*V4GEN::rotation_x(30/180.*3.1415) ) );
	
	CPPUNIT_ASSERT_EQUAL( V2(a).transpose().transpose() , V2(a) );
	CPPUNIT_ASSERT_EQUAL( V3(a).transpose().transpose() , V3(a) );
	CPPUNIT_ASSERT_EQUAL( V4(a).transpose().transpose() , V4(a) );
	CPPUNIT_ASSERT_EQUAL(transpose(  transpose( V5(a) )  ) , V5(a) );
	
	CPPUNIT_ASSERT_EQUAL(VEC(0,0,1.414), V4GEN::world2camera(VEC(0,0,0),VEC(1,1,0),VEC(0,1,0))*VEC(1,1,0) );
	
}




CPPUNIT_TEST_SUITE_REGISTRATION(MatrixTest);

int main() {
	CppUnit::TextUi::TestRunner runner;
	runner.addTest(CppUnit::TestFactoryRegistry::getRegistry().makeTest());
	CppUnit::Outputter* outputter = new CppUnit::TextOutputter(&runner.result(),std::cout);
	runner.setOutputter(outputter);
	return runner.run() ? 0 : 1;
}

