#ifndef _TMSLISTED_PTR_HPP
#define _TMSLISTED_PTR_HPP

//#include <cstddef>            // std::::std::size_t
#include <algorithm>          // std::swap

namespace tempest{
	
template<class T>
class slisted_ptr{
public:	
	typedef slisted_ptr<T> this_type;
	typedef const this_type link_type;

	typedef T element_type;
	
public:
	
	explicit slisted_ptr(T * p = 0):ptr(p){next = this;}
	slisted_ptr(const this_type & rhs):ptr(rhs.ptr){
		next = rhs.next;
		rhs.next = this;
		//(next = rhs.next)-> this;
	}
	
	~slisted_ptr(){
		withdrawal();	
	}
	
	this_type& operator=(const this_type & rhs){
		if(rhs.ptr != ptr){//same group!
			withdrawal();			
			next = rhs.next;
			rhs.next = this;
			//(next = rhs.next)-> this;
			ptr = rhs.ptr;
		}
			
		return *this;
	}
	
	
	void reset(T* p = 0){
		if(p != ptr){//same group!
			withdrawal();			
			next = this;	
			ptr = p;
		}
	}
	
		
	T & operator*()  const throw() { return *ptr; }
	T * operator->() const throw() { return  ptr; }
	T * get()        const throw() { return  ptr; }
	
	void swap( this_type & other ) throw() {
		 this_type * that           = &other;
         bool	this_isolated  = is_only();
         bool	that_isolated  = that->is_only();
		
		//
		
		std::swap( ptr, other.ptr );
		
		//

		 if ( this_isolated )
		 {								  // if both isolated, do nothing
			if ( !that_isolated )		  // but if only this is:
			{
			   next = that->next;

			   that->isolate();
			}
		 }
		 else if ( that_isolated )		  // and this isn't
		 {								  
			that->next = next;
		 		 	
			isolate();
		 }
		 else							  // neither isolated - full blown swap
		 {
			std::swap( next, that->next );
		 }		
	}
	
	//utilties
	bool is_only()const throw(){
		return (this == next);
	}
private:	
	void isolate() throw(){//I do HIKIKOMORI.
         next = this;
	}	
	
	const this_type* search_prev(){
		link_type* current = this;
		while(current->next != this){
			current = current->next;
		}
		return current;
	}
	
	void withdrawal(){
		if(is_only()){//this-->this
			delete ptr;
		}else{
			link_type* prev = search_prev();
			prev->next = next;
		}	
	}
private:
	mutable link_type* next;//next is not const ! This means pointer for const this_type.   
	T* ptr;
};

}

namespace std{
	template<class T>
	inline void swap(tempest::slisted_ptr<T> & lhs,tempest::slisted_ptr<T> & rhs){
		lhs.swap(rhs);
	}
}

#endif

