#ifndef _TMET_VECTOR_HPP
#define _TMET_VECTOR_HPP

/** 
 *	@file et_vector.hpp
 *	@brief Defines structs and functions related for ET(Expression Template).
 *	@author ototoi / Toru Matsuoka
 *	@date 2004/11/26		
 *	@attention 
 *	ET(Expression Template) demands from compiler high optimizations.
 *	But, in fact, a fine compiler would generate same code whether you used ET or not. 
 *	I think ... ET is wonderful gimmick(hack?),but it is only for code guru(crazy geek). 
 */

#include "../meta/operation_result.hpp"
#include<cstddef>

#define MEMBER(TYPE,VAR) const TYPE VAR
#define INIT(TYPE,VAR)   const TYPE VAR
#define CALL(TYPE,VAR)   const TYPE VAR

//#define MEMBER(TYPE,VAR) const TYPE & VAR
//#define INIT(TYPE,VAR)   const TYPE & VAR
//#define CALL(TYPE,VAR)   const TYPE & VAR


namespace tempest{
	
template <std::size_t i>
struct node_loop;
	
template <std::size_t i>
struct node_loop{
	template<class P, class Q>
	inline static void eval(P & lhs, const Q & rhs){
		lhs[i] = rhs[i];
		node_loop<i-1>::eval(lhs,rhs);
	}
};
	
template <>
struct node_loop<0>{
	template<class P, class Q>
	inline static void eval(P & lhs, const Q & rhs){
		lhs[0] = rhs[0];
	}
};
	
/**
	@def DECLARE_OP_STRUCT
	Defines Expression Template evaluater struct.
	
 */	
	
struct posite{
	template<class T>
	inline static T apply(T a){return a;}
};
	
struct negate{
	template<class T>
	inline static T apply(T a){return -a;}
};
	
#define DECLARE_OP_STRUCT(STRUCT_NAME,OP) 						\
struct STRUCT_NAME {											\
	template<class P,class Q>									\
    inline static												\
	typename operation_result<P,Q>::type						\
	apply(P a, Q b) {											\
		return a OP b;											\
    }															\
};	
	
DECLARE_OP_STRUCT(plus,+)
DECLARE_OP_STRUCT(minus,-)
DECLARE_OP_STRUCT(multiply,*)
DECLARE_OP_STRUCT(divide,/)	
	
#undef DECLARE_OP_STRUCT

template<class Self, class T, std::size_t Sz>struct vector_expression{};
	
template<class OP,class V>
struct vector_un_op;
	
template<class OP,class V>
struct vector_un_op:public vector_expression< vector_un_op<OP,V>,typename V::value_type,V::c_size>{
	//type define	
	typedef typename V::value_type value_type;
	//size
	static const std::size_t c_size = V::c_size;
	
	vector_un_op(INIT(V,rhs)):m(rhs){};
	
	value_type operator[](std::size_t i)const{
		return OP::apply(m[i]) ;
	}
	
	//member...
	MEMBER(V,m);
};

template<std::size_t PSz,std::size_t QSz>
struct PQ_SIZE_MIN{
	static const std::size_t value = (PSz<QSz)?PSz:QSz;
};

/** 
	@class vector_bin_op
	@brief vector_bin_op will be used for Expression Template Node. 
 */
template<class OP, class P, class Q>
struct vector_bin_op;
	
template<class OP, class P, class Q>
struct vector_bin_op:
	public vector_expression<
		vector_bin_op<OP,P,Q>,
		typename operation_result<typename P::value_type,typename Q::value_type>::type,
		PQ_SIZE_MIN<P::c_size,Q::c_size>::value
	>{
		
	typedef typename P::value_type PV;
	typedef typename Q::value_type QV;		
	typedef typename operation_result<PV,QV>::type value_type;
	 
	static const std::size_t p_size = P::c_size;
	static const std::size_t q_size = Q::c_size;
	static const std::size_t c_size = PQ_SIZE_MIN<p_size,q_size>::value;	

	vector_bin_op(INIT(P, lhs),INIT(Q, rhs) ):left(lhs),right(rhs){}
		
	value_type operator[](std::size_t i)const{
		return OP::apply(left[i],right[i]) ;
	}
	
	//member
	MEMBER(P,left);
	MEMBER(Q,right);
};
	
//Helper for making ref_vector.
template<class T, std::size_t Sz>
inline vector_un_op< posite,vector<T,Sz> >
	et(const vector<T,Sz> & rhs){return vector_un_op< posite,vector<T,Sz> >(rhs);}
	
//-----------------------------------------------

template<class Self, class T, std::size_t Sz, class _CharT, class _Traits>
std::basic_ostream<_CharT, _Traits>& operator<<(std::basic_ostream<_CharT, _Traits>& os, const vector_expression<Self,T,Sz>& rhs){
	const Self & tmp = static_cast<const Self &>(rhs);
	std::basic_ostringstream<_CharT, _Traits> s;
	s.flags(os.flags());
	s.imbue(os.getloc());
	s.precision(os.precision());
	s <<"(";
	for(std::size_t i = 0;i < Sz-1;++i){
		s << tmp[i] <<",";
	}
	s <<tmp[Sz-1];
	s <<")";
	return os << s.str();
}
//-----------------------------------------------
	
#define VE vector_expression<Self,T,Sz>
	
template<class Self, class T, std::size_t Sz>
inline vector_un_op<posite,Self>
operator+ (CALL(VE,rhs)){
	return vector_un_op<posite,Self>(static_cast<const Self&>(rhs));			
}
	
template<class Self, class T, std::size_t Sz>
inline vector_un_op<posite,Self>
operator- (CALL(VE,rhs)){
	return vector_un_op<negate,Self>(static_cast<const Self&>(rhs));			
}

#undef VE
	
#define VET vector_expression<Self_T, Type_T, Sz> 
#define VEX vector_expression<Self_X, Type_X, Sz> 

#define DECLARE_ET_VECTOR_OPERATOR(STRUCT_NAME,OP)																			\
	template<class Self_T, class Self_X, class Type_T, class Type_X, std::size_t Sz>										\
	inline vector_bin_op<STRUCT_NAME,Self_T,Self_X>																			\
	operator OP (CALL(VET,lhs),CALL(VEX,rhs)){																				\
		return vector_bin_op<STRUCT_NAME,Self_T,Self_X>(static_cast<const Self_T&>(lhs),static_cast<const Self_X&>(rhs) );	\
	}

DECLARE_ET_VECTOR_OPERATOR(plus,+)
DECLARE_ET_VECTOR_OPERATOR(minus,-)
DECLARE_ET_VECTOR_OPERATOR(multiply,*)
DECLARE_ET_VECTOR_OPERATOR(divide,/)
	
#undef DECLARE_ET_VECTOR_OPERATOR


#undef VET
#undef VEX

#undef MEMBER
#undef INIT
#undef CALL
	
	

}

#endif

