#ifndef _TMAUTO_ARRAY_HPP
#define _TMAUTO_ARRAY_HPP

//#include <cstddef>            // std::::std::size_t
#include <algorithm> 
namespace tempest{
	
template<class T> class auto_array{
public:
	typedef auto_array<T> this_type;
    typedef T element_type;
public:
    auto_array(T* p = 0) throw() {m_ptr = p;}
	explicit auto_array(this_type& rhs) throw() : m_ptr(rhs.release()){}
	
    ~auto_array(){//needing throw()
        delete[] m_ptr;
    }
	
	this_type& operator=(this_type & rhs) throw(){
		reset(rhs.release());
			
		return *this;
	}
	
	T & operator*()  const throw() { return *m_ptr; }
	T * operator->() const throw() { return  m_ptr; }
	T* get(std::size_t n = 0) const throw() {return &(m_ptr[n]);}
	
	T& 			operator[](std::size_t n) throw() 		{return (m_ptr[n]);}
	const T& 	operator[](std::size_t n) const throw() {return (m_ptr[n]);}
	
	void swap( this_type & other ) throw() {
		T* temp = m_ptr;
		m_ptr = other.m_ptr;
		other.m_ptr = temp;
	}
    
	void reset(T* p = 0) throw() {
		if (p != m_ptr){
			delete[] m_ptr;
			m_ptr = p;
		}
	}
	
	T* release() {
        T* tmp = m_ptr;
        m_ptr = 0;
        return tmp;
    }
	
private:
    T* m_ptr;    
};
	
template<class T> bool operator==( const auto_array<T> & lhs, const auto_array<T> & rhs ){ return (lhs.get() == rhs.get()); }
template<class T> bool operator!=( const auto_array<T> & lhs, const auto_array<T> & rhs ){ return (lhs.get() != rhs.get()); }

}

namespace std{
	template<class T>
	inline void swap(tempest::auto_array<T> & lhs, tempest::auto_array<T> & rhs){
		lhs.swap(rhs);	
	}
}

#endif
