#ifndef _TMCOUNTED_PTR_HPP
#define _TMCOUNTED_PTR_HPP


#include <cstddef>            // std::::std::size_t
#include <algorithm>          // std::swap

namespace tempest{
	
class counter{
public:
	typedef counter this_type;
	
	explicit counter():ctr(1){}	
	~counter()throw(){}
	
	void up() throw(){ctr++;}
	void down() throw(){ctr--;}
	
	::std::size_t count()const{return ctr;}	
	bool is_only()const throw(){return (ctr < 2);}
	
protected:
	::std::size_t ctr;		//counter	
};
	
template<class T>
class direct_counted_ptr{
public:
	typedef direct_counted_ptr<T> this_type;
	typedef T element_type;
public:
	explicit direct_counted_ptr(T * p = 0):ptr(p),ctr(new counter()){}
	
	direct_counted_ptr(const this_type & rhs):ptr(rhs.ptr),ctr(rhs.ctr){
		ctr->up();	
	}
	
	~direct_counted_ptr() throw() {		
		if(ctr->is_only()){
			delete ptr;
			delete ctr;
		}else{
			ctr->down();	
		}
	}
	
	this_type& operator=(const this_type & rhs){
		if(&rhs == this)return *this;
		
		if(ctr->is_only()){
			delete ptr;
			delete ctr;
		}else{
			ctr->down();	
		}
		ptr = rhs.ptr;
		ctr = rhs.ctr;
		ctr->up();
		
		return *this;
	}
	
	void reset(T* p = 0){
		if(ctr->is_only()){
			delete ptr;
			delete ctr;
		}else{
			ctr->down();	
		}
		ptr = p;
		ctr = new counter(); 
	}
	
	bool is_only()const throw(){ return ctr->is_only();	}	
	T* operator-> () const throw(){	return ptr; }
	T* get() const throw(){ return ptr; }	
	T& operator* () const throw(){ return *ptr;}
	
	T* get_pointer() const throw(){ return ptr; }//boost::mem_fn	
	
	void swap( this_type & other ) throw() {
		std::swap(ptr,other.ptr);
		std::swap(ctr,other.ctr);
	}
	
private:
	counter* ctr;
	T* ptr;
};
	
template<class T>
class counter_with_pointer:public counter{
public:
	typedef T value_type;
	typedef counter_with_pointer<T> this_type;
	
	explicit counter_with_pointer(T* p = 0):ptr(p){}
	
	~counter_with_pointer(){if(ptr != 0){delete ptr;}}
	
	T* get() const throw(){return ptr;}	
	T& operator* () const throw(){return *ptr;}	
	T* operator-> () const throw(){return ptr;}
	
private:
	T * ptr;		//inside pointer
};

template<class T>
class counted_ptr{
private:
	typedef counter_with_pointer<T> rc_type;
public:
	typedef counted_ptr<T> this_type;
	typedef T element_type;
public:
	explicit counted_ptr(T * p = 0):ptr(new rc_type(p)){}
	
	counted_ptr(const this_type & rhs):ptr(rhs.ptr){
		ptr->up();	
	}
	
	~counted_ptr() throw() {		
		if(ptr->is_only()){
			delete ptr;
		}else{
			ptr->down();	
		}
	}
	
	this_type& operator=(const this_type & rhs){
		if(ptr->is_only()){
			delete ptr;
		}else{
			ptr->down();	
		}
		ptr = rhs.ptr;
		ptr->up();
		
		return *this;
	}
	
	void reset(T* p = 0){
		if(ptr->is_only()){
			delete ptr;
		}else{
			ptr->down();	
		}
		ptr = new rc_type(p);
	}
	
	bool is_only()const throw(){ return ptr->is_only();	}	
	T* operator-> () const throw(){	return ptr->operator->(); }
	T* get() const throw(){ return ptr->get(); }	
	T& operator* () const throw(){ return *(ptr->get());}
	
	void swap( this_type & other ) throw() {
		std::swap(ptr,other.ptr);		
	}
	
	
private:
	rc_type* ptr;		
};



	
	
	
}

namespace std{
	template<class T>
	inline void swap(tempest::counted_ptr<T> & lhs,tempest::counted_ptr<T> & rhs){
		lhs.swap(rhs);
	}
	
	template<class T>
	inline void swap(tempest::direct_counted_ptr<T> & lhs,tempest::direct_counted_ptr<T> & rhs){
		lhs.swap(rhs);
	}
}

#endif

