
#include<ostream>
#include<sstream>
#include<functional>

namespace tempest{
	
template<class CharT, class Traits = std::char_traits<CharT> >
class basic_string_expression{

public:
	typedef CharT									value_type;
	typedef Traits									traits_type;
	typedef std::basic_string<CharT,Traits>			string_type;
	
	typedef basic_string_expression<CharT,Traits> 	this_type;
	
	typedef std::basic_ostringstream<CharT,Traits> sstr;
	
public:
	basic_string_expression():_m(""){}
	
	basic_string_expression(const this_type & rhs):_m(rhs._m){}
		
	template<class TYPE>
	explicit basic_string_expression(TYPE rhs){
		sstr ss;
		ss << rhs;
		//_m = static_cast<const sstr&>(sstr() << rhs) .str();
		_m = ss.str();	
	}
	
	
	explicit basic_string_expression(const char* rhs)
		:_m(rhs){}
	
	
	
	//------------
	
	this_type & operator=(const this_type & rhs){
		std::basic_ostringstream<CharT, Traits> ss;
		//ss << CharT('(');
		ss << rhs;
		//ss << CharT(')');
		_m = ss.str();	
		return *this;
	}
	
	template<class TYPE>
	this_type & operator=(TYPE rhs){
		sstr ss;
		ss << rhs;
		_m = ss.str();	
		
		return *this;
	}
	
	this_type & negate(){
		typedef typename string_type::iterator c_it;
		c_it i = std::find_if(_m.begin(),_m.end(),std::bind1st( std::not_equal_to<CharT>(), CharT(' ')) );
		
		if(i != _m.end()){
			if(*i != CharT('-')){			
				std::basic_ostringstream<CharT, Traits> ss;
				ss << CharT('-');
				ss << CharT('(');
				ss << _m;
				ss << CharT(')');
				_m = ss.str();
			}else{
				string_type s(++i,_m.end());
				_m.swap(s);				
			}
		}
		return *this;
	}
	
	this_type & operator+=(const this_type & rhs){
		std::basic_ostringstream<CharT, Traits> ss;
		ss << CharT('(');
		ss << _m;
		ss << CharT('+');
		ss << rhs._m;
		ss << CharT(')');
		_m = ss.str();
		return *this;
	}
	
	this_type & operator-=(const this_type & rhs){		
		std::basic_ostringstream<CharT, Traits> ss;
		ss << CharT('(');
		ss << _m;
		ss << CharT('-');
		ss << rhs._m;
		ss << CharT(')');
		_m = ss.str();
		return *this;
	}
	
	this_type & operator*=(const this_type & rhs){
		std::basic_ostringstream<CharT, Traits> ss;
		ss << _m;
		ss << CharT('*');
		ss << rhs._m;
		_m = ss.str();
		return *this;
	}
	
	this_type & operator/=(const this_type & rhs){
		std::basic_ostringstream<CharT, Traits> ss;
		ss << _m;
		ss << CharT('/');
		ss << rhs._m;
		_m = ss.str();
		return *this;
	}
	
	const string_type& str()const{
		return _m;	
	}
	
private:
	string_type _m;
	
};

#define DECLARE_OPERATOR(OP)																											\
template<class _CharT, class _Traits>																									\
inline basic_string_expression<_CharT, _Traits>																							\
operator OP (const basic_string_expression<_CharT, _Traits>& lhs,const basic_string_expression<_CharT, _Traits>& rhs){					\
	typedef basic_string_expression<_CharT, _Traits> ST;																				\
	return ST(lhs) OP ## = rhs;																											\
}
	
	DECLARE_OPERATOR(+)
	DECLARE_OPERATOR(-)
	DECLARE_OPERATOR(*)
	DECLARE_OPERATOR(/)
	
#undef DECLARE_OPERATOR
	
template<class _CharT, class _Traits>
inline basic_string_expression<_CharT, _Traits> operator+ (const basic_string_expression<_CharT, _Traits>& rhs){
	return rhs;
}
	
template<class _CharT, class _Traits>
inline basic_string_expression<_CharT, _Traits> operator- (const basic_string_expression<_CharT, _Traits>& rhs){
	typedef basic_string_expression<_CharT, _Traits> ST;
	return ST(rhs).negate();
}		
	
template<class _CharT, class _Traits>
inline bool operator==(const basic_string_expression<_CharT, _Traits>& lhs,const basic_string_expression<_CharT, _Traits>& rhs){
	return lhs.str() == rhs.str();
}
	
template<class _CharT, class _Traits>
inline bool operator!=(const basic_string_expression<_CharT, _Traits>& lhs,const basic_string_expression<_CharT, _Traits>& rhs){
	return !(lhs == rhs);
}


template<class _CharT, class _Traits>
std::basic_ostream<_CharT, _Traits>& operator<<(std::basic_ostream<_CharT, _Traits>& os, const basic_string_expression<_CharT, _Traits>& rhs){
	return os << rhs.str();
}
	
	
	
	typedef basic_string_expression<char> 		string_expression;
	typedef basic_string_expression<wchar_t> 	wstring_expression;
	
}

