#include<iostream>
#include<cmath>
#include<cstdlib>
#include<ctime>


#include"../util/math.hpp"

using namespace std;
using namespace tempest;

int main(int argc, char** argv){
	int num;
	clock_t cl1, cl2;
	if(argc < 2){
		cout <<"test NUMBER"<<endl;
		num = 10;
	}else{
		num = atoi(argv[1]);
	}
	
	if(num<10||20000000<num){
		cout <<"Unexpected number!"<<endl;
		return -1;
	}
	
	srand(time(0));
	
	float* array = new float[num];
	float* out1 = new float[num];
	float* out2 = new float[num];
	
	for(int i = 0;i<num;i++)array[i] = (float)(rand());
	
	
	cl1 = clock();
	for(int i = 0;i<num;i++)out1[i] = rsqrt(array[i]);
	cl2 = clock();
	cout <<cl2 -cl1<<endl;
	
	cout <<"----------------------------"<<endl;	
	cl1 = clock();
	for(int i = 0;i<num;i++)out2[i] = 1.0f/sqrt(array[i]);
	cl2 = clock();
	cout <<cl2 -cl1<<endl;
	
	cout <<"----------------------------"<<endl;
	cl1 = clock();
	for(int i = 0; i< 30;i++)
		for(int i = 0;i<num;i++)out1[i] = rsqrt(array[i]);
	cl2 = clock();
	cout <<cl2 -cl1<<endl;
	
	cout <<"----------------------------"<<endl;	
	cl1 = clock();
	for(int i = 0; i< 30;i++)
		for(int i = 0;i<num;i++)out2[i] = 1.0f/sqrt(array[i]);
	cl2 = clock();
	cout <<cl2 -cl1<<endl;
	
	int num100 = (num>30)?30:num;
	for(int i = 0; i< num100;i++){
		float f1 = array[i]*out1[i];
		float f2 = array[i]*out2[i];
		cout << out1[i] <<"," << out2[i] <<":\t" <<f1<<","<<f2<<"\n"<<f1*f1<<","<<f2*f2<<"\n"<<  endl;
		
	}
	
	
	delete[] out2;
	delete[] out1;
	delete[] array;
	
}

